static char rcsid[] = "$Id: 280a7dacd9e4dfce313e5e08d56650ebe6d6e3cd $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifndef HAVE_MEMCPY
#define memcpy(d,s,n) bcopy((s),(d),(n))
#endif
#ifndef HAVE_MEMMOVE
#define memmove(d,s,n) bcopy((s),(d),(n))
#endif

#include "stage1hr.h"
#include "stage1hr-single.h"
#include "stage1hr-paired.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>		/* For rint */
#include <string.h>		/* For memset */

#include "assert.h"
#include "mem.h"
#include "types.h"		/* Needed for HAVE_64_BIT */
#include "univcoord.h"

#include "list.h"
#include "compress.h"
#include "record.h"

#include "genomebits_mismatches.h" /* For MISMATCH_EXTRA */

#include "stage1hr.h"
#include "kmer-search.h"
#include "extension-search.h"
#include "segment-search.h"
#include "stage1hr-single.h"
#include "transcriptome-search.h"
#include "tr-extension-search.h"

#include "intersect-wdups-indices.h" /* For taking intersection of trnums */
#ifdef LARGE_GENOMES
#include "merge-uint8.h"
#include "intersect-approx-indices-uint8.h"
#else
#include "merge-uint4.h"
#include "intersect-approx-indices-uint4.h"
#endif

#include "concordance.h"
#include "trpath-solve.h"
#include "trpath-convert.h"
#include "path-solve.h"
#include "path-fusion.h"

#include "transcript-remap.h"
#include "transcript-velocity.h"
#include "path-eval.h"
#include "pathpair-eval.h"

#include "orderstat.h"


/* #define MIN_SIZELIMIT 100 */
#define MAX_HITS_EXACT 100	/* Excessive exact paths indicate a repetitive sequence */
#define MAX_DENSITY_INTERSECTION 100 /* Limit on ndense5 * ndense3 */
#define MAX_NPATHS_FIND_SPLICES 0    /* Merging seems not have much effect */

#define MAX_SINGLE_END_HITS 1000
#define MAX_UNEXTENDED_HITS 1000


#ifdef DEBUG0
#define debug0(x) x
#else
#define debug0(x)
#endif

#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif

/* Trdiagonals */
#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif

/* determine_pairtype */
#ifdef DEBUG14
#define debug14(x) x
#else
#define debug14(x)
#endif

/* consolidate_paired_results */
#ifdef DEBUG16
#define debug16(x) x
#else
#define debug16(x)
#endif


static Mode_T mode;
static int index1part;
static int index1interval;
static int index1part_tr;

static Transcriptome_T transcriptome;
static bool genome_align_p;
static bool transcriptome_align_p;

/* static double defect_rate = 0.01; */

static double user_nmismatches_filter_float;
static double user_mincoverage_filter_float;

static double max_middle_insertions_float;
static double max_middle_deletions_float;

static Chrpos_T shortsplicedist;
static Chrpos_T shortsplicedist_novelend;

static bool splicingp;
static int maxpaths_search;	/* Not currently used */
static int maxpaths_report;	/* Not currently used */

static bool *circularp;
static int pairmax_linear;
static int pairmax_circular;


#define T Stage1_T


#if 0
/* Do not need to extend all paths, since fusion procedures will extend fusion candidates */
static void
eval_unextended_paths (int *found_score, T this, Compress_T query_compress_fwd, Compress_T query_compress_rev) {
  List_T p;

  for (p = this->unextended_sense_paths_gplus; p != NULL; p = List_next(p)) {
    Path_eval_nmatches(&(*found_score),(Path_T) List_head(p),query_compress_fwd,query_compress_rev);
  }
  for (p = this->unextended_sense_paths_gminus; p != NULL; p = List_next(p)) {
    Path_eval_nmatches(&(*found_score),(Path_T) List_head(p),query_compress_fwd,query_compress_rev);
  }
  for (p = this->unextended_antisense_paths_gplus; p != NULL; p = List_next(p)) {
    Path_eval_nmatches(&(*found_score),(Path_T) List_head(p),query_compress_fwd,query_compress_rev);
  }
  for (p = this->unextended_antisense_paths_gminus; p != NULL; p = List_next(p)) {
    Path_eval_nmatches(&(*found_score),(Path_T) List_head(p),query_compress_fwd,query_compress_rev);
  }

  return;
}
#endif


static List_T
paired_search_trdiagonals (int *found_score_paired, int *found_score_5, int *found_score_3,
			   Method_T *last_method_5, Method_T *last_method_3,
		  
			   List_T pathpairs, T this5, T this3,
	      
			   Shortread_T queryseq5, Shortread_T queryseq3,
			   int querylength5, int querylength3,
	       
			   Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			   Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
	      
			   int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
			   int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,

			   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			   Listpool_T listpool, Trpathpool_T trpathpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			   Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Method_T method_goal) {
  
  int *sense_indices, *antisense_indices;
  int sense_nindices, antisense_nindices;
  int index1, index2;
  int tstart5, tend5, tstart3, tend3;
  Trpath_T trpath5, trpath3;

  int i, j, k;

  debug1(printf("Entered paired_search_trdiagonals\n"));

  if (*last_method_5 < TR_EXACT1 && *last_method_3 < TR_EXACT1) {
    *last_method_5 = single_read_next_method_trdiagonal(*last_method_5,this5,querylength5);
    *last_method_3 = single_read_next_method_trdiagonal(*last_method_3,this3,querylength3);

  } else if (*last_method_5 >= method_goal) {
    *last_method_3 = single_read_next_method_trdiagonal(*last_method_3,this3,querylength3);

  } else if (*last_method_3 >= method_goal) {
    *last_method_5 = single_read_next_method_trdiagonal(*last_method_5,this5,querylength5);

  } else if ((*found_score_5) >= (*found_score_3)) {
    *last_method_5 = single_read_next_method_trdiagonal(*last_method_5,this5,querylength5);

  } else {
    *last_method_3 = single_read_next_method_trdiagonal(*last_method_3,this3,querylength3);
  }

  debug(printf("Have %d and %d sense trdiagonals, %d and %d antisense trdiagonals\n",
	       this5->n_sense_trdiagonals,this3->n_sense_trdiagonals,
	       this5->n_antisense_trdiagonals,this3->n_antisense_trdiagonals));

#ifdef DEBUG1
  for (i = 0; i < this5->n_sense_trdiagonals; i++) {
    printf("%u %u\n",this5->sense_trnums[i],this5->sense_trdiagonals[i]);
  }
  printf("\n");

  for (i = 0; i < this5->n_antisense_trdiagonals; i++) {
    printf("%u %u\n",this5->antisense_trnums[i],this5->antisense_trdiagonals[i]);
  }
  printf("\n");

  for (i = 0; i < this3->n_sense_trdiagonals; i++) {
    printf("%u %u\n",this3->sense_trnums[i],this3->sense_trdiagonals[i]);
  }
  printf("\n");

  for (i = 0; i < this3->n_antisense_trdiagonals; i++) {
    printf("%u %u\n",this3->antisense_trnums[i],this3->antisense_trdiagonals[i]);
  }
  printf("\n");
#endif


  /* Find concordant trnums */
  if (this5->n_sense_trdiagonals == 0 || this3->n_sense_trdiagonals == 0) {
    sense_indices = (int *) NULL;
    sense_nindices = 0;
  } else {
#if 0
    /* Previously used this because Intersect_indices_uint4 doesn't allow duplicates */
    sense_indices =
      Intersect_approx_indices_uint4(&sense_nindices,
				     this5->sense_trnums,this5->n_sense_trdiagonals,/*diagterm1*/0,
				     this3->sense_trnums,this3->n_sense_trdiagonals,/*diagterm2*/0,
				     /*below_slop*/0,/*above_slop*/0);
#else
    sense_indices =
      Intersect_wdups_indices(&sense_nindices,
			      this5->sense_trnums,this5->n_sense_trdiagonals,
			      this3->sense_trnums,this3->n_sense_trdiagonals);
#endif
  }
  
  if (this5->n_antisense_trdiagonals == 0 || this3->n_antisense_trdiagonals == 0) {
    antisense_indices = (int *) NULL;
    antisense_nindices = 0;
  } else {
#if 0
    /* Previously used this because Intersect_indices_uint4 doesn't allow duplicates */
    antisense_indices =
      Intersect_approx_indices_uint4(&antisense_nindices,
				     this5->antisense_trnums,this5->n_antisense_trdiagonals,/*diagterm1*/0,
				     this3->antisense_trnums,this3->n_antisense_trdiagonals,/*diagterm2*/0,
				     /*below_slop*/0,/*above_slop*/0);
#else
    antisense_indices =
      Intersect_wdups_indices(&antisense_nindices,
			      this5->antisense_trnums,this5->n_antisense_trdiagonals,
			      this3->antisense_trnums,this3->n_antisense_trdiagonals);
#endif
  }

  debug1(printf("Have %d sense concordant and %d antisense concordant\n",
		sense_nindices,antisense_nindices));
    
  tstart5 = 0;
  tend5 = querylength5;
  tstart3 = 0;
  tend3 = querylength3;

  for (i = 0, k = 0; i < sense_nindices; i++, k += 2) {
    index1 = sense_indices[k];
    index2 = sense_indices[k+1];

    /* Previously checked last_method_5 */
    if (this5->sense_tstarts != NULL) {
      tstart5 = this5->sense_tstarts[index1];
      tend5 = this5->sense_tends[index1];
    }
    if ((trpath5 = Trpath_solve_from_trdiagonal(&(*found_score_5),/*trdiagonal*/this5->sense_trdiagonals[index1],
						tstart5,tend5,/*trnum*/this5->sense_trnums[index1],
						/*troffset*/this5->sense_troffsets[index1],
						/*trhigh*/this5->sense_trhighs[index1],
						/*query_compress_tr*/query5_compress_fwd,/*tplusp*/true,querylength5,
						mismatch_positions_alloc_5,/*want_lowest_coordinate_p*/true,
						this5->indelinfo,max_insertionlen_5,max_deletionlen_5,
						intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						*last_method_5)) != NULL) {
      this5->sense_trpaths = Hitlist_push(this5->sense_trpaths,hitlistpool,(void *) trpath5
					  hitlistpool_trace(__FILE__,__LINE__));
    }

    /* Previously checked last_method_3 */
    if (this3->sense_tstarts != NULL) {
      tstart3 = this3->sense_tstarts[index2];
      tend3 = this3->sense_tends[index2];
    }
    if ((trpath3 = Trpath_solve_from_trdiagonal(&(*found_score_3),/*trdiagonal*/this3->sense_trdiagonals[index2],
						tstart3,tend3,/*trnum*/this3->sense_trnums[index2],
						/*troffset*/this3->sense_troffsets[index2],
						/*trhigh*/this3->sense_trhighs[index2],
						/*query_compress_tr*/query3_compress_fwd,/*tplusp*/true,querylength3,
						mismatch_positions_alloc_3,/*want_lowest_coordinate_p*/true,
						this3->indelinfo,max_insertionlen_3,max_deletionlen_3,
						intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						*last_method_3)) != NULL) {
      this3->sense_trpaths = Hitlist_push(this3->sense_trpaths,hitlistpool,(void *) trpath3
					  hitlistpool_trace(__FILE__,__LINE__));
    }
  }
    

  tstart5 = 0;
  tend5 = querylength5;
  tstart3 = 0;
  tend3 = querylength3;

  for (i = 0, k = 0; i < antisense_nindices; i++, k += 2) {
    index1 = antisense_indices[k];
    index2 = antisense_indices[k+1];

    /* Previously checked last_method_5 */
    if (this5->antisense_tstarts != NULL) {
      tstart5 = this5->antisense_tstarts[index1];
      tend5 = this5->antisense_tends[index1];
    }
    if ((trpath5 = Trpath_solve_from_trdiagonal(&(*found_score_5),/*trdiagonal*/this5->antisense_trdiagonals[index1],
						tstart5,tend5,/*trnum*/this5->antisense_trnums[index1],
						/*troffset*/this5->antisense_troffsets[index1],
						/*trhigh*/this5->antisense_trhighs[index1],
						/*query_compress_tr*/query5_compress_rev,/*tplusp*/false,querylength5,
						mismatch_positions_alloc_5,/*want_lowest_coordinate_p*/true,
						this5->indelinfo,max_insertionlen_5,max_deletionlen_5,
						intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						*last_method_5)) != NULL) {
      this5->antisense_trpaths = Hitlist_push(this5->antisense_trpaths,hitlistpool,(void *) trpath5
					      hitlistpool_trace(__FILE__,__LINE__));
    }

    /* Previously checked last_method_3 */
    if (this3->antisense_tstarts != NULL) {
      tstart3 = this3->antisense_tstarts[index2];
      tend3 = this3->antisense_tends[index2];
    }
    if ((trpath3 = Trpath_solve_from_trdiagonal(&(*found_score_3),/*trdiagonal*/this3->antisense_trdiagonals[index2],
						tstart3,tend3,/*trnum*/this3->antisense_trnums[index2],
						/*troffset*/this3->antisense_troffsets[index2],
						/*trhigh*/this3->antisense_trhighs[index2],
						/*query_compress_tr*/query3_compress_rev,/*tplusp*/false,querylength3,
						mismatch_positions_alloc_3,/*want_lowest_coordinate_p*/true,
						this3->indelinfo,max_insertionlen_3,max_deletionlen_3,
						intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						*last_method_3)) != NULL) {
      this3->antisense_trpaths = Hitlist_push(this3->antisense_trpaths,hitlistpool,(void *) trpath3
					      hitlistpool_trace(__FILE__,__LINE__));
    }
  }

  pathpairs = Concordance_tr(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 
			     /*new*/this5->sense_trpaths,/*new*/this3->sense_trpaths,
			     /*trpaths5*/NULL,/*trpaths3*/NULL,

			     query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			     queryseq5,queryseq3,querylength5,querylength3,this5,this3,

			     intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			     vectorpool,hitlistpool,/*sensedir*/SENSE_FORWARD);

  pathpairs = Concordance_tr(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 
			     /*new*/this5->antisense_trpaths,/*new*/this3->antisense_trpaths,
			     /*trpaths5*/NULL,/*trpaths3*/NULL,
			     
			     query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			     queryseq5,queryseq3,querylength5,querylength3,this5,this3,

			     intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			     vectorpool,hitlistpool,/*sensedir*/SENSE_ANTI);

  if (pathpairs != NULL) {
    FREE(antisense_indices);
    FREE(sense_indices);
    return pathpairs;

  } else {
    /* Create trpaths out of remaining trdiagonals */

    /* 5' read, sense */
    tstart5 = 0;
    tend5 = querylength5;

    i = j = 0; k = 0;
    while (i < this5->n_sense_trdiagonals && j < sense_nindices) {
      index1 = sense_indices[k];
      if (i < index1) {
	if (this5->sense_tstarts != NULL) {
	  tstart5 = this5->sense_tstarts[i];
	  tend5 = this5->sense_tends[i];
	}
	if ((trpath5 = Trpath_solve_from_trdiagonal(&(*found_score_5),/*trdiagonal*/this5->sense_trdiagonals[i],
						    tstart5,tend5,/*trnum*/this5->sense_trnums[i],
						    /*troffset*/this5->sense_troffsets[i],
						    /*trhigh*/this5->sense_trhighs[i],
						    /*query_compress_tr*/query5_compress_fwd,/*tplusp*/true,querylength5,
						    mismatch_positions_alloc_5,/*want_lowest_coordinate_p*/true,
						    this5->indelinfo,max_insertionlen_5,max_deletionlen_5,
						    intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						    *last_method_5)) != NULL) {
	  this5->sense_trpaths = Hitlist_push(this5->sense_trpaths,hitlistpool,(void *) trpath5
					      hitlistpool_trace(__FILE__,__LINE__));
	}
	i++;

      } else if (index1 < i) {
	j++; k += 2;

      } else {
	i++; j++; k += 2;
      }
    }

    while (i < this5->n_sense_trdiagonals) {
      if (this5->sense_tstarts != NULL) {
	tstart5 = this5->sense_tstarts[i];
	tend5 = this5->sense_tends[i];
      }
      if ((trpath5 = Trpath_solve_from_trdiagonal(&(*found_score_5),/*trdiagonal*/this5->sense_trdiagonals[i],
						  tstart5,tend5,/*trnum*/this5->sense_trnums[i],
						  /*troffset*/this5->sense_troffsets[i],
						  /*trhigh*/this5->sense_trhighs[i],
						  /*query_compress_tr*/query5_compress_fwd,/*tplusp*/true,querylength5,
						  mismatch_positions_alloc_5,/*want_lowest_coordinate_p*/true,
						  this5->indelinfo,max_insertionlen_5,max_deletionlen_5,
						  intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						  *last_method_5)) != NULL) {
	this5->sense_trpaths = Hitlist_push(this5->sense_trpaths,hitlistpool,(void *) trpath5
					    hitlistpool_trace(__FILE__,__LINE__));
      }
      i++;
    }
      

    /* 3' read, sense */
    tstart3 = 0;
    tend3 = querylength3;

    i = j = 0; k = 0;
    while (i < this3->n_sense_trdiagonals && j < sense_nindices) {
      index2 = sense_indices[k+1];
      if (i < index2) {
	if (this3->sense_tstarts != NULL) {
	  tstart3 = this3->sense_tstarts[i];
	  tend3 = this3->sense_tends[i];
	}
	if ((trpath3 = Trpath_solve_from_trdiagonal(&(*found_score_3),/*trdiagonal*/this3->sense_trdiagonals[i],
						    tstart3,tend3,/*trnum*/this3->sense_trnums[i],
						    /*troffset*/this3->sense_troffsets[i],
						    /*trhigh*/this3->sense_trhighs[i],
						    /*query_compress_tr*/query3_compress_fwd,/*tplusp*/true,querylength3,
						    mismatch_positions_alloc_3,/*want_lowest_coordinate_p*/true,
						    this3->indelinfo,max_insertionlen_3,max_deletionlen_3,
						    intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						    *last_method_3)) != NULL) {
	  this3->sense_trpaths = Hitlist_push(this3->sense_trpaths,hitlistpool,(void *) trpath3
					      hitlistpool_trace(__FILE__,__LINE__));
	}
	i++;

      } else if (index2 < i) {
	j++; k += 2;

      } else {
	i++; j++; k += 2;
      }
    }

    while (i < this3->n_sense_trdiagonals) {
      if (this3->sense_tstarts != NULL) {
	tstart3 = this3->sense_tstarts[i];
	tend3 = this3->sense_tends[i];
      }
      if ((trpath3 = Trpath_solve_from_trdiagonal(&(*found_score_3),/*trdiagonal*/this3->sense_trdiagonals[i],
						  tstart3,tend3,/*trnum*/this3->sense_trnums[i],
						  /*troffset*/this3->sense_troffsets[i],
						  /*trhigh*/this3->sense_trhighs[i],
						  /*query_compress_tr*/query3_compress_fwd,/*tplusp*/true,querylength3,
						  mismatch_positions_alloc_3,/*want_lowest_coordinate_p*/true,
						  this3->indelinfo,max_insertionlen_3,max_deletionlen_3,
						  intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						  *last_method_3)) != NULL) {
	this3->sense_trpaths = Hitlist_push(this3->sense_trpaths,hitlistpool,(void *) trpath3
					    hitlistpool_trace(__FILE__,__LINE__));
      }
      i++;
    }


    /* 5' read, antisense */
    tstart5 = 0;
    tend5 = querylength5;

    i = j = 0; k = 0;
    while (i < this5->n_antisense_trdiagonals && j < antisense_nindices) {
      index1 = antisense_indices[k];
      if (i < index1) {
	if (this5->antisense_tstarts != NULL) {
	  tstart5 = this5->antisense_tstarts[i];
	  tend5 = this5->antisense_tends[i];
	}
	if ((trpath5 = Trpath_solve_from_trdiagonal(&(*found_score_5),/*trdiagonal*/this5->antisense_trdiagonals[i],
						    tstart5,tend5,/*trnum*/this5->antisense_trnums[i],
						    /*troffset*/this5->antisense_troffsets[i],
						    /*trhigh*/this5->antisense_trhighs[i],
						    /*query_compress_tr*/query5_compress_rev,/*tplusp*/false,querylength5,
						    mismatch_positions_alloc_5,/*want_lowest_coordinate_p*/true,
						    this5->indelinfo,max_insertionlen_5,max_deletionlen_5,
						    intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						    *last_method_5)) != NULL) {
	  this5->antisense_trpaths = Hitlist_push(this5->antisense_trpaths,hitlistpool,(void *) trpath5
						  hitlistpool_trace(__FILE__,__LINE__));
	}
	i++;

      } else if (index1 < i) {
	j++; k += 2;

      } else {
	i++; j++; k += 2;
      }
    }

    while (i < this5->n_antisense_trdiagonals) {
      if (this5->antisense_tstarts != NULL) {
	tstart5 = this5->antisense_tstarts[i];
	tend5 = this5->antisense_tends[i];
      }
      if ((trpath5 = Trpath_solve_from_trdiagonal(&(*found_score_5),/*trdiagonal*/this5->antisense_trdiagonals[i],
						  tstart5,tend5,/*trnum*/this5->antisense_trnums[i],
						  /*troffset*/this5->antisense_troffsets[i],
						  /*trhigh*/this5->antisense_trhighs[i],
						  /*query_compress_tr*/query5_compress_rev,/*tplusp*/false,querylength5,
						  mismatch_positions_alloc_5,/*want_lowest_coordinate_p*/true,
						  this5->indelinfo,max_insertionlen_5,max_deletionlen_5,
						  intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						  *last_method_5)) != NULL) {
	this5->antisense_trpaths = Hitlist_push(this5->antisense_trpaths,hitlistpool,(void *) trpath5
						hitlistpool_trace(__FILE__,__LINE__));
      }
      i++;
    }
      

    /* 3' read, antisense */
    tstart3 = 0;
    tend3 = querylength3;

    i = j = 0; k = 0;
    while (i < this3->n_antisense_trdiagonals && j < antisense_nindices) {
      index2 = antisense_indices[k+1];
      if (i < index2) {
	if (this3->antisense_tstarts != NULL) {
	  tstart3 = this3->antisense_tstarts[i];
	  tend3 = this3->antisense_tends[i];
	}
	if ((trpath3 = Trpath_solve_from_trdiagonal(&(*found_score_3),/*trdiagonal*/this3->antisense_trdiagonals[i],
						    tstart3,tend3,/*trnum*/this3->antisense_trnums[i],
						    /*troffset*/this3->antisense_troffsets[i],
						    /*trhigh*/this3->antisense_trhighs[i],
						    /*query_compress_tr*/query3_compress_rev,/*tplusp*/false,querylength3,
						    mismatch_positions_alloc_3,/*want_lowest_coordinate_p*/true,
						    this3->indelinfo,max_insertionlen_3,max_deletionlen_3,
						    intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						    *last_method_3)) != NULL) {
	  this3->antisense_trpaths = Hitlist_push(this3->antisense_trpaths,hitlistpool,(void *) trpath3
						  hitlistpool_trace(__FILE__,__LINE__));
	}
	i++;

      } else if (index2 < i) {
	j++; k += 2;

      } else {
	i++; j++; k += 2;
      }
    }

    while (i < this3->n_antisense_trdiagonals) {
      if (this3->antisense_tstarts != NULL) {
	tstart3 = this3->antisense_tstarts[i];
	tend3 = this3->antisense_tends[i];
      }
      if ((trpath3 = Trpath_solve_from_trdiagonal(&(*found_score_3),/*trdiagonal*/this3->antisense_trdiagonals[i],
						  tstart3,tend3,/*trnum*/this3->antisense_trnums[i],
						  /*troffset*/this3->antisense_troffsets[i],
						  /*trhigh*/this3->antisense_trhighs[i],
						  /*query_compress_tr*/query3_compress_rev,/*tplusp*/false,querylength3,
						  mismatch_positions_alloc_3,/*want_lowest_coordinate_p*/true,
						  this3->indelinfo,max_insertionlen_3,max_deletionlen_3,
						  intlistpool,uintlistpool,listpool,trpathpool,pathpool,
						  *last_method_3)) != NULL) {
	this3->antisense_trpaths = Hitlist_push(this3->antisense_trpaths,hitlistpool,(void *) trpath3
						hitlistpool_trace(__FILE__,__LINE__));
      }
      i++;
    }
    
    FREE(antisense_indices);
    FREE(sense_indices);

    return (List_T) NULL;
  }
}


static List_T
paired_read_next_method_tr_5 (int *found_score_paired, int *found_score_5, int *found_score_3, Method_T *last_method_5,

			      List_T pathpairs, T this5, T this3,
			      
			      Shortread_T queryseq5, Shortread_T queryseq3,
			      int querylength5, int querylength3,

			      int *mismatch_positions_alloc_5,
			      Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			      Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
			    
			      int nmismatches_allowed_5, int max_insertionlen_5, int max_deletionlen_5,
			      
			      int genestrand, Trdiagpool_T trdiagpool, Intlistpool_T intlistpool,
			      Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			      Listpool_T listpool, Trpathpool_T trpathpool, Pathpool_T pathpool,
			      Transcriptpool_T transcriptpool, Vectorpool_T vectorpool, Hitlistpool_T hitlistpool) {

  List_T sense_trpaths5, antisense_trpaths5;

  *last_method_5 = single_read_next_method_tr(&(*found_score_5),*last_method_5,
					     
					      &sense_trpaths5,&antisense_trpaths5,
					     
					      this5,genestrand,querylength5,
					      mismatch_positions_alloc_5,
					      query5_compress_fwd,query5_compress_rev,
					      nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
					      trdiagpool,intlistpool,uintlistpool,
					      listpool,trpathpool,pathpool,hitlistpool,/*appendp*/false);

  pathpairs = Concordance_tr(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 
			     /*new*/sense_trpaths5,/*sense_trpaths3*/NULL,
			     /*trpaths5*/this5->sense_trpaths,/*trpaths3*/this3->sense_trpaths,

			     query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			     queryseq5,queryseq3,querylength5,querylength3,this5,this3,

			     intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			     vectorpool,hitlistpool,/*sensedir*/SENSE_FORWARD);
  this5->sense_trpaths = List_append(sense_trpaths5,this5->sense_trpaths);

  pathpairs = Concordance_tr(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 
			     /*new*/antisense_trpaths5,/*antisense_trpaths3*/NULL,
			     /*trpaths5*/this5->antisense_trpaths,/*trpaths3*/this3->antisense_trpaths,
			     
			     query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			     queryseq5,queryseq3,querylength5,querylength3,this5,this3,

			     intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			     vectorpool,hitlistpool,/*sensedir*/SENSE_ANTI);
  this5->antisense_trpaths = List_append(antisense_trpaths5,this5->antisense_trpaths);

  return pathpairs;
}


static List_T
paired_read_next_method_tr_3 (int *found_score_paired, int *found_score_5, int *found_score_3, Method_T *last_method_3,

			      List_T pathpairs, T this5, T this3,
			      
			      Shortread_T queryseq5, Shortread_T queryseq3,
			      int querylength5, int querylength3,

			      int *mismatch_positions_alloc_3,
			      Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			      Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
			    
			      int nmismatches_allowed_3, int max_insertionlen_3, int max_deletionlen_3,
			      
			      int genestrand, Trdiagpool_T trdiagpool, Intlistpool_T intlistpool,
			      Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			      Listpool_T listpool, Trpathpool_T trpathpool, Pathpool_T pathpool,
			      Transcriptpool_T transcriptpool, Vectorpool_T vectorpool, Hitlistpool_T hitlistpool) {

  List_T sense_trpaths3, antisense_trpaths3;

  *last_method_3 = single_read_next_method_tr(&(*found_score_3),*last_method_3,
					     
					      &sense_trpaths3,&antisense_trpaths3,
					     
					      this3,genestrand,querylength3,
					      mismatch_positions_alloc_3,
					      query3_compress_fwd,query3_compress_rev,
					      nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
					      trdiagpool,intlistpool,uintlistpool,
					      listpool,trpathpool,pathpool,hitlistpool,/*appendp*/false);

  pathpairs = Concordance_tr(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 
			     /*sense_trpaths5*/NULL,/*new*/sense_trpaths3,
			     /*trpaths5*/this5->sense_trpaths,/*trpaths3*/this3->sense_trpaths,

			     query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			     queryseq5,queryseq3,querylength5,querylength3,this5,this3,

			     intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			     vectorpool,hitlistpool,/*sensedir*/SENSE_FORWARD);
  this3->sense_trpaths = List_append(sense_trpaths3,this3->sense_trpaths);

  pathpairs = Concordance_tr(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 
			     /*antisense_trpaths5*/NULL,/*new*/antisense_trpaths3,
			     /*trpaths5*/this5->antisense_trpaths,/*trpaths3*/this3->antisense_trpaths,
			     
			     query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			     queryseq5,queryseq3,querylength5,querylength3,this5,this3,

			     intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			     vectorpool,hitlistpool,/*sensedir*/SENSE_ANTI);
  this3->antisense_trpaths = List_append(antisense_trpaths3,this3->antisense_trpaths);

  return pathpairs;
}


static int
make_unique (Univcoord_T *diagonals, int ndiagonals) {
  int k = 0, i, j;

  i = 0;
  while (i < ndiagonals) {
    j = i + 1;
    while (j < ndiagonals && diagonals[j] == diagonals[i]) {
      j++;
    }
    diagonals[k++] = diagonals[i];
    
    i = j;
  }

  return k;
}


/* Should be fast for arrays in nearly sorted order */
static void
insertion_sort_low_univdiagonal (Path_T *paths, int len) {
  register int i, j;
  register Path_T temp;
  register Univcoord_T temp_low_univdiagonal;

  for (i = 1; i < len; i++) {
    j = i;
    temp = paths[j];
    temp_low_univdiagonal = Path_low_univdiagonal(temp);
    while (j > 0 && Path_low_univdiagonal(paths[j-1]) > temp_low_univdiagonal) {
      paths[j] = paths[j-1];
      j--;
    }
    paths[j] = temp;
  }

  return;
}

static void
insertion_sort_high_univdiagonal (Path_T *paths, int len) {
  register int i, j;
  register Path_T temp;
  register Univcoord_T temp_high_univdiagonal;

  for (i = 1; i < len; i++) {
    j = i;
    temp = paths[j];
    temp_high_univdiagonal = Path_high_univdiagonal(temp);
    while (j > 0 && Path_high_univdiagonal(paths[j-1]) > temp_high_univdiagonal) {
      paths[j] = paths[j-1];
      j--;
    }
    paths[j] = temp;
  }

  return;
}


/* Follows code in paired_search_trdiagonals */
/* Need to have paths in Stage1_T object that match univdiagonals */
static void
merge_paths_from_univdiagonals (int *found_score,

				List_T *unextended_sense_paths, List_T *unextended_antisense_paths,

				/* Merged sense/antisense univdiagonals */
				Univcoord_T **univdiagonals, int *nunivdiagonals,

				/* Targets */
				Path_T **sense_paths, Univcoord_T **sense_coords, int **sense_cumsums,
				int *sense_npaths, int *sense_nunique,
				Path_T **antisense_paths, Univcoord_T **antisense_coords, int **antisense_cumsums,
				int *antisense_npaths, int *antisense_nunique,
				
				/* Used for avoid duplicate solutions of univdiagonals */
				Univcoord_T *old_univdiagonals, int n_old_univdiagonals,
				Univcoord_T *new_univdiagonals, int n_new_univdiagonals,
				bool plusp, int querylength, bool first_read_p, 

				Shortread_T queryseq, char *queryptr, Compress_T query_compress,
				Compress_T query_compress_fwd, Compress_T query_compress_rev,
				int *mismatch_positions_alloc,

				Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
				T this, Knownsplicing_T knownsplicing, Knownindels_T knownindels,
				int max_insertionlen, int max_deletionlen, int localdb_nmismatches_allowed,
				Chrpos_T overall_end_distance,

				Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
				Univcoordlistpool_T univcoordlistpool, Listpool_T listpool, Pathpool_T pathpool,
				Transcriptpool_T transcriptpool, Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
				Spliceendsgen_T spliceendsgen, bool sort_high_univdiagonal_p, Method_T method,
				bool find_splices_p, bool solve_paths_p) {

  List_T new_sense_paths = NULL, new_antisense_paths = NULL;
  Univcoord_T univdiagonal_i, univdiagonal_j;
  int i, j;

  List_T incomplete;
  Path_T *alloc, *newpaths;
  Univcoord_T *coords;
  int noldpaths, nnewpaths, ncomplete;
  int *cumsums;


  if (solve_paths_p == false) {
    /* Use paths computed by TGGA, stored in Stage1_T arrays */
    for (i = 0; i < *sense_npaths; i++) {
      new_sense_paths = Hitlist_push(new_sense_paths,hitlistpool,(void *) (*sense_paths)[i]
				     hitlistpool_trace(__FILE__,__LINE__));
    }
    for (i = 0; i < *antisense_npaths; i++) {
      new_antisense_paths = Hitlist_push(new_antisense_paths,hitlistpool,(void *) (*antisense_paths)[i]
					 hitlistpool_trace(__FILE__,__LINE__));
    }

  } else {
    i = j = 0;
    while (i < n_old_univdiagonals && j < n_new_univdiagonals) {
      univdiagonal_i = old_univdiagonals[i];
      univdiagonal_j = new_univdiagonals[j];
      if (univdiagonal_i < univdiagonal_j) {
	i++;
      } else if (univdiagonal_i == univdiagonal_j) {
	i++; j++;
      } else {
	debug(printf("Solving %s path for leftover univdiagonal %u as method %s\n",
		     first_read_p ? "5'" : "3'",univdiagonal_j,Method_string(method)));
	Path_solve_from_univdiagonal(&(*found_score),

				     &(*unextended_sense_paths),&(*unextended_antisense_paths),
				     &new_sense_paths,&new_antisense_paths,

				     /*univdiagonal*/univdiagonal_j,
				     queryseq,queryptr,query_compress,
				     query_compress_fwd,query_compress_rev,

				     plusp,querylength,mismatch_positions_alloc,
				     novel_diagonals_alloc,localdb_alloc,this,knownsplicing,knownindels,
				     max_insertionlen,max_deletionlen,localdb_nmismatches_allowed,
				     overall_end_distance,/*paired_end_p*/true,first_read_p,

				     intlistpool,uintlistpool,univcoordlistpool,
				     listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen,
				     method,find_splices_p);
	j++;
      }
    }

    while (j < n_new_univdiagonals) {
      univdiagonal_j = new_univdiagonals[j];
      debug(printf("Solving %s path for leftover univdiagonal %u as method %s\n",
		   first_read_p ? "5'" : "3'",univdiagonal_j,Method_string(method)));
      Path_solve_from_univdiagonal(&(*found_score),

				   &(*unextended_sense_paths),&(*unextended_antisense_paths),
				   &new_sense_paths,&new_antisense_paths,

				   /*univdiagonal*/univdiagonal_j,
				   queryseq,queryptr,query_compress,
				   query_compress_fwd,query_compress_rev,

				   plusp,querylength,mismatch_positions_alloc,
				   novel_diagonals_alloc,localdb_alloc,this,knownsplicing,knownindels,
				   max_insertionlen,max_deletionlen,localdb_nmismatches_allowed,
				   overall_end_distance,/*paired_end_p*/true,first_read_p,

				   intlistpool,uintlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen,
				   method,find_splices_p);
      j++;
    }
  }


  /* univdiagonals should be in ascending order, so lists of paths should be approximately descending order */
  /* However, we don't know what happens to low_univdiagonal and high_univdiagonal when Path_solve_from_diagonals adds segments */
  new_sense_paths = List_reverse(new_sense_paths);
  new_antisense_paths = List_reverse(new_antisense_paths);

  debug(printf("Merging %d sense and %d antisense paths\n",
	       List_length(new_sense_paths),List_length(new_antisense_paths)));
  if ((nnewpaths = List_length(new_sense_paths)) > 0) {
    newpaths = (Path_T *) List_to_array(new_sense_paths,NULL); /* If solved from univdiagonals, should be nearly sorted already */

    if (sort_high_univdiagonal_p == true) {
      insertion_sort_high_univdiagonal(newpaths,nnewpaths);
    } else {
      insertion_sort_low_univdiagonal(newpaths,nnewpaths);
    }
    Hitlistpool_free_list(&new_sense_paths,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    noldpaths = *sense_npaths;
    alloc = (Path_T *) MALLOC((noldpaths + nnewpaths) * sizeof(Path_T));
    MALLOC_ALIGN(coords, (noldpaths + nnewpaths) * sizeof(Univcoord_T));
    cumsums = (int *) MALLOC((noldpaths + nnewpaths) * sizeof(int));

    if (sort_high_univdiagonal_p == true) {
      *sense_nunique =
	Path_merge_high_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				     newpaths,nnewpaths,/*oldpaths*/*sense_paths,noldpaths,
				     hitlistpool);
    } else {
      *sense_nunique =
	Path_merge_low_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				    newpaths,nnewpaths,/*oldpaths*/*sense_paths,noldpaths,
				    hitlistpool);
    }
    assert(incomplete == (List_T) NULL);
    FREE(newpaths);

    FREE(*sense_paths);
    FREE(*sense_coords);
    FREE(*sense_cumsums);
    *sense_paths = alloc;
    *sense_coords = coords;
    *sense_cumsums = cumsums;
    *sense_npaths += ncomplete;
  }

  if ((nnewpaths = List_length(new_antisense_paths)) > 0) {
    newpaths = (Path_T *) List_to_array(new_antisense_paths,NULL); /* If solved from univdiagonals, should be nearly sorted already */
    if (sort_high_univdiagonal_p == true) {
      insertion_sort_high_univdiagonal(newpaths,nnewpaths);
    } else {
      insertion_sort_low_univdiagonal(newpaths,nnewpaths);
    }
    Hitlistpool_free_list(&new_antisense_paths,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    noldpaths = *antisense_npaths;
    alloc = (Path_T *) MALLOC((noldpaths + nnewpaths) * sizeof(Path_T));
    MALLOC_ALIGN(coords, (noldpaths + nnewpaths) * sizeof(Univcoord_T));
    cumsums = (int *) MALLOC((noldpaths + nnewpaths) * sizeof(int));

    if (sort_high_univdiagonal_p == true) {
      *antisense_nunique =
	Path_merge_high_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				     newpaths,nnewpaths,/*oldpaths*/*antisense_paths,noldpaths,
				     hitlistpool);
    } else {
      *antisense_nunique =
	Path_merge_low_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				    newpaths,nnewpaths,/*oldpaths*/*antisense_paths,noldpaths,
				    hitlistpool);
    }
    assert(incomplete == (List_T) NULL);
    FREE(newpaths);

    FREE(*antisense_paths);
    FREE(*antisense_coords);
    FREE(*antisense_cumsums);
    *antisense_paths = alloc;
    *antisense_coords = coords;
    *antisense_cumsums = cumsums;
    *antisense_npaths += ncomplete;
  }

  FREE_ALIGN(*univdiagonals);
#ifdef LARGE_GENOMES
  *univdiagonals = Merge_uint8(/*dest*/NULL,*sense_coords,*antisense_coords,
			       *sense_nunique,*antisense_nunique);
#else
  *univdiagonals = Merge_uint4(/*dest*/NULL,*sense_coords,*antisense_coords,
			       *sense_nunique,*antisense_nunique);
#endif
  *nunivdiagonals = make_unique(*univdiagonals,(*sense_nunique) + (*antisense_nunique));

  return;
}


static void
merge_sense_antisense_coords (T this) {
#ifdef LARGE_GENOMES
  this->univdiagonals_gplus = Merge_uint8(/*dest*/NULL,this->sense_coords_gplus,this->antisense_coords_gplus,
					   this->nunique_sense_coords_gplus,this->nunique_antisense_coords_gplus);
  this->nunivdiagonals_gplus = make_unique(this->univdiagonals_gplus,
					    this->nunique_sense_coords_gplus + this->nunique_antisense_coords_gplus);
  this->univdiagonals_gminus = Merge_uint8(/*dest*/NULL,this->sense_coords_gminus,this->antisense_coords_gminus,
					    this->nunique_sense_coords_gminus,this->nunique_antisense_coords_gminus);
  this->nunivdiagonals_gminus = make_unique(this->univdiagonals_gminus,
					     this->nunique_sense_coords_gminus + this->nunique_antisense_coords_gminus);
#else
  this->univdiagonals_gplus = Merge_uint4(/*dest*/NULL,this->sense_coords_gplus,this->antisense_coords_gplus,
					   this->nunique_sense_coords_gplus,this->nunique_antisense_coords_gplus);
  this->nunivdiagonals_gplus = make_unique(this->univdiagonals_gplus,
					    this->nunique_sense_coords_gplus + this->nunique_antisense_coords_gplus);
  this->univdiagonals_gminus = Merge_uint4(/*dest*/NULL,this->sense_coords_gminus,this->antisense_coords_gminus,
					    this->nunique_sense_coords_gminus,this->nunique_antisense_coords_gminus);
  this->nunivdiagonals_gminus = make_unique(this->univdiagonals_gminus,
					     this->nunique_sense_coords_gminus + this->nunique_antisense_coords_gminus);
#endif
}
  

/* Find concordance on unextended paths in Stage1_T object */
static List_T
unextended_search (int *found_score_paired, int *found_score_5, int *found_score_3,

		   List_T pathpairs, T this5, T this3,
		   
		   Shortread_T queryseq5, Shortread_T queryseq3,
		   char *queryuc_ptr_5, char *queryrc5, int querylength5,
		   char *queryuc_ptr_3, char *queryrc3, int querylength3,
		   Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		   
		   int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
		   Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		   Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		   Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
		   
		   int nmismatches_allowed_5, int nmismatches_allowed_3,
		   int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
		   int genestrand, Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,

		   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		   Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		   Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
		   Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3) {

  debug(printf("Calling Concordance_gen with unextended paths, sense, with %d and %d gplus, %d and %d gminus\n",
	       List_length(this5->unextended_sense_paths_gplus),List_length(this3->unextended_sense_paths_gplus),
	       List_length(this5->unextended_sense_paths_gminus),List_length(this3->unextended_sense_paths_gminus)));
  pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,

			      /*newpaths5_gplus*/&this5->unextended_sense_paths_gplus,
			      /*newpaths5_gminus*/&this5->unextended_sense_paths_gminus,
			      /*newpaths3_gplus*/&this3->unextended_sense_paths_gplus,
			      /*newpaths3_gminus*/&this3->unextended_sense_paths_gminus,
			      
			      &this5->sense_paths_gplus,&this5->sense_paths_gminus,
			      &this3->sense_paths_gplus,&this3->sense_paths_gminus,
			      &this5->sense_coords_gplus,&this5->sense_coords_gminus,
			      &this3->sense_coords_gplus,&this3->sense_coords_gminus,
			      &this5->sense_indices_gplus,&this5->sense_indices_gminus,
			      &this3->sense_indices_gplus,&this3->sense_indices_gminus,
			      &this5->n_sense_paths_gplus,&this5->n_sense_paths_gminus,
			      &this3->n_sense_paths_gplus,&this3->n_sense_paths_gminus,
			      &this5->nunique_sense_coords_gplus,&this5->nunique_sense_coords_gminus,
			      &this3->nunique_sense_coords_gplus,&this3->nunique_sense_coords_gminus,
				 
			      query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			      queryseq5,queryseq3,
			      queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
			      this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				 
			      novel_diagonals_alloc,localdb_alloc,
			      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
			      nmismatches_allowed_5,nmismatches_allowed_3,
			      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
			      overall_end_distance_5,overall_end_distance_3,
				 
			      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			      vectorpool,hitlistpool,genestrand,/*mergep*/true);
  
    if (splicingp == true) {
    debug(printf("Calling Concordance_gen with unextended paths, antisense, with %d and %d gplus, %d and %d gminus\n",
	       List_length(this5->unextended_antisense_paths_gplus),List_length(this3->unextended_antisense_paths_gplus),
	       List_length(this5->unextended_antisense_paths_gminus),List_length(this3->unextended_antisense_paths_gminus)));
    pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,

				/*newpaths5_gplus*/&this5->unextended_antisense_paths_gplus,
				/*newpaths5_gminus*/&this5->unextended_antisense_paths_gminus,
				/*newpaths3_gplus*/&this3->unextended_antisense_paths_gplus,
				/*newpaths3_gminus*/&this3->unextended_antisense_paths_gminus,
				   
				&this5->antisense_paths_gplus,&this5->antisense_paths_gminus,
				&this3->antisense_paths_gplus,&this3->antisense_paths_gminus,
				&this5->antisense_coords_gplus,&this5->antisense_coords_gminus,
				&this3->antisense_coords_gplus,&this3->antisense_coords_gminus,
				&this5->antisense_indices_gplus,&this5->antisense_indices_gminus,
				&this3->antisense_indices_gplus,&this3->antisense_indices_gminus,
				&this5->n_antisense_paths_gplus,&this5->n_antisense_paths_gminus,
				&this3->n_antisense_paths_gplus,&this3->n_antisense_paths_gminus,
				&this5->nunique_antisense_coords_gplus,&this5->nunique_antisense_coords_gminus,
				&this3->nunique_antisense_coords_gplus,&this3->nunique_antisense_coords_gminus,
				   
				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				   
				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				   
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,genestrand,/*mergep*/true);
    
  }

  debug(printf("After looking at unextended paths, we have %d pathpairs and found scores %d and %d\n",
	       List_length(pathpairs),*found_score_5,*found_score_3));

  if (pathpairs != NULL) {
    return pathpairs;

  } else {
    FREE_ALIGN(this5->univdiagonals_gplus);
    FREE_ALIGN(this5->univdiagonals_gminus);
    FREE_ALIGN(this3->univdiagonals_gplus);
    FREE_ALIGN(this3->univdiagonals_gminus);

    merge_sense_antisense_coords(this5);
    merge_sense_antisense_coords(this3);

    return (List_T) NULL;
  }
}


static int
count_density (Univcoord_T *univdiagonals, int nunivdiagonals, Univcoord_T slop) {
  int ndense = 0;
  int i;

  for (i = 0; i < nunivdiagonals - 1; i++) {
    if (univdiagonals[i + 1] < univdiagonals[i] + slop) {
      ndense++;
    }
  }

  return ndense;
}
    

/* Also removes duplicates */
static int
remove_dense (Univcoord_T *diagonals, int ndiagonals, Univcoord_T slop) {
  int k = 0, i, j;
  int ndups;

  i = 0;
  while (i < ndiagonals) {
    j = i + 1;
    ndups = 0;
    while (j < ndiagonals && diagonals[j] == diagonals[i]) {
      j++;
      ndups++;
    }
    while (j < ndiagonals && diagonals[j] < diagonals[i] + slop) {
      j++;
    }
    if (j - i - ndups == 1) {
      diagonals[k++] = diagonals[i];
    } else {
      diagonals[k++] = diagonals[i];
      diagonals[k++] = diagonals[j - 1];
    }
    
    i = j;
  }

  return k;
}


static List_T
paired_search_univdiagonals (int *found_score_paired, int *found_score_5, int *found_score_3,
			     Method_T *last_method_5, Method_T *last_method_3,
		  
			     List_T pathpairs, T this5, T this3,
	      
			     Shortread_T queryseq5, Shortread_T queryseq3,
			     char *queryuc_ptr_5, char *queryrc5, int querylength5,
			     char *queryuc_ptr_3, char *queryrc3, int querylength3,
			     Knownsplicing_T knownsplicing, Knownindels_T knownindels,
			      
			     int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
			     Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			     Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			     Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
	      
			     int nmismatches_allowed_5, int nmismatches_allowed_3,
			     int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
			     int genestrand, Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,
			     
			     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			     Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			     Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
			     Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3,
			     Method_T final_univdiagonal_method) {
  
  List_T sense_paths5_gplus = NULL, sense_paths5_gminus = NULL, antisense_paths5_gplus = NULL, antisense_paths5_gminus = NULL,
    sense_paths3_gplus = NULL, sense_paths3_gminus = NULL, antisense_paths3_gplus = NULL, antisense_paths3_gminus = NULL;

  Univcoord_T *univdiagonals5_gplus, *univdiagonals5_gminus, *univdiagonals3_gplus, *univdiagonals3_gminus;
  int nunivdiagonals5_gplus, nunivdiagonals5_gminus, nunivdiagonals3_gplus, nunivdiagonals3_gminus;

  int *plus_indices, *minus_indices;
  int plus_nindices, minus_nindices;
  int index1, index2;

  int ndense5_gplus, ndense3_gplus, ndense5_gminus, ndense3_gminus;
  int i, k;

  /* Actually want to provide pair distance */
  debug(printf("\n>>Entered paired_search_univdiagonals with %d and %d, %s and %s\n",
	       *found_score_5,*found_score_3,Method_string(*last_method_5),Method_string(*last_method_3)));
  debug(Stage1_list_univdiagonals(this5));
  debug(Stage1_list_univdiagonals(this3));
	       
  if (*last_method_5 < final_univdiagonal_method && *last_method_3 < final_univdiagonal_method) {
    debug(printf("(1) Running 5' and 3'\n"));
    *last_method_5 = single_read_next_method_univdiagonal(*last_method_5,
							  &univdiagonals5_gplus,&nunivdiagonals5_gplus,
							  &univdiagonals5_gminus,&nunivdiagonals5_gminus,
							  this5,/*mate*/this3,genestrand,querylength5,
							  overall_end_distance_5,/*first_read_p*/true);
    *last_method_3 = single_read_next_method_univdiagonal(*last_method_3,
							  &univdiagonals3_gplus,&nunivdiagonals3_gplus,
							  &univdiagonals3_gminus,&nunivdiagonals3_gminus,
							  this3,/*mate*/this5,genestrand,querylength3,
							  overall_end_distance_3,/*first_read_p*/false);
  } else if (*last_method_5 >= final_univdiagonal_method) {
    debug(printf("(2) Running 3'\n"));
    univdiagonals5_gplus = univdiagonals5_gminus = (Univcoord_T *) NULL;
    nunivdiagonals5_gplus = nunivdiagonals5_gminus = 0;
    *last_method_3 = single_read_next_method_univdiagonal(*last_method_3,
							  &univdiagonals3_gplus,&nunivdiagonals3_gplus,
							  &univdiagonals3_gminus,&nunivdiagonals3_gminus,
							  this3,/*mate*/this5,genestrand,querylength3,
							  overall_end_distance_3,/*first_read_p*/false);
  } else if (*last_method_3 >= final_univdiagonal_method) {
    debug(printf("(3) Running 5'\n"));
    univdiagonals3_gplus = univdiagonals3_gminus = (Univcoord_T *) NULL;
    nunivdiagonals3_gplus = nunivdiagonals3_gminus = 0;
    *last_method_5 = single_read_next_method_univdiagonal(*last_method_5,
							  &univdiagonals5_gplus,&nunivdiagonals5_gplus,
							  &univdiagonals5_gminus,&nunivdiagonals5_gminus,
							  this5,/*mate*/this3,genestrand,querylength5,
							  overall_end_distance_5,/*first_read_p*/true);

  } else if (*found_score_5 >= *found_score_3) {
    debug(printf("(4) Running 5'\n"));
    univdiagonals3_gplus = univdiagonals3_gminus = (Univcoord_T *) NULL;
    nunivdiagonals3_gplus = nunivdiagonals3_gminus = 0;
    *last_method_5 = single_read_next_method_univdiagonal(*last_method_5,
							  &univdiagonals5_gplus,&nunivdiagonals5_gplus,
							  &univdiagonals5_gminus,&nunivdiagonals5_gminus,
							  this5,/*mate*/this3,genestrand,querylength5,
							  overall_end_distance_5,/*first_read_p*/true);

  } else {
    debug(printf("(5) Running 3'\n"));
    univdiagonals5_gplus = univdiagonals5_gminus = (Univcoord_T *) NULL;
    nunivdiagonals5_gplus = nunivdiagonals5_gminus = 0;
    *last_method_3 = single_read_next_method_univdiagonal(*last_method_3,
							  &univdiagonals3_gplus,&nunivdiagonals3_gplus,
							  &univdiagonals3_gminus,&nunivdiagonals3_gminus,
							  this3,/*mate*/this5,genestrand,querylength3,
							  overall_end_distance_3,/*first_read_p*/false);
  }

  debug(printf("Have %d and %d plus univdiagonals, %d and %d minus univdiagonals\n",
	       nunivdiagonals5_gplus,nunivdiagonals3_gplus,
	       nunivdiagonals5_gminus,nunivdiagonals3_gminus));

  nunivdiagonals5_gplus = remove_dense(univdiagonals5_gplus,nunivdiagonals5_gplus,/*slop*/shortsplicedist);
  nunivdiagonals5_gminus = remove_dense(univdiagonals5_gminus,nunivdiagonals5_gminus,/*slop*/shortsplicedist);
  nunivdiagonals3_gplus = remove_dense(univdiagonals3_gplus,nunivdiagonals3_gplus,/*slop*/shortsplicedist);
  nunivdiagonals3_gminus = remove_dense(univdiagonals3_gminus,nunivdiagonals3_gminus,/*slop*/shortsplicedist);

  debug(printf("After removing dense regions, have %d and %d plus univdiagonals, %d and %d minus univdiagonals\n",
	       nunivdiagonals5_gplus,nunivdiagonals3_gplus,
	       nunivdiagonals5_gminus,nunivdiagonals3_gminus));

#ifdef DEBUG
  printf("5' plus:");
  for (i = 0; i < nunivdiagonals5_gplus; i++) {
    printf(" %u",univdiagonals5_gplus[i]);
  }
  printf("\n");

  printf("3' plus:");
  for (i = 0; i < nunivdiagonals3_gplus; i++) {
    printf(" %u",univdiagonals3_gplus[i]);
  }
  printf("\n");

  printf("5' minus:");
  for (i = 0; i < nunivdiagonals5_gminus; i++) {
    printf(" %u",univdiagonals5_gminus[i]);
  }
  printf("\n");

  printf("3' minus:");
  for (i = 0; i < nunivdiagonals3_gminus; i++) {
    printf(" %u",univdiagonals3_gminus[i]);
  }
  printf("\n");
#endif


  /* Find concordant univdiagonals */
  /* Now that we are no longer using qmin and qmax, could change back to Intersect_approx procedures */
#if 0
  /* But check for dense univdiagonals on both sides, which can give O(n^2) pairs */
  ndense5_gplus = count_density(this5->exact_univdiagonals_gplus,this5->exact_nunivdiagonals_gplus,
				/*slop*/shortsplicedist);
  ndense3_gplus = count_density(this3->exact_univdiagonals_gplus,this3->exact_nunivdiagonals_gplus,
				/*slop*/shortsplicedist);
  debug(printf("plus density: %d/%d and %d/%d\n",
	       ndense5_gplus,this5->exact_nunivdiagonals_gplus,ndense3_gplus,this3->exact_nunivdiagonals_gplus));

  if (ndense5_gplus * ndense3_gplus > MAX_DENSITY_INTERSECTION &&
      ndense5_gplus >= 0.20 * this5->exact_nunivdiagonals_gplus &&
      ndense3_gplus >= 0.20 * this3->exact_nunivdiagonals_gplus) {
    debug(printf("Skipping due to dual density\n"));
    plus_indices = (int *) NULL;
    plus_nindices = 0;
  }
#endif

  /* A.  New5 vs New3 */
#ifdef LARGE_GENOMES
  plus_indices = Intersect_approx_indices_uint8(&plus_nindices,
						univdiagonals5_gplus,nunivdiagonals5_gplus,/*diagterm1*/0,
						univdiagonals3_gplus,nunivdiagonals3_gplus,/*diagterm2*/0,
						/*below_slop*/0,/*above_slop*/shortsplicedist);
#else
  plus_indices = Intersect_approx_indices_uint4(&plus_nindices,
						univdiagonals5_gplus,nunivdiagonals5_gplus,/*diagterm1*/0,
						univdiagonals3_gplus,nunivdiagonals3_gplus,/*diagterm2*/0,
						/*below_slop*/0,/*above_slop*/shortsplicedist);
#endif


#ifdef LARGE_GENOMES
  minus_indices = Intersect_approx_indices_uint8(&minus_nindices,
						 univdiagonals5_gminus,nunivdiagonals5_gminus,/*diagterm1*/0,
						 univdiagonals3_gminus,nunivdiagonals3_gminus,/*diagterm2*/0,
						 /*below_slop*/shortsplicedist,/*above_slop*/0);
#else
  minus_indices = Intersect_approx_indices_uint4(&minus_nindices,
						 univdiagonals5_gminus,nunivdiagonals5_gminus,/*diagterm1*/0,
						 univdiagonals3_gminus,nunivdiagonals3_gminus,/*diagterm2*/0,
						 /*below_slop*/shortsplicedist,/*above_slop*/0);
#endif

  debug(printf("New5 vs New3: Have %d plus concordant and %d minus concordant\n",plus_nindices,minus_nindices));
  for (i = 0, k = 0; i < plus_nindices; i++, k += 2) {
    index1 = plus_indices[k];
    index2 = plus_indices[k+1];

    debug(printf("Solving 5' path for new univdiagonal %u as method %s\n",
		 univdiagonals5_gplus[index1],Method_string(*last_method_5)));
    Path_solve_from_univdiagonal(&(*found_score_5),

				 &this5->unextended_sense_paths_gplus,&this5->unextended_antisense_paths_gplus,
				 &sense_paths5_gplus,&antisense_paths5_gplus,

				 /*univdiagonal*/univdiagonals5_gplus[index1],
				 queryseq5,/*queryptr*/queryuc_ptr_5,/*query_compress*/query5_compress_fwd,
				 query5_compress_fwd,query5_compress_rev,

				 /*plusp*/true,querylength5,mismatch_positions_alloc_5,
				 novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				 max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,
				 overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				 /*method*/*last_method_5,/*find_splices_p*/true);

    debug(printf("Solving 3' path for new univdiagonal %u as method %s\n",
		 univdiagonals3_gplus[index2],Method_string(*last_method_3)));
    Path_solve_from_univdiagonal(&(*found_score_3),

				 &this3->unextended_sense_paths_gplus,&this3->unextended_antisense_paths_gplus,
				 &sense_paths3_gplus,&antisense_paths3_gplus,

				 /*univdiagonal*/univdiagonals3_gplus[index2],
				 queryseq3,/*queryptr*/queryuc_ptr_3,/*query_compress*/query3_compress_fwd,
				 query3_compress_fwd,query3_compress_rev,

				 /*plusp*/true,querylength3,mismatch_positions_alloc_3,
				 novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				 max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,
				 overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				 /*method*/*last_method_3,/*find_splices_p*/true);
  }

  for (i = 0, k = 0; i < minus_nindices; i++, k += 2) {
    index1 = minus_indices[k];
    index2 = minus_indices[k+1];

    debug(printf("Solving 5' path for new univdiagonal %u as method %s\n",
		 univdiagonals5_gminus[index1],Method_string(*last_method_5)));
    Path_solve_from_univdiagonal(&(*found_score_5),

				 &this5->unextended_sense_paths_gminus,&this5->unextended_antisense_paths_gminus,
				 &sense_paths5_gminus,&antisense_paths5_gminus,

				 /*univdiagonal*/univdiagonals5_gminus[index1],
				 queryseq5,/*queryptr*/queryrc5,/*query_compress*/query5_compress_rev,
				 query5_compress_fwd,query5_compress_rev,

				 /*plusp*/false,querylength5,mismatch_positions_alloc_5,
				 novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				 max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,
				 overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				 /*method*/*last_method_5,/*find_splices_p*/true);

    debug(printf("Solving 3' path for new univdiagonal %u as method %s\n",
		 univdiagonals3_gminus[index2],Method_string(*last_method_3)));
    Path_solve_from_univdiagonal(&(*found_score_3),

				 &this3->unextended_sense_paths_gminus,&this3->unextended_antisense_paths_gminus,
				 &sense_paths3_gminus,&antisense_paths3_gminus,

				 /*univdiagonal*/univdiagonals3_gminus[index2],
				 queryseq3,/*queryptr*/queryrc3,/*query_compress*/query3_compress_rev,
				 query3_compress_fwd,query3_compress_rev,

				 /*plusp*/false,querylength3,mismatch_positions_alloc_3,
				 novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				 max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,
				 overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,
				 
				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				 /*method*/*last_method_3,/*find_splices_p*/true);
  }

  FREE(minus_indices);
  FREE(plus_indices);


  /* B.  New5 vs Old3 */
#ifdef LARGE_GENOMES
  plus_indices = Intersect_approx_indices_uint8(&plus_nindices,
						univdiagonals5_gplus,nunivdiagonals5_gplus,/*diagterm1*/0,
						this3->univdiagonals_gplus,this3->nunivdiagonals_gplus,/*diagterm2*/0,
						/*below_slop*/0,/*above_slop*/shortsplicedist);
#else
  plus_indices = Intersect_approx_indices_uint4(&plus_nindices,
						univdiagonals5_gplus,nunivdiagonals5_gplus,/*diagterm1*/0,
						this3->univdiagonals_gplus,this3->nunivdiagonals_gplus,/*diagterm2*/0,
						/*below_slop*/0,/*above_slop*/shortsplicedist);
#endif


#ifdef LARGE_GENOMES
  minus_indices = Intersect_approx_indices_uint8(&minus_nindices,
						 univdiagonals5_gminus,nunivdiagonals5_gminus,/*diagterm1*/0,
						 this3->univdiagonals_gminus,this3->nunivdiagonals_gminus,/*diagterm2*/0,
						 /*below_slop*/shortsplicedist,/*above_slop*/0);
#else
  minus_indices = Intersect_approx_indices_uint4(&minus_nindices,
						 univdiagonals5_gminus,nunivdiagonals5_gminus,/*diagterm1*/0,
						 this3->univdiagonals_gminus,this3->nunivdiagonals_gminus,/*diagterm2*/0,
						 /*below_slop*/shortsplicedist,/*above_slop*/0);
#endif

  debug(printf("New5 vs Old3: Have %d plus concordant and %d minus concordant\n",plus_nindices,minus_nindices));
  for (i = 0, k = 0; i < plus_nindices; i++, k += 2) {
    index1 = plus_indices[k];
    index2 = plus_indices[k+1];

    debug(printf("Solving 5' path for new univdiagonal %u as method %s\n",
		 univdiagonals5_gplus[index1],Method_string(*last_method_5)));
    Path_solve_from_univdiagonal(&(*found_score_5),

				 &this5->unextended_sense_paths_gplus,&this5->unextended_antisense_paths_gplus,
				 &sense_paths5_gplus,&antisense_paths5_gplus,

				 /*univdiagonal*/univdiagonals5_gplus[index1],
				 queryseq5,/*queryptr*/queryuc_ptr_5,/*query_compress*/query5_compress_fwd,
				 query5_compress_fwd,query5_compress_rev,

				 /*plusp*/true,querylength5,mismatch_positions_alloc_5,
				 novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				 max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,
				 overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				 /*method*/*last_method_5,/*find_splices_p*/true);


#if 0
    /* Paths should already be solved for old univdiagonals */
    if (method_print_p == false) {
      method3 = *last_method_3;
    } else {
      method3 = Univcoordtableuint_get(this3->methods_gplus,this3->univdiagonals_gplus[index2]);
    }
    debug(printf("Solving 3' path for old univdiagonal %u as method %s\n",
		 this3->univdiagonals_gplus[index2],Method_string(method3)));
    Path_solve_from_univdiagonal(&(*found_score_3),

				 &this3->unextended_sense_paths_gplus,&this3->unextended_antisense_paths_gplus,
				 &sense_paths3_gplus,&antisense_paths3_gplus,

				 /*univdiagonal*/this3->univdiagonals_gplus[index2],
				 queryseq3,/*queryptr*/queryuc_ptr_3,/*query_compress*/query3_compress_fwd,
				 query3_compress_fwd,query3_compress_rev,

				 /*plusp*/true,querylength3,mismatch_positions_alloc_3,
				 novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				 max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,
				 overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				 /*method*/method3,/*find_splices_p*/true);
#endif
  }

  for (i = 0, k = 0; i < minus_nindices; i++, k += 2) {
    index1 = minus_indices[k];
    index2 = minus_indices[k+1];

    debug(printf("Solving 5' path for new univdiagonal %u as method %s\n",
		 univdiagonals5_gminus[index1],Method_string(*last_method_5)));
    Path_solve_from_univdiagonal(&(*found_score_5),

				 &this5->unextended_sense_paths_gminus,&this5->unextended_antisense_paths_gminus,
				 &sense_paths5_gminus,&antisense_paths5_gminus,

				 /*univdiagonal*/univdiagonals5_gminus[index1],
				 queryseq5,/*queryptr*/queryrc5,/*query_compress*/query5_compress_rev,
				 query5_compress_fwd,query5_compress_rev,

				 /*plusp*/false,querylength5,mismatch_positions_alloc_5,
				 novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				 max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,
				 overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				 /*method*/*last_method_5,/*find_splices_p*/true);

#if 0
    /* Paths should already be solved for old univdiagonals */
    if (method_print_p == false) {
      method3 = *last_method_3;
    } else {
      method3 = Univcoordtableuint_get(this3->methods_gminus,this3->univdiagonals_gminus[index2]);
    }
    debug(printf("Solving 3' path for old univdiagonal %u as method %s\n",
		 this3->univdiagonals_gminus[index2],Method_string(method3)));
    Path_solve_from_univdiagonal(&(*found_score_3),

				 &this3->unextended_sense_paths_gminus,&this3->unextended_antisense_paths_gminus,
				 &sense_paths3_gminus,&antisense_paths3_gminus,

				 /*univdiagonal*/this3->univdiagonals_gminus[index2],
				 queryseq3,/*queryptr*/queryrc3,/*query_compress*/query3_compress_rev,
				 query3_compress_fwd,query3_compress_rev,

				 /*plusp*/false,querylength3,mismatch_positions_alloc_3,
				 novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				 max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,
				 overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,
				 
				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				 /*method*/method3,/*find_splices_p*/true);
#endif
  }

  FREE(minus_indices);
  FREE(plus_indices);


  /* C.  Old5 vs New3 */
#ifdef LARGE_GENOMES
  plus_indices = Intersect_approx_indices_uint8(&plus_nindices,
						this5->univdiagonals_gplus,this5->nunivdiagonals_gplus,/*diagterm1*/0,
						univdiagonals3_gplus,nunivdiagonals3_gplus,/*diagterm2*/0,
						/*below_slop*/0,/*above_slop*/shortsplicedist);
#else
  plus_indices = Intersect_approx_indices_uint4(&plus_nindices,
						this5->univdiagonals_gplus,this5->nunivdiagonals_gplus,/*diagterm1*/0,
						univdiagonals3_gplus,nunivdiagonals3_gplus,/*diagterm2*/0,
						/*below_slop*/0,/*above_slop*/shortsplicedist);
#endif


#ifdef LARGE_GENOMES
  minus_indices = Intersect_approx_indices_uint8(&minus_nindices,
						 this5->univdiagonals_gminus,this5->nunivdiagonals_gminus,/*diagterm1*/0,
						 univdiagonals3_gminus,nunivdiagonals3_gminus,/*diagterm2*/0,
						 /*below_slop*/shortsplicedist,/*above_slop*/0);
#else
  minus_indices = Intersect_approx_indices_uint4(&minus_nindices,
						 this5->univdiagonals_gminus,this5->nunivdiagonals_gminus,/*diagterm1*/0,
						 univdiagonals3_gminus,nunivdiagonals3_gminus,/*diagterm2*/0,
						 /*below_slop*/shortsplicedist,/*above_slop*/0);
#endif


  debug(printf("Old5 vs New3: Have %d plus concordant and %d minus concordant\n",plus_nindices,minus_nindices));
  for (i = 0, k = 0; i < plus_nindices; i++, k += 2) {
    index1 = plus_indices[k];
    index2 = plus_indices[k+1];

#if 0
    /* Paths should already be solved for old univdiagonals */
    if (method_print_p == false) {
      method5 = *last_method_5;
    } else {
      method5 = Univcoordtableuint_get(this5->methods_gplus,this5->univdiagonals_gplus[index1]);
    }
    debug(printf("Solving 5' path for old univdiagonal %u as method %s\n",
		 this5->univdiagonals_gplus[index1],Method_string(method5)));
    Path_solve_from_univdiagonal(&(*found_score_5),

				 &this5->unextended_sense_paths_gplus,&this5->unextended_antisense_paths_gplus,
				 &sense_paths5_gplus,&antisense_paths5_gplus,

				 /*univdiagonal*/this5->univdiagonals_gplus[index1],
				 queryseq5,/*queryptr*/queryuc_ptr_5,/*query_compress*/query5_compress_fwd,
				 query5_compress_fwd,query5_compress_rev,

				 /*plusp*/true,querylength5,mismatch_positions_alloc_5,
				 novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				 max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,
				 overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				 /*method*/method5,/*find_splices_p*/true);
#endif

    debug(printf("Solving 3' path for new univdiagonal %u as method %s\n",
		 univdiagonals3_gplus[index2],Method_string(*last_method_3)));
    Path_solve_from_univdiagonal(&(*found_score_3),

				 &this3->unextended_sense_paths_gplus,&this3->unextended_antisense_paths_gplus,
				 &sense_paths3_gplus,&antisense_paths3_gplus,

				 /*univdiagonal*/univdiagonals3_gplus[index2],
				 queryseq3,/*queryptr*/queryuc_ptr_3,/*query_compress*/query3_compress_fwd,
				 query3_compress_fwd,query3_compress_rev,

				 /*plusp*/true,querylength3,mismatch_positions_alloc_3,
				 novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				 max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,
				 overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				 /*method*/*last_method_3,/*find_splices_p*/true);
  }

  for (i = 0, k = 0; i < minus_nindices; i++, k += 2) {
    index1 = minus_indices[k];
    index2 = minus_indices[k+1];

#if 0
    /* Paths should already be solved for old univdiagonals */
    if (method_print_p == false) {
      method5 = *last_method_5;
    } else {
      method5 = Univcoordtableuint_get(this5->methods_gminus,this5->univdiagonals_gminus[index1]);
    }
    debug(printf("Solving 5' path for old univdiagonal %u as method %s\n",
		 this5->univdiagonals_gminus[index1],Method_string(method5)));
    Path_solve_from_univdiagonal(&(*found_score_5),

				 &this5->unextended_sense_paths_gminus,&this5->unextended_antisense_paths_gminus,
				 &sense_paths5_gminus,&antisense_paths5_gminus,

				 /*univdiagonal*/this5->univdiagonals_gminus[index1],
				 queryseq5,/*queryptr*/queryrc5,/*query_compress*/query5_compress_rev,
				 query5_compress_fwd,query5_compress_rev,

				 /*plusp*/false,querylength5,mismatch_positions_alloc_5,
				 novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				 max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,
				 overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,

				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				 /*method*/method5,/*find_splices_p*/true);
#endif

    debug(printf("Solving 3' path for new univdiagonal %u as method %s\n",
		 univdiagonals3_gminus[index2],Method_string(*last_method_3)));
    Path_solve_from_univdiagonal(&(*found_score_3),

				 &this3->unextended_sense_paths_gminus,&this3->unextended_antisense_paths_gminus,
				 &sense_paths3_gminus,&antisense_paths3_gminus,

				 /*univdiagonal*/univdiagonals3_gminus[index2],
				 queryseq3,/*queryptr*/queryrc3,/*query_compress*/query3_compress_rev,
				 query3_compress_fwd,query3_compress_rev,

				 /*plusp*/false,querylength3,mismatch_positions_alloc_3,
				 novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				 max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,
				 overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,
				 
				 intlistpool,uintlistpool,univcoordlistpool,
				 listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				 /*method*/*last_method_3,/*find_splices_p*/true);
  }
    
  FREE(minus_indices);
  FREE(plus_indices);



  debug(printf("%d and %d: %s and %s: Calling Concordance_gen with univdiagonals, sense, with %d and %d gplus, %d and %d gminus\n",
	       *found_score_5,*found_score_3,Method_string(*last_method_5),Method_string(*last_method_3),
	       List_length(sense_paths5_gplus),List_length(sense_paths3_gplus),
	       List_length(sense_paths5_gminus),List_length(sense_paths3_gminus)));

  pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,

			      &sense_paths5_gplus,&sense_paths5_gminus,
			      &sense_paths3_gplus,&sense_paths3_gminus,
			      
			      &this5->sense_paths_gplus,&this5->sense_paths_gminus,
			      &this3->sense_paths_gplus,&this3->sense_paths_gminus,
			      &this5->sense_coords_gplus,&this5->sense_coords_gminus,
			      &this3->sense_coords_gplus,&this3->sense_coords_gminus,
			      &this5->sense_indices_gplus,&this5->sense_indices_gminus,
			      &this3->sense_indices_gplus,&this3->sense_indices_gminus,
			      &this5->n_sense_paths_gplus,&this5->n_sense_paths_gminus,
			      &this3->n_sense_paths_gplus,&this3->n_sense_paths_gminus,
			      &this5->nunique_sense_coords_gplus,&this5->nunique_sense_coords_gminus,
			      &this3->nunique_sense_coords_gplus,&this3->nunique_sense_coords_gminus,
				 
			      query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			      queryseq5,queryseq3,
			      queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
			      this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				 
			      novel_diagonals_alloc,localdb_alloc,
			      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
			      nmismatches_allowed_5,nmismatches_allowed_3,
			      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
			      overall_end_distance_5,overall_end_distance_3,
				 
			      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			      vectorpool,hitlistpool,genestrand,/*mergep*/true);
  
  if (splicingp == true) {
    debug(printf("%d and %d: %s and %s: Calling Concordance_gen with univdiagonals, antisense, with %d and %d gplus, %d and %d gminus\n",
		 *found_score_5,*found_score_3,Method_string(*last_method_5),Method_string(*last_method_3),
		 List_length(antisense_paths5_gplus),List_length(antisense_paths3_gplus),
		 List_length(antisense_paths5_gminus),List_length(antisense_paths3_gminus)));
    pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,

				&antisense_paths5_gplus,&antisense_paths5_gminus,
				&antisense_paths3_gplus,&antisense_paths3_gminus,

				&this5->antisense_paths_gplus,&this5->antisense_paths_gminus,
				&this3->antisense_paths_gplus,&this3->antisense_paths_gminus,
				&this5->antisense_coords_gplus,&this5->antisense_coords_gminus,
				&this3->antisense_coords_gplus,&this3->antisense_coords_gminus,
				&this5->antisense_indices_gplus,&this5->antisense_indices_gminus,
				&this3->antisense_indices_gplus,&this3->antisense_indices_gminus,
				&this5->n_antisense_paths_gplus,&this5->n_antisense_paths_gminus,
				&this3->n_antisense_paths_gplus,&this3->n_antisense_paths_gminus,
				&this5->nunique_antisense_coords_gplus,&this5->nunique_antisense_coords_gminus,
				&this3->nunique_antisense_coords_gplus,&this3->nunique_antisense_coords_gminus,
				   
				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				   
				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				   
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,genestrand,/*mergep*/true);
  }

  /* All paths were complete and merged */
  assert(sense_paths5_gplus == NULL);
  assert(sense_paths5_gminus == NULL);
  assert(sense_paths3_gplus == NULL);
  assert(sense_paths3_gminus == NULL);
  assert(antisense_paths5_gplus == NULL);
  assert(antisense_paths5_gminus == NULL);
  assert(antisense_paths3_gplus == NULL);
  assert(antisense_paths3_gminus == NULL);


  if (pathpairs != NULL) {
    debug(printf("After looking at univdiagonals, we have %d pathpairs and found scores %d and %d\n",
		 List_length(pathpairs),*found_score_5,*found_score_3));

    FREE_ALIGN(univdiagonals5_gplus);
    FREE_ALIGN(univdiagonals5_gminus);
    FREE_ALIGN(univdiagonals3_gplus);
    FREE_ALIGN(univdiagonals3_gminus);
    return pathpairs;

  } else if ((pathpairs = unextended_search(&(*found_score_paired),&(*found_score_5),&(*found_score_3),
					    pathpairs,this5,this3,queryseq5,queryseq3,

					    queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
					    knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
					    novel_diagonals_alloc,localdb_alloc,
					    query5_compress_fwd,query5_compress_rev,
					    query3_compress_fwd,query3_compress_rev,
					    /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
					    /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
					    max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
					    genestrand,overall_end_distance_5,overall_end_distance_3,
					    intlistpool,uintlistpool,univcoordlistpool,listpool,
					    pathpool,transcriptpool,vectorpool,hitlistpool,
					    spliceendsgen5,spliceendsgen3)) != NULL) {

    /* Found concordance from unextended paths that were concordant */
    /* This turns out to be very helpful in avoiding later calls to
       SEGMENT1, even though Path_solve_from_univdiagonal calls
       Path_solve_from_diagonals */
    debug(printf("Found %d pathpairs from unextended paths that were concordant\n",List_length(pathpairs)));
    FREE_ALIGN(univdiagonals5_gplus);
    FREE_ALIGN(univdiagonals5_gminus);
    FREE_ALIGN(univdiagonals3_gplus);
    FREE_ALIGN(univdiagonals3_gminus);
    return pathpairs;

  } else {
    /* Update found_scores and merge univdiagonals into Stage1_T storage */
    /* 1.  5' plus */
    if (nunivdiagonals5_gplus > 0) {
#if 0
      if (method_print_p == true) {
	for (i = 0; i < nunivdiagonals5_gplus; i++) {
	  Univcoordtableuint_put(this5->methods_gplus,univdiagonals5_gplus[i],*last_method_5);
	}
      }
#endif

      merge_paths_from_univdiagonals(&(*found_score_5),

				     &this5->unextended_sense_paths_gplus,&this5->unextended_antisense_paths_gplus,

				     &this5->univdiagonals_gplus,&this5->nunivdiagonals_gplus,

				     /*paths*/&this5->sense_paths_gplus,/*coords*/&this5->sense_coords_gplus,
				     /*cumsums*/&this5->sense_indices_gplus,/*npaths*/&this5->n_sense_paths_gplus,
				     /*nunique*/&this5->nunique_sense_coords_gplus,

				     /*paths*/&this5->antisense_paths_gplus,/*coords*/&this5->antisense_coords_gplus,
				     /*cumsums*/&this5->antisense_indices_gplus,/*npaths*/&this5->n_antisense_paths_gplus,
				     /*nunique*/&this5->nunique_antisense_coords_gplus,
				     
				     this5->univdiagonals_gplus,this5->nunivdiagonals_gplus,
				     univdiagonals5_gplus,nunivdiagonals5_gplus,
				     /*plusp*/true,querylength5,/*first_read_p*/true,
				     
				     queryseq5,/*queryptr*/queryuc_ptr_5,/*query_compress*/query5_compress_fwd,
				     query5_compress_fwd,query5_compress_rev,mismatch_positions_alloc_5,
				     
				     novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				     max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,overall_end_distance_5,
				     
				     intlistpool,uintlistpool,univcoordlistpool,
				     listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				     /*sort_high_univdiagonal_p*/true,/*method*/*last_method_5,/*find_splices_p*/true,
				     /*solve_paths_p*/true);
    }


    /* 2.  5' minus */
    if (nunivdiagonals5_gminus > 0) {
#if 0
      if (method_print_p == true) {
	for (i = 0; i < nunivdiagonals5_gminus; i++) {
	  Univcoordtableuint_put(this5->methods_gminus,univdiagonals5_gminus[i],*last_method_5);
	}
      }
#endif

      merge_paths_from_univdiagonals(&(*found_score_5),

				     &this5->unextended_sense_paths_gminus,&this5->unextended_antisense_paths_gminus,
				     
				     &this5->univdiagonals_gminus,&this5->nunivdiagonals_gminus,

				     /*paths*/&this5->sense_paths_gminus,/*coords*/&this5->sense_coords_gminus,
				     /*cumsums*/&this5->sense_indices_gminus,/*npaths*/&this5->n_sense_paths_gminus,
				     /*nunique*/&this5->nunique_sense_coords_gminus,
				     
				     /*paths*/&this5->antisense_paths_gminus,/*coords*/&this5->antisense_coords_gminus,
				     /*cumsums*/&this5->antisense_indices_gminus,/*npaths*/&this5->n_antisense_paths_gminus,
				     /*nunique*/&this5->nunique_antisense_coords_gminus,

				     this5->univdiagonals_gminus,this5->nunivdiagonals_gminus,
				     univdiagonals5_gminus,nunivdiagonals5_gminus,
				     /*plusp*/false,querylength5,/*first_read_p*/true,

				     queryseq5,/*queryptr*/queryrc5,/*query_compress*/query5_compress_rev,
				     query5_compress_fwd,query5_compress_rev,mismatch_positions_alloc_5,
				   
				     novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				     max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,overall_end_distance_5,

				     intlistpool,uintlistpool,univcoordlistpool,
				     listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				     /*sort_high_univdiagonal_p*/false,/*method*/*last_method_5,/*find_splices_p*/true,
				     /*solve_paths_p*/true);
    }


    /* 3.  3' plus */
    if (nunivdiagonals3_gplus > 0) {
#if 0
      if (method_print_p == true) {
	for (i = 0; i < nunivdiagonals3_gplus; i++) {
	  Univcoordtableuint_put(this3->methods_gplus,univdiagonals3_gplus[i],*last_method_3);
	}
      }
#endif

      merge_paths_from_univdiagonals(&(*found_score_3),

				     &this3->unextended_sense_paths_gplus,&this3->unextended_antisense_paths_gplus,
				   
				     &this3->univdiagonals_gplus,&this3->nunivdiagonals_gplus,

				     /*paths*/&this3->sense_paths_gplus,/*coords*/&this3->sense_coords_gplus,
				     /*cumsums*/&this3->sense_indices_gplus,/*npaths*/&this3->n_sense_paths_gplus,
				     /*nunique*/&this3->nunique_sense_coords_gplus,
				   
				     /*paths*/&this3->antisense_paths_gplus,/*coords*/&this3->antisense_coords_gplus,
				     /*cumsums*/&this3->antisense_indices_gplus,/*npaths*/&this3->n_antisense_paths_gplus,
				     /*nunique*/&this3->nunique_antisense_coords_gplus,
				   
				     this3->univdiagonals_gplus,this3->nunivdiagonals_gplus,
				     univdiagonals3_gplus,nunivdiagonals3_gplus,
				     /*plusp*/true,querylength3,/*first_read_p*/false,
				   
				     queryseq3,/*queryptr*/queryuc_ptr_3,/*query_compress*/query3_compress_fwd,
				     query3_compress_fwd,query3_compress_rev,mismatch_positions_alloc_3,
				   
				     novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				     max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,overall_end_distance_3,
				   
				     intlistpool,uintlistpool,univcoordlistpool,
				     listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				     /*sort_high_univdiagonal_p*/false,/*method*/*last_method_3,/*find_splices_p*/true,
				     /*solve_paths_p*/true);
    }


    /* 4.  3' minus */
    if (nunivdiagonals3_gminus > 0) {
#if 0
      if (method_print_p == true) {
	for (i = 0; i < nunivdiagonals3_gminus; i++) {
	  Univcoordtableuint_put(this3->methods_gminus,univdiagonals3_gminus[i],*last_method_3);
	}
      }
#endif

      merge_paths_from_univdiagonals(&(*found_score_3),

				     &this3->unextended_sense_paths_gminus,&this3->unextended_antisense_paths_gminus,

				     &this3->univdiagonals_gminus,&this3->nunivdiagonals_gminus,

				     /*paths*/&this3->sense_paths_gminus,/*coords*/&this3->sense_coords_gminus,
				     /*cumsums*/&this3->sense_indices_gminus,/*npaths*/&this3->n_sense_paths_gminus,
				     /*nunique*/&this3->nunique_sense_coords_gminus,

				     /*paths*/&this3->antisense_paths_gminus,/*coords*/&this3->antisense_coords_gminus,
				     /*cumsums*/&this3->antisense_indices_gminus,/*npaths*/&this3->n_antisense_paths_gminus,
				     /*nunique*/&this3->nunique_antisense_coords_gminus,

				     this3->univdiagonals_gminus,this3->nunivdiagonals_gminus,
				     univdiagonals3_gminus,nunivdiagonals3_gminus,
				     /*plusp*/false,querylength3,/*first_read_p*/false,
				   
				     queryseq3,/*queryptr*/queryrc3,/*query_compress*/query3_compress_rev,
				     query3_compress_fwd,query3_compress_rev,mismatch_positions_alloc_3,
				   
				     novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				     max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,overall_end_distance_3,

				     intlistpool,uintlistpool,univcoordlistpool,
				     listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				     /*sort_high_univdiagonal_p*/true,/*method*/*last_method_3,/*find_splices_p*/true,
				     /*solve_paths_p*/true);
    }

    FREE_ALIGN(univdiagonals5_gplus);
    FREE_ALIGN(univdiagonals5_gminus);
    FREE_ALIGN(univdiagonals3_gplus);
    FREE_ALIGN(univdiagonals3_gminus);
    return (List_T) NULL;
  }
}


static List_T
find_inner_fusions_path5 (int *found_score_5, List_T pathpairs, Path_T path5, List_T singlepaths3,
			  Stage1_T this5, Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			  Shortread_T queryseq5, Shortread_T queryseq3, char *queryuc_ptr_5, char *queryrc5,
			  Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			  Knownsplicing_T knownsplicing,
			  int nmismatches_allowed_5, int max_insertionlen_5, int max_deletionlen_5,
			  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			  Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			  Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool) {
  List_T p;
  Path_T newpath, path3;
  Pathpair_T pathpair;

  for (p = singlepaths3; p != NULL; p = List_next(p)) {
    path3 = (Path_T) List_head(p); /* anchor */
    /* path3 determines overall plusp, and query_compress and queryptr for main part of path5 */
    if (Path_unextended_querystart_p(path5,/*endtrim_allowed*/8,/*allow_ambig_p*/true) == true) {
      /* Skip.  Want fusion alignments to extend to the end */
    } else if (path3->plusp == true) {
      /* Case 1: fusion5 plus, main5 plus; anchor3 plus */
      /* Case 2: fusion5 minus, main5 plus; anchor3 plus */
      if ((newpath = Path_fusion_inner_qend(&(*found_score_5),/*fusion5*/path5,/*anchor3*/path3,
					    /*queryptr_main*/queryuc_ptr_5,/*main_plusp*/true,path5->querylength,
					    /*main_chrnum*/path3->chrnum,path3->chroffset,path3->chrhigh,
					    novel_diagonals_alloc,localdb_alloc,
					    this5->streamspace_max_alloc,this5->streamspace_alloc,
					    this5->streamptr_alloc,this5->streamsize_alloc,this5->mergeinfo,
					    this5->indelinfo,this5->spliceinfo,knownsplicing,
					    /*query_compress_main*/query5_compress_fwd,query5_compress_fwd,query5_compress_rev,
					    queryseq5,path5->genestrand,nmismatches_allowed_5,
					    max_insertionlen_5,max_deletionlen_5,
					    intlistpool,uintlistpool,univcoordlistpool,listpool,
					    pathpool,vectorpool,transcriptpool,hitlistpool)) != NULL &&
	  (pathpair = Pathpair_new_inner_fusion(/*pathL*/newpath,/*pathH*/path3,
						/*queryseqL*/queryseq5,/*queryseqH*/queryseq3,/*plusp*/true,
						intlistpool,univcoordlistpool,listpool,pathpool,
						vectorpool,transcriptpool,hitlistpool,
						/*copyLp*/false,/*copyHp*/true)) != NULL) {
	pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				 hitlistpool_trace(__FILE__,__LINE__));
      }
    } else {
      /* Case 4': anchor3 minus; main5 minus, fusion5 plus */
      /* Case 3': anchor3 minus; main5 minus, fusion5 minus */
      if ((newpath = Path_fusion_inner_qend(&(*found_score_5),/*fusion5*/path5,/*anchor3*/path3,
					    /*queryptr_main*/queryrc5,/*main_plusp*/false,path5->querylength,
					    /*main_chrnum*/path3->chrnum,path3->chroffset,path3->chrhigh,
					    novel_diagonals_alloc,localdb_alloc,
					    this5->streamspace_max_alloc,this5->streamspace_alloc,
					    this5->streamptr_alloc,this5->streamsize_alloc,this5->mergeinfo,
					    this5->indelinfo,this5->spliceinfo,knownsplicing,
					    /*query_compress_main*/query5_compress_rev,query5_compress_fwd,query5_compress_rev,
					    queryseq5,path5->genestrand,nmismatches_allowed_5,
					    max_insertionlen_5,max_deletionlen_5,
					    intlistpool,uintlistpool,univcoordlistpool,listpool,
					    pathpool,vectorpool,transcriptpool,hitlistpool)) != NULL &&
	  (pathpair = Pathpair_new_inner_fusion(/*pathL*/path3,/*pathH*/newpath,
						/*queryseqL*/queryseq3,/*queryseqH*/queryseq5,/*plusp*/false,
						intlistpool,univcoordlistpool,listpool,pathpool,
						vectorpool,transcriptpool,hitlistpool,
						/*copyLp*/true,/*copyHp*/false)) != NULL) {
	pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				 hitlistpool_trace(__FILE__,__LINE__));
      }
    }
  }

  return pathpairs;
}


static List_T
find_inner_fusions_path3 (int *found_score_3, List_T pathpairs, Path_T path3, List_T singlepaths5,
			  Stage1_T this3, Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
			  Shortread_T queryseq5, Shortread_T queryseq3, char *queryuc_ptr_3, char *queryrc3,
			  Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			  Knownsplicing_T knownsplicing,
			  int nmismatches_allowed_3, int max_insertionlen_3, int max_deletionlen_3,
			  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			  Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
			  Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool) {
  List_T p;
  Path_T newpath, path5;
  Pathpair_T pathpair;

  for (p = singlepaths5; p != NULL; p = List_next(p)) {
    path5 = (Path_T) List_head(p);
    /* path5 determines query_compress and queryptr for main part of path3 */
    if (Path_unextended_queryend_p(path3,/*endtrim_allowed*/8,/*allow_ambig_p*/true) == true) {
      /* Skip.  Want fusion alignments to extend to the end */
    } else if (path5->plusp == true) {
      /* Case 3: anchor5 plus; main3 plus, fusion3 plus */
      /* Case 4: anchor5 plus; main3 plus, fusion3 minus */
      if ((newpath = Path_fusion_inner_qstart(&(*found_score_3),/*fusion3*/path3,/*anchor5*/path5,
					      /*queryptr_main*/queryuc_ptr_3,/*main_plusp*/true,path3->querylength,
					      /*main_chrnum*/path5->chrnum,path5->chroffset,path5->chrhigh,
					      novel_diagonals_alloc,localdb_alloc,
					      this3->streamspace_max_alloc,this3->streamspace_alloc,
					      this3->streamptr_alloc,this3->streamsize_alloc,this3->mergeinfo,
					      this3->indelinfo,this3->spliceinfo,knownsplicing,
					      /*query_compress_main*/query3_compress_fwd,query3_compress_fwd,query3_compress_rev,
					      queryseq3,path3->genestrand,nmismatches_allowed_3,
					      max_insertionlen_3,max_deletionlen_3,
					      intlistpool,uintlistpool,univcoordlistpool,listpool,
					      pathpool,vectorpool,transcriptpool,hitlistpool)) != NULL &&
	  (pathpair = Pathpair_new_inner_fusion(/*pathL*/path5,/*pathH*/newpath,
						/*queryseqL*/queryseq5,/*queryseqH*/queryseq3,/*plusp*/true,
						intlistpool,univcoordlistpool,listpool,pathpool,
						vectorpool,transcriptpool,hitlistpool,
						/*copyLp*/true,/*copyHp*/false)) != NULL) {
	pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				 hitlistpool_trace(__FILE__,__LINE__));
      }

    } else {
      /* Case 2': fusion3 plus, main3 minus; anchor5 minus */
      /* Case 1': fusion3 minus, main3 minus; anchor5 minus */
      if ((newpath = Path_fusion_inner_qstart(&(*found_score_3),/*fusion3*/path3,/*anchor5*/path5,
					      /*queryptr_main*/queryrc3,/*main_plusp*/false,path3->querylength,
					      /*main_chrnum*/path5->chrnum,path5->chroffset,path5->chrhigh,
					      novel_diagonals_alloc,localdb_alloc,
					      this3->streamspace_max_alloc,this3->streamspace_alloc,
					      this3->streamptr_alloc,this3->streamsize_alloc,this3->mergeinfo,
					      this3->indelinfo,this3->spliceinfo,knownsplicing,
					      /*query_compress_main*/query3_compress_rev,query3_compress_fwd,query3_compress_rev,
					      queryseq3,path3->genestrand,nmismatches_allowed_3,
					      max_insertionlen_3,max_deletionlen_3,
					      intlistpool,uintlistpool,univcoordlistpool,listpool,
					      pathpool,vectorpool,transcriptpool,hitlistpool)) != NULL &&
	  (pathpair = Pathpair_new_inner_fusion(/*pathL*/newpath,/*pathH*/path5,
						/*queryseqL*/queryseq3,/*queryseqH*/queryseq5,/*plusp*/false,
						intlistpool,univcoordlistpool,listpool,pathpool,
						vectorpool,transcriptpool,hitlistpool,
						/*copyLp*/false,/*copyHp*/true)) != NULL) {
	pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				 hitlistpool_trace(__FILE__,__LINE__));
      }
    }
  }

  return pathpairs;
}


#ifdef DEBUG0
static void
print_pathpairs_contents (List_T pathpairs) {
  List_T p;
  Pathpair_T pathpair;

  for (p = pathpairs; p != NULL; p = List_next(p)) {
    pathpair = (Pathpair_T) List_head(p);
    printf("%p %p pathpair\n",pathpair->path5,pathpair->path3);
  }

  return;
}
#endif


static List_T
paired_read_next_method_gen_5 (int *found_score_paired, int *found_score_5, int *found_score_3, Method_T *last_method_5,

			       List_T pathpairs, T this5, T this3, EF64_T repetitive_ef64,

			       Shortread_T queryseq5, Shortread_T queryseq3,
			       char *queryuc_ptr_5, char *queryrc5, int querylength5,
			       char *queryuc_ptr_3, char *queryrc3, int querylength3,
			       Knownsplicing_T knownsplicing, Knownindels_T knownindels,

			       int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
			       Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			       Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			       Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
			    
			       int nmismatches_allowed_5, int nmismatches_allowed_3,
			       int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
			       int genestrand, Chrpos_T overall_max_distance_5, Chrpos_T overall_max_distance_3,
			       Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,
			      
			       Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			       Listpool_T listpool, Univdiagpool_T univdiagpool,
			       Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			       Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
			       Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3, Pass_T pass) {

  List_T sense_paths5_gplus, sense_paths5_gminus, antisense_paths5_gplus, antisense_paths5_gminus,
    sense_paths3_gplus = NULL, sense_paths3_gminus = NULL, antisense_paths3_gplus = NULL, antisense_paths3_gminus = NULL;

  *last_method_5 = single_read_next_method_gen(&(*found_score_5),*last_method_5,
						
					       &sense_paths5_gplus,&sense_paths5_gminus,
					       &antisense_paths5_gplus,&antisense_paths5_gminus,
						
					       this5,repetitive_ef64,genestrand,
					       queryseq5,queryuc_ptr_5,queryrc5,querylength5,
					       knownsplicing,knownindels,mismatch_positions_alloc_5,
					       novel_diagonals_alloc,localdb_alloc,
					       query5_compress_fwd,query5_compress_rev,
					       nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
					       overall_max_distance_5,overall_end_distance_5,
					       univdiagpool,intlistpool,uintlistpool,univcoordlistpool,
					       listpool,pathpool,transcriptpool,vectorpool,
					       hitlistpool,spliceendsgen5,
					       /*paired_end_p*/true,/*first_read_p*/true,/*appendp*/false);

  debug(printf(">5' Method %s: Calling Concordance_gen, sense, with %d gplus, %d gminus\n",
	       Method_string(*last_method_5),
	       List_length(sense_paths5_gplus),List_length(sense_paths5_gminus)));
  pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
			      
			      /*new*/&sense_paths5_gplus,/*new*/&sense_paths5_gminus,
			      /*new*/&sense_paths3_gplus,/*new*/&sense_paths3_gminus,
			      
			      &this5->sense_paths_gplus,&this5->sense_paths_gminus,
			      &this3->sense_paths_gplus,&this3->sense_paths_gminus,
			      &this5->sense_coords_gplus,&this5->sense_coords_gminus,
			      &this3->sense_coords_gplus,&this3->sense_coords_gminus,
			      &this5->sense_indices_gplus,&this5->sense_indices_gminus,
			      &this3->sense_indices_gplus,&this3->sense_indices_gminus,
			      &this5->n_sense_paths_gplus,&this5->n_sense_paths_gminus,
			      &this3->n_sense_paths_gplus,&this3->n_sense_paths_gminus,
			      &this5->nunique_sense_coords_gplus,&this5->nunique_sense_coords_gminus,
			      &this3->nunique_sense_coords_gplus,&this3->nunique_sense_coords_gminus,
				    
			      query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			      queryseq5,queryseq3,
			      queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
			      this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
			      
			      novel_diagonals_alloc,localdb_alloc,
			      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
			      nmismatches_allowed_5,nmismatches_allowed_3,
			      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
			      overall_end_distance_5,overall_end_distance_3,
			      
			      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			      vectorpool,hitlistpool,genestrand,/*mergep*/true);
  
  if (splicingp == true) {
    debug(printf(">5' Method %s: Calling Concordance_gen, antisense, with %d gplus, %d gminus\n",
		 Method_string(*last_method_5),
		 List_length(antisense_paths5_gplus),List_length(antisense_paths5_gminus)));
    
    pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				
				/*new*/&antisense_paths5_gplus,/*new*/&antisense_paths5_gminus,
				/*new*/&antisense_paths3_gplus,/*new*/&antisense_paths3_gminus,
				
				&this5->antisense_paths_gplus,&this5->antisense_paths_gminus,
				&this3->antisense_paths_gplus,&this3->antisense_paths_gminus,
				&this5->antisense_coords_gplus,&this5->antisense_coords_gminus,
				&this3->antisense_coords_gplus,&this3->antisense_coords_gminus,
				&this5->antisense_indices_gplus,&this5->antisense_indices_gminus,
				&this3->antisense_indices_gplus,&this3->antisense_indices_gminus,
				&this5->n_antisense_paths_gplus,&this5->n_antisense_paths_gminus,
				&this3->n_antisense_paths_gplus,&this3->n_antisense_paths_gminus,
				&this5->nunique_antisense_coords_gplus,&this5->nunique_antisense_coords_gminus,
				&this3->nunique_antisense_coords_gplus,&this3->nunique_antisense_coords_gminus,
				
				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				
				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,genestrand,/*mergep*/true);
  }

  /* All paths were complete and merged */
  assert(sense_paths5_gplus == NULL);
  assert(sense_paths5_gminus == NULL);
  assert(sense_paths3_gplus == NULL);
  assert(sense_paths3_gminus == NULL);
  assert(antisense_paths5_gplus == NULL);
  assert(antisense_paths5_gminus == NULL);
  assert(antisense_paths3_gplus == NULL);
  assert(antisense_paths3_gminus == NULL);

  if (pathpairs != NULL) {
    return pathpairs;

  } else if ((pathpairs = unextended_search(&(*found_score_paired),&(*found_score_5),&(*found_score_3),
					    pathpairs,this5,this3,queryseq5,queryseq3,
					    queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
					    knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
					    novel_diagonals_alloc,localdb_alloc,
					    query5_compress_fwd,query5_compress_rev,
					    query3_compress_fwd,query3_compress_rev,
					    /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
					    /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
					    max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
					    genestrand,overall_end_distance_5,overall_end_distance_3,
					    intlistpool,uintlistpool,univcoordlistpool,listpool,
					    pathpool,transcriptpool,vectorpool,hitlistpool,
					    spliceendsgen5,spliceendsgen3)) != NULL) {
    return pathpairs;

  } else {
    FREE_ALIGN(this5->univdiagonals_gplus);
    FREE_ALIGN(this5->univdiagonals_gminus);
    FREE_ALIGN(this3->univdiagonals_gplus);
    FREE_ALIGN(this3->univdiagonals_gminus);

    merge_sense_antisense_coords(this5);
    merge_sense_antisense_coords(this3);

    return (List_T) NULL;
  }
}


static List_T
paired_read_next_method_gen_3 (int *found_score_paired, int *found_score_5, int *found_score_3, Method_T *last_method_3,

			       List_T pathpairs, T this5, T this3, EF64_T repetitive_ef64,
			       
			       Shortread_T queryseq5, Shortread_T queryseq3,
			       char *queryuc_ptr_5, char *queryrc5, int querylength5,
			       char *queryuc_ptr_3, char *queryrc3, int querylength3,
			       Knownsplicing_T knownsplicing, Knownindels_T knownindels,
			   
			       int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
			       Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			       Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
			       Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
			   
			       int nmismatches_allowed_5, int nmismatches_allowed_3,
			       int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
			       int genestrand, Chrpos_T overall_max_distance_5, Chrpos_T overall_max_distance_3,
			       Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,
			   
			       Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			       Listpool_T listpool, Univdiagpool_T univdiagpool,
			       Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			       Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
			       Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3, Pass_T pass) {
  
  List_T sense_paths3_gplus, sense_paths3_gminus, antisense_paths3_gplus, antisense_paths3_gminus;
  List_T sense_paths5_gplus = NULL, sense_paths5_gminus = NULL, antisense_paths5_gplus = NULL, antisense_paths5_gminus = NULL;
  
  *last_method_3 = single_read_next_method_gen(&(*found_score_3),*last_method_3,
						
					       &sense_paths3_gplus,&sense_paths3_gminus,
					       &antisense_paths3_gplus,&antisense_paths3_gminus,
						
					       this3,repetitive_ef64,genestrand,
					       queryseq3,queryuc_ptr_3,queryrc3,querylength3,
					       knownsplicing,knownindels,mismatch_positions_alloc_3,
					       novel_diagonals_alloc,localdb_alloc,
					       query3_compress_fwd,query3_compress_rev,
					       nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
					       overall_max_distance_3,overall_end_distance_3,
					       univdiagpool,intlistpool,uintlistpool,univcoordlistpool,
					       listpool,pathpool,transcriptpool,vectorpool,
					       hitlistpool,spliceendsgen3,
					       /*paired_end_p*/true,/*first_read_p*/false,/*appendp*/false);

  debug(printf(">3' Method %s: Calling Concordance_gen, sense, with %d gplus, %d gminus\n",
	       Method_string(*last_method_3),
	       List_length(sense_paths3_gplus),List_length(sense_paths3_gminus)));
  pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
			      
			      /*new*/&sense_paths5_gplus,/*new*/&sense_paths5_gminus,
			      /*new*/&sense_paths3_gplus,/*new*/&sense_paths3_gminus,
			      
			      &this5->sense_paths_gplus,&this5->sense_paths_gminus,
			      &this3->sense_paths_gplus,&this3->sense_paths_gminus,
			      &this5->sense_coords_gplus,&this5->sense_coords_gminus,
			      &this3->sense_coords_gplus,&this3->sense_coords_gminus,
			      &this5->sense_indices_gplus,&this5->sense_indices_gminus,
			      &this3->sense_indices_gplus,&this3->sense_indices_gminus,
			      &this5->n_sense_paths_gplus,&this5->n_sense_paths_gminus,
			      &this3->n_sense_paths_gplus,&this3->n_sense_paths_gminus,
			      &this5->nunique_sense_coords_gplus,&this5->nunique_sense_coords_gminus,
			      &this3->nunique_sense_coords_gplus,&this3->nunique_sense_coords_gminus,
				    
			      query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
			      queryseq5,queryseq3,
			      queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
			      this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
			      
			      novel_diagonals_alloc,localdb_alloc,
			      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
			      nmismatches_allowed_5,nmismatches_allowed_3,
			      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
			      overall_end_distance_5,overall_end_distance_3,
			      
			      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			      vectorpool,hitlistpool,genestrand,/*mergep*/true);
  
  if (splicingp == true) {
    debug(printf(">3' Method %s: Calling Concordance_gen, antisense, with %d gplus, %d gminus\n",
		 Method_string(*last_method_3),
		 List_length(antisense_paths3_gplus),List_length(antisense_paths3_gminus)));
    
    pathpairs = Concordance_gen(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				
				&antisense_paths5_gplus,&antisense_paths5_gminus,
				&antisense_paths3_gplus,&antisense_paths3_gminus,
				
				&this5->antisense_paths_gplus,&this5->antisense_paths_gminus,
				&this3->antisense_paths_gplus,&this3->antisense_paths_gminus,
				&this5->antisense_coords_gplus,&this5->antisense_coords_gminus,
				&this3->antisense_coords_gplus,&this3->antisense_coords_gminus,
				&this5->antisense_indices_gplus,&this5->antisense_indices_gminus,
				&this3->antisense_indices_gplus,&this3->antisense_indices_gminus,
				&this5->n_antisense_paths_gplus,&this5->n_antisense_paths_gminus,
				&this3->n_antisense_paths_gplus,&this3->n_antisense_paths_gminus,
				&this5->nunique_antisense_coords_gplus,&this5->nunique_antisense_coords_gminus,
				&this3->nunique_antisense_coords_gplus,&this3->nunique_antisense_coords_gminus,
				
				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				
				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,genestrand,/*mergep*/true);
  }

  /* All paths were complete and merged */
  assert(sense_paths5_gplus == NULL);
  assert(sense_paths5_gminus == NULL);
  assert(sense_paths3_gplus == NULL);
  assert(sense_paths3_gminus == NULL);
  assert(antisense_paths5_gplus == NULL);
  assert(antisense_paths5_gminus == NULL);
  assert(antisense_paths3_gplus == NULL);
  assert(antisense_paths3_gminus == NULL);

  
  if (pathpairs != NULL) {
    return pathpairs;

  } else if ((pathpairs = unextended_search(&(*found_score_paired),&(*found_score_5),&(*found_score_3),
					    pathpairs,this5,this3,queryseq5,queryseq3,
					    queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
					    knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
					    novel_diagonals_alloc,localdb_alloc,
					    query5_compress_fwd,query5_compress_rev,
					    query3_compress_fwd,query3_compress_rev,
					    /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
					    /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
					    max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
					    genestrand,overall_end_distance_5,overall_end_distance_3,
					    intlistpool,uintlistpool,univcoordlistpool,listpool,
					    pathpool,transcriptpool,vectorpool,hitlistpool,
					    spliceendsgen5,spliceendsgen3)) != NULL) {
    return pathpairs;

  } else {
    FREE_ALIGN(this5->univdiagonals_gplus);
    FREE_ALIGN(this5->univdiagonals_gminus);
    FREE_ALIGN(this3->univdiagonals_gplus);
    FREE_ALIGN(this3->univdiagonals_gminus);

    merge_sense_antisense_coords(this5);
    merge_sense_antisense_coords(this3);

    return (List_T) NULL;
  }
}


#if 0
static Univcoord_T *
merge_univdiagonals (int *nunivdiagonals, Path_T *sense_paths, int n_sense_paths,
		     Path_T *antisense_paths, int n_antisense_paths,
		     bool sort_high_univdiagonal_p) {
  Univcoord_T *univdiagonals;
  Univcoord_T *sense_univdiagonals, *antisense_univdiagonals;
  int i;

  if (n_sense_paths == 0) {
    sense_univdiagonals = (Univcoord_T *) NULL;
  } else {
    MALLOC_ALIGN(sense_univdiagonals, n_sense_paths * sizeof(Univcoord_T));
    if (sort_high_univdiagonal_p == true) {
      for (i = 0; i < n_sense_paths; i++) {
	sense_univdiagonals[i] = Path_high_univdiagonal(sense_paths[i]);
      }
    } else {
      for (i = 0; i < n_sense_paths; i++) {
	sense_univdiagonals[i] = Path_low_univdiagonal(sense_paths[i]);
      }
    }
  }

  if (n_antisense_paths == 0) {
    antisense_univdiagonals = (Univcoord_T *) NULL;
  } else {
    MALLOC_ALIGN(antisense_univdiagonals, n_antisense_paths * sizeof(Univcoord_T));
    if (sort_high_univdiagonal_p == true) {
      for (i = 0; i < n_antisense_paths; i++) {
	antisense_univdiagonals[i] = Path_high_univdiagonal(antisense_paths[i]);
      }
    } else {
      for (i = 0; i < n_antisense_paths; i++) {
	antisense_univdiagonals[i] = Path_low_univdiagonal(antisense_paths[i]);
      }
    }
  }

#ifdef LARGE_GENOMES
  univdiagonals = Merge_uint8(/*dest*/NULL,sense_univdiagonals,antisense_univdiagonals,
			      n_sense_paths,n_antisense_paths);
#else
  univdiagonals = Merge_uint4(/*dest*/NULL,sense_univdiagonals,antisense_univdiagonals,
			      n_sense_paths,n_antisense_paths);
#endif
  *nunivdiagonals = make_unique(univdiagonals,n_sense_paths + n_antisense_paths);

  FREE(antisense_univdiagonals);
  FREE(sense_univdiagonals);

  return univdiagonals;
}
#endif


static List_T
paired_read (int found_score_paired, int *found_score_5, int *found_score_3, Method_T last_method_5, Method_T last_method_3,

	     Shortread_T queryseq5, Shortread_T queryseq3,
	     char *queryuc_ptr_5, char *queryrc5, int querylength5, char *queryuc_ptr_3, char *queryrc3, int querylength3,
	     Knownsplicing_T knownsplicing, Knownindels_T knownindels,

	     int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3, Univcoord_T *novel_diagonals_alloc,
	     unsigned short *localdb_alloc, T this5, T this3, EF64_T repetitive_ef64,

	     Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
	     Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
	     int nmismatches_allowed_5, int nmismatches_allowed_3,
	     int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
	     int genestrand, Chrpos_T pairmax_linear, Chrpos_T overall_max_distance_5, Chrpos_T overall_max_distance_3,
	     Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,

	     Trdiagpool_T trdiagpool, Univdiagpool_T univdiagpool,
	     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
	     Univcoordlistpool_T univcoordlistpool, Listpool_T listpool, 
	     Trpathpool_T trpathpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
	     Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, 
	     Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3, Pass_T pass) {

  List_T pathpairs = NULL;

  Method_T final_univdiagonal_method;

  List_T sense_paths5_gplus, sense_paths5_gminus, antisense_paths5_gplus, antisense_paths5_gminus,
    sense_paths3_gplus, sense_paths3_gminus, antisense_paths3_gplus, antisense_paths3_gminus;

  List_T unextended_sense_seg2paths5_gplus = NULL, unextended_sense_seg2paths5_gminus = NULL,
    unextended_antisense_seg2paths5_gplus = NULL, unextended_antisense_seg2paths5_gminus = NULL;
  List_T unextended_sense_seg2paths3_gplus = NULL, unextended_sense_seg2paths3_gminus = NULL,
    unextended_antisense_seg2paths3_gplus = NULL, unextended_antisense_seg2paths3_gminus = NULL;

  /* For transcriptome-based alignment and merging */
  Path_T *newpaths_gplus, *newpaths_gminus, *alloc;
  int nnewpaths_gplus, nnewpaths_gminus;
  Univcoord_T *coords;
  int *cumsums;

  List_T incomplete;
  int ncomplete;

  bool solvedp = false;


  debug(printf("Entered paired_read with alloc5 %p, methods %s and %s\n",
	       this5->antisense_paths_gplus,Method_string(last_method_5),Method_string(last_method_3)));

#if 0
  /* Take the larger of maxpaths_search and 10*maxpaths_report */
  maxpairedpaths = maxpaths_search;
  if (maxpairedpaths < 10*maxpaths_report) {
    maxpairedpaths = 10*maxpaths_report;
  }
#endif

  /* TODO: Return level from single_read.  Then if we don't have concordant pathpairs, take the min(level5,level3) and start paired_readfrom t
here */


  if (transcriptome_align_p == true &&
      (last_method_5 < TR_EXT || last_method_3 < TR_EXT)) {
    /* A.  Initial search.  Try each side until we get a result */
    /* Disjunction: Stops when we have found pathpairs or both ends have gone to TR_ANYPAIR (conjunction would mean either end) */
    while (last_method_5 < TR_ANYPAIR || last_method_3 < TR_ANYPAIR) {
      if ((pathpairs = paired_search_trdiagonals(&found_score_paired,&(*found_score_5),&(*found_score_3),
						 &last_method_5,&last_method_3,

						 pathpairs,this5,this3,queryseq5,queryseq3,querylength5,querylength3,
						 query5_compress_fwd,query5_compress_rev,
						 query3_compress_fwd,query3_compress_rev,
						 mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						 max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						 
						 intlistpool,uintlistpool,univcoordlistpool,
						 listpool,trpathpool,pathpool,transcriptpool,vectorpool,
						 hitlistpool,/*method_goal*/TR_ANYPAIR)) != NULL) {
	debug1(printf("Exiting after methods %s and %s with %d pathpairs\n",
		      Method_string(last_method_5),Method_string(last_method_3),List_length(pathpairs)));
	/* Path_print(((Pathpair_T) pathpairs->first)->path5); */
	/* Path_print(((Pathpair_T) pathpairs->first)->path3); */
	return pathpairs;

      } else {
	debug1(printf("Continuing with found scores %d and %d\n",*found_score_5,*found_score_3));
      }
    }


    /* B.  Advance by side separately to TR_EXT */
    /* Helps to avoid genomic search */
    /* Disjunction: Stops when we have found pathpairs or both ends have gone to TR_EXT (conjunction would mean either end) */
    while (last_method_5 < TR_EXT || last_method_3 < TR_EXT) {
      if (last_method_3 >= TR_EXT) {
	if ((pathpairs = paired_read_next_method_tr_5(&found_score_paired,&(*found_score_5),&(*found_score_3),
						      &last_method_5,

						      pathpairs,this5,this3,queryseq5,queryseq3,
						      querylength5,querylength3,mismatch_positions_alloc_5,
						      query5_compress_fwd,query5_compress_rev,
						      query3_compress_fwd,query3_compress_rev,
						      nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
						      genestrand,trdiagpool,intlistpool,uintlistpool,univcoordlistpool,
						      listpool,trpathpool,pathpool,transcriptpool,
						      vectorpool,hitlistpool)) != NULL) {
	  debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	  return pathpairs;
	}

      } else if (last_method_5 >= TR_EXT) {
	if ((pathpairs = paired_read_next_method_tr_3(&found_score_paired,&(*found_score_5),&(*found_score_3),
						      &last_method_3,

						      pathpairs,this5,this3,queryseq5,queryseq3,
						      querylength5,querylength3,mismatch_positions_alloc_3,
						      query5_compress_fwd,query5_compress_rev,
						      query3_compress_fwd,query3_compress_rev,
						      nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
						      genestrand,trdiagpool,intlistpool,uintlistpool,univcoordlistpool,
						      listpool,trpathpool,pathpool,transcriptpool,
						      vectorpool,hitlistpool)) != NULL) {
	  debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	  return pathpairs;
	}

      } else if ((*found_score_5) >= (*found_score_3)) {
	if ((pathpairs = paired_read_next_method_tr_5(&found_score_paired,&(*found_score_5),&(*found_score_3),
						      &last_method_5,

						      pathpairs,this5,this3,queryseq5,queryseq3,
						      querylength5,querylength3,mismatch_positions_alloc_5,
						      query5_compress_fwd,query5_compress_rev,
						      query3_compress_fwd,query3_compress_rev,
						      nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
						      genestrand,trdiagpool,intlistpool,uintlistpool,univcoordlistpool,
						      listpool,trpathpool,pathpool,transcriptpool,
						      vectorpool,hitlistpool)) != NULL) {
	  debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	  return pathpairs;
	}

      } else {
	if ((pathpairs = paired_read_next_method_tr_3(&found_score_paired,&(*found_score_5),&(*found_score_3),
						      &last_method_3,

						      pathpairs,this5,this3,queryseq5,queryseq3,
						      querylength5,querylength3,mismatch_positions_alloc_3,
						      query5_compress_fwd,query5_compress_rev,
						      query3_compress_fwd,query3_compress_rev,
						      nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
						      genestrand,trdiagpool,intlistpool,uintlistpool,univcoordlistpool,
						      listpool,trpathpool,pathpool,transcriptpool,
						      vectorpool,hitlistpool)) != NULL) {
	  debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	  return pathpairs;
	}
      }
    }


    /* D.  Prep for genomic search.  Previously converted all trpaths to paths.  Merge paths into Stage1_T arrays */
    /* 5' sense */
    Trpath_convert_sense(&solvedp,&(*found_score_5),
			 &this5->unsolved_sense_paths_gplus,&this5->unsolved_sense_paths_gminus,
			 &sense_paths5_gplus,&sense_paths5_gminus,
			 this5->sense_trpaths,query5_compress_fwd,query5_compress_rev,querylength5,
			 intlistpool,univcoordlistpool,listpool,pathpool,
			 transcriptpool,hitlistpool);

    newpaths_gplus = (Path_T *) List_to_array_n(&nnewpaths_gplus,sense_paths5_gplus);
    newpaths_gminus = (Path_T *) List_to_array_n(&nnewpaths_gminus,sense_paths5_gminus);
    qsort(newpaths_gplus,nnewpaths_gplus,sizeof(Path_T),Path_high_univdiagonal_cmp);
    qsort(newpaths_gminus,nnewpaths_gminus,sizeof(Path_T),Path_low_univdiagonal_cmp);
    Hitlistpool_free_list(&sense_paths5_gplus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&sense_paths5_gminus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    if (this5->n_sense_paths_gplus + nnewpaths_gplus > 0) {
      alloc = (Path_T *) MALLOC((this5->n_sense_paths_gplus + nnewpaths_gplus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this5->n_sense_paths_gplus + nnewpaths_gplus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this5->n_sense_paths_gplus + nnewpaths_gplus) * sizeof(int));

      this5->nunique_sense_coords_gplus =
	Path_merge_high_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				     newpaths_gplus,nnewpaths_gplus,
				     /*oldpaths*/this5->sense_paths_gplus,this5->n_sense_paths_gplus,
				     hitlistpool);

      FREE(this5->sense_paths_gplus);
      FREE_ALIGN(this5->sense_coords_gplus);
      FREE(this5->sense_indices_gplus);
      this5->sense_paths_gplus = alloc;
      this5->sense_coords_gplus = coords;
      this5->sense_indices_gplus = cumsums;
      this5->n_sense_paths_gplus += nnewpaths_gplus;
      FREE(newpaths_gplus);
    }

    if (this5->n_sense_paths_gminus + nnewpaths_gminus > 0) {
      alloc = (Path_T *) MALLOC((this5->n_sense_paths_gminus + nnewpaths_gminus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this5->n_sense_paths_gminus + nnewpaths_gminus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this5->n_sense_paths_gminus + nnewpaths_gminus) * sizeof(int));

      this5->nunique_sense_coords_gminus =
	Path_merge_low_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				    newpaths_gminus,nnewpaths_gminus,
				    /*oldpaths*/this5->sense_paths_gminus,this5->n_sense_paths_gminus,
				    hitlistpool);

      FREE(this5->sense_paths_gminus);
      FREE_ALIGN(this5->sense_coords_gminus);
      FREE(this5->sense_indices_gminus);
      this5->sense_paths_gminus = alloc;
      this5->sense_coords_gminus = coords;
      this5->sense_indices_gminus = cumsums;
      this5->n_sense_paths_gminus += nnewpaths_gminus;
      FREE(newpaths_gminus);
    }


    /* 5' antisense */
    Trpath_convert_antisense(&solvedp,&(*found_score_5),
			     &this5->unsolved_antisense_paths_gplus,&this5->unsolved_antisense_paths_gminus,
			     &antisense_paths5_gplus,&antisense_paths5_gminus,
			     this5->antisense_trpaths,query5_compress_fwd,query5_compress_rev,querylength5,
			     intlistpool,univcoordlistpool,listpool,pathpool,
			     transcriptpool,hitlistpool);

    newpaths_gplus = (Path_T *) List_to_array_n(&nnewpaths_gplus,antisense_paths5_gplus);
    newpaths_gminus = (Path_T *) List_to_array_n(&nnewpaths_gminus,antisense_paths5_gminus);
    qsort(newpaths_gplus,nnewpaths_gplus,sizeof(Path_T),Path_high_univdiagonal_cmp);
    qsort(newpaths_gminus,nnewpaths_gminus,sizeof(Path_T),Path_low_univdiagonal_cmp);
    Hitlistpool_free_list(&antisense_paths5_gplus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&antisense_paths5_gminus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    if (this5->n_antisense_paths_gplus + nnewpaths_gplus > 0) {
      alloc = (Path_T *) MALLOC((this5->n_antisense_paths_gplus + nnewpaths_gplus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this5->n_antisense_paths_gplus + nnewpaths_gplus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this5->n_antisense_paths_gplus + nnewpaths_gplus) * sizeof(int));

      this5->nunique_antisense_coords_gplus =
	Path_merge_high_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				     newpaths_gplus,nnewpaths_gplus,
				     /*oldpaths*/this5->antisense_paths_gplus,this5->n_antisense_paths_gplus,
				     hitlistpool);

      FREE(this5->antisense_paths_gplus);
      FREE_ALIGN(this5->antisense_coords_gplus);
      FREE(this5->antisense_indices_gplus);
      this5->antisense_paths_gplus = alloc;
      this5->antisense_coords_gplus = coords;
      this5->antisense_indices_gplus = cumsums;
      this5->n_antisense_paths_gplus += nnewpaths_gplus;
      FREE(newpaths_gplus);
    }

    if (this5->n_antisense_paths_gminus + nnewpaths_gminus > 0) {
      alloc = (Path_T *) MALLOC((this5->n_antisense_paths_gminus + nnewpaths_gminus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this5->n_antisense_paths_gminus + nnewpaths_gminus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this5->n_antisense_paths_gminus + nnewpaths_gminus) * sizeof(int));

      this5->nunique_antisense_coords_gminus =
	Path_merge_low_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				    newpaths_gminus,nnewpaths_gminus,
				    /*oldpaths*/this5->antisense_paths_gminus,this5->n_antisense_paths_gminus,
				    hitlistpool);

      FREE(this5->antisense_paths_gminus);
      FREE_ALIGN(this5->antisense_coords_gminus);
      FREE(this5->antisense_indices_gminus);
      this5->antisense_paths_gminus = alloc;
      this5->antisense_coords_gminus = coords;
      this5->antisense_indices_gminus = cumsums;
      this5->n_antisense_paths_gminus += nnewpaths_gminus;
      FREE(newpaths_gminus);
    }



    /* 3' sense */
    Trpath_convert_sense(&solvedp,&(*found_score_3),
			 &this3->unsolved_sense_paths_gplus,&this3->unsolved_sense_paths_gminus,
			 &sense_paths3_gplus,&sense_paths3_gminus,
			 this3->sense_trpaths,query3_compress_fwd,query3_compress_rev,querylength3,
			 intlistpool,univcoordlistpool,listpool,pathpool,
			 transcriptpool,hitlistpool);

    newpaths_gplus = (Path_T *) List_to_array_n(&nnewpaths_gplus,sense_paths3_gplus);
    newpaths_gminus = (Path_T *) List_to_array_n(&nnewpaths_gminus,sense_paths3_gminus);
    qsort(newpaths_gplus,nnewpaths_gplus,sizeof(Path_T),Path_low_univdiagonal_cmp);
    qsort(newpaths_gminus,nnewpaths_gminus,sizeof(Path_T),Path_high_univdiagonal_cmp);
    Hitlistpool_free_list(&sense_paths3_gplus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&sense_paths3_gminus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    if (this3->n_sense_paths_gplus + nnewpaths_gplus > 0) {
      alloc = (Path_T *) MALLOC((this3->n_sense_paths_gplus + nnewpaths_gplus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this3->n_sense_paths_gplus + nnewpaths_gplus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this3->n_sense_paths_gplus + nnewpaths_gplus) * sizeof(int));

      this3->nunique_sense_coords_gplus =
	Path_merge_low_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				    newpaths_gplus,nnewpaths_gplus,
				    /*oldpaths*/this3->sense_paths_gplus,this3->n_sense_paths_gplus,
				    hitlistpool);

      FREE(this3->sense_paths_gplus);
      FREE_ALIGN(this3->sense_coords_gplus);
      FREE(this3->sense_indices_gplus);
      this3->sense_paths_gplus = alloc;
      this3->sense_coords_gplus = coords;
      this3->sense_indices_gplus = cumsums;
      this3->n_sense_paths_gplus += nnewpaths_gplus;
      FREE(newpaths_gplus);
    }

    if (this3->n_sense_paths_gminus + nnewpaths_gminus > 0) {
      alloc = (Path_T *) MALLOC((this3->n_sense_paths_gminus + nnewpaths_gminus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this3->n_sense_paths_gminus + nnewpaths_gminus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this3->n_sense_paths_gminus + nnewpaths_gminus) * sizeof(int));

      this3->nunique_sense_coords_gminus =
	Path_merge_high_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				     newpaths_gminus,nnewpaths_gminus,
				     /*oldpaths*/this3->sense_paths_gminus,this3->n_sense_paths_gminus,
				     hitlistpool);

      FREE(this3->sense_paths_gminus);
      FREE_ALIGN(this3->sense_coords_gminus);
      FREE(this3->sense_indices_gminus);
      this3->sense_paths_gminus = alloc;
      this3->sense_coords_gminus = coords;
      this3->sense_indices_gminus = cumsums;
      this3->n_sense_paths_gminus += nnewpaths_gminus;
      FREE(newpaths_gminus);
    }


    /* 3' antisense */
    Trpath_convert_antisense(&solvedp,&(*found_score_3),
			     &this3->unsolved_antisense_paths_gplus,&this3->unsolved_antisense_paths_gminus,
			     &antisense_paths3_gplus,&antisense_paths3_gminus,
			     this3->antisense_trpaths,query3_compress_fwd,query3_compress_rev,querylength3,
			     intlistpool,univcoordlistpool,listpool,pathpool,
			     transcriptpool,hitlistpool);

    newpaths_gplus = (Path_T *) List_to_array_n(&nnewpaths_gplus,antisense_paths3_gplus);
    newpaths_gminus = (Path_T *) List_to_array_n(&nnewpaths_gminus,antisense_paths3_gminus);
    qsort(newpaths_gplus,nnewpaths_gplus,sizeof(Path_T),Path_low_univdiagonal_cmp);
    qsort(newpaths_gminus,nnewpaths_gminus,sizeof(Path_T),Path_high_univdiagonal_cmp);
    Hitlistpool_free_list(&antisense_paths3_gplus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&antisense_paths3_gminus,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    if (this3->n_antisense_paths_gplus + nnewpaths_gplus > 0) {
      alloc = (Path_T *) MALLOC((this3->n_antisense_paths_gplus + nnewpaths_gplus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this3->n_antisense_paths_gplus + nnewpaths_gplus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this3->n_antisense_paths_gplus + nnewpaths_gplus) * sizeof(int));

      this3->nunique_antisense_coords_gplus =
	Path_merge_low_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				    newpaths_gplus,nnewpaths_gplus,
				    /*oldpaths*/this3->antisense_paths_gplus,this3->n_antisense_paths_gplus,
				    hitlistpool);

      FREE(this3->antisense_paths_gplus);
      FREE_ALIGN(this3->antisense_coords_gplus);
      FREE(this3->antisense_indices_gplus);
      this3->antisense_paths_gplus = alloc;
      this3->antisense_coords_gplus = coords;
      this3->antisense_indices_gplus = cumsums;
      this3->n_antisense_paths_gplus += nnewpaths_gplus;
      FREE(newpaths_gplus);
    }

    if (this3->n_antisense_paths_gminus + nnewpaths_gminus > 0) {
      alloc = (Path_T *) MALLOC((this3->n_antisense_paths_gminus + nnewpaths_gminus) * sizeof(Path_T));
      MALLOC_ALIGN(coords, (this3->n_antisense_paths_gminus + nnewpaths_gminus) * sizeof(Univcoord_T));
      cumsums = (int *) MALLOC((this3->n_antisense_paths_gminus + nnewpaths_gminus) * sizeof(int));

      this3->nunique_antisense_coords_gminus =
	Path_merge_high_univdiagonal(&incomplete,&ncomplete,alloc,coords,cumsums,
				     newpaths_gminus,nnewpaths_gminus,
				     /*oldpaths*/this3->antisense_paths_gminus,this3->n_antisense_paths_gminus,
				     hitlistpool);

      FREE(this3->antisense_paths_gminus);
      FREE_ALIGN(this3->antisense_coords_gminus);
      FREE(this3->antisense_indices_gminus);
      this3->antisense_paths_gminus = alloc;
      this3->antisense_coords_gminus = coords;
      this3->antisense_indices_gminus = cumsums;
      this3->n_antisense_paths_gminus += nnewpaths_gminus;
      FREE(newpaths_gminus);
    }



    /* 1.3.  Try unsolved trpaths, if any */
    debug(printf("Calling single_read_unsolved_tr on 5' read\n"));
    sense_paths5_gplus = sense_paths5_gminus =
      antisense_paths5_gplus = antisense_paths5_gminus = (List_T) NULL;
    debug(printf("Read 5': 1.3.  Solving unsolved trpaths\n"));
    single_read_unsolved_tr(&(*found_score_5),
			  
			    &sense_paths5_gplus,&sense_paths5_gminus,
			    &antisense_paths5_gplus,&antisense_paths5_gminus,

			    this5,queryseq5,querylength5,knownsplicing,
			    query5_compress_fwd,query5_compress_rev,
			    max_insertionlen_5,max_deletionlen_5,
			    intlistpool,uintlistpool,univcoordlistpool,
			    listpool,pathpool,transcriptpool,hitlistpool);

    debug(printf("Read 3': 1.3.  Solving unsolved trpaths\n"));
    sense_paths3_gplus = sense_paths3_gminus =
      antisense_paths3_gplus = antisense_paths3_gminus = (List_T) NULL;
    single_read_unsolved_tr(&(*found_score_3),
			    
			    &sense_paths3_gplus,&sense_paths3_gminus,
			    &antisense_paths3_gplus,&antisense_paths3_gminus,
			    
			    this3,queryseq3,querylength3,knownsplicing,
			    query3_compress_fwd,query3_compress_rev,
			    max_insertionlen_3,max_deletionlen_3,
			    intlistpool,uintlistpool,univcoordlistpool,
			    listpool,pathpool,transcriptpool,hitlistpool);
    

    debug(printf(">1.3.  Calling Concordance_gen, sense, with %d and %d gplus, %d and %d gminus\n",
		 List_length(sense_paths5_gplus),List_length(sense_paths3_gplus),
		 List_length(sense_paths5_gminus),List_length(sense_paths3_gminus)));
    pathpairs = Concordance_gen(&found_score_paired,&(*found_score_5),&(*found_score_3),pathpairs,
				   
				/*new*/&sense_paths5_gplus,/*new*/&sense_paths5_gminus,
				/*new*/&sense_paths3_gplus,/*new*/&sense_paths3_gminus,
				
				&this5->sense_paths_gplus,&this5->sense_paths_gminus,
				&this3->sense_paths_gplus,&this3->sense_paths_gminus,
				&this5->sense_coords_gplus,&this5->sense_coords_gminus,
				&this3->sense_coords_gplus,&this3->sense_coords_gminus,
				&this5->sense_indices_gplus,&this5->sense_indices_gminus,
				&this3->sense_indices_gplus,&this3->sense_indices_gminus,
				&this5->n_sense_paths_gplus,&this5->n_sense_paths_gminus,
				&this3->n_sense_paths_gplus,&this3->n_sense_paths_gminus,
				&this5->nunique_sense_coords_gplus,&this5->nunique_sense_coords_gminus,
				&this3->nunique_sense_coords_gplus,&this3->nunique_sense_coords_gminus,
				   
				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				   
				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				   
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,genestrand,/*mergep*/true);
    
    debug(printf(">1.3.  Calling Concordance_gen, antisense, with %d and %d gplus, %d and %d gminus\n",
		 List_length(antisense_paths5_gplus),List_length(antisense_paths3_gplus),
		 List_length(antisense_paths5_gminus),List_length(antisense_paths3_gminus)));
    pathpairs = Concordance_gen(&found_score_paired,&(*found_score_5),&(*found_score_3),pathpairs,

				/*new*/&antisense_paths5_gplus,/*new*/&antisense_paths5_gminus,
				/*new*/&antisense_paths3_gplus,/*new*/&antisense_paths3_gminus,

				&this5->antisense_paths_gplus,&this5->antisense_paths_gminus,
				&this3->antisense_paths_gplus,&this3->antisense_paths_gminus,
				&this5->antisense_coords_gplus,&this5->antisense_coords_gminus,
				&this3->antisense_coords_gplus,&this3->antisense_coords_gminus,
				&this5->antisense_indices_gplus,&this5->antisense_indices_gminus,
				&this3->antisense_indices_gplus,&this3->antisense_indices_gminus,
				&this5->n_antisense_paths_gplus,&this5->n_antisense_paths_gminus,
				&this3->n_antisense_paths_gplus,&this3->n_antisense_paths_gminus,
				&this5->nunique_antisense_coords_gplus,&this5->nunique_antisense_coords_gminus,
				&this3->nunique_antisense_coords_gplus,&this3->nunique_antisense_coords_gminus,

				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,

				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				 
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,genestrand,/*mergep*/true);

    /* All paths were complete and merged */
    assert(sense_paths5_gplus == NULL);
    assert(sense_paths5_gminus == NULL);
    assert(sense_paths3_gplus == NULL);
    assert(sense_paths3_gminus == NULL);
    assert(antisense_paths5_gplus == NULL);
    assert(antisense_paths5_gminus == NULL);
    assert(antisense_paths3_gplus == NULL);
    assert(antisense_paths3_gminus == NULL);

    if (pathpairs != NULL) {
      debug0(print_pathpairs_contents(pathpairs));
      return pathpairs;
    }

    /* Initialize all univdiagonals to mirror paths in Stage1_T object */
    /* Stage1_list_paths(this5); */
    /* Stage1_list_paths(this3); */

#if 0
    this5->univdiagonals_gplus = merge_univdiagonals(&this5->nunivdiagonals_gplus,
						     this5->sense_paths_gplus,this5->n_sense_paths_gplus,
						     this5->antisense_paths_gplus,this5->n_antisense_paths_gplus,
						     /*sort_high_univdiagonal_p*/true);
#endif

#if 0
    /* Transcriptome methods should not yield univdiagonals */
    merge_paths_from_univdiagonals(&(*found_score_5),

				   &this5->unextended_sense_paths_gplus,&this5->unextended_antisense_paths_gplus,

				   &this5->univdiagonals_gplus,&this5->nunivdiagonals_gplus,

				   /*paths*/&this5->sense_paths_gplus,/*coords*/&this5->sense_coords_gplus,
				   /*cumsums*/&this5->sense_indices_gplus,/*npaths*/&this5->n_sense_paths_gplus,
				   /*nunique*/&this5->nunique_sense_coords_gplus,

				   /*paths*/&this5->antisense_paths_gplus,/*coords*/&this5->antisense_coords_gplus,
				   /*cumsums*/&this5->antisense_indices_gplus,/*npaths*/&this5->n_antisense_paths_gplus,
				   /*nunique*/&this5->nunique_antisense_coords_gplus,
				     
				   /*old_univdiagonals*/NULL,/*n_old_univdiagonals*/0,
				   /*new*/this5->univdiagonals_gplus,/*new*/this5->nunivdiagonals_gplus,
				   /*plusp*/true,querylength5,/*first_read_p*/true,
				     
				   queryseq5,/*queryptr*/queryuc_ptr_5,/*query_compress*/query5_compress_fwd,
				   query5_compress_fwd,query5_compress_rev,mismatch_positions_alloc_5,
				     
				   novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				   max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,overall_end_distance_5,
				     
				   intlistpool,uintlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				   /*sort_high_univdiagonal_p*/true,/*method*/last_method_5,/*find_splices_p*/true,
				   /*solve_paths_p*/false);
#endif


#if 0
    this5->univdiagonals_gminus = merge_univdiagonals(&this5->nunivdiagonals_gminus,
						     this5->sense_paths_gminus,this5->n_sense_paths_gminus,
						     this5->antisense_paths_gminus,this5->n_antisense_paths_gminus,
						     /*sort_high_univdiagonal_p*/false);
#endif

#if 0
    /* Transcriptome methods should not yield univdiagonals */
    merge_paths_from_univdiagonals(&(*found_score_5),

				   &this5->unextended_sense_paths_gminus,&this5->unextended_antisense_paths_gminus,
				     
				   &this5->univdiagonals_gminus,&this5->nunivdiagonals_gminus,

				   /*paths*/&this5->sense_paths_gminus,/*coords*/&this5->sense_coords_gminus,
				   /*cumsums*/&this5->sense_indices_gminus,/*npaths*/&this5->n_sense_paths_gminus,
				   /*nunique*/&this5->nunique_sense_coords_gminus,
				   
				   /*paths*/&this5->antisense_paths_gminus,/*coords*/&this5->antisense_coords_gminus,
				   /*cumsums*/&this5->antisense_indices_gminus,/*npaths*/&this5->n_antisense_paths_gminus,
				   /*nunique*/&this5->nunique_antisense_coords_gminus,

				   /*old_univdiagonals*/NULL,/*n_old_univdiagonals*/0,
				   /*new*/this5->univdiagonals_gminus,/*new*/this5->nunivdiagonals_gminus,
				   /*plusp*/false,querylength5,/*first_read_p*/true,

				   queryseq5,/*queryptr*/queryrc5,/*query_compress*/query5_compress_rev,
				   query5_compress_fwd,query5_compress_rev,mismatch_positions_alloc_5,
				   
				   novel_diagonals_alloc,localdb_alloc,this5,knownsplicing,knownindels,
				   max_insertionlen_5,max_deletionlen_5,nmismatches_allowed_5,overall_end_distance_5,
				   
				   intlistpool,uintlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen5,
				   /*sort_high_univdiagonal_p*/false,/*method*/last_method_5,/*find_splices_p*/true,
				   /*solve_paths_p*/false);
#endif


#if 0
    this3->univdiagonals_gplus = merge_univdiagonals(&this3->nunivdiagonals_gplus,
						     this3->sense_paths_gplus,this3->n_sense_paths_gplus,
						     this3->antisense_paths_gplus,this3->n_antisense_paths_gplus,
						     /*sort_high_univdiagonal_p*/false);
#endif

#if 0
    /* Transcriptome methods should not yield univdiagonals */
    merge_paths_from_univdiagonals(&(*found_score_3),

				   &this3->unextended_sense_paths_gplus,&this3->unextended_antisense_paths_gplus,
				   
				   &this3->univdiagonals_gplus,&this3->nunivdiagonals_gplus,

				   /*paths*/&this3->sense_paths_gplus,/*coords*/&this3->sense_coords_gplus,
				   /*cumsums*/&this3->sense_indices_gplus,/*npaths*/&this3->n_sense_paths_gplus,
				   /*nunique*/&this3->nunique_sense_coords_gplus,
				   
				   /*paths*/&this3->antisense_paths_gplus,/*coords*/&this3->antisense_coords_gplus,
				   /*cumsums*/&this3->antisense_indices_gplus,/*npaths*/&this3->n_antisense_paths_gplus,
				   /*nunique*/&this3->nunique_antisense_coords_gplus,
				   
				   /*old_univdiagonals*/NULL,/*n_old_univdiagonals*/0,
				   /*new*/this3->univdiagonals_gplus,/*new*/this3->nunivdiagonals_gplus,
				   /*plusp*/true,querylength3,/*first_read_p*/false,
				   
				   queryseq3,/*queryptr*/queryuc_ptr_3,/*query_compress*/query3_compress_fwd,
				   query3_compress_fwd,query3_compress_rev,mismatch_positions_alloc_3,
				   
				   novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				   max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,overall_end_distance_3,
				   
				   intlistpool,uintlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				   /*sort_high_univdiagonal_p*/false,/*method*/last_method_3,/*find_splices_p*/true,
				   /*solve_paths_p*/false);
#endif


#if 0
    this3->univdiagonals_gminus = merge_univdiagonals(&this3->nunivdiagonals_gminus,
						     this3->sense_paths_gminus,this3->n_sense_paths_gminus,
						     this3->antisense_paths_gminus,this3->n_antisense_paths_gminus,
						     /*sort_high_univdiagonal_p*/true);
#endif

#if 0
    /* Transcriptome methods should not yield univdiagonals */
    merge_paths_from_univdiagonals(&(*found_score_3),

				   &this3->unextended_sense_paths_gminus,&this3->unextended_antisense_paths_gminus,

				   &this3->univdiagonals_gminus,&this3->nunivdiagonals_gminus,

				   /*paths*/&this3->sense_paths_gminus,/*coords*/&this3->sense_coords_gminus,
				   /*cumsums*/&this3->sense_indices_gminus,/*npaths*/&this3->n_sense_paths_gminus,
				   /*nunique*/&this3->nunique_sense_coords_gminus,

				   /*paths*/&this3->antisense_paths_gminus,/*coords*/&this3->antisense_coords_gminus,
				   /*cumsums*/&this3->antisense_indices_gminus,/*npaths*/&this3->n_antisense_paths_gminus,
				   /*nunique*/&this3->nunique_antisense_coords_gminus,

				   /*old_univdiagonals*/NULL,/*n_old_univdiagonals*/0,
				   /*new*/this3->univdiagonals_gminus,/*new*/this3->nunivdiagonals_gminus,
				   /*plusp*/false,querylength3,/*first_read_p*/false,
				   
				   queryseq3,/*queryptr*/queryrc3,/*query_compress*/query3_compress_rev,
				   query3_compress_fwd,query3_compress_rev,mismatch_positions_alloc_3,
				   
				   novel_diagonals_alloc,localdb_alloc,this3,knownsplicing,knownindels,
				   max_insertionlen_3,max_deletionlen_3,nmismatches_allowed_3,overall_end_distance_3,

				   intlistpool,uintlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,vectorpool,hitlistpool,spliceendsgen3,
				   /*sort_high_univdiagonal_p*/true,/*method*/last_method_3,/*find_splices_p*/true,
				   /*solve_paths_p*/false);
#endif
  }

  /* End of TR task.  Continuation of genomic methods.  Start of RNA or DNA task */

  if (splicingp == false) {
    final_univdiagonal_method = KMER_EXACT1;
  } else {
    /* Allow for splicing at ends */
    final_univdiagonal_method = KMER_EXACT2;
  }
    
  /* A.  Gather univdiagonals using fastest methods */
  debug(printf("Starting univdiagonal search up through %s: methods %s and %s, found_scores %d and %d\n",
	       Method_string(final_univdiagonal_method),
	       Method_string(last_method_5),Method_string(last_method_3),*found_score_5,*found_score_3));

  /* Disjunction: Stops when we have found pathpairs or both ends have gone to KMER_EXACT2 */
  while (last_method_5 < final_univdiagonal_method || last_method_3 < final_univdiagonal_method) {
    if ((pathpairs = paired_search_univdiagonals(&found_score_paired,&(*found_score_5),&(*found_score_3),
						 &last_method_5,&last_method_3,

						 pathpairs,this5,this3,queryseq5,queryseq3,
						 queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						 knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						 novel_diagonals_alloc,localdb_alloc,
						 query5_compress_fwd,query5_compress_rev,
						 query3_compress_fwd,query3_compress_rev,
						 nmismatches_allowed_5,nmismatches_allowed_3,
						 max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						 genestrand,overall_end_distance_5,overall_end_distance_3,
						 intlistpool,uintlistpool,univcoordlistpool,listpool,
						 pathpool,transcriptpool,vectorpool,hitlistpool,
						 spliceendsgen5,spliceendsgen3,final_univdiagonal_method)) != NULL) {
      debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
      return pathpairs;

    } else {
      debug(printf("Continuing with found scores %d and %d\n",*found_score_5,*found_score_3));
      /* Better not to update methods based on found_scores */
    }
  }


#if 0
  /* KMER_PREVALENCE useful for genomic alignment, but not so much for TGGA */
  /* KMER_PREVALENCE is slow for single-end reads */
  /* B.  Gather univdiagonals using slower methods (but still faster than genomic methods) */
  debug(printf("Starting univdiagonal search through KMER_PREVALENT: methods %s and %s, found_scores %d and %d\n",
	       Method_string(last_method_5),Method_string(last_method_3),*found_score_5,*found_score_3));

  /* Disjunction: Stops when we have found pathpairs or both ends have gone to KMER_EXACT2 */
  while (last_method_5 < KMER_PREVALENT || last_method_3 < KMER_PREVALENT) {
    if ((pathpairs = paired_search_univdiagonals(&found_score_paired,&(*found_score_5),&(*found_score_3),
						 &last_method_5,&last_method_3,

						 pathpairs,this5,this3,queryseq5,queryseq3,
						 queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						 knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						 novel_diagonals_alloc,localdb_alloc,
						 query5_compress_fwd,query5_compress_rev,
						 query3_compress_fwd,query3_compress_rev,
						 nmismatches_allowed_5,nmismatches_allowed_3,
						 max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						 genestrand,overall_end_distance_5,overall_end_distance_3,
						 intlistpool,uintlistpool,univcoordlistpool,listpool,
						 pathpool,transcriptpool,vectorpool,hitlistpool,
						 spliceendsgen5,spliceendsgen3,
						 /*final_univdiagonal_method*/KMER_PREVALENT)) != NULL) {
      debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
      return pathpairs;

    } else {
      debug(printf("Continuing with found scores %d and %d\n",*found_score_5,*found_score_3));
      /* Better not to update methods based on found_scores */
    }
  }
#endif


  /* C.  Try genomic search through EXT.  SEGMENT1 is similar to KMER_PREVALENCE */
  debug(printf("Starting gen search after univdiagonal search: methods %s and %s, found_scores %d and %d\n",
	       Method_string(last_method_5),Method_string(last_method_3),*found_score_5,*found_score_3));
  /* Conjunction: Stops when we have found pathpairs or either end has gone to EXT */
  while (last_method_5 < EXT || last_method_3 < EXT) {
    if (last_method_3 >= EXT) {
      debug(printf("(1) Running gen search on 5' end\n"));
      if ((pathpairs = paired_read_next_method_gen_5(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_5,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }

    } else if (last_method_5 >= EXT) {
      debug(printf("(2) Running gen search on 3' end\n"));
      if ((pathpairs = paired_read_next_method_gen_3(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_3,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }

    } else if ((*found_score_5) >= (*found_score_3)) {
      debug(printf("(3) Running gen search on 5' end\n"));
      if ((pathpairs = paired_read_next_method_gen_5(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_5,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }

    } else {
      debug(printf("(4) Running gen search on 3' end\n"));
      if ((pathpairs = paired_read_next_method_gen_3(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_3,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }
    }
  }


#if 1
  /* Need this for speed; otherwise we see slowing by a factor of 2 */
  /* Now called within next_method procedures */
  /* C.  Perform unextended search, using unextended paths in Stage1_T object from EXT method */
  debug(printf("Starting unextended_search after EXT\n"));
  if ((pathpairs = unextended_search(&found_score_paired,&(*found_score_5),&(*found_score_3),
				     pathpairs,this5,this3,queryseq5,queryseq3,
				     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				     novel_diagonals_alloc,localdb_alloc,
				     query5_compress_fwd,query5_compress_rev,
				     query3_compress_fwd,query3_compress_rev,
				     /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
				     /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
				     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				     genestrand,overall_end_distance_5,overall_end_distance_3,
				     intlistpool,uintlistpool,univcoordlistpool,listpool,
				     pathpool,transcriptpool,vectorpool,hitlistpool,
				     spliceendsgen5,spliceendsgen3)) != NULL) {

    debug(printf("Exiting after unextended search\n"));
    return pathpairs;
  }
#endif


#if 0
  /* F.  Anchored search (or SEGMENT2) */
  if ((*found_score_5) >= (*found_score_3)) {
    if ((pathpairs = anchored_search_5(&found_score_paired,&(*found_score_5),&(*found_score_3),

				       &unextended_sense_seg2paths5_gplus,
				       &unextended_sense_seg2paths5_gminus,
				       &unextended_antisense_seg2paths5_gplus,
				       &unextended_antisense_seg2paths5_gminus,
				       
				       pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
				       
				       queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				       knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				       novel_diagonals_alloc,localdb_alloc,
				       query5_compress_fwd,query5_compress_rev,
				       query3_compress_fwd,query3_compress_rev,
				       /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
				       /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
				       max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				       genestrand,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				       overall_end_distance_5,overall_end_distance_3,
				       intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
				       pathpool,transcriptpool,vectorpool,hitlistpool,
				       spliceendsgen5,spliceendsgen3,pass,/*use_unextended_p*/false)) != NULL) {

      /* Save unextended paths for finding fusions */
      this5->unextended_sense_paths_gplus = List_append(unextended_sense_seg2paths5_gplus,this5->unextended_sense_paths_gplus);
      this5->unextended_sense_paths_gminus = List_append(unextended_sense_seg2paths5_gminus,this5->unextended_sense_paths_gminus);
      this5->unextended_antisense_paths_gplus = List_append(unextended_antisense_seg2paths5_gplus,this5->unextended_antisense_paths_gplus);
      this5->unextended_antisense_paths_gminus = List_append(unextended_antisense_seg2paths5_gminus,this5->unextended_antisense_paths_gminus);

      debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
      return pathpairs;
    }

  } else {
    if ((pathpairs = anchored_search_3(&found_score_paired,&(*found_score_5),&(*found_score_3),

				       &unextended_sense_seg2paths3_gplus,
				       &unextended_sense_seg2paths3_gminus,
				       &unextended_antisense_seg2paths3_gplus,
				       &unextended_antisense_seg2paths3_gminus,
				       
				       pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
				       
				       queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				       knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				       novel_diagonals_alloc,localdb_alloc,
				       query5_compress_fwd,query5_compress_rev,
				       query3_compress_fwd,query3_compress_rev,
				       /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
				       /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
				       max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				       genestrand,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				       overall_end_distance_5,overall_end_distance_3,
				       intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
				       pathpool,transcriptpool,vectorpool,hitlistpool,
				       spliceendsgen5,spliceendsgen3,pass,/*use_unextended_p*/false)) != NULL) {

      /* Save unextended paths for finding fusions */
      this3->unextended_sense_paths_gplus = List_append(unextended_sense_seg2paths3_gplus,this3->unextended_sense_paths_gplus);
      this3->unextended_sense_paths_gminus = List_append(unextended_sense_seg2paths3_gminus,this3->unextended_sense_paths_gminus);
      this3->unextended_antisense_paths_gplus = List_append(unextended_antisense_seg2paths3_gplus,this3->unextended_antisense_paths_gplus);
      this3->unextended_antisense_paths_gminus = List_append(unextended_antisense_seg2paths3_gminus,this3->unextended_antisense_paths_gminus);

      debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
      return pathpairs;
    }
  }
#endif
      

#if 0
  /* B.  Try genomic search */
  debug(printf("Starting gen search after univdiagonal search: methods %s and %s, found_scores %d and %d\n",
	       Method_string(last_method_5),Method_string(last_method_3),*found_score_5,*found_score_3));
  /* Disjunction: Stops when we have found pathpairs or both ends have gone to SEGMENT1 */
  while (last_method_5 < SEGMENT1 || last_method_3 < SEGMENT1) {
    if (last_method_3 == SEGMENT1) {
      debug(printf("(1) Running gen search on 5' end\n"));
      if ((pathpairs = paired_read_next_method_gen_5(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_5,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }

    } else if (last_method_5 == SEGMENT1) {
      debug(printf("(2) Running gen search on 3' end\n"));
      if ((pathpairs = paired_read_next_method_gen_3(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_3,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }

    } else if ((*found_score_5) >= (*found_score_3)) {
      debug(printf("(3) Running gen search on 5' end\n"));
      if ((pathpairs = paired_read_next_method_gen_5(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_5,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }

    } else {
      debug(printf("(4) Running gen search on 3' end\n"));
      if ((pathpairs = paired_read_next_method_gen_3(&found_score_paired,&(*found_score_5),&(*found_score_3),&last_method_3,
						     pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
					
						     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
						     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
						     novel_diagonals_alloc,localdb_alloc,
						     query5_compress_fwd,query5_compress_rev,
						     query3_compress_fwd,query3_compress_rev,
						     nmismatches_allowed_5,nmismatches_allowed_3,
						     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
						     genestrand,overall_max_distance_5,overall_max_distance_3,
						     overall_end_distance_5,overall_end_distance_3,
						     intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
						     pathpool,transcriptpool,vectorpool,hitlistpool,
						     spliceendsgen5,spliceendsgen3,pass)) != NULL) {
	debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
	return pathpairs;
      }
    }
  }
#endif



#if 0
  /* Doing the other anchored search (seems not to help) */
  if (last_method_5 < SEGMENT2) {
    if ((pathpairs = anchored_search_5(&found_score_paired,&(*found_score_5),&(*found_score_3),

				       &unextended_sense_seg2paths5_gplus,
				       &unextended_sense_seg2paths5_gminus,
				       &unextended_antisense_seg2paths5_gplus,
				       &unextended_antisense_seg2paths5_gminus,
				       
				       pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
				       
				       queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				       knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				       novel_diagonals_alloc,localdb_alloc,
				       query5_compress_fwd,query5_compress_rev,
				       query3_compress_fwd,query3_compress_rev,
				       /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
				       /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
				       max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				       genestrand,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				       overall_end_distance_5,overall_end_distance_3,
				       intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
				       pathpool,transcriptpool,vectorpool,hitlistpool,
				       spliceendsgen5,spliceendsgen3,pass,/*use_unextended_p*/false)) != NULL) {

      /* Save unextended paths for finding fusions */
      this5->unextended_sense_paths_gplus = List_append(unextended_sense_seg2paths5_gplus,this5->unextended_sense_paths_gplus);
      this5->unextended_sense_paths_gminus = List_append(unextended_sense_seg2paths5_gminus,this5->unextended_sense_paths_gminus);
      this5->unextended_antisense_paths_gplus = List_append(unextended_antisense_seg2paths5_gplus,this5->unextended_antisense_paths_gplus);
      this5->unextended_antisense_paths_gminus = List_append(unextended_antisense_seg2paths5_gminus,this5->unextended_antisense_paths_gminus);

      debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
      return pathpairs;
    }
  }

  if (last_method_3 < SEGMENT2) {
    if ((pathpairs = anchored_search_3(&found_score_paired,&(*found_score_5),&(*found_score_3),

				       &unextended_sense_seg2paths3_gplus,
				       &unextended_sense_seg2paths3_gminus,
				       &unextended_antisense_seg2paths3_gplus,
				       &unextended_antisense_seg2paths3_gminus,
				       
				       pathpairs,this5,this3,repetitive_ef64,queryseq5,queryseq3,
				       
				       queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				       knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				       novel_diagonals_alloc,localdb_alloc,
				       query5_compress_fwd,query5_compress_rev,
				       query3_compress_fwd,query3_compress_rev,
				       /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
				       /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
				       max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				       genestrand,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				       overall_end_distance_5,overall_end_distance_3,
				       intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
				       pathpool,transcriptpool,vectorpool,hitlistpool,
				       spliceendsgen5,spliceendsgen3,pass,/*use_unextended_p*/false)) != NULL) {

      /* Save unextended paths for finding fusions */
      this3->unextended_sense_paths_gplus = List_append(unextended_sense_seg2paths3_gplus,this3->unextended_sense_paths_gplus);
      this3->unextended_sense_paths_gminus = List_append(unextended_sense_seg2paths3_gminus,this3->unextended_sense_paths_gminus);
      this3->unextended_antisense_paths_gplus = List_append(unextended_antisense_seg2paths3_gplus,this3->unextended_antisense_paths_gplus);
      this3->unextended_antisense_paths_gminus = List_append(unextended_antisense_seg2paths3_gminus,this3->unextended_antisense_paths_gminus);

      debug(printf("Exiting after methods %s and %s\n",Method_string(last_method_5),Method_string(last_method_3)));
      return pathpairs;
    }
  }
#endif


#if 0
  /* Perform anchored_unextended_search */
  /* This also seems not to help */
  pathpairs = anchored_unextended_search(&found_score_paired,&(*found_score_5),&(*found_score_3),
					 pathpairs,this5,this3,repetitive_ef64,

					 unextended_sense_seg2paths5_gplus,
					 unextended_sense_seg2paths5_gminus,
					 unextended_antisense_seg2paths5_gplus,
					 unextended_antisense_seg2paths5_gminus,

					 unextended_sense_seg2paths3_gplus,
					 unextended_sense_seg2paths3_gminus,
					 unextended_antisense_seg2paths3_gplus,
					 unextended_antisense_seg2paths3_gminus,
				       
					 queryseq5,queryseq3,
					 queryuc_ptr_5,queryrc5,querylength5,
					 queryuc_ptr_3,queryrc3,querylength3,
					 knownsplicing,knownindels,
					 mismatch_positions_alloc_5,mismatch_positions_alloc_3,
					 novel_diagonals_alloc,localdb_alloc,
					 query5_compress_fwd,query5_compress_rev,
					 query3_compress_fwd,query3_compress_rev,
					 /*nmismatches_allowed_5*/2 * nmismatches_allowed_5,
					 /*nmismatches_allowed_3*/2 * nmismatches_allowed_3,
					 max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
					 genestrand,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
					 overall_end_distance_5,overall_end_distance_3,
					 intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,
					 pathpool,transcriptpool,vectorpool,hitlistpool,
					 spliceendsgen5,spliceendsgen3,pass);
#endif

  /* Save unextended paths for finding fusions */
  this5->unextended_sense_paths_gplus = List_append(unextended_sense_seg2paths5_gplus,this5->unextended_sense_paths_gplus);
  this5->unextended_sense_paths_gminus = List_append(unextended_sense_seg2paths5_gminus,this5->unextended_sense_paths_gminus);
  this5->unextended_antisense_paths_gplus = List_append(unextended_antisense_seg2paths5_gplus,this5->unextended_antisense_paths_gplus);
  this5->unextended_antisense_paths_gminus = List_append(unextended_antisense_seg2paths5_gminus,this5->unextended_antisense_paths_gminus);

  this3->unextended_sense_paths_gplus = List_append(unextended_sense_seg2paths3_gplus,this3->unextended_sense_paths_gplus);
  this3->unextended_sense_paths_gminus = List_append(unextended_sense_seg2paths3_gminus,this3->unextended_sense_paths_gminus);
  this3->unextended_antisense_paths_gplus = List_append(unextended_antisense_seg2paths3_gplus,this3->unextended_antisense_paths_gplus);
  this3->unextended_antisense_paths_gminus = List_append(unextended_antisense_seg2paths3_gminus,this3->unextended_antisense_paths_gminus);

  return pathpairs;
}


static List_T
find_inner_fusions (int *found_score_5, int *found_score_3,

		    List_T local_sense_paths5, List_T local_antisense_paths5,
		    List_T local_sense_paths3, List_T local_antisense_paths3,

		    Shortread_T queryseq5, Shortread_T queryseq3,
		    char *queryuc_ptr_5, char *queryrc5, char *queryuc_ptr_3, char *queryrc3,
		    Knownsplicing_T knownsplicing, Univcoord_T *novel_diagonals_alloc,
		    unsigned short *localdb_alloc, T this5, T this3,

		    Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		    Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
		    int nmismatches_allowed_5, int nmismatches_allowed_3,
		    int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
		    
		    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		    Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
		    Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool) {


  List_T pathpairs = NULL, p;
  Path_T path5, path3;


  for (p = local_sense_paths5; p != NULL; p = List_next(p)) {
    path5 = (Path_T) List_head(p);
    if ((path5->plusp == true && Path_unextended_qend_p(path5,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true) ||
	(path5->plusp == false && Path_unextended_qstart_p(path5,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true)) {
      pathpairs = find_inner_fusions_path5(&(*found_score_5),pathpairs,path5,local_sense_paths3,
					   this5,query5_compress_fwd,query5_compress_rev,queryseq5,queryseq3,
					   queryuc_ptr_5,queryrc5,novel_diagonals_alloc,localdb_alloc,
					   knownsplicing,nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
					   intlistpool,uintlistpool,univcoordlistpool,
					   listpool,pathpool,vectorpool,hitlistpool,transcriptpool);

    }
  }

  for (p = local_antisense_paths5; p != NULL; p = List_next(p)) {
    path5 = (Path_T) List_head(p);
    if ((path5->plusp == true && Path_unextended_qend_p(path5,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true) ||
	(path5->plusp == false && Path_unextended_qstart_p(path5,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true)) {
      pathpairs = find_inner_fusions_path5(&(*found_score_5),pathpairs,path5,local_antisense_paths3,
					   this5,query5_compress_fwd,query5_compress_rev,queryseq5,queryseq3,
					   queryuc_ptr_5,queryrc5,novel_diagonals_alloc,localdb_alloc,
					   knownsplicing,nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
					   intlistpool,uintlistpool,univcoordlistpool,
					   listpool,pathpool,vectorpool,hitlistpool,transcriptpool);
    }
  }

  for (p = local_sense_paths3; p != NULL; p = List_next(p)) {
    path3 = (Path_T) List_head(p);
    if ((path3->plusp == true && Path_unextended_qstart_p(path3,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true) ||
	(path3->plusp == false && Path_unextended_qend_p(path3,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true)) {
      pathpairs = find_inner_fusions_path3(&(*found_score_3),pathpairs,path3,local_sense_paths5,
					   this3,query3_compress_fwd,query3_compress_rev,queryseq5,queryseq3,
					   queryuc_ptr_3,queryrc3,novel_diagonals_alloc,localdb_alloc,
					   knownsplicing,nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
					   intlistpool,uintlistpool,univcoordlistpool,
					   listpool,pathpool,vectorpool,
					   hitlistpool,transcriptpool);
    }
  }

  for (p = local_antisense_paths3; p != NULL; p = List_next(p)) {
    path3 = (Path_T) List_head(p);
    if ((path3->plusp == true && Path_unextended_qstart_p(path3,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true) ||
	(path3->plusp == false && Path_unextended_qend_p(path3,/*endtrim_allowed*/8,/*allow_ambig_p*/false) == true)) {
      pathpairs = find_inner_fusions_path3(&(*found_score_3),pathpairs,path3,local_antisense_paths5,
					   this3,query3_compress_fwd,query3_compress_rev,queryseq5,queryseq3,
					   queryuc_ptr_3,queryrc3,novel_diagonals_alloc,localdb_alloc,
					   knownsplicing,nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
					   intlistpool,uintlistpool,univcoordlistpool,
					   listpool,pathpool,vectorpool,
					   hitlistpool,transcriptpool);
    }
  }

  return pathpairs;
}



/* pairtype can be CONCORDANT, CONCORDANT_TRANSLOCATIONS, PAIRED_INVERSION, PAIRED_SCRAMBLE, PAIRED_TOOLONG, UNPAIRED */
static Pairtype_T
determine_pairtype (Path_T path5, Path_T path3) {
  Univcoord_T genomicstart5, genomicend5, genomicstart3, genomicend3;
  Chrpos_T pairmax;

  debug14(printf("Entered determine_pairtype\n"));
  if (path5->chrnum != path3->chrnum) {
    debug14(printf("Returning unpaired because path5 chrnum %d != path3 chrnum %d\n",
		   path5->chrnum,path3->chrnum));
    return UNPAIRED;

  } else if (path5->fusion_querystart_junction != NULL ||
      path5->fusion_queryend_junction != NULL ||
      path3->fusion_querystart_junction != NULL ||
      path3->fusion_queryend_junction != NULL) {
    debug14(printf("Returning translocations\n"));
    /* On the same chromosome, so consider them concordant, but we may need to check their distance */
    return CONCORDANT_TRANSLOCATIONS;

#ifdef TO_FIX
  } else if (Transcript_concordant_p(path5->transcripts_consistent,path3->transcripts_consistent) == true) {
    debug14(printf("Returning concordant based on transcriptome\n"));
    return CONCORDANT;
#endif

  } else if (path5->plusp != path3->plusp) {
    debug14(printf("Returning paired_inversion\n"));
    return PAIRED_INVERSION;

  } else if (path5->plusp == true) {
    genomicstart5 = Path_genomicstart(path5);
    genomicend5 = Path_genomicend(path5);
    genomicstart3 = Path_genomicstart(path3);
    genomicend3 = Path_genomicend(path3);

#ifdef TO_FIX
    if (path5->circularalias == 0 && path3->circularalias == 0) {
      /* Keep coordinates as is */
    } else if (path5->circularalias == 0) {
      if (path3->circularalias == -1) {
	debug14(printf("Have to alias path3\n"));
	assert(circularp[path3->chrnum] == true);
	chrlength = (path3->chrhigh - path3->chroffset)/2;
	genomicstart3 += chrlength;
	genomicend3 += chrlength;
      }
    } else if (path3->circularalias == 0) {
      if (path5->circularalias == +1) {
	debug14(printf("Have to unalias path5\n"));
	assert(circularp[path5->chrnum] == true);
	chrlength = (path5->chrhigh - path5->chroffset)/2;
	genomicstart5 -= chrlength;
	genomicend5 -= chrlength;
      }
    }
#endif

    if (genomicend3 < genomicstart5) {
      debug14(printf("(plus) path3 genomicend %u < path5 genomicstart %u => Returning paired_scramble\n",
		     genomicend3,genomicstart5));
      return PAIRED_SCRAMBLE;
    } else {
      if (circularp[path5->chrnum] == true) {
	pairmax = pairmax_circular;
      } else {
	pairmax = pairmax_linear;
      }

      if (genomicstart3 > genomicend5 + pairmax) {
	debug14(printf("Returning paired_toolong\n"));
	return PAIRED_TOOLONG;
      } else {
	debug14(printf("Returning concordant\n"));
	return CONCORDANT;
      }
    }

  } else {
    genomicstart5 = Path_genomicstart(path5);
    genomicend5 = Path_genomicend(path5);
    genomicstart3 = Path_genomicstart(path3);
    genomicend3 = Path_genomicend(path3);

#ifdef TO_FIX
    if (path5->circularalias == 0 && path3->circularalias == 0) {
      /* Keep coordinates as is */
    } else if (path5->circularalias == 0) {
      if (path3->circularalias == +1) {
	debug14(printf("Have to unalias path3\n"));
	assert(circularp[path3->chrnum] == true);
	chrlength = (path3->chrhigh - path3->chroffset)/2;
	genomicstart3 -= chrlength;
	genomicend3 -= chrlength;
      }
    } else if (path3->circularalias == 0) {
      if (path5->circularalias == -1) {
	debug14(printf("Have to alias path5\n"));
	assert(circularp[path5->chrnum] == true);
	chrlength = (path5->chrhigh - path5->chroffset)/2;
	genomicstart5 += chrlength;
	genomicend5 += chrlength;
      }
    }
#endif

    if (genomicend3 > genomicstart5) {
      debug14(printf("(minus) path3 genomicend %u > path5 genomicstart %u => Returning paired_scramble\n",
		     genomicend3,genomicstart5));
      return PAIRED_SCRAMBLE;
    } else {
      if (circularp[path3->chrnum] == true) {
	pairmax = pairmax_circular;
      } else {
	pairmax = pairmax_linear;
      }

      if (genomicstart3 + pairmax < genomicend5) {
	debug14(printf("Returning paired_toolong\n"));
	return PAIRED_TOOLONG;
      } else {
	debug14(printf("Returning concordant\n"));
	return CONCORDANT;
      }
    }
  }
}


/* Have three lists: pathpairs, samechr, and conc_transloc => result */
/* final_pairtype can be CONCORDANT_TRANSLOCATIONS, CONCORDANT, PAIRED_INVERSION, PAIRED_SCRAMBLE, PAIRED_TOOLONG, UNPAIRED */


static Pathpair_T *
consolidate_results (int *found_score_5, int *found_score_3, Pairtype_T *final_pairtype,
		     int *npaths_primary, int *npaths_altloc, int *first_absmq, int *second_absmq,
		     Path_T **patharray5, int *npaths5_primary, int *npaths5_altloc, int *first_absmq5, int *second_absmq5,
		     Path_T **patharray3, int *npaths3_primary, int *npaths3_altloc, int *first_absmq3, int *second_absmq3,

		     List_T pathpairs, List_T sense_paths5, List_T antisense_paths5,
		     List_T sense_paths3, List_T antisense_paths3,

		     Shortread_T queryseq5, Shortread_T queryseq3,
		     char *queryuc_ptr_5, char *queryrc5, int querylength5,
		     char *queryuc_ptr_3, char *queryrc3, int querylength3,

		     Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		     Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		     T this5, T this3,

		     int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,

		     Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		     Compress_T query3_compress_fwd, Compress_T query3_compress_rev,

		     int nmismatches_allowed_5, int nmismatches_allowed_3,
		     int nmismatches_filter_5, int nmismatches_filter_3,
		     int mincoverage_filter_5, int mincoverage_filter_3,
		     int max_insertionlen_5, int max_insertionlen_3,
		     int max_deletionlen_5, int max_deletionlen_3,
		     int overall_end_distance_5, int overall_end_distance_3,
		
		     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		     Listpool_T listpool, Univdiagpool_T univdiagpool,
		     Pathpool_T pathpool, Vectorpool_T vectorpool,
		     Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool,
		     Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3, Pass_T pass) {

  Pathpair_T *pathpairarray, pathpair;
  List_T newpaths, singlepaths5, singlepaths3, paths5, paths3, p, q;
  Path_T path, path5, path3, copy;
  Compress_T query_compress;
  char *queryptr;
  bool completep;
  int sensedir5, sensedir3;
  int tr_insertlength;
  int i, j;


  debug16(printf("Entered consolidate_paired_results\n"));

  *npaths5_primary = *npaths5_altloc = 0;
  *npaths3_primary = *npaths3_altloc = 0;
  *patharray5 = (Path_T *) NULL;
  *patharray3 = (Path_T *) NULL;

  if (pathpairs == NULL) {
    debug(printf("pathpairs is NULL, so handling unpaired ends\n"));
    /* Unpaired ends */
    if (sense_paths5 != NULL && antisense_paths5 == NULL) {
      sensedir5 = SENSE_FORWARD;
    } else if (sense_paths5 == NULL && antisense_paths5 != NULL) {
      sensedir5 = SENSE_ANTI;
    } else {
      sensedir5 = SENSE_NULL;
    }
	
    if (sense_paths3 != NULL && antisense_paths3 == NULL) {
      sensedir3 = SENSE_FORWARD;
    } else if (sense_paths3 == NULL && antisense_paths3 != NULL) {
      sensedir3 = SENSE_ANTI;
    } else {
      sensedir3 = SENSE_NULL;
    }

    if (sensedir5 == SENSE_NULL && sensedir3 == SENSE_NULL) {
      /* No restriction */
      paths5 = List_append(sense_paths5,antisense_paths5);
      paths3 = List_append(sense_paths3,antisense_paths3);
    } else if (sensedir5 == SENSE_FORWARD && sensedir3 == SENSE_ANTI) {
      /* Contradiction */
      paths5 = List_append(sense_paths5,antisense_paths5);
      paths3 = List_append(sense_paths3,antisense_paths3);
    } else if (sensedir5 == SENSE_ANTI && sensedir3 == SENSE_FORWARD) {
      /* Contradiction */
      paths5 = List_append(sense_paths5,antisense_paths5);
      paths3 = List_append(sense_paths3,antisense_paths3);
    } else if (sensedir5 == SENSE_FORWARD || sensedir3 == SENSE_FORWARD) {
      /* Restrict to sense */
      paths5 = sense_paths5;
      paths3 = sense_paths3;
    } else if (sensedir5 == SENSE_ANTI || sensedir3 == SENSE_ANTI) {
      /* Restrict to antisense */
      paths5 = antisense_paths5;
      paths3 = antisense_paths3;
    } else {
      fprintf(stderr,"Unexpected combination of sensedirs\n");
      abort();
    }

    singlepaths5 = (List_T) NULL;
    for (p = paths5; p != NULL; p = List_next(p)) {
      path = (Path_T) List_head(p);
      if (path->plusp == true) {
	queryptr = queryuc_ptr_5;
	query_compress = query5_compress_fwd;
      } else {
	queryptr = queryrc5;
	query_compress = query5_compress_rev;
      }
      /* Need to call Path_extend primarily for the trimming, which can weed out false alignments past the end of the chromosome,
	 but might as well extend also if possible */
      if (path->transcriptome_method_p == true) {
	copy = Path_copy(path,intlistpool,univcoordlistpool,listpool,
			 pathpool,vectorpool,transcriptpool,hitlistpool);
	singlepaths5 = Hitlist_push(singlepaths5,hitlistpool,(void *) copy
				    hitlistpool_trace(__FILE__,__LINE__));
      } else if (path->extendedp == true) {
	assert(path->extended_paths != NULL);
	for (q = path->extended_paths; q != NULL; q = List_next(q)) {
	  path = (Path_T) List_head(q);
	  Path_eval_nmatches(&(*found_score_5),path,query5_compress_fwd,query5_compress_rev);
	  singlepaths5 = Hitlist_push(singlepaths5,hitlistpool,(void *) path
				      hitlistpool_trace(__FILE__,__LINE__));
	}

      } else {
	newpaths = Path_extend(&completep,&(*found_score_5),
			       /*original_path*/path,queryseq5,queryptr,querylength5,
			       mismatch_positions_alloc_5,novel_diagonals_alloc,localdb_alloc,
			       this5,knownsplicing,knownindels,
			       query_compress,query5_compress_fwd,query5_compress_rev,
			       /*genestrand*/0,max_insertionlen_5,max_deletionlen_5,overall_end_distance_5,nmismatches_allowed_5,
			       /*paired_end_p*/false,/*lowp*/true,
			       intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			       vectorpool,hitlistpool,spliceendsgen5,
			       /*extend_qstart_p*/true,/*extend_qend_p*/true);
	for (q = newpaths; q != NULL; q = List_next(q)) {
	  path = (Path_T) List_head(q);
	  Path_eval_nmatches(&(*found_score_5),path,query5_compress_fwd,query5_compress_rev);
	  singlepaths5 = Hitlist_push(singlepaths5,hitlistpool,(void *) path
				      hitlistpool_trace(__FILE__,__LINE__));
	}
	Hitlistpool_free_list(&newpaths,hitlistpool
			      hitlistpool_trace(__FILE__,__LINE__)); /* Allocated by Hitlistpool_T */
      }
    }
    Hitlistpool_free_list(&paths5,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));


    singlepaths3 = (List_T) NULL;
    for (p = paths3; p != NULL; p = List_next(p)) {
      path = (Path_T) List_head(p);
      if (path->plusp == true) {
	queryptr = queryuc_ptr_3;
	query_compress = query3_compress_fwd;
      } else {
	queryptr = queryrc3;
	query_compress = query3_compress_rev;
      }
      /* Need to call Path_extend primarily for the trimming, which can weed out false alignments past the end of the chromosome,
	 but might as well extend also if possible */
      if (path->transcriptome_method_p == true) {
	copy = Path_copy(path,intlistpool,univcoordlistpool,listpool,
			 pathpool,vectorpool,transcriptpool,hitlistpool);
	singlepaths3 = Hitlist_push(singlepaths3,hitlistpool,(void *) copy
				    hitlistpool_trace(__FILE__,__LINE__));
      } else if (path->extendedp == true) {
	assert(path->extended_paths != NULL);
	for (q = path->extended_paths; q != NULL; q = List_next(q)) {
	  path = (Path_T) List_head(q);
	  Path_eval_nmatches(&(*found_score_3),path,query3_compress_fwd,query3_compress_rev);
	  singlepaths3 = Hitlist_push(singlepaths3,hitlistpool,(void *) path
				      hitlistpool_trace(__FILE__,__LINE__));
	}

      } else {
	newpaths = Path_extend(&completep,&(*found_score_3),
			       /*original_path*/path,queryseq3,queryptr,querylength3,
			       mismatch_positions_alloc_3,novel_diagonals_alloc,localdb_alloc,
			       this3,knownsplicing,knownindels,
			       query_compress,query3_compress_fwd,query3_compress_rev,
			       /*genestrand*/0,max_insertionlen_3,max_deletionlen_3,overall_end_distance_3,nmismatches_allowed_3,
			       /*paired_end_p*/false,/*lowp*/true,
			       intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			       vectorpool,hitlistpool,spliceendsgen3,
			       /*extend_qstart_p*/true,/*extend_qend_p*/true);
	for (q = newpaths; q != NULL; q = List_next(q)) {
	  path = (Path_T) List_head(q);
	  Path_eval_nmatches(&(*found_score_3),path,query3_compress_fwd,query3_compress_rev);
	  singlepaths3 = Hitlist_push(singlepaths3,hitlistpool,(void *) path
				      hitlistpool_trace(__FILE__,__LINE__));
	}
	Hitlistpool_free_list(&newpaths,hitlistpool
			      hitlistpool_trace(__FILE__,__LINE__)); /* Allocated by Hitlistpool_T */
      }
    }
    Hitlistpool_free_list(&paths3,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));

    if (singlepaths5 == (List_T) NULL) {
      *npaths5_primary = *npaths5_altloc = 0;
      *patharray5 = (Path_T *) NULL;
    } else {
      *patharray5 = (Path_T *) List_to_array_out(singlepaths5,NULL); /* Return value */
      *patharray5 = Path_eval_and_sort(&(*npaths5_primary),&(*npaths5_altloc),&(*first_absmq5),&(*second_absmq5),
				       *patharray5,List_length(singlepaths5),
				       query5_compress_fwd,query5_compress_rev,queryuc_ptr_5,queryrc5,
				       Shortread_quality_string(queryseq5),
				       nmismatches_filter_5,mincoverage_filter_5,
				       intlistpool,univcoordlistpool,listpool,
				       pathpool,transcriptpool,hitlistpool);

      if (transcriptome != NULL && pass == PASS2) {
	for (i = 0; i < (*npaths5_primary) + (*npaths5_altloc); i++) {
	  path = (*patharray5)[i];
	  Transcript_velocity_single(path);
	}
      }

      Hitlistpool_free_list(&singlepaths5,hitlistpool
			    hitlistpool_trace(__FILE__,__LINE__));
    }

    if (singlepaths3 == (List_T) NULL) {
      *npaths3_primary = *npaths3_altloc = 0;
      *patharray3 = (Path_T *) NULL;
    } else {
      *patharray3 = (Path_T *) List_to_array_out(singlepaths3,NULL); /* Return value */
      *patharray3 = Path_eval_and_sort(&(*npaths3_primary),&(*npaths3_altloc),&(*first_absmq3),&(*second_absmq3),
				       *patharray3,List_length(singlepaths3),
				       query3_compress_fwd,query3_compress_rev,queryuc_ptr_3,queryrc3,
				       Shortread_quality_string(queryseq3),
				       nmismatches_filter_3,mincoverage_filter_3,
				       intlistpool,univcoordlistpool,listpool,
				       pathpool,transcriptpool,hitlistpool);

      if (transcriptome != NULL && pass == PASS2) {
	for (i = 0; i < (*npaths3_primary) + (*npaths3_altloc); i++) {
	  path = (*patharray3)[i];
	  Transcript_velocity_single(path);
	}
      }

      Hitlistpool_free_list(&singlepaths3,hitlistpool
			    hitlistpool_trace(__FILE__,__LINE__));
    }

    debug(printf("For single paths5, got %d+%d paths\n",*npaths5_primary,*npaths5_altloc));
    debug(printf("For single paths3, got %d+%d paths\n",*npaths3_primary,*npaths3_altloc));

    /* Check for concordance */
    assert(pathpairs == NULL);
    for (i = 0; i < *npaths5_primary + *npaths5_altloc; i++) {
      path5 = (*patharray5)[i];
      for (j = 0; j < *npaths3_primary + *npaths3_altloc; j++) {
	path3 = (*patharray3)[j];
	if (determine_pairtype(path5,path3) != CONCORDANT) {
	  /* Skip */
	} else if (path5->plusp == true) {
	  if ((pathpair = Pathpair_new_concordant(/*pathL*/path5,/*pathH*/path3,
						  /*queryseqL*/queryseq5,/*queryseqH*/queryseq3,/*plusp*/true,
						  intlistpool,univcoordlistpool,listpool,
						  pathpool,vectorpool,transcriptpool,hitlistpool,
						  /*copyLp*/true,/*copyHp*/true)) != NULL) {
	    debug16(printf("Found a concordant pair, gplus\n"));
	    pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				     hitlistpool_trace(__FILE__,__LINE__));
	    debug16(Path_print(pathpair->path5));
	    debug16(Path_print(pathpair->path3));
	  }
	} else {
	  if ((pathpair = Pathpair_new_concordant(/*pathL*/path3,/*pathH*/path5,
						  /*queryseqL*/queryseq3,/*queryseqH*/queryseq5,/*plusp*/false,
						  intlistpool,univcoordlistpool,listpool,
						  pathpool,vectorpool,transcriptpool,hitlistpool,
						  /*copyLp*/true,/*copyHp*/true)) != NULL) {
	    debug16(printf("Found a concordant pair, gminus\n"));
	    pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				     hitlistpool_trace(__FILE__,__LINE__));
	    debug16(Path_print(pathpair->path5));
	    debug16(Path_print(pathpair->path3));
	  }
	}
      }
    }
  }

  debug16(printf("Have %d pathpairs\n",List_length(pathpairs)));

  if (pathpairs == NULL) {
    *npaths_primary = *npaths_altloc = 0;

  } else {
    /* Don't want to filter here, since Pathpair_eval_and_sort needs to keep both sensedirs and perform resolve */
    /* pathpairs = Pathpair_filter(pathpairs,
       intlistpool,univcoordlistpool,listpool,pathpool,hitlistpool); */

    *npaths_primary = List_length(pathpairs);
    *npaths_altloc = 0;	/* TODO: Determine whether any paths are on the altloc chromosome */

    pathpairarray = (Pathpair_T *) List_to_array_out(pathpairs,NULL);
    pathpairarray = Pathpair_eval_and_sort(&(*found_score_5),&(*found_score_3),
					   &(*npaths_primary),&(*npaths_altloc),&(*first_absmq),&(*second_absmq),
					   pathpairarray,/*npaths*/List_length(pathpairs),this5,this3,
					   query5_compress_fwd,query5_compress_rev,
					   query3_compress_fwd,query3_compress_rev,
					   queryseq5,queryseq3,
					   queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,
					   /*quality_string_5*/Shortread_quality_string(queryseq5),
					   /*quality_string_3*/Shortread_quality_string(queryseq3),
					   mismatch_positions_alloc_5,mismatch_positions_alloc_3,
					   novel_diagonals_alloc,localdb_alloc,knownsplicing,knownindels,

					   nmismatches_allowed_5,nmismatches_allowed_3,
					   nmismatches_filter_5,nmismatches_filter_3,
					   mincoverage_filter_5,mincoverage_filter_3,
					   max_insertionlen_5,max_insertionlen_3,
					   max_deletionlen_5,max_deletionlen_3,
					   overall_end_distance_5,overall_end_distance_3,
					   querylength5,querylength3,
					   univdiagpool,intlistpool,uintlistpool,univcoordlistpool,
					   listpool,pathpool,transcriptpool,vectorpool,hitlistpool,
					   spliceendsgen5,spliceendsgen3);

    /* Compute transcripts for pass2 */
    if (transcriptome != NULL && pass == PASS2) {
      for (i = 0; i < (*npaths_primary) + (*npaths_altloc); i++) {
	pathpair = pathpairarray[i];
	path5 = pathpair->path5;
	path3 = pathpair->path3;

	Transcript_velocity_paired(path5,path3);
	if ((tr_insertlength = Transcript_fragment_length(path5,path3,queryseq5,queryseq3)) > 0) {
	  pathpair->insertlength = tr_insertlength;
	}
      }
    }

    Hitlistpool_free_list(&pathpairs,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));  /* Allocated by hitlistpool */

    debug(printf("After Pathpair_eval_and_sort, have %d + %d pathpairs\n",
		 *npaths_primary,*npaths_altloc));
  }

  if ((*npaths_primary) + (*npaths_altloc) > 0) {
    *final_pairtype = CONCORDANT;
    debug(printf("Success in finding pathpairs, so clearing single paths\n"));
    for (i = 0; i < *npaths5_primary + *npaths5_altloc; i++) {
      path5 = (*patharray5)[i];
      Path_free(&path5,intlistpool,univcoordlistpool,
		listpool,pathpool,transcriptpool,hitlistpool);
    }
    *npaths5_primary = *npaths5_altloc = 0;
    FREE_OUT(*patharray5);
    
    for (i = 0; i < *npaths3_primary + *npaths3_altloc; i++) {
      path3 = (*patharray3)[i];
      Path_free(&path3,intlistpool,univcoordlistpool,
		listpool,pathpool,transcriptpool,hitlistpool);
    }
    *npaths3_primary = *npaths3_altloc = 0;
    FREE_OUT(*patharray3);

    *patharray5 = *patharray3 = (Path_T *) NULL;
    debug(printf("(1) Returning %d %d %d\n",*npaths_primary,*npaths5_primary,*npaths3_primary));

  } else if (*npaths5_primary != 1 || *npaths3_primary != 1) {
    *final_pairtype = UNPAIRED;
    *npaths_primary = *npaths_altloc = 0;
    pathpairarray = (Pathpair_T *) NULL;
    debug(printf("(2) Returning %d %d %d\n",*npaths_primary,*npaths5_primary,*npaths3_primary));

  } else {
    *final_pairtype = determine_pairtype((*patharray5)[0],(*patharray3)[0]);
    *npaths_primary = *npaths_altloc = 0;
    pathpairarray = (Pathpair_T *) NULL;
    debug(printf("(3) Returning %d %d %d\n",*npaths_primary,*npaths5_primary,*npaths3_primary));
  }

  return pathpairarray;
}

#ifdef DEBUG0
static void
print_pathpairarray_contents (Pathpair_T *pathpairarray, int n) {
  int i;

  for (i = 0; i < n; i++) {
    printf("%p %p pathpairarray\n",pathpairarray[i]->path5,pathpairarray[i]->path3);
  }

  return;
}
#endif




/* final_pairtype can be CONCORDANT_TRANSLOCATIONS, CONCORDANT, PAIRED_INVERSION, PAIRED_SCRAMBLE, PAIRED_TOOLONG, UNPAIRED */
Pathpair_T *
Stage1_paired_read (int *npaths_primary, int *npaths_altloc, int *first_absmq, int *second_absmq, Pairtype_T *final_pairtype,
		    Path_T **patharray5, int *npaths5_primary, int *npaths5_altloc, int *first_absmq5, int *second_absmq5,
		    Path_T **patharray3, int *npaths3_primary, int *npaths3_altloc, int *first_absmq3, int *second_absmq3,
		    Shortread_T queryseq5, Shortread_T queryseq3, EF64_T repetitive_ef64,
		    Knownsplicing_T knownsplicing, Knownindels_T knownindels, Chrpos_T pairmax_linear,
		    Trdiagpool_T trdiagpool, Univdiagpool_T univdiagpool,
		    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		    Univcoordlistpool_T univcoordlistpool, Listpool_T listpool, 
		    Trpathpool_T trpathpool, Pathpool_T pathpool, Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
		    Transcriptpool_T transcriptpool,
		    Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3, Pass_T pass) {
  Pathpair_T *pathpairarray;
  List_T pathpairs = NULL;

  List_T sense_paths5_gplus, sense_paths5_gminus, antisense_paths5_gplus, antisense_paths5_gminus,
    sense_paths3_gplus, sense_paths3_gminus, antisense_paths3_gplus, antisense_paths3_gminus;

  List_T sense_paths5 = NULL, antisense_paths5 = NULL, sense_paths3 = NULL, antisense_paths3 = NULL;
  List_T local_sense_paths5, local_antisense_paths5, local_sense_paths3, local_antisense_paths3, paths5, paths3;

  /* List_T geneplus_pathpairs, geneminus_pathpairs; */
  /* List_T geneplus_paths5, geneplus_paths3, geneminus_paths5, geneminus_paths3; */

  int querylength5, querylength3;

  int found_score_paired, found_score_5, found_score_3;
  Method_T last_method_5, last_method_3, final_univdiagonal_method;

  int nmismatches_filter_5, nmismatches_filter_3;
  int mincoverage_filter_5, mincoverage_filter_3;
  int nmismatches_allowed_5, nmismatches_allowed_3;
  int max_middle_insertions_5, max_middle_insertions_3, max_middle_deletions_5, max_middle_deletions_3;
  int max_insertionlen_5, max_insertionlen_3, max_deletionlen_5, max_deletionlen_3;
  Chrpos_T overall_max_distance_5, overall_max_distance_3, overall_end_distance_5, overall_end_distance_3;
  char *queryuc_ptr_5, *queryuc_ptr_3, *queryrc5, *queryrc3;
  int *mismatch_positions_alloc_5, *mismatch_positions_alloc_3;
  Univcoord_T *novel_diagonals_alloc;
  unsigned short *localdb_alloc;
  Compress_T query5_compress_fwd, query5_compress_rev, query3_compress_fwd, query3_compress_rev;
  T this5, this3;


  if ((querylength5 = Shortread_fulllength(queryseq5)) < index1part + index1interval - 1 ||
      (querylength3 = Shortread_fulllength(queryseq3)) < index1part + index1interval - 1) {
    return (Pathpair_T *) NULL;
  }

  queryuc_ptr_5 = Shortread_queryuc_ptr(queryseq5);
  queryuc_ptr_3 = Shortread_queryuc_ptr(queryseq3);
  queryrc5 = Shortread_queryrc(queryseq5);
  queryrc3 = Shortread_queryrc(queryseq3);

  this5 = Stage1_new(queryuc_ptr_5,querylength5);
  this3 = Stage1_new(queryuc_ptr_3,querylength3);

  found_score_5 = querylength5;
  found_score_3 = querylength3;

  /* sufficient_score_5 = (int) rint(defect_rate * (double) querylength5); */
  /* sufficient_score_3 = (int) rint(defect_rate * (double) querylength3); */

  /* nmismatches_allowed means nmismatches_search and is not specified
     by the user.  The user-specified value for -m represents
     nmismatches_filter */
  /* TODO: make this dependent upon the defect rate */
  nmismatches_allowed_5 = querylength5/20; /* was querylength/index1part */
  nmismatches_allowed_3 = querylength3/20; /* was querylength/index1part */

  if (user_nmismatches_filter_float < 0.0) {
    /* Not specified, so don't filter */
    nmismatches_filter_5 = querylength5;
    nmismatches_filter_3 = querylength3;
  } else if (user_nmismatches_filter_float < 1.0) {
    nmismatches_filter_5 = (int) rint(user_nmismatches_filter_float * (double) querylength5);
    nmismatches_filter_3 = (int) rint(user_nmismatches_filter_float * (double) querylength3);
  } else {
    nmismatches_filter_5 = nmismatches_filter_3 = (int) user_nmismatches_filter_float;
  }

  if (user_mincoverage_filter_float <= 0.0) {
    /* Not specified, so don't filter */
    mincoverage_filter_5 = 0;
    mincoverage_filter_3 = 0;
  } else if (user_mincoverage_filter_float <= 1.0) {
    /* Assuming that --min-coverage=1 must mean 1.0 and not a coverage of 1 bp */
    mincoverage_filter_5 = (int) rint(user_mincoverage_filter_float * (double) querylength5);
    mincoverage_filter_3 = (int) rint(user_mincoverage_filter_float * (double) querylength3);
  } else {
    mincoverage_filter_5 = mincoverage_filter_3 = (int) user_mincoverage_filter_float;
  }

  if (max_middle_insertions_float > 0.0 && max_middle_insertions_float < 1.0) {
    max_middle_insertions_5 = (int) rint(max_middle_insertions_float * (double) querylength5);
    max_middle_insertions_3 = (int) rint(max_middle_insertions_float * (double) querylength3);
  } else {
    max_middle_insertions_5 = max_middle_insertions_3 = (int) max_middle_insertions_float;
  }
  max_insertionlen_5 = max_middle_insertions_5;
  if (max_insertionlen_5 > querylength5) {
    max_insertionlen_5 = querylength5;
  }
  max_insertionlen_3 = max_middle_insertions_3;
  if (max_insertionlen_3 > querylength3) {
    max_insertionlen_3 = querylength3;
  }


  if (max_middle_deletions_float > 0.0 && max_middle_deletions_float < 1.0) {
    max_middle_deletions_5 = (int) rint(max_middle_deletions_float * (double) querylength5);
    max_middle_deletions_3 = (int) rint(max_middle_deletions_float * (double) querylength3);
  } else {
    max_middle_deletions_5 = max_middle_insertions_3 = (int) max_middle_deletions_float;
  }
  max_deletionlen_5 = max_middle_deletions_5;
  max_deletionlen_3 = max_middle_deletions_3;

  overall_max_distance_5 = shortsplicedist;
  if ((Chrpos_T) max_middle_deletions_5 > overall_max_distance_5) {
    overall_max_distance_5 = (Chrpos_T) max_middle_deletions_5;
  }
  if ((Chrpos_T) max_middle_insertions_5 > overall_max_distance_5) {
    overall_max_distance_5 = (Chrpos_T) max_middle_insertions_5;
  }
  overall_end_distance_5 = shortsplicedist_novelend > (Chrpos_T) max_deletionlen_5 ? shortsplicedist_novelend : (Chrpos_T) max_deletionlen_5;

  overall_max_distance_3 = shortsplicedist;
  if ((Chrpos_T) max_middle_deletions_3 > overall_max_distance_3) {
    overall_max_distance_3 = (Chrpos_T) max_middle_deletions_3;
  }
  if ((Chrpos_T) max_middle_insertions_3 > overall_max_distance_3) {
    overall_max_distance_3 = (Chrpos_T) max_middle_insertions_3;
  }
  overall_end_distance_3 = shortsplicedist_novelend > (Chrpos_T) max_deletionlen_3 ? shortsplicedist_novelend : (Chrpos_T) max_deletionlen_3;


  mismatch_positions_alloc_5 = (int *) MALLOC((querylength5+MISMATCH_EXTRA)*sizeof(int));
  mismatch_positions_alloc_3 = (int *) MALLOC((querylength3+MISMATCH_EXTRA)*sizeof(int));

  /* 2 localdb regions possible if shortsplicedist_novelend < 65536 */
  /* 65536 represents the worst possible case where every position in the localdb region matches the query */
  novel_diagonals_alloc = (Univcoord_T *) MALLOC(2 * 65536 * sizeof(Univcoord_T));
  MALLOC_ALIGN(localdb_alloc,65536 * sizeof(unsigned short)); /* Maximum number of intersections in a localdb region */

  query5_compress_fwd = Compress_new_fwd(queryuc_ptr_5,querylength5);
  query5_compress_rev = Compress_new_rev(queryuc_ptr_5,querylength5);
  query3_compress_fwd = Compress_new_fwd(queryuc_ptr_3,querylength3);
  query3_compress_rev = Compress_new_rev(queryuc_ptr_3,querylength3);


  if (splicingp == false) {
    final_univdiagonal_method = KMER_EXACT1;
  } else {
    /* Allows for splicing at ends */
    final_univdiagonal_method = KMER_EXACT2;
  }


  if (mode == CMET_NONSTRANDED || mode == ATOI_NONSTRANDED || mode == TTOC_NONSTRANDED) {
    /* Not implemented yet */
    fprintf(stderr,"Nonstranded modes not yet implemented\n");
    exit(9);

    pathpairarray = (Pathpair_T *) NULL;
#ifdef TO_FIX
    geneplus_pathpairs = paired_read(&geneplus_abort_pairing_p,&geneplus_hits5,&geneplus_hits3,
				     &geneplus_samechr,&geneplus_conc_transloc,
				     queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				     knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				     novel_diagonals_alloc,localdb_alloc,this5,this3,
				     query5_compress_fwd,query5_compress_rev,
				     query3_compress_fwd,query3_compress_rev,
				     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				     /*genestrand*/+1,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				     overall_end_distance_5,overall_end_distance_3,
				     max_mismatches_refalt_5,max_mismatches_refalt_3,
				     max_mismatches_ref_5,max_mismatches_ref_3,
				     min_coverage_5,min_coverage_3,
				     intlistpool,univcoordlistpool,listpool,univdiagpool,
				     hitlistpool,pathpool,vectorpool,
				     transcriptpool,spliceendsgen5,spliceendsgen3,pass);

    geneminus_pathpairs = paired_read(&geneminus_abort_pairing_p,&geneminus_hits5,&geneminus_hits3,
				      &geneminus_samechr,&geneminus_conc_transloc,
				      queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				      knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				      novel_diagonals_alloc,localdb_alloc,this5,this3,
				      query5_compress_fwd,query5_compress_rev,
				      query3_compress_fwd,query3_compress_rev,
				      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				      /*genestrand*/+2,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				      overall_end_distance_5,overall_end_distance_3,
				      max_mismatches_refalt_5,max_mismatches_refalt_3,
				      max_mismatches_ref_5,max_mismatches_ref_3,
				      min_coverage_5,min_coverage_3,
				      intlistpool,univcoordlistpool,listpool,univdiagpool,
				      hitlistpool,pathpool,vectorpool,
				      transcriptpool,spliceendsgen5,spliceendsgen3,pass);
#endif

  } else { /*mode == STANDARD || mode == CMET_STRANDED || mode == ATOI_STRANDED || mode == TTOC_STRANDED */
    found_score_5 = querylength5;
    found_score_3 = querylength3;
    last_method_5 = last_method_3 = METHOD_INIT;

    /* Look at each end separately to satisfy sufficient score */
    single_read(&found_score_5,&last_method_5,

		&sense_paths5_gplus,&sense_paths5_gminus,
		&antisense_paths5_gplus,&antisense_paths5_gminus,
		
		this5,repetitive_ef64,/*genestrand*/0,

		queryseq5,queryuc_ptr_5,queryrc5,querylength5,knownsplicing,knownindels,
		mismatch_positions_alloc_5,novel_diagonals_alloc,localdb_alloc,
		query5_compress_fwd,query5_compress_rev,
			 
		nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
		overall_max_distance_5,overall_end_distance_5,
			 
		trdiagpool,univdiagpool,intlistpool,uintlistpool,
		univcoordlistpool,listpool,trpathpool,pathpool,transcriptpool,
		vectorpool,hitlistpool,spliceendsgen5,
		/*paired_end_p*/true,/*first_read_p*/true,final_univdiagonal_method);

    single_read(&found_score_3,&last_method_3,

		&sense_paths3_gplus,&sense_paths3_gminus,
		&antisense_paths3_gplus,&antisense_paths3_gminus,

		this3,repetitive_ef64,/*genestrand*/0,

		queryseq3,queryuc_ptr_3,queryrc3,querylength3,knownsplicing,knownindels,
		mismatch_positions_alloc_3,novel_diagonals_alloc,localdb_alloc,
		query3_compress_fwd,query3_compress_rev,

		nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
		overall_max_distance_3,overall_end_distance_3,
			 
		trdiagpool,univdiagpool,intlistpool,uintlistpool,
		univcoordlistpool,listpool,trpathpool,pathpool,transcriptpool,
		vectorpool,hitlistpool,spliceendsgen3,
		/*paired_end_p*/true,/*first_read_p*/false,final_univdiagonal_method);

    debug(printf("%d and %d: %s and %s: Calling Concordance_gen with univdiagonals, sense, with %d and %d gplus, %d and %d gminus\n",
		 found_score_5,found_score_3,Method_string(last_method_5),Method_string(last_method_3),
		 List_length(sense_paths5_gplus),List_length(sense_paths3_gplus),
		 List_length(sense_paths5_gminus),List_length(sense_paths3_gminus)));
    
    found_score_paired = querylength5 + querylength3;
    pathpairs = Concordance_gen(&found_score_paired,&found_score_5,&found_score_3,pathpairs,

				&sense_paths5_gplus,&sense_paths5_gminus,
				&sense_paths3_gplus,&sense_paths3_gminus,
			      
				&this5->sense_paths_gplus,&this5->sense_paths_gminus,
				&this3->sense_paths_gplus,&this3->sense_paths_gminus,
				&this5->sense_coords_gplus,&this5->sense_coords_gminus,
				&this3->sense_coords_gplus,&this3->sense_coords_gminus,
				&this5->sense_indices_gplus,&this5->sense_indices_gminus,
				&this3->sense_indices_gplus,&this3->sense_indices_gminus,
				&this5->n_sense_paths_gplus,&this5->n_sense_paths_gminus,
				&this3->n_sense_paths_gplus,&this3->n_sense_paths_gminus,
				&this5->nunique_sense_coords_gplus,&this5->nunique_sense_coords_gminus,
				&this3->nunique_sense_coords_gplus,&this3->nunique_sense_coords_gminus,
				 
				query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				queryseq5,queryseq3,
				queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				 
				novel_diagonals_alloc,localdb_alloc,
				knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				nmismatches_allowed_5,nmismatches_allowed_3,
				max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				overall_end_distance_5,overall_end_distance_3,
				 
				intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				vectorpool,hitlistpool,/*genestrand*/0,/*mergep*/true);
  
    if (splicingp == true) {
      debug(printf("%d and %d: %s and %s: Calling Concordance_gen with univdiagonals, antisense, with %d and %d gplus, %d and %d gminus\n",
		   found_score_5,found_score_3,Method_string(last_method_5),Method_string(last_method_3),
		   List_length(antisense_paths5_gplus),List_length(antisense_paths3_gplus),
		   List_length(antisense_paths5_gminus),List_length(antisense_paths3_gminus)));
      pathpairs = Concordance_gen(&found_score_paired,&found_score_5,&found_score_3,pathpairs,

				  &antisense_paths5_gplus,&antisense_paths5_gminus,
				  &antisense_paths3_gplus,&antisense_paths3_gminus,

				  &this5->antisense_paths_gplus,&this5->antisense_paths_gminus,
				  &this3->antisense_paths_gplus,&this3->antisense_paths_gminus,
				  &this5->antisense_coords_gplus,&this5->antisense_coords_gminus,
				  &this3->antisense_coords_gplus,&this3->antisense_coords_gminus,
				  &this5->antisense_indices_gplus,&this5->antisense_indices_gminus,
				  &this3->antisense_indices_gplus,&this3->antisense_indices_gminus,
				  &this5->n_antisense_paths_gplus,&this5->n_antisense_paths_gminus,
				  &this3->n_antisense_paths_gplus,&this3->n_antisense_paths_gminus,
				  &this5->nunique_antisense_coords_gplus,&this5->nunique_antisense_coords_gminus,
				  &this3->nunique_antisense_coords_gplus,&this3->nunique_antisense_coords_gminus,
				   
				  query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,
				  queryseq5,queryseq3,
				  queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,querylength5,querylength3,
				  this5,this3,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				   
				  novel_diagonals_alloc,localdb_alloc,
				  knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				  nmismatches_allowed_5,nmismatches_allowed_3,
				  max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				  overall_end_distance_5,overall_end_distance_3,
				   
				  intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				  vectorpool,hitlistpool,/*genestrand*/0,/*mergep*/true);
    }
	
    if (pathpairs != NULL) {
      /* Skip */

    } else {
      FREE_ALIGN(this5->univdiagonals_gplus);
      FREE_ALIGN(this5->univdiagonals_gminus);
      FREE_ALIGN(this3->univdiagonals_gplus);
      FREE_ALIGN(this3->univdiagonals_gminus);

      merge_sense_antisense_coords(this5);
      merge_sense_antisense_coords(this3);
    }
  }


  /* Try aligning paired ends together */
  if (pathpairs != NULL) {
    /* Found concordant results from single-end searches */
    local_sense_paths5 = local_antisense_paths5 = (List_T) NULL;
    local_sense_paths3 = local_antisense_paths3 = (List_T) NULL;

  } else if ((pathpairs = paired_read(found_score_paired,&found_score_5,&found_score_3,last_method_5,last_method_3,
				      queryseq5,queryseq3,
				      queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,
				      knownsplicing,knownindels,mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				      novel_diagonals_alloc,localdb_alloc,this5,this3,repetitive_ef64,
				      query5_compress_fwd,query5_compress_rev,
				      query3_compress_fwd,query3_compress_rev,
				      nmismatches_allowed_5,nmismatches_allowed_3,
				      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				      /*genestrand*/0,pairmax_linear,overall_max_distance_5,overall_max_distance_3,
				      overall_end_distance_5,overall_end_distance_3,

				      trdiagpool,univdiagpool,intlistpool,uintlistpool,univcoordlistpool,listpool,
				      trpathpool,pathpool,transcriptpool,vectorpool,hitlistpool,
				      spliceendsgen5,spliceendsgen3,pass)) != NULL) {

    /* Found concordant results from paired-end search */
    local_sense_paths5 = local_antisense_paths5 = (List_T) NULL;
    local_sense_paths3 = local_antisense_paths3 = (List_T) NULL;

  } else {
    /* Gather all single paths.  Combine so that sensedirs can compete. */
    if (this5 == NULL) {
      local_sense_paths5 = local_antisense_paths5 = (List_T) NULL;
    } else {
      paths5 = Stage1_flatten_paths(this5,queryseq5,queryuc_ptr_5,queryrc5,
				    querylength5,/*genestrand*/0,
				    query5_compress_fwd,query5_compress_rev,
				    knownsplicing,knownindels,
				    mismatch_positions_alloc_5,novel_diagonals_alloc,localdb_alloc,
				    nmismatches_allowed_5,max_insertionlen_5,max_deletionlen_5,
				    overall_end_distance_5,/*paired_end_p*/true,/*first_read_p*/true,
				    intlistpool,uintlistpool,univcoordlistpool,
				    listpool,pathpool,transcriptpool,
				    vectorpool,hitlistpool,spliceendsgen5);

      Path_local_pick_sensedir(&local_sense_paths5,&local_antisense_paths5,paths5,hitlistpool);
      /* Above function frees paths5 */
    }

    if (this3 == NULL) {
      local_sense_paths3 = local_antisense_paths3 = (List_T) NULL;
    } else {
      paths3 = Stage1_flatten_paths(this3,queryseq3,queryuc_ptr_3,queryrc3,
				    querylength3,/*genestrand*/0,
				    query3_compress_fwd,query3_compress_rev,
				    knownsplicing,knownindels,
				    mismatch_positions_alloc_3,novel_diagonals_alloc,localdb_alloc,
				    nmismatches_allowed_3,max_insertionlen_3,max_deletionlen_3,
				    overall_end_distance_3,/*paired_end_p*/true,/*first_read_p*/false,
				    intlistpool,uintlistpool,univcoordlistpool,
				    listpool,pathpool,transcriptpool,
				    vectorpool,hitlistpool,spliceendsgen3);
      Path_local_pick_sensedir(&local_sense_paths3,&local_antisense_paths3,paths3,hitlistpool);
      /* Above function frees paths3 */
    }

    /* Then separate locally to find winning sensedirs */
    /* printf("Have %d sense paths5 and %d antisense paths5\n",List_length(sense_paths5),List_length(antisense_paths5));*/
    /* printf("Have %d sense paths3 and %d antisense paths3\n",List_length(sense_paths3),List_length(antisense_paths3)); */

    if (splicingp == true && this5 != NULL && this3 != NULL) {
      /* Inner path fusions require further work */
      pathpairs = find_inner_fusions(&found_score_5,&found_score_3,

				     local_sense_paths5,local_antisense_paths5,
				     local_sense_paths3,local_antisense_paths3,
				     queryseq5,queryseq3,queryuc_ptr_5,queryrc5,queryuc_ptr_3,queryrc3,
				     knownsplicing,novel_diagonals_alloc,localdb_alloc,this5,this3,
				     query5_compress_fwd,query5_compress_rev,
				     query3_compress_fwd,query3_compress_rev,
				     nmismatches_allowed_5,nmismatches_allowed_3,
				     max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,

				     intlistpool,uintlistpool,univcoordlistpool,listpool,
				     pathpool,vectorpool,hitlistpool,transcriptpool);
    }
  }

  /* This call to Pathpair_filter can favor incorrect splices, so need to look at splice probs */
  debug0(printf("Have %d pathpairs before filtering\n",List_length(pathpairs)));
  debug0(print_pathpairs_contents(pathpairs));
  pathpairs = Pathpair_filter(pathpairs,
			      intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
  debug0(printf("Have %d pathpairs after filtering\n",List_length(pathpairs)));
  debug0(print_pathpairs_contents(pathpairs));

  /* local paths are a subset of the paths in this5 and this3 */
  if (pathpairs != NULL) {
    Hitlistpool_free_list(&local_sense_paths5,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&local_sense_paths3,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&local_antisense_paths5,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    Hitlistpool_free_list(&local_antisense_paths3,hitlistpool
			  hitlistpool_trace(__FILE__,__LINE__));
    sense_paths5 = sense_paths3 = antisense_paths5 = antisense_paths3 = (List_T) NULL;

  } else {
    /* Unpaired paths */
    paths5 = List_append(local_sense_paths5,local_antisense_paths5);
    paths3 = List_append(local_sense_paths3,local_antisense_paths3);

    Path_filter_pick_sensedir(&sense_paths5,&antisense_paths5,paths5,hitlistpool);
    Path_filter_pick_sensedir(&sense_paths3,&antisense_paths3,paths3,hitlistpool);
    /* Above functions free paths5 and paths3 */
  }

  /* sense_paths are a subset of the paths in this5 and this3 */

  pathpairarray =
    consolidate_results(&found_score_5,&found_score_3,&(*final_pairtype),
			&(*npaths_primary),&(*npaths_altloc),&(*first_absmq),&(*second_absmq),
			&(*patharray5),&(*npaths5_primary),&(*npaths5_altloc),&(*first_absmq5),&(*second_absmq5),
			&(*patharray3),&(*npaths3_primary),&(*npaths3_altloc),&(*first_absmq3),&(*second_absmq3),
			pathpairs,sense_paths5,antisense_paths5,sense_paths3,antisense_paths3,
				 
			queryseq5,queryseq3,
			queryuc_ptr_5,queryrc5,querylength5,queryuc_ptr_3,queryrc3,querylength3,

			knownsplicing,knownindels,novel_diagonals_alloc,localdb_alloc,this5,this3,
			mismatch_positions_alloc_5,mismatch_positions_alloc_3,
			query5_compress_fwd,query5_compress_rev,query3_compress_fwd,query3_compress_rev,

			nmismatches_allowed_5,nmismatches_allowed_3,
			nmismatches_filter_5,nmismatches_filter_3,mincoverage_filter_5,mincoverage_filter_3,
			max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
			overall_end_distance_5,overall_end_distance_3,

			intlistpool,uintlistpool,univcoordlistpool,listpool,univdiagpool,pathpool,vectorpool,
			hitlistpool,transcriptpool,spliceendsgen5,spliceendsgen3,pass);

  Hitlistpool_free_list(&sense_paths5,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));
  Hitlistpool_free_list(&sense_paths3,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));
  Hitlistpool_free_list(&antisense_paths5,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));
  Hitlistpool_free_list(&antisense_paths3,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));
    
  Hitlistpool_free_list(&pathpairs,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));

  Compress_free(&query3_compress_rev);
  Compress_free(&query3_compress_fwd);
  Compress_free(&query5_compress_rev);
  Compress_free(&query5_compress_fwd);

  FREE_ALIGN(localdb_alloc);
  FREE(novel_diagonals_alloc);

  FREE(mismatch_positions_alloc_3);
  FREE(mismatch_positions_alloc_5);

  Stage1_free(&this3,trdiagpool,univdiagpool,intlistpool,uintlistpool,
	      univcoordlistpool,listpool,pathpool,trpathpool,
	      transcriptpool,hitlistpool,/*free_paths_p*/true);
  Stage1_free(&this5,trdiagpool,univdiagpool,intlistpool,uintlistpool,
	      univcoordlistpool,listpool,pathpool,trpathpool,
	      transcriptpool,hitlistpool,/*free_paths_p*/true);

  /* FREE(queryrc3); -- Taken from Shortread */
  /* FREE(queryrc5); -- Taken from Shortread */

  debug(printf("Returning with final_pairtype %s\n",Pairtype_string(*final_pairtype)));
  debug0(print_pathpairarray_contents(pathpairarray,/*n*/(*npaths_primary) + (*npaths_altloc)));

  return pathpairarray;
}


void
Stage1hr_paired_setup (Mode_T mode_in, int index1part_in, int index1interval_in, int index1part_tr_in,
		       Transcriptome_T transcriptome_in, bool genome_align_p_in, bool transcriptome_align_p_in,
		       double user_nmismatches_filter_float_in, double user_mincoverage_filter_float_in,
		       double max_middle_insertions_float_in, double max_middle_deletions_float_in,
		       Chrpos_T shortsplicedist_in, Chrpos_T shortsplicedist_novelend_in,
		       bool splicingp_in, int maxpaths_search_in, int maxpaths_report_in,
		       bool *circularp_in, int pairmax_linear_in, int pairmax_circular_in) {

  mode = mode_in;
  index1part = index1part_in;
  index1interval = index1interval_in;
  index1part_tr = index1part_tr_in;

  transcriptome = transcriptome_in;
  genome_align_p = genome_align_p_in;
  transcriptome_align_p = transcriptome_align_p_in;

  user_nmismatches_filter_float = user_nmismatches_filter_float_in;
  user_mincoverage_filter_float = user_mincoverage_filter_float_in;

  max_middle_insertions_float = max_middle_insertions_float_in;
  max_middle_deletions_float = max_middle_deletions_float_in;

  shortsplicedist = shortsplicedist_in;
  shortsplicedist_novelend = shortsplicedist_novelend_in;

  splicingp = splicingp_in;
  maxpaths_search = maxpaths_search_in;
  maxpaths_report = maxpaths_report_in;

  circularp = circularp_in;
  pairmax_linear = pairmax_linear_in;
  pairmax_circular = pairmax_circular_in;

  return;
}
