# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EndUserTypeTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_user_types.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/EndUserTypes',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "end_user_types": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/EndUserTypes?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/EndUserTypes?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "end_user_types"
                }
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_user_types.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://trusthub.twilio.com/v1/EndUserTypes?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://trusthub.twilio.com/v1/EndUserTypes?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "end_user_types"
                },
                "end_user_types": [
                    {
                        "url": "https://trusthub.twilio.com/v1/EndUserTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "fields": [
                            {
                                "machine_name": "last_name",
                                "friendly_name": "Last Name",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "email",
                                "friendly_name": "Email",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "first_name",
                                "friendly_name": "First Name",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "business_title",
                                "friendly_name": "Business Title",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "phone_number",
                                "friendly_name": "Phone Number",
                                "constraint": "String"
                            },
                            {
                                "machine_name": "job_position",
                                "friendly_name": "Job Position",
                                "constraint": "String"
                            }
                        ],
                        "machine_name": "authorized_representative_1",
                        "friendly_name": "Authorized Representative one",
                        "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_user_types.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.trusthub.v1.end_user_types("OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://trusthub.twilio.com/v1/EndUserTypes/OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "url": "https://trusthub.twilio.com/v1/EndUserTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "fields": [
                    {
                        "machine_name": "last_name",
                        "friendly_name": "Last Name",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "email",
                        "friendly_name": "Email",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "first_name",
                        "friendly_name": "First Name",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "business_title",
                        "friendly_name": "Business Title",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "phone_number",
                        "friendly_name": "Phone Number",
                        "constraint": "String"
                    },
                    {
                        "machine_name": "job_position",
                        "friendly_name": "Job Position",
                        "constraint": "String"
                    }
                ],
                "machine_name": "authorized_representative_1",
                "friendly_name": "Authorized Representative one",
                "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.trusthub.v1.end_user_types("OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)
