# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.pricing.v2.country import CountryList
from twilio.rest.pricing.v2.number import NumberList
from twilio.rest.pricing.v2.voice import VoiceList


class V2(Version):

    def __init__(self, domain):
        """
        Initialize the V2 version of Pricing

        :returns: V2 version of Pricing
        :rtype: twilio.rest.pricing.v2.V2.V2
        """
        super(V2, self).__init__(domain)
        self.version = 'v2'
        self._countries = None
        self._numbers = None
        self._voice = None

    @property
    def countries(self):
        """
        :rtype: twilio.rest.pricing.v2.country.CountryList
        """
        if self._countries is None:
            self._countries = CountryList(self)
        return self._countries

    @property
    def numbers(self):
        """
        :rtype: twilio.rest.pricing.v2.number.NumberList
        """
        if self._numbers is None:
            self._numbers = NumberList(self)
        return self._numbers

    @property
    def voice(self):
        """
        :rtype: twilio.rest.pricing.v2.voice.VoiceList
        """
        if self._voice is None:
            self._voice = VoiceList(self)
        return self._voice

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Pricing.V2>'
