% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeGroupedDirection.R
\name{summarizeGroupedDirection}
\alias{summarizeGroupedDirection}
\title{Summarize overall direction of grouped tests}
\usage{
summarizeGroupedDirection(effects, grouping, influential, threshold = 0)
}
\arguments{
\item{effects}{A numeric vector containing the effect size for each test.}

\item{grouping}{A vector of factor of length equal to \code{effects}, specifying the assigned group for each tests.

Alternatively, an \link{rle} object where each run corresponds to a group and specifies the entries of \code{effects} belonging to that group.
This assumes that \code{effects} is ordered such that all entries in the same group are adjacent to each other.}

\item{influential}{A logical vector of length equal to \code{effects},
indicating whether each test is influential in its assigned group.}

\item{threshold}{Numeric scalar defining the threshold at which an effect is \dQuote{"up"} or \dQuote{"down"}.}
}
\value{
A character vector of length equal to the number of groups.
Each entry can be:
\itemize{
\item \code{"up"}, if all influential tests have effects above \code{threshold}.
\item \code{"down"}, if all influential tests have effects below \code{threshold}.
\item \code{"none"}, if all influential tests have effects equal to \code{threshold}.
\item \code{"mixed"}, if there are influential tests with effects above and below \code{threshold}.
}
}
\description{
Summarize the overall direction of grouped tests in a meta-analysis,
based on the influential tests defined by one of the \code{grouped*} functions.
}
\details{
We focus on the direction of effect for the influential tests that actually contribute to a group's final p-value.
For example, if we did our meta-analysis using \code{\link{parallelSimes}},we are not particularly concerned about the direction of tests with large p-values.
Thus, we just ignore them when summarizing the group's direction in this function.
Otherwise, we would unnecessarily obtain a \code{mixed} direction of effect if a test with a large p-value had a weakly opposing effect.

Of course, the interpretation of \dQuote{influential} really depends on the choice of meta-analysis strategy.
It is also possible that this function reports a single direction when the group really is mixed,
e.g., if the tests with the lowest p-values are changing in one direction but tests with weaker but still interesting effects are changing in the other direction.
The extent to which this is of interest is left to the discretion of the user.
}
\examples{
p <- rbeta(100, 0.5, 1)
eff <- rnorm(100)
g <- sample(20, 100, replace=TRUE)

out <- groupedSimes(p, g)
(dir <- summarizeGroupedDirection(eff, g, out$influential))
}
\seealso{
\code{\link{groupedSimes}} and related \code{grouped*} functions, to obtain \code{influential}.

\code{\link{summarizeParallelDirection}}, for the equivalent function based on parallel tests.

\code{\link{countGroupedDirection}}, to count the number of effects in each direction.
}
\author{
Aaron Lun
}
