# Welcome to Sidekiq 6.0!

Sidekiq 6.0 contains some breaking changes which streamline proper operation
of Sidekiq. It also drops support for EOL versions of Ruby and Rails.

## What's New

This release has major breaking changes.  Read and test carefully in production.

- ActiveJobs can now use `sidekiq_options` directly to configure Sidekiq
  features/internals like the retry subsystem. Prefer the native
  Sidekiq::Worker APIs as some Sidekiq features (e.g. unique jobs) do not work well with AJ.
  (requires Rails 6.0.2)
```ruby
class MyJob < ActiveJob::Base
  queue_as :myqueue
  sidekiq_options retry: 10, backtrace: 20
  def perform(...)
  end
end
```
- Logging has been redesigned to allow pluggable formatters and several
  formats ship with Sidekiq:
  * default - your typical output on macOS
  * heroku - enabled specifically when running in Heroku
  * json - a JSON format for search indexing, one hash per line

Sidekiq will enable the best formatter for the detected environment but
you can override it by configuring the log formatter explicitly. See
'sidekiq/logger' for implementation details.

```ruby
Sidekiq.configure_server do |config|
  config.log_formatter = AcmeCorp::PlainLogFormatter.new
  # config.log_formatter = Sidekiq::Logger::Formatters::JSON.new
end
```
Please see the [Logging](https://github.com/mperham/sidekiq/wiki/Logging) wiki page for the latest documentation and notes.
- **Remove the daemonization, logfile and pidfile command line arguments and `sidekiqctl` binary**.
I've [noted for years](https://www.mikeperham.com/2014/09/22/dont-daemonize-your-daemons/)
how modern services should be managed with a proper init system.
Managing services manually is more error-prone, let your operating system do it for you.
systemd, upstart, and foreman are three options. See the Deployment wiki page for the latest details.
- **Validate proper usage of the `REDIS_PROVIDER` variable.**
This variable is meant to hold the name of the environment
variable which contains your Redis URL, so that you can switch Redis
providers quickly and easily with a single variable change.  It is not
meant to hold the actual Redis URL itself.  If you want to manually set
the Redis URL then you may set `REDIS_URL` directly. [#3969]
- **Increase default shutdown timeout from 8 seconds to 25 seconds.**
Both Heroku and ECS now use 30 second shutdown timeout
by default and we want Sidekiq to take advantage of this time.  If you
have deployment scripts which depend on the old default timeout, use `-t 8` to
get the old behavior. [#3968]
* **Rails <5** is no longer supported. Rails 6+ only works in zeitwerk mode.
* **Ruby <2.5** is no longer supported.
* **Redis <4** is no longer supported.

## Upgrade

As always, please upgrade Sidekiq **one major version at a time**.
If you are already running Sidekiq 5.x, then:

* Upgrade to the latest Sidekiq 5.x.
```ruby
gem 'sidekiq', '< 6'
```
* Fix any deprecation warnings you see.
* Upgrade to 6.x.
```ruby
gem 'sidekiq', '< 7'
```
