//===--- StringEnum.swift -------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2021 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

import TestsUtils

public let benchmarks = [
  BenchmarkInfo(
    name: "StringEnumRawValueInitialization",
    runFunction: run_StringEnumRawValueInitialization,
    tags: [.validation, .api, .String],
    legacyFactor: 20),
]

enum TestEnum : String {
  case c1 = "Swift"
  case c2 = "is"
  case c3 = "a"
  case c4 = "general-purpose"
  case c5 = "programming language"
  case c7 = "built"
  case c8 = "using"
  case c10 = "modern"
  case c11 = "approach"
  case c12 = "to"
  case c13 = "safety,"
  case c14 = "performance,"
  case c15 = "and"
  case c16 = "software"
  case c17 = "design"
  case c18 = "patterns."
  case c19 = ""
  case c20 = "The"
  case c21 = "goal"
  case c22 = "of"
  case c23 = "the"
  case c25 = "project"
  case c28 = "create"
  case c30 = "best"
  case c31 = "available"
  case c33 = "for"
  case c34 = "uses"
  case c35 = "ranging"
  case c36 = "from"
  case c37 = "systems"
  case c40 = "mobile"
  case c42 = "desktop"
  case c43 = "apps,"
  case c44 = "scaling"
  case c45 = "up"
  case c47 = "cloud"
  case c48 = "services."
  case c49 = "Most"
  case c50 = "importantly,"
  case c53 = "designed"
  case c55 = "make"
  case c56 = "writing"
  case c58 = "maintaining"
  case c59 = "correct"
  case c60 = "programs"
  case c61 = "easier"
  case c64 = "developer."
  case c65 = "To"
  case c66 = "achieve"
  case c67 = "this"
  case c68 = "goal,"
  case c69 = "we"
  case c70 = "believe"
  case c71 = "that"
  case c73 = "most"
  case c74 = "obvious"
  case c75 = "way"
  case c77 = "write"
  case c79 = "code"
  case c80 = "must"
  case c81 = "also"
  case c82 = "be:"
  case c84 = "Safe."
  case c92 = "should"
  case c94 = "behave"
  case c95 = "in"
  case c97 = "safe"
  case c98 = "manner."
  case c99 = "Undefined"
  case c100 = "behavior"
  case c103 = "enemy"
  case c107 = "developer"
  case c108 = "mistakes"
  case c110 = "be"
  case c111 = "caught"
  case c112 = "before"
  case c116 = "production."
  case c117 = "Opting"
  case c119 = "safety"
  case c120 = "sometimes"
  case c121 = "means"
  case c123 = "will"
  case c124 = "feel"
  case c125 = "strict,"
  case c126 = "but"
  case c130 = "clarity"
  case c131 = "saves"
  case c132 = "time"
  case c135 = "long"
  case c136 = "run."
  case c138 = "Fast."
  case c141 = "intended"
  case c142 = "as"
  case c144 = "replacement"
  case c146 = "C-based"
  case c147 = "languages"
  case c148 = "(C, C++, Objective-C)."
  case c152 = "As"
  case c153 = "such,"
  case c157 = "comparable"
  case c159 = "those"
  case c162 = "performance"
  case c165 = "tasks."
  case c166 = "Performance"
  case c170 = "predictable"
  case c172 = "consistent,"
  case c173 = "not"
  case c174 = "just"
  case c175 = "fast"
  case c177 = "short"
  case c178 = "bursts"
  case c180 = "require"
  case c181 = "clean-up"
  case c182 = "later."
  case c183 = "There"
  case c184 = "are"
  case c185 = "lots"
  case c188 = "with"
  case c189 = "novel"
  case c190 = "features"
  case c191 = "—"
  case c192 = "being"
  case c195 = "rare."
  case c197 = "Expressive."
  case c199 = "benefits"
  case c201 = "decades"
  case c203 = "advancement"
  case c205 = "computer"
  case c206 = "science"
  case c208 = "offer"
  case c209 = "syntax"
  case c213 = "joy"
  case c215 = "use,"
  case c219 = "developers"
  case c220 = "expect."
  case c221 = "But"
  case c224 = "never"
  case c225 = "done."
  case c226 = "We"
  case c228 = "monitor"
  case c230 = "advancements"
  case c232 = "embrace"
  case c233 = "what"
  case c234 = "works,"
  case c235 = "continually"
  case c236 = "evolving"
  case c240 = "even"
  case c241 = "better."
  case c243 = "Tools"
  case c246 = "critical"
  case c247 = "part"
  case c251 = "ecosystem."
  case c253 = "strive"
  case c255 = "integrate"
  case c256 = "well"
  case c257 = "within"
  case c259 = "developer’s"
  case c260 = "toolset,"
  case c262 = "build"
  case c263 = "quickly,"
  case c265 = "present"
  case c266 = "excellent"
  case c267 = "diagnostics,"
  case c270 = "enable"
  case c271 = "interactive"
  case c272 = "development"
  case c273 = "experiences."
  case c275 = "can"
  case c278 = "so"
  case c279 = "much"
  case c280 = "more"
  case c281 = "powerful,"
  case c282 = "like"
  case c283 = "Swift-based"
  case c284 = "playgrounds"
  case c285 = "do"
  case c287 = "Xcode,"
  case c288 = "or"
  case c290 = "web-based"
  case c291 = "REPL"
  case c293 = "when"
  case c294 = "working"
  case c296 = "Linux"
  case c297 = "server-side"
  case c298 = "code."
}

@inline(never)
func convert(_ s: String) {
  blackHole(TestEnum(rawValue: s))
}

@inline(never)
public func run_StringEnumRawValueInitialization(_ n: Int) {
  let first = "Swift"
  let short = "To"
  let long = "(C, C++, Objective-C)."
  let last = "code."
  for _ in 1...100*n {
    convert(first)
    convert(short)
    convert(long)
    convert(last)
  }
}
