; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple armv8.6a-arm-none-eabi -mattr=+neon,+bf16 -float-abi=hard -verify-machineinstrs < %s -o - | FileCheck %s

define arm_aapcs_vfpcc <2 x float> @test_vbfdot_f32(<2 x float> %r, <4 x bfloat> %a, <4 x bfloat> %b) {
; CHECK-LABEL: test_vbfdot_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdot.bf16 d0, d1, d2
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <4 x bfloat> %a to <8 x i8>
  %1 = bitcast <4 x bfloat> %b to <8 x i8>
  %vbfdot1.i = call <2 x float> @llvm.arm.neon.bfdot.v2f32.v8i8(<2 x float> %r, <8 x i8> %0, <8 x i8> %1)
  ret <2 x float> %vbfdot1.i
}

define <4 x float> @test_vbfdotq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfdotq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdot.bf16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %b to <16 x i8>
  %vbfdot1.i = call <4 x float> @llvm.arm.neon.bfdot.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfdot1.i
}

define <2 x float> @test_vbfdot_lane_f32(<2 x float> %r, <4 x bfloat> %a, <4 x bfloat> %b) {
; CHECK-LABEL: test_vbfdot_lane_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdot.bf16 d0, d1, d2[0]
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <4 x bfloat> %b to <2 x float>
  %shuffle = shufflevector <2 x float> %0, <2 x float> undef, <2 x i32> zeroinitializer
  %1 = bitcast <4 x bfloat> %a to <8 x i8>
  %2 = bitcast <2 x float> %shuffle to <8 x i8>
  %vbfdot1.i = call <2 x float> @llvm.arm.neon.bfdot.v2f32.v8i8(<2 x float> %r, <8 x i8> %1, <8 x i8> %2)
  ret <2 x float> %vbfdot1.i
}

define <4 x float> @test_vbfdotq_laneq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfdotq_laneq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdup.32 q8, d5[1]
; CHECK-NEXT:    vdot.bf16 q0, q1, q8
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <8 x bfloat> %b to <4 x float>
  %shuffle = shufflevector <4 x float> %0, <4 x float> undef, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %1 = bitcast <8 x bfloat> %a to <16 x i8>
  %2 = bitcast <4 x float> %shuffle to <16 x i8>
  %vbfdot1.i = call <4 x float> @llvm.arm.neon.bfdot.v4f32.v16i8(<4 x float> %r, <16 x i8> %1, <16 x i8> %2)
  ret <4 x float> %vbfdot1.i
}

define <2 x float> @test_vbfdot_laneq_f32(<2 x float> %r, <4 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfdot_laneq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdot.bf16 d0, d1, d3[1]
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <8 x bfloat> %b to <4 x float>
  %shuffle = shufflevector <4 x float> %0, <4 x float> undef, <2 x i32> <i32 3, i32 3>
  %1 = bitcast <4 x bfloat> %a to <8 x i8>
  %2 = bitcast <2 x float> %shuffle to <8 x i8>
  %vbfdot1.i = call <2 x float> @llvm.arm.neon.bfdot.v2f32.v8i8(<2 x float> %r, <8 x i8> %1, <8 x i8> %2)
  ret <2 x float> %vbfdot1.i
}

define <4 x float> @test_vbfdotq_lane_f32(<4 x float> %r, <8 x bfloat> %a, <4 x bfloat> %b) {
; CHECK-LABEL: test_vbfdotq_lane_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    @ kill: def $d4 killed $d4 def $q2
; CHECK-NEXT:    vdot.bf16 q0, q1, d4[0]
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <4 x bfloat> %b to <2 x float>
  %shuffle = shufflevector <2 x float> %0, <2 x float> undef, <4 x i32> zeroinitializer
  %1 = bitcast <8 x bfloat> %a to <16 x i8>
  %2 = bitcast <4 x float> %shuffle to <16 x i8>
  %vbfdot1.i = call <4 x float> @llvm.arm.neon.bfdot.v4f32.v16i8(<4 x float> %r, <16 x i8> %1, <16 x i8> %2)
  ret <4 x float> %vbfdot1.i
}

define <4 x float> @test_vbfmmlaq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfmmlaq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmmla.bf16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %b to <16 x i8>
  %vbfmmla1.i = call <4 x float> @llvm.arm.neon.bfmmla.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmmla1.i
}

define <4 x float> @test_vbfmlalbq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlalbq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vfmab.bf16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %b to <16 x i8>
  %vbfmlalb1.i = call <4 x float> @llvm.arm.neon.bfmlalb.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalb1.i
}

define <4 x float> @test_vbfmlaltq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlaltq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vfmat.bf16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %b to <16 x i8>
  %vbfmlalt1.i = call <4 x float> @llvm.arm.neon.bfmlalt.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalt1.i
}

define <4 x float> @test_vbfmlalbq_lane_f32(<4 x float> %r, <8 x bfloat> %a, <4 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlalbq_lane_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    @ kill: def $d4 killed $d4 def $q2
; CHECK-NEXT:    vfmab.bf16 q0, q1, d4[0]
; CHECK-NEXT:    bx lr
entry:
  %vecinit35 = shufflevector <4 x bfloat> %b, <4 x bfloat> undef, <8 x i32> zeroinitializer
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %vecinit35 to <16 x i8>
  %vbfmlalb1.i = call <4 x float> @llvm.arm.neon.bfmlalb.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalb1.i
}

define <4 x float> @test_vbfmlalbq_laneq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlalbq_laneq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vfmab.bf16 q0, q1, d4[3]
; CHECK-NEXT:    bx lr
entry:
  %vecinit35 = shufflevector <8 x bfloat> %b, <8 x bfloat> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %vecinit35 to <16 x i8>
  %vbfmlalb1.i = call <4 x float> @llvm.arm.neon.bfmlalb.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalb1.i
}

define <4 x float> @test_vbfmlaltq_lane_f32(<4 x float> %r, <8 x bfloat> %a, <4 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlaltq_lane_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    @ kill: def $d4 killed $d4 def $q2
; CHECK-NEXT:    vfmat.bf16 q0, q1, d4[0]
; CHECK-NEXT:    bx lr
entry:
  %vecinit35 = shufflevector <4 x bfloat> %b, <4 x bfloat> undef, <8 x i32> zeroinitializer
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %vecinit35 to <16 x i8>
  %vbfmlalt1.i = call <4 x float> @llvm.arm.neon.bfmlalt.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalt1.i
}

define <4 x float> @test_vbfmlaltq_laneq_f32(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlaltq_laneq_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vfmat.bf16 q0, q1, d4[3]
; CHECK-NEXT:    bx lr
entry:
  %vecinit35 = shufflevector <8 x bfloat> %b, <8 x bfloat> undef, <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %vecinit35 to <16 x i8>
  %vbfmlalt1.i = call <4 x float> @llvm.arm.neon.bfmlalt.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalt1.i
}

define <4 x float> @test_vbfmlaltq_laneq_f32_v2(<4 x float> %r, <8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-LABEL: test_vbfmlaltq_laneq_f32_v2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdup.16 q8, d5[2]
; CHECK-NEXT:    vfmat.bf16 q0, q1, q8
; CHECK-NEXT:    bx lr
entry:
  %vecinit35 = shufflevector <8 x bfloat> %b, <8 x bfloat> undef, <8 x i32> <i32 6, i32 6, i32 6, i32 6, i32 6, i32 6, i32 6, i32 6>
  %0 = bitcast <8 x bfloat> %a to <16 x i8>
  %1 = bitcast <8 x bfloat> %vecinit35 to <16 x i8>
  %vbfmlalt1.i = call <4 x float> @llvm.arm.neon.bfmlalt.v4f32.v16i8(<4 x float> %r, <16 x i8> %0, <16 x i8> %1)
  ret <4 x float> %vbfmlalt1.i
}

declare <2 x float> @llvm.arm.neon.bfdot.v2f32.v8i8(<2 x float>, <8 x i8>, <8 x i8>)
declare <4 x float> @llvm.arm.neon.bfdot.v4f32.v16i8(<4 x float>, <16 x i8>, <16 x i8>)
declare <4 x float> @llvm.arm.neon.bfmmla.v4f32.v16i8(<4 x float>, <16 x i8>, <16 x i8>)
declare <4 x float> @llvm.arm.neon.bfmlalb.v4f32.v16i8(<4 x float>, <16 x i8>, <16 x i8>)
declare <4 x float> @llvm.arm.neon.bfmlalt.v4f32.v16i8(<4 x float>, <16 x i8>, <16 x i8>)
