#!/bin/bash
INSTALLBASE='output'
INSTALLPATH='usr'

################################################################################
cd ..
qmake PREFIX=./debian/${INSTALLBASE}/${INSTALLPATH}
make
make install
mkdir debian/${INSTALLBASE}/DEBIAN
mv debian/control debian/${INSTALLBASE}/DEBIAN/control
./clean_all.sh
cd debian

################################################################################
echo ''
APPFILENAME=$(grep 'Package: ' ${INSTALLBASE}/DEBIAN/control | cut -d' ' -f2)
echo 'Package:'$APPFILENAME
APPVERSION=$(grep 'Version: ' ${INSTALLBASE}/DEBIAN/control | cut -d' ' -f2)
echo 'Version:'$APPVERSION
APPARCH=$(grep 'Architecture: ' ${INSTALLBASE}/DEBIAN/control | cut -d' ' -f2)
echo 'Architecture:'$APPARCH
echo ''

DEBFILENAME="${APPFILENAME}_${APPVERSION}_${APPARCH}".deb
dpkg-deb --build $INSTALLBASE $DEBFILENAME

gpg -b --use-agent $DEBFILENAME
#
echo ""
echo "To install please do:"
echo "                      sudo dpkg -i $DEBFILENAME"
echo ""
echo "To upload please do:"
echo "                     rsync $DEBFILENAME     trucomanx@dl.sv.nongnu.org:/releases/bsltl/tools/$APPFILENAME/binaries-gnulinux/deb-files"
echo "                     rsync $DEBFILENAME.sig trucomanx@dl.sv.nongnu.org:/releases/bsltl/tools/$APPFILENAME/binaries-gnulinux/deb-files"
echo ""
rm -r -f ${INSTALLBASE}


