.TH groff_mspdf @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff-mspdf \- a macro package binding pdfmark with ms
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.\"
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_mspdf_7_man_C
.cp 0
.
.\" ====================================================================
.\" Local Macro Definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY pdfroff\0\-mspdf
.RI [ option \ .\|.\|.\&]
.RI [ file \ .\|.\|.\&]
.
.SY pdfroff\0\-m\~spdf
.RI [ option \ .\|.\|.\&]
.RI [ file \ .\|.\|.\&]
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.B \%groff_mspdf
is a \%full-service document formatting macro package;
it fully reproduces the features of
.MR groff_ms @MAN7EXT@ ,
integrated with the
.MR groff_pdfmark @MAN7EXT@
macros.
.
.P
In addition to implicitly loading the
.MR groff_ms @MAN7EXT@ ,
and the
.MR groff_pdfmark @MAN7EXT@
macros,
.B \%groff_mspdf
defines one new register,
.BR \%.\h'0.05n'NH ,
and several new,
or redefined macros, notably
.BR XH ,
and
.BR XN ,
together with associated hook macros,
.BR \%XH\-INIT ,
.BR \%XN\-INIT ,
.BR \%XH\-REPLACEMENT ,
.BR \%XN\-REPLACEMENT ,
and
.BR \%XH\-UPDATE\-TOC ;
it also defines the
.BR \%OMIT ,
.BR \%CS ,
and
.B \%CE
macros,
as specified by
.MR groff_omit @MAN7EXT@ .
.
.P
The
.BR XH ,
and
.B XN
macros may be used after
.BR \%.\h'0.05n'SH ,
and
.BR \%.\h'0.05n'NH ,
respectively,
to specify text which is to be incroporated into the document body,
as (part of) the associated section heading,
while also duplicating it to create a table of contents reference,
and, in the case of the
.B \%groff_mspdf
implementations,
a PDF document outline reference,
to this heading.
.
.P
The associated hook macros, collectively,
determine the specific features of the
.BR XH ,
and the
.B XN
macro implementations;
default implementations for each hook are provided,
but any of these may be redefined by the user,
to implement features which differ from the defaults.
.
.P
It may be noted that the
.BR XH ,
and
.B XN
macros,
and their associated hooks,
originated in
.BR groff_mspdf .
Although simplified variants of these macros have been incorporated into
contemporary versions of
.MR groff_ms @MAN7EXT@ ,
since the publication of
.I GNU\ roff
version 1.23.0,
these are
.I not
functionally equivalent to the variants defined in
.BR \%groff_mspdf ;
the differences will be explained in the
.SR 1 Usage
section,
below.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
Whereas the use of
.MR groff_ms @MAN7EXT@
is normally initiated with a command conforming to the synopsis:
.RS 2n
.SY \%groff\0\-ms
.RI [ option \ .\|.\|.\&]
.RI [ file \ .\|.\|.\&]
.YS
.RE
.P
exploitation of the additionally integrated
.MR groff_pdfmark @MAN7EXT@
macro features will normally necessitate multiple-pass
.MR groff @MAN1EXT@
processing;
consequently, the use of
.MR pdfroff @MAN1EXT@ ,
which automatically performs such multiple-pass processing,
in preference to only simple single-pass
.MR groff @MAN1EXT@
processing, is
.I strongly
recommended,
as indicated in the
.SR 1 Synopsis
section, above,
when the
.B \%groff_mspdf
macro package is used as an alternative to
.MR groff_ms @MAN7EXT@ .
.
.P
Since
.B \%groff_mspdf
implicitly loads the
.MR groff_ms @MAN7EXT@
and
.MR groff_pdfmark @MAN7EXT@
packages,
any feature of either of these packages may be used,
as documented in the respective manual page.
Furthermore, since
.MR groff_pdfmark @MAN7EXT@
also provides the features documented in the
.MR groff_pdfhref @MAN7EXT@ ,
and the
.MR groff_pdfnote @MAN7EXT@
manual pages,
any of these features may also be used,
in accordance with their respective documentation,
.I without
explicitly loading any further macro package.
.
.P
Conversely,
although simplified variants of the
.B XH
and
.B XN
macro implementations,
derived from their original
.B \%groff_mspdf
implementations,
have been incorporated into
.MR groff_ms @MAN7EXT@ ,
from the release of
.I \%GNU\ roff
version 1.23.0 onwards,
these simplified variants are
.I not
usage compatible with their original
.B \%groff_mspdf
implementations.
Whereas the
.MR groff @MAN7EXT@
implementations,
if supported by the underlying
.I \%GNU\ roff
distribution,
conform to the basic synopses:
.P
.RS 2n
.SY .\^SH
.RI [< outline-level >]
.SY .\^XH
.RI < outline-level >
.RI < heading-text >\ .\|.\|.\&
.YS
.SY .\^NH
.RI < outline-level >
.SY .\^XN
.RI < heading-text >\ .\|.\|.\&
.YS
.RE
.P
the
.B \%groff_mspdf
implementations conform to the extended synopses:
.P
.RS 2n
.SY .\^SH
.RI [< outline-level >]
.SY .\^XH
.RB [ \-N
.RI < reference-name >]
.RB [ \-S ]
.RB [ \-X ]
.RI < outline-level >
.RI < heading-text >\ .\|.\|.\&
.YS
.SY .\^NH
.RI < outline-level >
.SY .\^XN
.RB [ \-N
.RI < reference-name >]
.RB [ \-S ]
.RB [ \-X ]
.RI < heading-text >\ .\|.\|.\&
.YS
.RE
.
.P
The options,
which provide control of
.MR groff_pdfhref @MAN7EXT@
features,
and are supported
.I exclusively
by the
.B \%groff_mspdf
implementations of
.BR XH ,
and
.BR XN ,
are:
.P
.RS 2n
.ll -2n
.TP 3.6n
.BR \-N \ <\c
.IR reference-name >
Use
.RI < reference-name >
for the destination,
to which the associated PDF outline entry refers.\v'-1v'
.
.TP 3.6n
.B \-S
Strip,
or transliterate,
a nominated set of
.MR groff @MAN7EXT@
special characters, and escape sequences, from
.RI \%< heading-text >,
when copying it to the PDF outline;
this operation is performed by the
.B \%sanitize
macro,
as described in
.MR groff_sanitize @MAN7EXT@ .
.
.TP 3.6n
.B \-X
Create an external cross-reference dictionary entry for
.RI < reference-name >.
.ll +2n
.RE
.P
It should be noted that all of these options are specific to
the handling of PDF outline entries.
Since a bare
.MR groff_ms @MAN7EXT@
implementation makes no provision for creating a PDF outline,
its rudimentary
.BR XH ,
and
.B XN
implementations have no need to make any such provision;
consequently,
these options would have no meaning in the bare
.MR groff_ms @MAN7EXT@
context, so are unsupported, and if specified, they
.I \%will
result in incorrect behaviour.
.
.P
Regardless of whether they originate in a recent
.MR groff_ms @MAN7EXT@
implementation, or legacy fallbacks from
.B \%groff_mspdf
are adopted,
the initial implementations of both
.BR \%XH ,
and
.BR \%XN ,
are simple stubs;
each, when invoked for its first, and only time,
following its definition by its originating macro package,
performs its own standardized self-initialization,
before replacing itself by, and transferring control to,
whatever complementary
.BR \%XH\-REPLACEMENT ,
or
.B \%XN\-REPLACEMENT
macro implementation,
respectively,
is in scope at this time.
This initialization strategy ensures that the
.B \%groff_mspdf
implementations,
of each of these two macros,
will override the corresponding
.MR groff_ms @MAN7EXT@
implementations,
while still according the user an opportunity to override the
.B \%groff_mspdf
implementations,
by furnishing their own alternative definitions,
.I after
.B \%groff_mspdf
has been loaded, but
.I before
invoking
.BR \%XH ,
or
.BR \%XN ,
as may be appropriate,
for the first time.
.
.P
After initialization,
and when their respective
.BR \%XH\-REPLACEMENT ,
and
.B \%XN\-REPLACEMENT
handlers have been installed, the default operation of
.BR \%XH ,
and
.B \%XN
reduces to:
.RS 2n
.ll -2n
.IP \(bu 2n
Invocation of the respective
.BR \%XH\-INIT ,
or
.B \%XN\-INIT
callback hook;
no arguments are passed,
and unless otherwise redefined, by the user,
each of these is processed as a \%\(lqno-op\(rq.
.
.IP \(bu 2n
The macro argument list,
together with any specified options,
are processed to construct a PDF document outline entry;
any specified options are discarded from the argument list.
(This step is
.I not
performed by the default
.MR groff_ms @MAN7EXT@
implementation of either macro).
.
.IP \(bu 2n
Both macros conclude by invoking the
.I same
additional user-redefinable callback hook,
.BR \%XH\-UPDATE\-TOC ,
passing all residual arguments
from its own argument list.
.ll +2n
.RE
.P
The default implementation of
.BR \%XH\-UPDATE\-TOC ,
regardless of whether its origin is to be found in
.BR \%groff_mspdf ,
or in a contemporary version of
.MR groff_ms @MAN7EXT@ ,
is very rudimentary:
it discards\|\(em\|i.e.\ it completely ignores\|\(em\|its
.RI \%< outline-level >
argument,
and simply emits the interpolation of its remaining arguments,
as the embedded content within a
.MR groff_ms @MAN7EXT@
.BR \%.\^XS \~.\|.\|.\~ .\^XE
construct.
.
.
.\" ====================================================================
.SH Control Registers
.\" ====================================================================
.
Although
.MR groff_ms @MAN7EXT@
.I \%does
track the progression of heading levels,
as assigned by the
.B NH
macro,
the tracked value is not exposed publicly.
While public access to this tracked value may not
be particularly useful,
in any conventional deployment of
.MR groff_ms @MAN7EXT@ ,
it may be found useful in a user-defined replacement for the
.B \%XH\-UPDATE\-TOC
macro;
thus,
.B \%groff_ms
augments the
.MR groff_ms @MAN7EXT@
definition of the
.B NH
macro,
to assign the internally tracked value to a register named
.BR \%.\h'0.05n'NH .
.
.ig
.P
Also related to the behaviour of the
.B \%XH\-UPDATE\-TOC
macro,
the numeric register,
.BR \%TC\-MARGIN ,
specifies, in
.MR groff @MAN7EXT@
basic units,
the width of a column field at the right hand end of each output line,
within the table of contents,
which is to be reserved for output of the page number,
while the defined character entity,
.BR \%TC\-LEADER ,
specifies a special leader character sequence,
which is used to fill the space between the text
of each table of contents entry,
and the corresponding page number output field;
..
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@SITE_TMACDIR@/spdf.tmac
Provides the implementation of the
.B \%groff_mspdf
bindings for conjoined use of
.MR groff_ms @MAN7EXT@
and
.MR groff_pdfmark @MAN7EXT@ .
.
.TP
.I \%@SITE_TMACDIR@/s.tmac
Provides the implementation of the underlying
.MR groff_ms @MAN7EXT@
macro package.
.
.TP
.I \%@SITE_TMACDIR@/pdfmark.tmac
Provides the implementation of the underlying
.MR groff_pdfmark @MAN7EXT@
macro package.
.
.
.\" ====================================================================
.SH Caveats and Bugs
.\" ====================================================================
.
The
.B \%.\h'0.05n'NH
register is named in accordance with the
.MR groff @MAN7EXT@
convention that an initial dot designates it as
exhibiting the read-only property;
however, since it is not implemented as a built-in register,
.MR groff @MAN7EXT@
provides no mechanism for enforcing this.
Thus, users are cautioned that setting it to any value,
other than that assigned by the
.B NH
macro,
may produce unexpected results.
.
.
.\" ====================================================================
.SH Examples
.\" ====================================================================
.
The default implementation of the
.B \%XH\-UPDATE\-TOC
macro,
which serves as the common table of contents collector for
.I \%both
.BR \%XH ,
and
.BR \%XN ,
is:
.P
.RS 2n
.EX
\&.de XH\-UPDATE\-TOC
\&.\(rs" .XH\-UPDATE\-TOC <outline-level> [<section-number>] <text>
\&.\(rs"
\&.   XS            \(rs" use conventional s.tmac TOC data collection
\&.      shift      \(rs" ignore <outline-level> in rudimentary style
\&.      nop \(rs&\(rs\(rs$* \(rs" capture <section-number> and <text>
\&.   XE
\&..
.EE
.RE
.P
This relies on the
.MR groff_ms @MAN7EXT@
built-in table of contents data collector,
but offers virtually no capability for control of
the layout of the table of contents,
when it is ultimately printed.
.
Thus,
users may wish to replace this default implementation,
to achieve a more sophisticated layout;
for example,
(for headings set
.I exclusively
by
.BR \%XN ):
.P
.RS 2n
.EX
\&.ds XNVS1 0.50v  \(rs" leading for top level
\&.ds XNVS2 0.15v  \(rs" leading at nesting level increment
\&.ds XNVS3 0.30v  \(rs" leading following nested group
\&.
\&.de XH\-UPDATE\-TOC
\&.   XS
\&.      if r tc*hl \(rs{\(rs
\&.            \(rs" Compute additional leading
\&.            \(rs" at <outline-level> change
\&.            \(rs"
\&.            ie \(rs\(rs$1>1 \(rs{\(rs
\&.                  ie \(rs\(rs$1>\(rs\(rsn[tc*hl] .sp \(rs\(rs*[XNVS2]
\&.                  el .if \(rs\(rsn[tc*hl]>\(rs\(rs$1 .sp \(rs\(rs*[XNVS3]
\&.               \(rs}
\&.            el .sp \(rs\(rs*[XNVS1]
\&.         \(rs}
\&.
\&.      \(rs" Record <outline-level> of this entry,
\&.      \(rs" for comparison with the next
\&.      \(rs"
\&.      ie \(rs\(rs$1 .nr tc*hl \(rs\(rs$1
\&.      el .nr tc*hl 1
\&.
\&.      \(rs" Set indentation, and insert
\&.      \(rs" <section-number> for this entry
\&.      \(rs"
\&.      nop \(rsh\(aq\(rs\(rsn[tc*hl]-1m\(aq\(rs\(rs$2\(rsc
\&.
\&.      \(rs" Append <heading-text> for this entry
\&.      \(rs"
\&.      shift 2
\&.      nop \(rsh\(aq1.5n\(aq\(rs\(rs$*\(rsh\(aq0.5n\(aq
\&.   XE
\&..
.EE
.RE
.P
.ne 2v
The preceding example is suitable
.I only
for use when
.I all
headings,
which are to be incorporated into the table of contents,
are specified using the
.B XN
macro,
on account of its separate handling of its
\%\(lq\fC\(rs\(rs$2\fP\(rq argument,
(which is
.I \%always
assumed to represent a section number,
as generated by a prior call of the
.B NH
macro).
.
Since no such
.RI \%< section-number >
argument is ever specified, when
.B \%XH\-UPDATE\-TOC
is called from within
.BR \%XH ,
this example might be modified,
for
.I \%exclusive
use with headings specified \%using the
.B \%XH
macro,
by replacing the statements:
.P
.RS 2n
.EX
\&.      \(rs" Set indentation, and insert
\&.      \(rs" <section-number> for this entry
\&.      \(rs"
\&.      nop \(rsh\(aq\(rs\(rsn[tc*hl]-1m\(aq\(rs\(rs$2\(rsc
\&.
\&.      \(rs" Append <heading-text> for this entry
\&.      \(rs"
\&.      shift 2
\&.      nop \(rsh\(aq1.5n\(aq\(rs\(rs$*\(rsh\(aq0.5n\(aq
.EE
.RE
.P
with a simplified alternative,
such as:
.P
.RS 2n
.EX
\&.      \(rs" Set indentation, and append aggregate
\&.      \(rs" <heading-text> for this entry
\&.      \(rs"
\&.      shift
\&.      nop \(rsh\(aq\(rs\(rsn[tc*hl]-1m\(aq\(rs\(rs$*\(rsh\(aq0.5n\(aq
.EE
.RE
.P
As may be seen,
from the foregoing examples,
when all table of contents entries are specified using
.I \%either
.BR \%XH
.IR alone ,
.I or
.BR \%XN
.IR alone ,
customization of the
.BR \%XH\-UPDATE\-TOC
callback macro,
to achieve a more structured \%table of contents layout,
is relatively straightforward.
.
Conversely,
any customization which is required to accommodate
a combination of table of contents entries,
some of which may be specified by
.BR \%XH ,
and some by
.BR \%XN ,
will require a more complex implementation.
.
The specific details of how the layout is to be adjusted,
dependent on whether the entry is specified using
.BR \%XH ,
or using
.BR \%XN ,
is the prerogative of the document author,
or of the callback macro implementor;
usually, it will also be necessary to redefine the
.BR \%XH\-INIT ,
and the
.B \%XN\-INIT
callback macros,
to record the calling context:
.P
.RS 2n
.EX
\&.de XH\-INIT
\&.   nr XH\-UPDATE\-MODE 0
\&..
\&.de XN\-INIT
\&.   nr XH\-UPDATE\-MODE 1
\&..
.EE
.RE
.P
and then test the value of
.BR \%XH\-UPDATE\-MODE ,
within the redefined
.B \%XH\-UPDATE\-TOC
callback macro,
as predicate for the choice of an applicable layout model.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%groff_mspdf
macros are provided by the auxiliary
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ,
and is maintained independently of
.IR \%GNU\ roff ,
at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation,
on the use of the
.B \%groff_mspdf
binding macros may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_mspdf_7_man_C]
.do rr *groff_mspdf_7_man_C
.
.\" ====================================================================
.\"
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
