.TH groff_toc @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff_toc \- a GNU roff macro framework for table of contents collation
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_toc_7_man_C
.cp 0
.
.\" ====================================================================
.\" Local Macro Definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The
.B \%groff_toc
macro package provides a minimal framework
for managing the specification, and the collation
of table of contents entries.
.
It is intended that this minimal framework should be extended,
by the addition of user-defined macros,
to control the layout of tables of contents.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The
.B \%groff_toc
macro framework may be loaded directly from the
.MR groff @MAN1EXT@
command line:
.RS 3n
.SY groff
.RI \%[ options \ .\|.\|.\&]
.B \%\-mtoc
.RI \%[ files \ .\|.\|.\&]
.YS
.RE
.P
Alternatively,
it may be found to be more convenient to load it
from within a
.MR groff @MAN7EXT@
document source file,
or from some other dependent macro package:
.RS 3n
.SY .mso\ toc.tmac
.YS
.RE
.
.P
All features of the
.B \%groff_toc
framework are accessed through a single primary macro, named
.BR \%toc ,
which should be called in accordance with the syntax specification:
.RS 3n
.SY .toc
.IR \%opcode \ [ arglist \ .\|.\|.\&]
.YS
.RE
.P
The
.I \%opcode
argument is required;
it causes the call to be redirected to a supplementary macro, named
.B \%.toc.\c
.IR opcode ,
which may correspond to one of the predefined actions,
as specified below, or it may be a user-defined extension macro,
to perform the desired operation.
.P
The remaining arguments, designated by
.RI \%[ arglist \ .\|.\|.\&]
are formally optional;
however, depending on the particular
.I \%opcode
which has been specified,
at least some of these formally optional arguments
may be required.
.
.P
The predefined
.B \%groff_toc
macros correspond to
.B \%toc
macro calls of the form:
.RS 3n
.SY .toc\ file
.RI [ name ]
.SY .toc\ put
.IR \%opcode \ [ arglist \ .\|.\|.\&]
.SY .toc\ error
.IR message\ text \ .\|.\|.
.YS
.RE
.P
The operation of each of these predefined
.B \%toc
macro forms is described below:
.
.ll -4n
.RS 3n
.TP 4n
.BR .toc\ file \ [\c
.IR name ]
Closes any file stream,
which may have been opened by a previous
.B \%.toc\ file
assignment,
and opens
.I \%name
as a new file stream,
for collection of table of contents reference data.
if the
.I \%name
argument is omitted,
or if the
.MR groff @MAN7EXT@
input data stream is being processed by
.MR pdfroff @MAN1EXT@ ,
collected table of contents reference data will be directed
to the standard error output data stream,
rather than to a named file.
.
.IP \& 4n
When the collected table of contents
reference data is to be directed to a named file,
it will normally be necessary to invoke
.MR groff @MAN1EXT@
in
.I \%unsafe
mode,
(that is, with its
.B \%\-U
option in effect);
however, in the special case of processing with
.MR pdfroff @MAN1EXT@ ,
this restriction may be relaxed,
because the collected data will be directed through
the standard error stream,
whence
.MR pdfroff @MAN1EXT@
will redirect it to the named file.
.
.TP 4n
.BR .toc\ put \ \c
.IR \%opcode \ [ arglist \ .\|.\|.\&]
Emit a table of contents entry specification
to the nominated reference data collection stream;
this reference takes the form:
.P
.RS 7n
.EX
\(rs*[TOC.REQUEST] \c
.IR \%opcode \ [ arglist \ ...\&]
.EE
.RE
.RS 4n
.P
with the default value of \fC\(rs*[TOC.REQUEST]\fP being specified as
.BR \%\fC.toc\fP ,
(as discussed in the
.RK V \h'-0.2n'V\h'-0.2n'
.SR 1 Control\ Variables
section, below);
thus, the table of contents reference data is recorded
as a sequence of macro calls, which will then be evaluated,
when this data is read back into the document source input stream.
.
.P
Note that,
regardless of how
.B \%TOC.REQUEST
may have been defined,
the onus falls on the user,
to furnish any macros which may be required
to evaluate each
.P
.RS 3n
.EX
\(rs*[TOC.REQUEST] \c
.IR \%opcode \ [ arglist \ ...\&]
.EE
.RE
.P
request which has been inserted into
the table of contents reference data stream,
by any
.B \%.toc\ put
macro call;
when
.B \%TOC.REQUEST
retains its default assignment,
this implies that the user must furnish a
.BI \%.toc. opcode
macro definition
for each and every distinct
.IR \%opcode
which is specified,
in any such
.B \%.toc\ put
macro call.
.RE
.
.ne 8v
.TP 4n
.BI .toc\ error \ message\ text\ .\|.\|.
Emit a diagnostic message,
on the standard error output stream;
this message is presented in the form:
.RS 7n
.EX
toc macro error: \c
.I message text ...
.EE
.RE
.RS 4n
This form of the
.B \%toc
macro is typically used to report issues
which are encountered when evaluating other macros,
within the context of the
.B \%groff_toc
framework,
(both those which are included within the basic framework,
and user-defined extensions to it).
.RE 1
.ll +4n
.P
On their own,
the three variants of the
.B \%toc
macro, as described above,
will not be sufficient to lay out a table of contents;
thus, it will be necessary for the user to define at least one,
and possibly a collection of several supplementary macros,
to fulfil the evaluation of the macro sequence,
as written to, and subsequently read back from,
the table of contents reference data collection stream.
.
.
.\" ====================================================================
.SH Control Variables
.\" ====================================================================
.
The
.B \%groff_toc
macro framework defines
.I \%one
.MR groff @MAN7EXT@
string, namely
.BR \%TOC.REQUEST ,
which is used to specify the first token\|\(em\|nominally
a macro name, preceded by the
.MR groff @MAN7EXT@
.IR "control character" \|\(em\|in
each record written
to the table of contents reference data stream,
by the
.B \%toc\ put
macro.
.
By default,
this is defined as
.BR \%.toc ,
which implies that each record in this data stream
will represent a macro call to another variant\|\(em\|which,
of necessity, should usually be user-defined\|\(em\|of the
.B \%toc
macro.
.
.P
After loading the
.I \%toc.tmac
macro file,
the user may redefine the
.B \%TOC.REQUEST
string,
thus substituting an alternative to the
.B \%toc
macro, for laying out the table of contents;
(any such substitute macro will usually also need
to be furnished by the user).
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@SITE_TMACDIR@/toc.tmac
Implements the
.B \%groff_toc
framework.
.
.TP
.I \%@SITE_TMACDIR@/spdf-toc.tmac
Provides a concrete working example of integration of the
.B \%groff_toc
macro framework with
.MR pdfroff @MAN1EXT@ ,
the
.IR \%spdf.tmac ,
and the
.I \%pdfmark.tmac
macros.
.
.
.\" ====================================================================
.SH Caveats and Bugs
.\" ====================================================================
.
When using
.MR pdfroff @MAN1EXT@
as the formatter,
only the default setting of
.B \%.toc
is suitable as an assignment for
.BR \%TOC.REQUEST ;
.MR pdfroff @MAN1EXT@
will not recognize any value,
other than
.BR \%.toc ,
as a valid record signature
for a table of contents data reference.
.
.
.\" ====================================================================
.SH Examples
.\" ====================================================================
.
To activate the
.B \%groff_toc
framework,
initialize the reference data collector,
and to insert a formatted table of contents into a document,
add markup to the document source, similar to the following,
at the point at which the table of contents
is to be placed:
.P
.RS 4n
.EX
\&.mso toc.tmac
\&.
\&.\(rs" Initialization of the reference data collector may
\&.\(rs" overwrite any existing content in the associated file,
\&.\(rs" thus, this file must be read in, BEFORE the collector
\&.\(rs" file stream is assigned.  Additionally, any required
\&.\(rs" toc.extension macros must be defined here, BEFORE
\&.\(rs" reading any existing content from the named file.
\&.
\&.so foo.toc
\&.toc file foo.toc
.EE
.RE
.
.P
To add entries into the table of contents,
place macro calls similar to the following,
at each point throughout the document source,
to which a table of contents should refer:
.P
.RS 4n
.EX
\&.toc put pageref \(rsn% \c
.I reference text ...
.EE
.RE
.
.P
Notice that,
to service the macro calls which this will insert into
the table of contents reference data file,
a user-defined
.BI \%toc. extension
macro, named
.BR \%toc.pageref ,
must be defined,
.I before
the file is read in;
(that is, it
.I must
have been defined
.IR before ,
or at least
.IR at ,
the position of the comment,
within the initial example sequence of requests,
above, which indicates this requirement).
.
Assuming that tab stops are already set up,
as appropriate for laying out the table of contents,
at the time when the reference data file is read back,
'ne 15v
a suitable, if rudimentary, implementation for such
an extension macro might be:
.P
.RS 4n
.EX
\&.de toc.pageref
\&.\(rs" Usage: .toc pageref page-number reference text ...
\&.\(rs"
\&.\(rs" Placing the page number as the first argument, before
\&.\(rs" the reference text arguments, may seem counterintuitive;
\&.\(rs" it is done this way to avoid any requirement to iterate
\&.\(rs" over the reference text, to locate the page number.
\&.\(rs"
\&.   nr \(rs\(rs$0.page \(rs\(rs$1       \(rs" save page number ...
\&.   shift                   \(rs" and remove from arguments
\&.   nop \(rs\(rs$* \(rsa\(rst\(rs\(rs$0.page  \(rs" emit TOC entry
\&.   rr \(rs\(rs$0.page            \(rs" clean up local storage
\&..
.EE
.RE
.
.P
The preceding examples are fairly trivial;
for a more comprehensive working example of
.B \%groff_toc
usage, see the
.I \%spdf-toc.tmac
file,
which accompanies the
.I \%groff-pdfmark
distribution.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%groff_toc
macro framework is provided as an adjunct to the
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ;
it is independently maintained at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained.
.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation on the use of the
.I \%groff-pdfmark
macro suite,
which incorporates the
.B \%groff_toc
framework,
may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_toc_7_man_C]
.do rr *groff_toc_7_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\"
.\" vim: set filetype=groff textwidth=72:
