import os
import polib
import re

# Updated list of target phrases
target_phrases = [
    "Visualize",
    "Visualize recursively",
    "Keep Root Menu Separate in Saved Menu File",
    "Keep as is",
    "Edit"
]

# Normalize text by collapsing whitespace
def normalize(text):
    return " ".join(text.split())

# Check if any target phrase exists in normalized msgid
def phrase_in_msgid(text):
    text = normalize(text)
    for phrase in target_phrases:
        if phrase in text:
            return phrase
    return None

# Check if any target phrase appears in msgstr as a full word
def phrase_in_msgstr(text):
    text = normalize(text)
    for phrase in target_phrases:
        pattern = r'\b' + re.escape(phrase) + r'\b'
        if re.search(pattern, text):
            return phrase
    return None

# Traverse all .po files in the current directory (excluding en_GB.po)
po_dir = os.path.join("..", "..", "po")

for filename in os.listdir(po_dir):
    if not filename.endswith(".po") or filename == "en_GB.po":
        continue

    fpath = os.path.join(po_dir, filename)
    po = polib.pofile(fpath)

    for entry in po:
        id_phrase = phrase_in_msgid(entry.msgid)
        str_phrase = phrase_in_msgstr(entry.msgstr)

        if id_phrase and str_phrase and id_phrase == str_phrase:
            print(f"{filename}: Phrase '{id_phrase}' found in both msgid and msgstr")
