# The script assumes that there is a po folder inside the source folder that 
# contains the translation files.

import os

# List of sentences to look up
sentences = [
    "Create Backup Before Overwriting Menu File",
    "Use Tabs for Indentations in Saved Menu File",
    "Keep Root Menu Separate in Saved Menu File",
    "Sort Execute/Startupnotify Options",
    "Always notify about Execute option conversions.",
    "Use Client-Side Decorations",
    "Show Menu Button Instead of Menubar"
]

# Function to read the .po file and get translations
def get_translations(language_code):
    po_file_path = f"../../po/{language_code}.po"
    
    if not os.path.isfile(po_file_path):
        print(f"File {po_file_path} not found.")
        return
    
    translations = {}
    current_msgid = None
    
    with open(po_file_path, 'r', encoding='utf-8') as file:
        for line in file:
            line = line.strip()
            if line.startswith('msgid'):
                current_msgid = line[6:].strip().strip('"')
            elif line.startswith('msgstr'):
                current_msgstr = line[7:].strip().strip('"')
                if current_msgid in sentences:
                    translations[current_msgid] = current_msgstr
    
    for sentence in sentences:
        translation = translations.get(sentence)
        if translation:
            print(translation)
        else:
            print("Translation not found")

# Main execution
if __name__ == "__main__":
    language_code = input("Enter the language code (e.g., 'en', 'zh_CN'): ").strip()
    get_translations(language_code)

