/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEventMulticaster;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.ItemEvt;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class Choice
extends Container
implements ItemSelectable,
ActionListener,
ItemListener,
MouseListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = -4075310674757313071L;
    static int BTN_WIDTH = 15;
    static int HILIGHTED = 1;
    Vector items = new Vector();
    Object selection;
    ItemListener iListener;
    ChoiceWindow prompter;
    TextField entry = new TextField();
    int state;

    public void actionPerformed(ActionEvent actionEvent) {
        this.select(actionEvent.getActionCommand());
    }

    public synchronized void add(String string) {
        this.addItem(string);
    }

    public synchronized void addItem(String string) {
        this.insert(string, this.items.size());
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
    }

    void closePrompt(boolean bl) {
        if (this.prompter != null) {
            this.prompter.list.removeItemListener(this);
            this.prompter.list.removeActionListener(this);
            this.prompter.list.removeFocusListener(this);
            this.prompter.dispose();
            this.prompter = null;
            this.paintButton();
            if (bl) {
                this.entry.requestFocus();
            }
        }
    }

    public void doLayout() {
        int n = 2;
        this.entry.setBounds(0, 0, this.width - BTN_WIDTH - 2 * n, this.height);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.prompter != null && focusEvent.getSource() == this.prompter.list) {
            this.closePrompt(false);
        }
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public int getItemCount() {
        return this.getItems();
    }

    public int getItems() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.items.indexOf(this.selection);
    }

    public synchronized String getSelectedItem() {
        return (String)this.selection;
    }

    public synchronized Object[] getSelectedObjects() {
        Object[] objectArray = this.selection != null ? new Object[]{this.selection} : new Object[]{};
        return objectArray;
    }

    public synchronized void insert(String string, int n) {
        if (this.items.size() == 0) {
            this.selection = string;
            this.entry.setText(string);
        }
        this.items.insertElementAt(string, n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && this.prompter.list.selMouse) {
            this.select(this.prompter.list.getSelectedItem());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        int n = keyEvent.getKeyCode();
        if (this.prompter != null && object == this.prompter.list) {
            if (n == 27) {
                this.closePrompt(true);
            }
        } else if (n == 40) {
            this.openPrompt();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.state |= HILIGHTED;
        this.paintButton();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.state &= ~HILIGHTED;
        this.paintButton();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.prompter == null) {
            this.openPrompt();
        } else {
            this.closePrompt(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyItem() {
        if (this.iListener != null || (this.eventMask & 0x200) != 0) {
            Toolkit.eventQueue.postEvent(ItemEvt.getEvent(this, 701, this.selection, 1));
        }
    }

    void openPrompt() {
        if (this.prompter == null) {
            Component component = this.getToplevel();
            Choice choice = this;
            if (choice == null) {
                throw null;
            }
            this.prompter = choice.new ChoiceWindow(component instanceof Frame ? (Frame)component : null);
            Point point = this.getLocationOnScreen();
            this.prompter.popUpAt(point.x, point.y + this.height + 1, this.width, Math.min(this.items.size() + 1, 8) * Defaults.WndFontMetrics.getHeight());
            this.prompter.list.addItemListener(this);
            this.prompter.list.addActionListener(this);
            this.prompter.list.addKeyListener(this);
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintButton(graphics);
    }

    void paintButton() {
        if (this.isShowing()) {
            Graphics graphics = this.getGraphics();
            this.paintButton(graphics);
            graphics.dispose();
        }
    }

    void paintButton(Graphics graphics) {
        int n = 2;
        int n2 = BTN_WIDTH;
        graphics.setColor((this.state & HILIGHTED) > 0 ? Defaults.BtnPointClr : Defaults.BtnClr);
        graphics.fill3DRect(this.width - n2 - n, n, n2, this.height - 2 * n, this.prompter == null);
        int n3 = this.width - n - n2 / 2;
        int n4 = this.height - (this.height - 7) / 2;
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n4, n3 - 3, n4 - 7);
        graphics.drawLine(n3, n4, n3 + 3, n4 - 7);
        graphics.setColor((this.state & HILIGHTED) > 0 ? Defaults.FocusClr : Color.black);
        graphics.drawLine(--n3, n4, n3 - 3, n4 - 7);
        graphics.drawLine(n3, n4, n3 + 3, n4 - 7);
        graphics.setColor(Defaults.BtnClr);
        n3 = this.width - n2 - 2 * n;
        graphics.draw3DRect(n3, 0, this.width - n3 - 1, this.height - 1, true);
        graphics.draw3DRect(n3 + 1, 1, this.width - n3 - 3, this.height - 3, false);
    }

    protected String paramString() {
        return super.paramString();
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension();
        int n = this.items.size();
        while (--n >= 0) {
            Dimension dimension2 = this.entry.getPreferredSize(((String)this.items.elementAt(n)).length());
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        dimension.width += BTN_WIDTH + 4;
        return dimension;
    }

    void process(ItemEvent itemEvent) {
        if (this.iListener != null || (this.eventMask & 0x200) != 0) {
            this.processEvent(itemEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.iListener != null) {
            this.iListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized void remove(String string) {
        this.items.removeElement(string);
    }

    public synchronized void remove(int n) {
        if (n >= 0 && n < this.items.size()) {
            this.items.removeElementAt(n);
        }
    }

    public synchronized void removeAll() {
        this.items.removeAllElements();
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public void requestFocus() {
        this.entry.requestFocus();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.doLayout();
        this.flags |= 2;
    }

    public synchronized void select(String string) {
        this.closePrompt(true);
        if (this.items.contains(string)) {
            this.selection = string;
            if (!this.entry.getText().equals(string)) {
                this.entry.setText(string);
            }
            this.notifyItem();
        }
    }

    public synchronized void select(int n) {
        if (n >= 0 && n < this.items.size()) {
            this.select((String)this.items.elementAt(n));
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.entry.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.entry.setFont(font);
    }

    public Choice() {
        this.setLayout(null);
        this.setBackground(Color.lightGray);
        this.add(this.entry);
        this.entry.setEditable(false);
        this.entry.addActionListener(this);
        this.entry.addKeyListener(this);
        this.addMouseListener(this);
    }

    class ChoiceWindow
    extends Window {
        List list = new List();

        public void doLayout() {
            int n = 1;
            this.list.setBounds(n, n, this.width - 2 * n, this.height - 2 * n);
        }

        void popUpAt(int n, int n2, int n3, int n4) {
            int n5 = Choice.this.items.size();
            this.setBounds(n, n2, n3, n4);
            this.list.setFont(Choice.this.font);
            int n6 = 0;
            while (n6 < n5) {
                this.list.add((String)Choice.this.items.elementAt(n6));
                ++n6;
            }
            this.setVisible(true);
            this.list.select(Choice.this.items.indexOf(Choice.this.selection));
            Choice.this.prompter.list.requestFocus();
        }

        void process(WindowEvent windowEvent) {
            super.process(windowEvent);
            if (windowEvent.id == 206) {
                Choice.this.closePrompt(false);
            }
        }

        public ChoiceWindow(Frame frame) {
            super(frame);
            this.setLayout(null);
            this.list.removeHScroll();
            this.add(this.list);
        }
    }
}

