/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import kaffe.util.UTF8;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public void flush() throws IOException {
        super.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.written += n2;
    }

    public synchronized void write(int n) throws IOException {
        super.write(n);
        ++this.written;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    public final void writeChar(int n) throws IOException {
        this.writeByte((n & 0xFF00) >> 8);
        this.writeByte(n & 0xFF);
    }

    public final void writeChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeChar(string.charAt(n));
            ++n;
        }
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        this.write(byArray, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public final void writeShort(int n) throws IOException {
        this.writeChar(n);
    }

    public final void writeUTF(String string) throws IOException {
        byte[] byArray = UTF8.encode(string);
        if (byArray.length > 65535) {
            throw new UTFDataFormatException("String too long");
        }
        DataOutputStream dataOutputStream = this;
        synchronized (dataOutputStream) {
            this.writeShort(byArray.length);
            this.write(byArray, 0, byArray.length);
        }
    }

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

