/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.rmic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import kaffe.rmi.rmic.TabbedWriter;
import kaffe.rmi.server.RMIHashes;
import kaffe.tools.compiler.Compiler;

public class RMIC {
    private String[] args;
    private int next;
    private Exception exception;
    private boolean keep = false;
    private boolean need11Stubs = true;
    private boolean need12Stubs = true;
    private boolean compile = true;
    private boolean verbose;
    private String destination;
    private PrintWriter out;
    private TabbedWriter ctrl;
    private Class clazz;
    private String classname;
    private String fullclassname;
    private MethodRef[] remotemethods;
    private String stubname;
    private String skelname;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$Exception;

    public static void main(String[] stringArray) {
        RMIC rMIC = new RMIC(stringArray);
        if (!rMIC.run()) {
            Exception exception = rMIC.getException();
            if (exception != null) {
                exception.printStackTrace();
            } else {
                RMIC.usage();
            }
        }
    }

    public boolean run() {
        this.parseOptions();
        if (this.next >= this.args.length) {
            return false;
        }
        int n = this.next;
        while (n < this.args.length) {
            try {
                if (this.verbose) {
                    System.out.println("[Processing class " + this.args[n] + ".class]");
                }
                this.processClass(this.args[n]);
            }
            catch (Exception exception) {
                this.exception = exception;
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean processClass(String string) throws Exception {
        this.analyzeClass(string);
        this.generateStub();
        if (this.need11Stubs) {
            this.generateSkel();
        }
        if (this.compile) {
            this.compile(this.stubname + ".java");
            if (this.need11Stubs) {
                this.compile(this.skelname + ".java");
            }
        }
        if (!this.keep) {
            new File(this.stubname + ".java").delete();
            if (this.need11Stubs) {
                new File(this.skelname + ".java").delete();
            }
        }
        return true;
    }

    private void analyzeClass(String string) throws Exception {
        Object object;
        int n = string.lastIndexOf(46);
        this.classname = n != -1 ? string.substring(n + 1) : string;
        this.fullclassname = string;
        HashSet<Object> hashSet = new HashSet<Object>();
        this.findClass();
        Class clazz = this.clazz;
        while (clazz != null) {
            if (clazz.getName().startsWith("java.")) break;
            object = clazz.getDeclaredMethods();
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                int n3 = ((Method)object[n2]).getModifiers();
                if (Modifier.isPublic(n3) && !Modifier.isStatic(n3)) {
                    hashSet.add(object[n2]);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        this.remotemethods = new MethodRef[hashSet.size()];
        int n4 = 0;
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.remotemethods[n4++] = new MethodRef((Method)object.next());
        }
        Arrays.sort(this.remotemethods);
    }

    public Exception getException() {
        return this.exception;
    }

    private void findClass() throws ClassNotFoundException {
        this.clazz = Class.forName(this.fullclassname);
    }

    private void generateStub() throws IOException {
        int n;
        Class<?>[] classArray;
        Method method;
        Class<?>[] classArray2;
        this.stubname = this.classname + "_Stub";
        this.ctrl = new TabbedWriter(new FileWriter(this.stubname + ".java"));
        this.out = new PrintWriter(this.ctrl);
        if (this.verbose) {
            System.out.println("[Generating class " + this.stubname + ".java]");
        }
        this.out.println("// Stub class generated by rmic - DO NOT EDIT!");
        this.out.println();
        if (this.fullclassname != this.classname) {
            classArray2 = this.fullclassname.substring(0, this.fullclassname.lastIndexOf(46));
            this.out.println("package " + (String)classArray2 + ";");
            this.out.println();
        }
        this.out.print("public final class " + this.stubname);
        this.ctrl.indent();
        this.out.println("extends java.rmi.server.RemoteStub");
        this.out.print("implements ");
        classArray2 = this.clazz.getInterfaces();
        int n2 = 0;
        while (n2 < classArray2.length) {
            this.out.print(classArray2[n2].getName());
            if (n2 + 1 < classArray2.length) {
                this.out.print(", ");
            }
            ++n2;
        }
        this.ctrl.unindent();
        this.out.print("{");
        this.ctrl.indent();
        if (this.need12Stubs) {
            this.out.println("private static final long serialVersionUID = 2L;");
            this.out.println();
        }
        if (this.need11Stubs) {
            this.out.println("private static final long interfaceHash = " + RMIHashes.getInterfaceHash(this.clazz) + "L;");
            this.out.println();
            if (this.need12Stubs) {
                this.out.println("private static boolean useNewInvoke;");
                this.out.println();
            }
            this.out.print("private static final java.rmi.server.Operation[] operations = {");
            this.ctrl.indent();
            n2 = 0;
            while (n2 < this.remotemethods.length) {
                method = this.remotemethods[n2].meth;
                this.out.print("new java.rmi.server.Operation(\"");
                this.out.print(RMIC.getPrettyName(method.getReturnType()) + " ");
                this.out.print(method.getName() + "(");
                classArray = method.getParameterTypes();
                n = 0;
                while (n < classArray.length) {
                    this.out.print(RMIC.getPrettyName(classArray[n]));
                    if (n + 1 < classArray.length) {
                        this.out.print(", ");
                    }
                    ++n;
                }
                this.out.print(")\")");
                if (n2 + 1 < this.remotemethods.length) {
                    this.out.println(",");
                }
                ++n2;
            }
            this.ctrl.unindent();
            this.out.println("};");
            this.out.println();
        }
        if (this.need12Stubs) {
            n2 = 0;
            while (n2 < this.remotemethods.length) {
                method = this.remotemethods[n2].meth;
                this.out.println("private static java.lang.reflect.Method $method_" + method.getName() + "_" + n2 + ";");
                ++n2;
            }
            this.out.println();
            this.out.print("static {");
            this.ctrl.indent();
            this.out.print("try {");
            this.ctrl.indent();
            if (this.need11Stubs) {
                this.out.println("java.rmi.server.RemoteRef.class.getMethod(\"invoke\", new java.lang.Class[] { java.rmi.Remote.class, java.lang.reflect.Method.class, java.lang.Object[].class, long.class });");
                this.out.println("useNewInvoke = true;");
            }
            n2 = 0;
            while (n2 < this.remotemethods.length) {
                method = this.remotemethods[n2].meth;
                this.out.print("$method_" + method.getName() + "_" + n2 + " = ");
                this.out.print(this.fullclassname + ".class.getMethod(\"" + method.getName() + "\"");
                this.out.print(", new java.lang.Class[] {");
                classArray = method.getParameterTypes();
                n = 0;
                while (n < classArray.length) {
                    this.out.print(RMIC.getPrettyName(classArray[n]) + ".class");
                    if (n + 1 < classArray.length) {
                        this.out.print(", ");
                    }
                    ++n;
                }
                this.out.println("});");
                ++n2;
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.lang.NoSuchMethodException e) {");
            this.ctrl.indent();
            if (this.need11Stubs) {
                this.out.print("useNewInvoke = false;");
            } else {
                this.out.print("throw new java.lang.NoSuchMethodError(\"stub class initialization failed\");");
            }
            this.ctrl.unindent();
            this.out.print("}");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.println();
        }
        if (this.need11Stubs) {
            this.out.print("public " + this.stubname + "() {");
            this.ctrl.indent();
            this.out.print("super();");
            this.ctrl.unindent();
            this.out.println("}");
        }
        if (this.need12Stubs) {
            this.out.print("public " + this.stubname + "(java.rmi.server.RemoteRef ref) {");
            this.ctrl.indent();
            this.out.print("super(ref);");
            this.ctrl.unindent();
            this.out.println("}");
        }
        n2 = 0;
        while (n2 < this.remotemethods.length) {
            method = this.remotemethods[n2].meth;
            classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            Class[] classArray3 = this.sortExceptions(method.getExceptionTypes());
            this.out.println();
            this.out.print("public " + RMIC.getPrettyName(clazz) + " " + method.getName() + "(");
            int n3 = 0;
            while (n3 < classArray.length) {
                this.out.print(RMIC.getPrettyName(classArray[n3]));
                this.out.print(" $param_" + n3);
                if (n3 + 1 < classArray.length) {
                    this.out.print(", ");
                }
                ++n3;
            }
            this.out.print(") ");
            this.out.print("throws ");
            n3 = 0;
            while (n3 < classArray3.length) {
                this.out.print(RMIC.getPrettyName(classArray3[n3]));
                if (n3 + 1 < classArray3.length) {
                    this.out.print(", ");
                }
                ++n3;
            }
            this.out.print(" {");
            this.ctrl.indent();
            this.out.print("try {");
            this.ctrl.indent();
            if (this.need12Stubs) {
                if (this.need11Stubs) {
                    this.out.print("if (useNewInvoke) {");
                    this.ctrl.indent();
                }
                if (clazz != Void.TYPE) {
                    this.out.print("java.lang.Object $result = ");
                }
                this.out.print("ref.invoke(this, $method_" + method.getName() + "_" + n2 + ", ");
                if (classArray.length == 0) {
                    this.out.print("null, ");
                } else {
                    this.out.print("new java.lang.Object[] {");
                    n3 = 0;
                    while (n3 < classArray.length) {
                        if (classArray[n3] == Boolean.TYPE) {
                            this.out.print("new java.lang.Boolean($param_" + n3 + ")");
                        } else if (classArray[n3] == Byte.TYPE) {
                            this.out.print("new java.lang.Byte($param_" + n3 + ")");
                        } else if (classArray[n3] == Character.TYPE) {
                            this.out.print("new java.lang.Character($param_" + n3 + ")");
                        } else if (classArray[n3] == Short.TYPE) {
                            this.out.print("new java.lang.Short($param_" + n3 + ")");
                        } else if (classArray[n3] == Integer.TYPE) {
                            this.out.print("new java.lang.Integer($param_" + n3 + ")");
                        } else if (classArray[n3] == Long.TYPE) {
                            this.out.print("new java.lang.Long($param_" + n3 + ")");
                        } else if (classArray[n3] == Float.TYPE) {
                            this.out.print("new java.lang.Float($param_" + n3 + ")");
                        } else if (classArray[n3] == Double.TYPE) {
                            this.out.print("new java.lang.Double($param_" + n3 + ")");
                        } else {
                            this.out.print("$param_" + n3);
                        }
                        if (n3 + 1 < classArray.length) {
                            this.out.print(", ");
                        }
                        ++n3;
                    }
                    this.out.print("}, ");
                }
                this.out.print(Long.toString(this.remotemethods[n2].hash) + "L");
                this.out.print(");");
                if (clazz != Void.TYPE) {
                    this.out.println();
                    this.out.print("return (");
                    if (clazz == Boolean.TYPE) {
                        this.out.print("((java.lang.Boolean)$result).booleanValue()");
                    } else if (clazz == Byte.TYPE) {
                        this.out.print("((java.lang.Byte)$result).byteValue()");
                    } else if (clazz == Character.TYPE) {
                        this.out.print("((java.lang.Character)$result).charValue()");
                    } else if (clazz == Short.TYPE) {
                        this.out.print("((java.lang.Short)$result).shortValue()");
                    } else if (clazz == Integer.TYPE) {
                        this.out.print("((java.lang.Integer)$result).intValue()");
                    } else if (clazz == Long.TYPE) {
                        this.out.print("((java.lang.Long)$result).longValue()");
                    } else if (clazz == Float.TYPE) {
                        this.out.print("((java.lang.Float)$result).floatValue()");
                    } else if (clazz == Double.TYPE) {
                        this.out.print("((java.lang.Double)$result).doubleValue()");
                    } else {
                        this.out.print("(" + RMIC.getPrettyName(clazz) + ")$result");
                    }
                    this.out.print(");");
                }
                if (this.need11Stubs) {
                    this.ctrl.unindent();
                    this.out.println("}");
                    this.out.print("else {");
                    this.ctrl.indent();
                }
            }
            if (this.need11Stubs) {
                this.out.println("java.rmi.server.RemoteCall call = ref.newCall((java.rmi.server.RemoteObject)this, operations, " + n2 + ", interfaceHash);");
                this.out.print("try {");
                this.ctrl.indent();
                this.out.print("java.io.ObjectOutput out = call.getOutputStream();");
                n3 = 0;
                while (n3 < classArray.length) {
                    this.out.println();
                    if (classArray[n3] == Boolean.TYPE) {
                        this.out.print("out.writeBoolean(");
                    } else if (classArray[n3] == Byte.TYPE) {
                        this.out.print("out.writeByte(");
                    } else if (classArray[n3] == Character.TYPE) {
                        this.out.print("out.writeChar(");
                    } else if (classArray[n3] == Short.TYPE) {
                        this.out.print("out.writeShort(");
                    } else if (classArray[n3] == Integer.TYPE) {
                        this.out.print("out.writeInt(");
                    } else if (classArray[n3] == Long.TYPE) {
                        this.out.print("out.writeLong(");
                    } else if (classArray[n3] == Float.TYPE) {
                        this.out.print("out.writeFloat(");
                    } else if (classArray[n3] == Double.TYPE) {
                        this.out.print("out.writeDouble(");
                    } else {
                        this.out.print("out.writeObject(");
                    }
                    this.out.print("$param_" + n3 + ");");
                    ++n3;
                }
                this.ctrl.unindent();
                this.out.println("}");
                this.out.print("catch (java.io.IOException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.MarshalException(\"error marshalling arguments\", e);");
                this.ctrl.unindent();
                this.out.println("}");
                this.out.println("ref.invoke(call);");
                if (clazz != Void.TYPE) {
                    this.out.println(RMIC.getPrettyName(clazz) + " $result;");
                }
                this.out.print("try {");
                this.ctrl.indent();
                this.out.print("java.io.ObjectInput in = call.getInputStream();");
                n3 = 0;
                if (clazz != Void.TYPE) {
                    this.out.println();
                    this.out.print("$result = ");
                    if (clazz == Boolean.TYPE) {
                        this.out.print("in.readBoolean();");
                    } else if (clazz == Byte.TYPE) {
                        this.out.print("in.readByte();");
                    } else if (clazz == Character.TYPE) {
                        this.out.print("in.readChar();");
                    } else if (clazz == Short.TYPE) {
                        this.out.print("in.readShort();");
                    } else if (clazz == Integer.TYPE) {
                        this.out.print("in.readInt();");
                    } else if (clazz == Long.TYPE) {
                        this.out.print("in.readLong();");
                    } else if (clazz == Float.TYPE) {
                        this.out.print("in.readFloat();");
                    } else if (clazz == Double.TYPE) {
                        this.out.print("in.readDouble();");
                    } else {
                        if (clazz != (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : RMIC.class$("java.lang.Object"))) {
                            this.out.print("(" + RMIC.getPrettyName(clazz) + ")");
                        } else {
                            n3 = 1;
                        }
                        this.out.print("in.readObject();");
                    }
                    this.out.println();
                    this.out.print("return ($result);");
                }
                this.ctrl.unindent();
                this.out.println("}");
                this.out.print("catch (java.io.IOException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                this.ctrl.unindent();
                this.out.println("}");
                if (n3 != 0) {
                    this.out.print("catch (java.lang.ClassNotFoundException e) {");
                    this.ctrl.indent();
                    this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                    this.ctrl.unindent();
                    this.out.println("}");
                }
                this.out.print("finally {");
                this.ctrl.indent();
                this.out.print("ref.done(call);");
                this.ctrl.unindent();
                this.out.print("}");
                if (this.need12Stubs && this.need11Stubs) {
                    this.ctrl.unindent();
                    this.out.print("}");
                }
            }
            this.ctrl.unindent();
            this.out.print("}");
            n3 = 1;
            int n4 = 0;
            while (n4 < classArray3.length) {
                this.out.println();
                this.out.print("catch (" + RMIC.getPrettyName(classArray3[n4]) + " e) {");
                this.ctrl.indent();
                this.out.print("throw e;");
                this.ctrl.unindent();
                this.out.print("}");
                if (classArray3[n4] == (class$Ljava$lang$Exception != null ? class$Ljava$lang$Exception : RMIC.class$("java.lang.Exception"))) {
                    n3 = 0;
                }
                ++n4;
            }
            if (n3 != 0) {
                this.out.println();
                this.out.print("catch (java.lang.Exception e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnexpectedException(\"undeclared checked exception\", e);");
                this.ctrl.unindent();
                this.out.print("}");
            }
            this.ctrl.unindent();
            this.out.print("}");
            this.out.println();
            ++n2;
        }
        this.ctrl.unindent();
        this.out.println("}");
        this.out.close();
    }

    private void generateSkel() throws IOException {
        int n;
        Class<?>[] classArray;
        Method method;
        this.skelname = this.classname + "_Skel";
        this.ctrl = new TabbedWriter(new FileWriter(this.skelname + ".java"));
        this.out = new PrintWriter(this.ctrl);
        if (this.verbose) {
            System.out.println("[Generating class " + this.skelname + ".java]");
        }
        this.out.println("// Skel class generated by rmic - DO NOT EDIT!");
        this.out.println();
        if (this.fullclassname != this.classname) {
            String string = this.fullclassname.substring(0, this.fullclassname.lastIndexOf(46));
            this.out.println("package " + string + ";");
            this.out.println();
        }
        this.out.print("public final class " + this.skelname);
        this.ctrl.indent();
        this.out.print("implements java.rmi.server.Skeleton");
        this.ctrl.unindent();
        this.out.print("{");
        this.ctrl.indent();
        this.out.println("private static final long interfaceHash = " + RMIHashes.getInterfaceHash(this.clazz) + "L;");
        this.out.println();
        this.out.print("private static final java.rmi.server.Operation[] operations = {");
        this.ctrl.indent();
        int n2 = 0;
        while (n2 < this.remotemethods.length) {
            method = this.remotemethods[n2].meth;
            this.out.print("new java.rmi.server.Operation(\"");
            this.out.print(RMIC.getPrettyName(method.getReturnType()) + " ");
            this.out.print(method.getName() + "(");
            classArray = method.getParameterTypes();
            n = 0;
            while (n < classArray.length) {
                this.out.print(RMIC.getPrettyName(classArray[n]));
                if (n + 1 < classArray.length) {
                    this.out.print(", ");
                }
                ++n;
            }
            this.out.print("\")");
            if (n2 + 1 < this.remotemethods.length) {
                this.out.println(",");
            }
            ++n2;
        }
        this.ctrl.unindent();
        this.out.println("};");
        this.out.println();
        this.out.print("public java.rmi.server.Operation[] getOperations() {");
        this.ctrl.indent();
        this.out.print("return ((java.rmi.server.Operation[]) operations.clone());");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.println();
        this.out.print("public void dispatch(java.rmi.Remote obj, java.rmi.server.RemoteCall call, int opnum, long hash) throws java.lang.Exception {");
        this.ctrl.indent();
        this.out.print("if (opnum < 0) {");
        this.ctrl.indent();
        n2 = 0;
        while (n2 < this.remotemethods.length) {
            this.out.print("if (hash == " + Long.toString(this.remotemethods[n2].hash) + "L) {");
            this.ctrl.indent();
            this.out.print("opnum = " + n2 + ";");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("else ");
            ++n2;
        }
        this.out.print("{");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.print("else if (hash != interfaceHash) {");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.println();
        this.out.println(this.fullclassname + " server = (" + this.fullclassname + ")obj;");
        this.out.println("switch (opnum) {");
        n2 = 0;
        while (n2 < this.remotemethods.length) {
            method = this.remotemethods[n2].meth;
            this.out.println("case " + n2 + ":");
            this.out.print("{");
            this.ctrl.indent();
            classArray = method.getParameterTypes();
            n = 0;
            while (n < classArray.length) {
                this.out.print(RMIC.getPrettyName(classArray[n]));
                this.out.println(" $param_" + n + ";");
                ++n;
            }
            this.out.print("try {");
            n = 0;
            this.ctrl.indent();
            this.out.println("java.io.ObjectInput in = call.getInputStream();");
            int n3 = 0;
            while (n3 < classArray.length) {
                this.out.print("$param_" + n3 + " = ");
                if (classArray[n3] == Boolean.TYPE) {
                    this.out.print("in.readBoolean();");
                } else if (classArray[n3] == Byte.TYPE) {
                    this.out.print("in.readByte();");
                } else if (classArray[n3] == Character.TYPE) {
                    this.out.print("in.readChar();");
                } else if (classArray[n3] == Short.TYPE) {
                    this.out.print("in.readShort();");
                } else if (classArray[n3] == Integer.TYPE) {
                    this.out.print("in.readInt();");
                } else if (classArray[n3] == Long.TYPE) {
                    this.out.print("in.readLong();");
                } else if (classArray[n3] == Float.TYPE) {
                    this.out.print("in.readFloat();");
                } else if (classArray[n3] == Double.TYPE) {
                    this.out.print("in.readDouble();");
                } else {
                    if (classArray[n3] != (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : RMIC.class$("java.lang.Object"))) {
                        this.out.print("(" + RMIC.getPrettyName(classArray[n3]) + ")");
                        n = 1;
                    }
                    this.out.print("in.readObject();");
                }
                this.out.println();
                ++n3;
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.io.IOException e) {");
            this.ctrl.indent();
            this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
            this.ctrl.unindent();
            this.out.println("}");
            if (n != 0) {
                this.out.print("catch (java.lang.ClassCastException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
                this.ctrl.unindent();
                this.out.println("}");
            }
            this.out.print("finally {");
            this.ctrl.indent();
            this.out.print("call.releaseInputStream();");
            this.ctrl.unindent();
            this.out.println("}");
            Class<?> clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                this.out.print(RMIC.getPrettyName(clazz) + " $result = ");
            }
            this.out.print("server." + method.getName() + "(");
            int n4 = 0;
            while (n4 < classArray.length) {
                this.out.print("$param_" + n4);
                if (n4 + 1 < classArray.length) {
                    this.out.print(", ");
                }
                ++n4;
            }
            this.out.println(");");
            this.out.print("try {");
            this.ctrl.indent();
            this.out.print("java.io.ObjectOutput out = call.getResultStream(true);");
            if (clazz != Void.TYPE) {
                this.out.println();
                if (clazz == Boolean.TYPE) {
                    this.out.print("out.writeBoolean($result);");
                } else if (clazz == Byte.TYPE) {
                    this.out.print("out.writeByte($result);");
                } else if (clazz == Character.TYPE) {
                    this.out.print("out.writeChar($result);");
                } else if (clazz == Short.TYPE) {
                    this.out.print("out.writeShort($result);");
                } else if (clazz == Integer.TYPE) {
                    this.out.print("out.writeInt($result);");
                } else if (clazz == Long.TYPE) {
                    this.out.print("out.writeLong($result);");
                } else if (clazz == Float.TYPE) {
                    this.out.print("out.writeFloat($result);");
                } else if (clazz == Double.TYPE) {
                    this.out.print("out.writeDouble($result);");
                } else {
                    this.out.print("out.writeObject($result);");
                }
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.io.IOException e) {");
            this.ctrl.indent();
            this.out.print("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("break;");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.println();
            ++n2;
        }
        this.out.print("default:");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.UnmarshalException(\"invalid method number\");");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.close();
    }

    private void compile(String string) throws Exception {
        Compiler compiler = Compiler.getInstance();
        if (this.verbose) {
            System.out.println("[Compiling class " + string + "]");
        }
        compiler.setDestination(this.destination);
        boolean bl = compiler.compile(string);
        if (!bl) {
            throw compiler.getException();
        }
    }

    private static String getPrettyName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (!clazz.isArray()) {
                stringBuffer.append(clazz.getName());
                while (n > 0) {
                    stringBuffer.append("[]");
                    --n;
                }
                return stringBuffer.toString();
            }
            clazz = clazz.getComponentType();
            ++n;
        }
    }

    private Class[] sortExceptions(Class[] classArray) {
        int n = 0;
        while (n < classArray.length) {
            int n2 = n + 1;
            while (n2 < classArray.length) {
                if (classArray[n].isAssignableFrom(classArray[n2])) {
                    Class clazz = classArray[n];
                    classArray[n] = classArray[n2];
                    classArray[n2] = clazz;
                }
                ++n2;
            }
            ++n;
        }
        return classArray;
    }

    private void parseOptions() {
        while (this.next < this.args.length && this.args[this.next].charAt(0) == '-') {
            String string = this.args[this.next];
            ++this.next;
            if (string.equals("-keep")) {
                this.keep = true;
                continue;
            }
            if (string.equals("-keepgenerated")) {
                this.keep = true;
                continue;
            }
            if (string.equals("-v1.1")) {
                this.need11Stubs = true;
                this.need12Stubs = false;
                continue;
            }
            if (string.equals("-vcompat")) {
                this.need11Stubs = true;
                this.need12Stubs = true;
                continue;
            }
            if (string.equals("-v1.2")) {
                this.need11Stubs = false;
                this.need12Stubs = true;
                continue;
            }
            if (string.equals("-g") || string.equals("-depend") || string.equals("-nowarn")) continue;
            if (string.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (string.equals("-nocompile")) {
                this.compile = false;
                continue;
            }
            if (string.equals("-classpath")) {
                ++this.next;
                continue;
            }
            if (string.equals("-d")) {
                this.destination = this.args[this.next];
                ++this.next;
                continue;
            }
            if (string.charAt(1) == 'J') continue;
            System.err.println("Unknown option: " + string);
        }
    }

    private static void usage() {
        System.out.println("usage: rmic [-options] classes\nOptions are:\n\t-keep \t\t\tDon't delete any intermediate files\n\t-keepgenerated \t\tSame as -keep\n\t-v1.1\t\t\tJava 1.1 style stubs only\n\t-vcompat\t\tJava 1.1 & Java 1.2 stubs\n\t-v1.2\t\t\tJava 1.2 style stubs only\n\t-g *\t\t\tGenerated debugging information\n\t-depend *\t\tRecompile out-of-date files\n\t-nowarn\t*\t\tSuppress warning messages\n\t-nocompile\t\tDon't compile the generated files\n\t-verbose \t\tOutput what's going on\n\t-classpath <path> *\tUse given path as classpath\n\t-d <directory> \t\tSpecify where to place generated classes\n\t-J<flag> *\t\tPass flag to Java\n  * Option currently ignored");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public RMIC(String[] stringArray) {
        this.args = stringArray;
    }

    static class MethodRef
    implements Comparable {
        Method meth;
        String sig;
        long hash;

        public int compareTo(Object object) {
            MethodRef methodRef = (MethodRef)object;
            return this.sig.compareTo(methodRef.sig);
        }

        MethodRef(Method method) {
            this.meth = method;
            this.sig = method.getName();
            this.hash = RMIHashes.getMethodHash(method);
        }
    }
}

