/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Parser;

public abstract class ScopeExp
extends Expression {
    Declaration decls;
    Declaration last;
    Scope scope = new Scope();
    public ScopeExp outer;

    public void add(Declaration declaration) {
        if (this.last == null) {
            this.decls = declaration;
        } else {
            this.last.next = declaration;
        }
        this.last = declaration;
    }

    public final void addDeclaration(Declaration declaration) {
        this.add(declaration);
        declaration.context = this;
    }

    public final Declaration addDeclaration(String string) {
        Declaration declaration = new Declaration(string);
        this.addDeclaration(declaration);
        return declaration;
    }

    public final Declaration addDeclaration(String string, Type type) {
        Declaration declaration = new Declaration(string);
        this.addDeclaration(declaration);
        declaration.setType(type);
        return declaration;
    }

    public int countDecls() {
        int n = 0;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            ++n;
            declaration = declaration.nextDecl();
        }
        return n;
    }

    public LambdaExp currentLambda() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof LambdaExp) {
                return (LambdaExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public final Declaration firstDecl() {
        return this.decls;
    }

    public Declaration getDefine(String string, char c, Parser parser) {
        Declaration declaration = this.lookup(string);
        if (declaration == null) {
            declaration = this.addDeclaration(string);
        } else if (declaration.getFlag(512)) {
            declaration.setFlag(false, 512);
        } else {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("duplicate definition for '");
            stringBuffer.append(string);
            int n = declaration.getLine();
            if (n <= 0) {
                stringBuffer.append('\'');
            } else {
                stringBuffer.append("' (overrides ");
                String string2 = declaration.getFile();
                if (string2 == null || string2.equals(parser.getFile())) {
                    stringBuffer.append("line ");
                } else {
                    stringBuffer.append(string2);
                    stringBuffer.append(':');
                }
                stringBuffer.append(n);
                int n2 = declaration.getColumn();
                if (n2 > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(n2);
                }
                stringBuffer.append(')');
            }
            parser.error(c, stringBuffer.toString());
            declaration = this.addDeclaration(string);
        }
        return declaration;
    }

    public Declaration getNoDefine(String string) {
        Declaration declaration = this.lookup(string);
        if (declaration == null) {
            declaration = this.addDeclaration(string);
            declaration.setFlag(512);
        }
        return declaration;
    }

    public Declaration lookup(String string) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration.name == string) {
                return declaration;
            }
            declaration = declaration.nextDecl();
        }
        return null;
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkScopeExp(this);
    }
}

