/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;
import gnu.mapping.Values;
import java.lang.reflect.Field;

public class StaticSet
extends Procedure1
implements Inlineable {
    ClassType ctype;
    String fname;
    gnu.bytecode.Field field;
    Field reflectField;

    public StaticSet(ClassType classType, String string, Type type, int n) {
        this.ctype = classType;
        this.fname = string;
        this.field = classType.getField(string);
        if (this.field == null) {
            this.field = classType.addField(string, type, n);
        }
    }

    StaticSet(Class clazz, String string) {
        this.ctype = (ClassType)Type.make(clazz);
        this.fname = string;
    }

    public Object apply1(Object object2) {
        if (this.reflectField == null) {
            Class clazz = this.ctype.getReflectClass();
            try {
                this.reflectField = clazz.getField(this.fname);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException("no such field " + this.fname + " in " + clazz.getName());
            }
        }
        try {
            this.reflectField.set(null, object2);
            return Values.empty;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("illegal access for field " + this.fname);
        }
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        if (this.field == null) {
            this.field = this.ctype.getField(this.fname);
            if (this.field == null) {
                this.field = this.ctype.addField(this.fname, Type.make(this.reflectField.getType()), this.reflectField.getModifiers());
            }
        }
        applyExp.getArgs()[0].compile(compilation, this.field.getType());
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitPutStatic(this.field);
        compilation.compileConstant(Values.empty, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.void_type;
    }
}

