/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.Parser;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.kawa.util.LList;
import gnu.kawa.util.Pair;
import gnu.kawa.util.PairWithPosition;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import gnu.text.SourceMessages;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Syntax;

public class Translator
extends Parser {
    public Environment environ;
    public boolean immediate;
    private static Expression errorExp = new ErrorExp("unknown syntax error");
    private Environment env;
    Syntax currentSyntax;
    ModuleExp module;
    Stack shadowStack = new Stack();

    public Translator() {
        this(Environment.user());
    }

    public Translator(Environment environment) {
        super(new SourceMessages());
        this.env = environment;
        this.environ = new Environment();
    }

    public Translator(Environment environment, SourceMessages sourceMessages) {
        super(sourceMessages);
        this.env = environment;
        this.environ = new Environment();
    }

    public void addGlobal(String string, Object object2) {
        this.env.put(string, object2);
    }

    Expression apply_rewrite(Syntax syntax2, Pair pair) {
        Expression expression = errorExp;
        Syntax syntax3 = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            expression = syntax2.rewriteForm(pair, this);
        }
        finally {
            Object var6_5 = null;
            this.currentSyntax = syntax3;
        }
        return expression;
    }

    public Syntax check_if_Syntax(Object object2) {
        if ((object2 = this.getBinding(object2)) instanceof Syntax) {
            return (Syntax)object2;
        }
        return null;
    }

    public void finishModule(ModuleExp moduleExp, Vector vector) {
        Expression expression;
        boolean bl = moduleExp.isStatic();
        Declaration declaration = moduleExp.firstDecl();
        while (declaration != null) {
            if (declaration.getFlag(512)) {
                String string = "'";
                String string2 = declaration.getFlag(1024) ? "' exported but never defined" : (declaration.getFlag(2048) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', declaration, string, string2);
            }
            if (moduleExp.getFlag(1024)) {
                if (declaration.getFlag(1024)) {
                    if (declaration.isPrivate()) {
                        this.error('e', declaration, "'", "' is declared both private and exported");
                        declaration.setPrivate(false);
                    }
                } else {
                    declaration.setPrivate(true);
                }
            }
            if (bl) {
                declaration.setFlag(2048);
            } else if (moduleExp.getFlag(4096) && !declaration.getFlag(2048) || Compilation.moduleStatic < 0 || moduleExp.getFlag(8192)) {
                declaration.setFlag(4096);
            }
            declaration = declaration.nextDecl();
        }
        if (!bl) {
            moduleExp.declareThis(null);
        }
        this.module = moduleExp;
        int n = vector.size();
        int n2 = moduleExp.countDecls();
        this.pushDecls(moduleExp);
        if (n == 1) {
            expression = this.rewrite(vector.elementAt(0));
        } else if (n == 0) {
            expression = QuoteExp.voidExp;
        } else {
            Expression[] expressionArray = new Expression[n];
            int n3 = 0;
            while (n3 < n) {
                expressionArray[n3] = this.rewrite(vector.elementAt(n3));
                ++n3;
            }
            expression = new BeginExp(expressionArray);
        }
        moduleExp.body = expression;
        this.pop(moduleExp);
    }

    Object getBinding(Object object2) {
        if (object2 instanceof String) {
            Expression expression;
            String string = (String)object2;
            Binding binding = this.environ.lookup(string);
            if (binding == null) {
                binding = this.env.lookup(string);
            }
            if ((object2 = binding == null ? null : binding.getFunctionValue()) instanceof Syntax) {
                return object2;
            }
            if (object2 instanceof Declaration && (expression = ((Declaration)object2).getValue()) instanceof QuoteExp) {
                return ((QuoteExp)expression).getValue();
            }
            binding = null;
            if (object2 != null) {
                if (object2 instanceof String) {
                    binding = this.env.lookup((String)object2);
                } else if (object2 instanceof Declaration && !this.isLexical((Declaration)object2)) {
                    object2 = null;
                }
            } else {
                binding = this.env.lookup(string);
            }
            if (binding != null && binding.isBound()) {
                return binding.get();
            }
            return null;
        }
        return object2;
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public final ModuleExp getModule() {
        return this.module;
    }

    public boolean isLexical(Declaration declaration) {
        if (declaration == null) {
            return false;
        }
        if (!declaration.isFluid()) {
            return true;
        }
        ScopeExp scopeExp = this.currentScope();
        ScopeExp scopeExp2 = declaration.getContext();
        while (scopeExp != null) {
            if (scopeExp == scopeExp2) {
                return true;
            }
            if (scopeExp instanceof LambdaExp && !((LambdaExp)scopeExp).getInlineOnly()) {
                return false;
            }
            scopeExp = scopeExp.outer;
        }
        return false;
    }

    public static Pair makePair(Pair pair, Object object2, Object object3) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, object2, object3);
        }
        return new Pair(object2, object3);
    }

    public Expression parse(Object object2) {
        return this.rewrite(object2);
    }

    public boolean popBinding() {
        Object e = this.shadowStack.pop();
        if (e == null) {
            return false;
        }
        Object e2 = this.shadowStack.pop();
        if (e2 == null) {
            this.environ.remove(e);
        } else {
            this.environ.put(e, e2);
        }
        return true;
    }

    public void pushBinding(String string, Object object2) {
        Object object3 = this.environ.put(string, object2);
        this.shadowStack.push(object3);
        this.shadowStack.push(string);
    }

    public Expression rewrite(Object object2) {
        if (object2 instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, (PairWithPosition)object2);
        }
        if (object2 instanceof Pair) {
            return this.rewrite_pair((Pair)object2);
        }
        if (object2 instanceof String) {
            String string = (String)object2;
            Object object3 = this.environ.get(string);
            boolean bl = this.getInterpreter().hasSeparateFunctionNamespace();
            Declaration declaration = null;
            if (object3 != null && object3 instanceof String) {
                string = (String)object3;
            } else if (object3 instanceof Declaration && (!this.isLexical(declaration = (Declaration)object3) || bl && declaration.isProcedureDecl())) {
                declaration = null;
            }
            ReferenceExp referenceExp = new ReferenceExp(string, declaration);
            if (bl) {
                referenceExp.setFlag(ReferenceExp.PREFER_BINDING2);
            }
            return referenceExp;
        }
        if (object2 instanceof Expression) {
            return (Expression)object2;
        }
        return new QuoteExp(object2);
    }

    public Expression rewrite_body(Object object2) {
        Vector vector = new Vector(20);
        LetExp letExp = new LetExp(null);
        if (!this.scan_body(object2, vector, letExp)) {
            return new ErrorExp("error while scanning in body");
        }
        return this.rewrite_body(vector, letExp);
    }

    public Expression rewrite_body(Vector vector, LetExp letExp) {
        Object object2;
        int n = vector.size();
        if (n == 0) {
            return this.syntaxError("body with no expressions");
        }
        int n2 = letExp.countDecls();
        if (n2 != 0) {
            object2 = new Expression[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                object2[n3] = QuoteExp.nullExp;
            }
            letExp.inits = object2;
            this.push(letExp);
        }
        if (n == 1) {
            object2 = this.rewrite(vector.elementAt(0));
        } else {
            Expression[] expressionArray = new Expression[n];
            int n4 = 0;
            while (n4 < n) {
                expressionArray[n4] = this.rewrite(vector.elementAt(n4));
                ++n4;
            }
            object2 = new BeginExp(expressionArray);
        }
        if (n2 == 0) {
            return object2;
        }
        letExp.body = object2;
        this.pop(letExp);
        return letExp;
    }

    final Expression rewrite_car(Pair pair) {
        Object object2 = pair.car;
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, (PairWithPosition)pair);
        }
        return this.rewrite(object2);
    }

    public Expression rewrite_pair(Pair pair) {
        Object object2;
        Expression expression;
        block23: {
            Printable printable;
            Object object3;
            block24: {
                Syntax syntax2 = this.check_if_Syntax(pair.car);
                if (syntax2 != null) {
                    return this.apply_rewrite(syntax2, pair);
                }
                Object object4 = pair.cdr;
                expression = this.rewrite_car(pair);
                object3 = null;
                ReferenceExp referenceExp = null;
                if (expression instanceof ReferenceExp) {
                    referenceExp = (ReferenceExp)expression;
                    Declaration declaration = referenceExp.getBinding();
                    if (declaration == null) {
                        object2 = referenceExp.getName();
                        Binding binding = this.env.lookup((String)object2);
                        if (binding != null) {
                            object3 = binding.getFunctionValue();
                        }
                        if (object3 instanceof Syntax) {
                            return this.apply_rewrite((Syntax)object3, pair);
                        }
                        if (object3 instanceof AutoloadProcedure) {
                            try {
                                object3 = ((AutoloadProcedure)object3).getLoaded();
                            }
                            catch (RuntimeException runtimeException) {
                                object3 = null;
                            }
                        }
                        if (object3 instanceof Inlineable) {
                            expression = new QuoteExp(object3);
                        }
                    } else if (declaration instanceof Syntax) {
                        return this.apply_rewrite((Syntax)declaration, pair);
                    }
                }
                int n = LList.length(object4);
                if (expression instanceof QuoteExp && (object3 = ((QuoteExp)expression).getValue()) instanceof Procedure && (object2 = WrongArguments.checkArgCount((Procedure)object3, n)) != null) {
                    return this.syntaxError((String)object2);
                }
                object2 = new Expression[n];
                int n2 = 0;
                while (n2 < n) {
                    printable = (Pair)object4;
                    object2[n2] = this.rewrite_car((Pair)printable);
                    object4 = printable.cdr;
                    ++n2;
                }
                if (object3 == null || !(object3 instanceof Procedure) || object3 instanceof Inlineable) break block23;
                if (!(object3 instanceof AutoloadProcedure)) break block24;
                try {
                    object3 = ((AutoloadProcedure)object3).getLoaded();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace(System.err);
                    break block23;
                }
                if (object3 == null || !(object3 instanceof Procedure) || object3 instanceof Inlineable) break block23;
            }
            if ((printable = PrimProcedure.getMethodFor((Procedure)object3, object2)) != null) {
                expression = new QuoteExp(printable);
            }
        }
        if (expression instanceof ReferenceExp) {
            ((ReferenceExp)expression).setProcedureName(true);
            if (this.getInterpreter().hasSeparateFunctionNamespace()) {
                expression.setFlag(ReferenceExp.PREFER_BINDING2);
            }
        }
        return new ApplyExp(expression, (Expression[])object2);
    }

    public Expression rewrite_with_position(Object object2, PairWithPosition pairWithPosition) {
        Expression expression;
        int n;
        int n2;
        String string;
        block3: {
            string = this.current_filename;
            n2 = this.current_line;
            n = this.current_column;
            try {
                String string2 = pairWithPosition.getFile();
                int n3 = pairWithPosition.getLine();
                int n4 = pairWithPosition.getColumn();
                this.current_filename = string2;
                this.current_line = n3;
                this.current_column = n4;
                expression = object2 == pairWithPosition ? this.rewrite_pair(pairWithPosition) : this.rewrite(object2);
                if (expression.getFile() == null) {
                    expression.setFile(string2);
                }
                if (expression.getLine() != 0) break block3;
                expression.setLine(n3, n4);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.current_filename = string;
                this.current_line = n2;
                this.current_column = n;
                throw throwable;
            }
        }
        Object var8_10 = null;
        this.current_filename = string;
        this.current_line = n2;
        this.current_column = n;
        return expression;
    }

    public boolean scan_body(Object object2, Vector vector, ScopeExp scopeExp) {
        boolean bl = true;
        while (object2 != LList.Empty) {
            if (!(object2 instanceof Pair)) {
                vector.addElement(this.syntaxError("body is not a proper list"));
                return false;
            }
            Pair pair = (Pair)object2;
            Object object3 = pair.car;
            if (!this.scan_form(object3, vector, scopeExp)) {
                bl = false;
            }
            object2 = pair.cdr;
        }
        return bl;
    }

    boolean scan_form(Object object2, Vector vector, ScopeExp scopeExp) {
        if (!(object2 instanceof Pair)) {
            vector.addElement(object2);
        } else {
            Pair pair = (Pair)object2;
            Object object3 = pair.car;
            Syntax syntax2 = this.check_if_Syntax(object3);
            if (syntax2 == null) {
                vector.addElement(object2);
            } else {
                String string = this.current_filename;
                int n = this.current_line;
                int n2 = this.current_column;
                try {
                    this.setLine(pair);
                    if (!syntax2.scanForDefinitions(pair, vector, scopeExp, this)) {
                        boolean bl = false;
                        Object var12_11 = null;
                        this.current_filename = string;
                        this.current_line = n;
                        this.current_column = n2;
                        return bl;
                    }
                    Object var12_12 = null;
                    this.current_filename = string;
                    this.current_line = n;
                    this.current_column = n2;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    this.current_filename = string;
                    this.current_line = n;
                    this.current_column = n2;
                    throw throwable;
                }
            }
        }
        return true;
    }

    public static void setLine(Declaration declaration, Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            declaration.setFile(pairWithPosition.getFile());
            declaration.setLine(pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public void setLine(Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            this.setLine(pairWithPosition.getFile(), pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public Expression syntaxError(String string) {
        this.error('e', string);
        return new ErrorExp(string);
    }
}

