.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\"
.\" $XFree86: xc/doc/man/X11/XmbDTxt.man,v 1.4 2003/04/28 22:17:58 herrb Exp $
.\" $XdotOrg: xc/doc/man/X11/XmbDTxt.man,v 1.1.4.2.2.2 2004/03/29 15:45:29 ago Exp $
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XmbDrawText 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XmbDrawText, XwcDrawText, Xutf8DrawText \- draw text using multiple font sets 
.SH SYNTAX
.HP
void XmbDrawText\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^, XmbTextItem *\fIitems\fP\^, int
\fInitems\fP\^); 
.HP
void XwcDrawText\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^, XwcTextItem *\fIitems\fP\^, int
\fInitems\fP\^); 
.HP
void Xutf8DrawText\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^, XmbTextItem *\fIitems\fP\^, int \fInitems\fP\^);
.SH ARGUMENTS
.IP \fId\fP 1i
Specifies the drawable. 
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fIitems\fP 1i
Specifies an array of text items.
.IP \fInitems\fP 1i
Specifies the number of text items in the array.
.ds Xy
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
The
.ZN XmbDrawText ,
.ZN XwcDrawText 
and 
.ZN Xutf8DrawText 
functions allow complex spacing and font set shifts between text strings.
Each text item is processed in turn, with the origin of a text
element advanced in the primary draw direction by the escapement of the
previous text item.
A text item delta specifies an additional escapement of the text item
drawing origin in the primary draw direction.
A font_set member other than 
.ZN None
in an item causes the font set to be used for this and subsequent text items
in the text_items list.
Leading text items with a font_set member set to
.ZN None
will not be drawn.
.LP
.ZN XmbDrawText ,
.ZN XwcDrawText
and
.ZN Xutf8DrawText
do not perform any context-dependent rendering between text segments.
Clients may compute the drawing metrics by passing each text segment to
.ZN XmbTextExtents ,
.ZN XwcTextExtents ,
.ZN Xutf8TextExtents
or
.ZN XmbTextPerCharExtents ,
.ZN XwcTextPerCharExtents .
.ZN Xutf8TextPerCharExtents .
When the 
.ZN XFontSet
has missing charsets, each unavailable character is drawn 
with the default string returned by 
.ZN XCreateFontSet .
The behavior for an invalid codepoint is undefined.
.LP
The function
.ZN Xutf8DrawText
is an extension introduced by The XFree86 Project, Inc. in their 4.0.2
release. Its presence is
indicated by the macro
.ZN X_HAVE_UTF8_STRING .
.SH STRUCTURES
The
.ZN XmbTextItem
structure contains:
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	char *chars;	/\(** pointer to string */
	int nchars;	/\(** number of bytes */
	int delta;	/\(** pixel delta between strings */
	XFontSet font_set; 	/\(** fonts, None means don't change */
} XmbTextItem;
.De
The
.ZN XwcTextItem
structure contains:
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	wchar_t *chars;	/\(** pointer to wide char string */
	int nchars;	/\(** number of wide characters */
	int delta;	/\(** pixel delta between strings */
	XFontSet font_set;	/\(** fonts, None means don't change */
} XwcTextItem;
.De
.SH "SEE ALSO"
XDrawImageString(3X11),
XDrawString(3X11),
XDrawText(3X11),
XmbDrawImageString(3X11),
XmbDrawString(3X11)
.br
\fI\*(xL\fP
