#!/bin/sh

PWD="`pwd`"
SRCDIR="antiword-0.34"

# Prepare
tar -xzf antiword-0.34.tar.gz
cd "${SRCDIR}"
patch -p1<../antiword-0.34-1.patch
ln -sf Makefile.Cygwin Makefile
cp ../*.ico CYGWIN-PATCHES/
mkdir .inst
DESTDIR="${PWD}/antiword-0.34/.inst"

# Build
make
make DESTDIR="${DESTDIR}" global_install

# Docs
mkdir -p "${DESTDIR}/usr/share/doc/antiword-0.34/"
/bin/install -c -m 644 \
	Docs/antiword.php \
	Docs/ChangeLog \
	Docs/COPYING \
	Docs/Emacs \
	Docs/Exmh \
	Docs/FAQ \
	Docs/History \
	Docs/Mozilla \
	Docs/Mutt \
	Docs/Netscape \
	Docs/QandA \
	Docs/ReadMe \
	Docs/testdoc.doc \
	"${DESTDIR}/usr/share/doc/antiword-0.34/"
mkdir -p "${DESTDIR}/usr/share/doc/Cygwin"
/bin/install -c -m 644 CYGWIN-PATCHES/README \
	"${DESTDIR}/usr/share/doc/Cygwin/antiword-0.34-1.README"

# Package
(cd "${DESTDIR}"; tar cjvf "${PWD}/antiword-0.34-1.tar.bz2" usr/ )

# Source package
cd ${PWD}
tar cjvf antiword-0.34-1-src.tar.bz2 antiword-0.34-1.patch antiword-0.34-1.sh antiword-0.34.tar.gz *.ico

# Finish
rm -rf antiword-0.34/
