#! /bin/sh
SRCDIR=$1
BUILDDIR=$2
scriptname=$3
cp ${BUILDDIR}/fragments/top.frag ${scriptname}

(while read LINE ; do \
  if [ -e ${SRCDIR}/options/${LINE}.var ] ; then
    cat ${SRCDIR}/options/${LINE}.var >> ${scriptname} ;\
  fi ;\
done
) < ${SRCDIR}/${scriptname}.options

cat ${SRCDIR}/fragments/args_top.frag >> ${scriptname}

(while read LINE ; do \
  if [ -e ${SRCDIR}/options/${LINE}.option ] ; then
    cat ${SRCDIR}/options/${LINE}.option >> ${scriptname} ;\
  fi
done
) < ${SRCDIR}/${scriptname}.options

cat ${SRCDIR}/fragments/args_bot.frag >> ${scriptname}

(while read LINE ; do \
  if [ -e ${SRCDIR}/options/${LINE}.finish ] ; then
    cat ${SRCDIR}/options/${LINE}.finish >> ${scriptname} ;\
  fi
done
) < ${SRCDIR}/${scriptname}.options

case ${scriptname} in
  aclocal)
    cat ${SRCDIR}/fragments/check_zero_args.frag >> ${scriptname}
    ;;
  *) ;;
esac

#cat ${SRCDIR}/fragments/trap.frag >> ${scriptname}

case ${scriptname} in
  NOTUSED)
    cat ${SRCDIR}/fragments/tmpdir_pre.frag >> ${scriptname}
    ;;
  *) ;;
esac

cat ${SRCDIR}/fragments/ver-shortcut.frag | \
  sed -e "s,@PROGRAM@,${scriptname},g" >> ${scriptname}

if [ -e ${SRCDIR}/fragments/core-${scriptname}.frag ] ; then
  infile=${SRCDIR}/fragments/core-${scriptname}.frag ;
else
  infile=${SRCDIR}/fragments/core.frag ;
fi
cat ${infile} | sed -e "s,@PROGRAM@,${scriptname},g" >> ${scriptname}

case ${scriptname} in
  NOTUSED)
    cat ${SRCDIR}/fragments/stdin_copy.frag >> ${scriptname}
    ;;
  *) ;;
esac

cat ${SRCDIR}/fragments/setpath.frag | \
  sed -e "s,@PROGRAM@,${scriptname},g" >> ${scriptname}

cat ${SRCDIR}/fragments/exec-${scriptname}.frag >> ${scriptname}

chmod +x ${scriptname}

