//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end

// ================================================================
// This variable allows the header version
// to be queried at runtime.
// ================================================================
namespace {
  char ccdoc_rcsid[] = "$Id: strmgr.cc,v 1.6 2004/09/30 04:16:07 jlinoff Exp $";
}

#include "strmgr.h"

// ================================================================
// Constructor.
// ================================================================
ccdoc::strmgr::strmgr() {
  m_mapped = false;
}
// ================================================================
// Destructor.
// ================================================================
ccdoc::strmgr::~strmgr() {
}
// ================================================================
// Retrieve
// ================================================================
const string& ccdoc::strmgr::get(const string& key) {
  str_coll_itr i = m_strmap.find(key);
  if( i == m_strmap.end() ) {
    // Not found, add it.
    pair<string,unsigned> p(key,0);
    m_strmap.insert( p );
    i = m_strmap.find(key);
    m_mapped = false;
  }
  return (*i).first;
}
// ================================================================
// Get index.
// ================================================================
unsigned ccdoc::strmgr::get_idx(const string key) {
  gen_maps();
  str_coll_itr i = m_strmap.find(key);
  return (*i).second;
}
// ================================================================
// Get by index.
// ================================================================
const string& ccdoc::strmgr::get_by_idx(unsigned key) {
  gen_maps();
  idx_coll_itr i = m_idxmap.find(key);
  ccdoc_assert( i != m_idxmap.end() );
  return *((*i).second);
}
// ================================================================
// Generate the xref maps.
// ================================================================
void ccdoc::strmgr::gen_maps() {
  if(!m_mapped) {
    m_idxmap.clear();

    // Assign the index values.
    str_coll tmp;
    str_coll_itr i = m_strmap.begin();
    str_coll_itr e = m_strmap.end();
    for(unsigned idx=0;i!=e;++i,++idx) {
      pair<const string,unsigned>& p = *i;
      p.second = idx;
    }
    
    // Map the string data.
    i = m_strmap.begin();
    e = m_strmap.end();
    for(;i!=e;++i) {
      m_idxmap.insert( make_pair( (*i).second, &((*i).first) ) );
    }
    m_mapped = true;
  }
}


