#
# AC_DIR_INIT - locate the /etc/rc.d directory, which contains
# the init.d directory.  Defines the directory
# as INIT_DIR, which is substituted in the output files.
#
AC_DEFUN(AC_DIR_INIT,
[
  AC_MSG_CHECKING(for location of init.d directory)

  AC_ARG_WITH(init-dir,
	[  --with-init-dir=PATH    absolute path of init.d directory])

  # default to /etc/rc.d
  INIT_DIR=/etc/rc.d/init.d
  # list dirs in reverse order of preference
  for a in /sbin /etc /etc/rc.d ; do
	if (test -d $a/init.d); then
		INIT_DIR="$a/init.d";
	fi
  done
  test -z "$with_init_dir" || INIT_DIR=$with_init_dir
  
  AC_MSG_RESULT($INIT_DIR)
  AC_SUBST(INIT_DIR)dnl
])

#
# AC_DIR_RC - locate the /etc/rc.d directory, which contains
# the rc?.d directories.  Defines the directory as RC_DIR,
# which is substituted in the output files.
#
AC_DEFUN(AC_DIR_RC,
[
  AC_MSG_CHECKING(for location of rc.d directories)

  AC_ARG_WITH(rc-dir,
	[  --with-rc-dir=PATH      absolute path of rc.d directory])

  # default to /etc/rc.d
  RC_DIR=/etc/rc.d
  # list dirs in reverse order of preference
  for a in /sbin/init.d /etc /etc/rc.d ; do
	if (test -d $a/rc3.d); then
		RC_DIR=$a;
	fi
  done
  test -z "$with_rc_dir" || RC_DIR=$with_rc_dir
  
  AC_MSG_RESULT($RC_DIR)
  AC_SUBST(RC_DIR)dnl
])


#
# AC_DIR_XINETD - locate the /etc/xinetd.d directory.
# Defines the directory as XINETD_DIR, which is substituted in the output files.
#
AC_DEFUN(AC_DIR_XINETD,
[
  AC_MSG_CHECKING(for location of xinetd.d directory)

  AC_ARG_WITH(xinetd-d,
	[  --with-xinetd-dir=PATH  absolute path of xinetd.d directory])

  # default to /etc/xinetd.d
  XINETD_DIR="/etc/xinetd.d"
  # list dirs in reverse order of preference
  for a in /usr/local/etc /etc; do
	if (test -d "$a/xinetd.d"); then
		XINETD_DIR="$a/xinetd.d";
	fi
  done
  test -z "$with_xinetd_d" || XINETD_DIR=$with_xinetd_d
  
  AC_MSG_RESULT($XINETD_DIR)
  AC_SUBST(XINETD_DIR)dnl
])

#
# AC_NTSYSV - the conditional code for compiling the NTSYSV program
#
AC_DEFUN(AC_NTSYSV,
[
    AC_MSG_CHECKING([whether to compile ntsysv])
    dnl Default is enabled ntsysv
    AC_ARG_ENABLE(ntsysv,
	[  --enable-ntsysv         activates compilation of ntsysv program],
	COMP_NTSYSV=$enableval, COMP_NTSYSV=yes)
    AC_MSG_RESULT($COMP_NTSYSV)
    dnl If we want ntsysv, then setup vars
    if test "$COMP_NTSYSV" = "yes"; then
	NTSYSV="ntsysv"
	NTSYSVMAN="ntsysv.8"
	AC_SUBST(NTSYSV)
	AC_SUBST(NTSYSVMAN)
    fi
])

#
# AC_MANDATORY_HEADERS - the conditional code for compiling the NTSYSV program
#
AC_DEFUN(AC_MANDATORY_HEADERS,
[
    AC_MSG_CHECKING([whether to require chkconfig headers])
    dnl Default is to require headers
    AC_ARG_ENABLE(mandatory-headers,
	[  --enable-mandatory-headers  require chkconfig headers on init scripts],
	COMP_REQHDRS=$enableval, COMP_REQHDRS=yes)
    AC_MSG_RESULT($COMP_REQHDRS)
    dnl If we want mandatory headers, then define it.
    if test "$COMP_REQHDRS" = "yes"; then
	AC_DEFINE(MANDATORY_HEADERS)
    fi
])


#
# AC_MAX_LEVEL - find the maximum level to allow
#
AC_DEFUN(AC_MAX_LEVEL,
[
  AC_MSG_CHECKING(for maximum init level)

  AC_ARG_WITH(max-level,
	[  --with-max-level=INT    maximum init level allowed])

  # for levels in RC_DIR
  MAX_LEVEL=0
  for a in 0 1 2 3 4 5 6 7 8 9; do
	if (test -d $RC_DIR/rc$a.d); then
		MAX_LEVEL=$a
	fi
  done
  test -z "$with_max_level" || MAX_LEVEL=$with_max_level
  
  AC_MSG_RESULT($MAX_LEVEL)
  AC_SUBST(MAX_LEVEL)dnl
])

