#!/usr/bin/perl
# api2man.pl
# cygwin-doc 
#
# This script makes passable man pages out of a specific subset of SGML
# files.  This script works with the SGML files used for documenting
# the Cygwin-specific functions of the Cygwin project (i.e., those with
# no UNIX counterparts). It does not work for other SGML files. Don't
# even try it.
# 
# Copyright (c) 2002, 2003, 2004 Joshua Daniel Franklin 
# 
# --------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License (GPL) as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
# USA.
# --------------------------------------------------------------------------
#
#	ChangeLog:
#
#	2004-02-22  Joshua Daniel Franklin  <joshuadfranklin@yahoo.com>
#	        * remove extra quote after date
#	        * update copyrights
#	
#	2003-99-99  Joshua Daniel Franklin  <joshuadfranklin@yahoo.com>
#	        * other small updates I didn't keep track of
#	
#	2002-04-10  Joshua Daniel Franklin  <joshuadfranklin@yahoo.com>
#	        * first release
#
#

$date=`date +"%Y %b %d"`;
chomp ($date);
if ($#ARGV < 0)
{
	print "usage: api2man api-sgml-file [api-sgml-file2 ...]\n";
	print "	The api-sgml-files are, as of this writing:\n";
	print "	winsup/cygwin/dll_init.sgml\n";
	print "	winsup/cygwin/dtable.sgml\n";
	print "	winsup/cygwin/external.sgml\n";
	print "	winsup/cygwin/path.sgml\n";
	print "	winsup/cygwin/shared.sgml\n";
	print "	winsup/cygwin/stackdump.sgml\n";
}

# just in case 
mkdir "man3";
@filelist = @ARGV;

foreach (@filelist) 
{
	open(INF, "$_");
	$sect = 0;
	while (<INF>) 
	{
		s/\\/\\\\/g;
		chomp (); # I hate newlines!!
                # Check for beginning or end of section (not really necessary, but good to know)
                if (/sect1/) 
                {
                        if ($sect == 1)
                        {
                                $sect = 0;
                        }
                        else 
                        {
                                s/<.*id="(.*)">/$1/;
#                               print OUTF "Begining section $_";
                                $sect = 1;
                                $_ = "";
                        }
                }
		# Now look for tags; basically, the translation works
		# by taking a specific action based on the tag found. This
		# would be in a case statement, but this is perl :)
		@line = split (/</);
		foreach (@line)
		{
			if (/>/)
			{
				($type, $content) = split (/>/);
				if ($type eq "/funcsynopsis")
				{
					if ($comma)
					{
					print OUTF ");\n\n.SH DESCRIPTION\n";
					$comma = 0;
					}
				}
				elsif ($type eq "void")
				{
				print OUTF ");\n\n.SH DESCRIPTION\n";
				}
				elsif ($type eq "title")
				{
				$comma = 0;
				# The name of each page is dependent on the title, so first
				#  we need to print a footer for the last page (if any)
				print_footer ();
				print "Creating man3/$content.3\n";
				close (OUTF);
				# And now, to start a new output file and header
				open (OUTF, ">man3/$content.3");
				# man uses uppercase for titles
				$CONTENT = uc $content;
				print OUTF ".TH $CONTENT 1 \"$date\" ";
				print OUTF "\"\" \"CYGWIN\"\n";
				print OUTF ".SH NAME\n$content\n";
				}
				elsif ($type eq "funcsynopsis")
				{
				print OUTF ".SH SYNOPSIS\n";
				}
				elsif ($type eq "funcdef")
				{
				print OUTF "\\fB$content\\fP \n.br \n.B ";
				}
				elsif ($type eq "function")
				{
				print OUTF "$content (";
				}
				elsif ($type eq "paramdef")
				{
					if ($comma)
					{
						print OUTF ", ";
						$comma = 0;
					}
					print OUTF "$content ";
				}
				elsif ($type eq "parameter")
				{
				print OUTF "\\fI$content\\fP";
				$comma = 1;
				}
				elsif ($type eq "para")
				{
				print OUTF "$content ";
				}
				elsif ($type eq "/link")
				{
				print OUTF "(3)\\fP ";
				}
				# The <example> tag tells us that we need to 
				#  1) ignore the secondary <title> tag (by reading two extra lines)
				#  2) switch to outputting preformatted code (until </example>
				elsif ($type eq "example")
				{
				print OUTF "\n\n.SH EXAMPLE\n";
				$_ = <INF>;
				$_ = <INF>;
				while (! /example/)
					{
					$_ = <INF>;
					s/\\/\\\\/g;
					if (! /</)
						{	
						print OUTF ".br\n";
						print OUTF;
						}
					}
				}
				elsif ($type eq "/title" || "/parameter")
				{
				if ($content)
					{
					print OUTF "$content ";
					}
				}
				else 
				{
					if ($_) 
						{
						print OUTF "$_ ";
						}
				}
			}
			else 
			{
				# This is a horrible kludge but it works
				if ($_ eq "link")
				{
				print OUTF "\n.br\n\\fB";
				}
				elsif ($_) 
					{
					print OUTF "$_ ";
					}
			}
		}
	}
	print_footer ();
	close (OUTF);
	close (INF);
}	

# Here is how the only parts of the man pages that look right are produced
sub print_footer 
{
	print OUTF "\n\n.SH COPYRIGHT\n";
	print OUTF ".B Cygwin \n";
	print OUTF "is Copyright (C) 1995, 1996, 1997, 1998, 1999, \n";
	print OUTF "2000, 2001, 2002, 2003, 2004 Red Hat, Inc.\n";
	print OUTF ".PP\n";
	print OUTF "\\fBCygwin\\fP is Free software; for complete licensing\n"; 
	print OUTF "information, refer to:\n\n";
	print OUTF ".B http://cygwin.com/licensing.html\n";
	print OUTF ".SH MAINTAINER\n";
	print OUTF "This man page was written and is maintained by \n";
	print OUTF "Joshua Daniel Franklin, <joshuadfranklin\@yahoo.com>\n\n";
	print OUTF ".SH SEE ALSO\n\n";
	print OUTF "The full documentation to the Cygwin API is maintained\n";
	print OUTF "on the web at:\n\n";
	print OUTF ".B http://cygwin.com/cygwin-api/cygwin-api.html\n\n";
	print OUTF "The website is updated more frequently than the\n";
	print OUTF "man pages and should be considered the authoritative\n";
	print OUTF "source of information.\n\n";
}
