/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon8;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ExtensionInstruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xpath.XPathException;

public class Text
extends ExtensionInstruction {
    Expression hrefExpr;
    Expression encodingExpr;

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String fnAtt = this.getAttribute("href");
        if (fnAtt == null || "".equals(fnAtt)) {
            this.reportAbsence("href");
        }
        this.hrefExpr = this.makeAttributeValueTemplate(fnAtt);
        fnAtt = this.getAttribute("encoding");
        this.encodingExpr = fnAtt == null || "".equals(fnAtt) ? null : this.makeAttributeValueTemplate(fnAtt);
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.hrefExpr = this.typeCheck("href", this.hrefExpr);
        if (this.encodingExpr != null) {
            this.encodingExpr = this.typeCheck("encoding", this.encodingExpr);
        }
    }

    public Expression compile(Executable exec) throws TransformerConfigurationException {
        return new TextInstruction(this.hrefExpr, this.encodingExpr);
    }

    private static class TextInstruction
    extends SimpleExpression {
        Expression hrefExpr;
        Expression encodingExpr;

        public TextInstruction(Expression hrefExpr, Expression encExpr) {
            this.hrefExpr = hrefExpr;
            this.encodingExpr = encExpr;
        }

        public int getImplementationMethod() {
            return 0;
        }

        public String getExpressionType() {
            return "s8text:insertfile";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            SequenceReceiver out = context.getReceiver();
            String href = this.hrefExpr.evaluateAsString(context);
            String encoding = "";
            if (this.encodingExpr != null) {
                encoding = this.encodingExpr.evaluateAsString(context);
            }
            String baseURI = ((NodeInfo)context.getContextItem()).getBaseURI();
            URIResolver resolver = context.getController().getURIResolver();
            if (resolver != null) {
                try {
                    Source source = resolver.resolve(href, baseURI);
                    href = source.getSystemId();
                }
                catch (TransformerException te) {
                    // empty catch block
                }
            }
            URL baseURL = null;
            URL fileURL = null;
            try {
                baseURL = new URL(baseURI);
            }
            catch (MalformedURLException e0) {
                baseURL = null;
            }
            try {
                try {
                    fileURL = new URL(baseURL, href);
                }
                catch (MalformedURLException e1) {
                    try {
                        fileURL = new URL(baseURL, "file:" + href);
                    }
                    catch (MalformedURLException e2) {
                        System.out.println("Cannot open " + href);
                        return null;
                    }
                }
                InputStreamReader isr = null;
                isr = encoding.equals("") ? new InputStreamReader(fileURL.openStream()) : new InputStreamReader(fileURL.openStream(), encoding);
                BufferedReader is = new BufferedReader(isr);
                int BUFFER_SIZE = 4096;
                char[] chars = new char[4096];
                char[] nchars = new char[4096];
                int len = 0;
                int i = 0;
                int carry = -1;
                while ((len = is.read(chars)) > 0) {
                    int nlen = 0;
                    for (i = 0; i < len; ++i) {
                        if (chars[i] == '\r') {
                            if (i < len - 1) {
                                if (chars[i + 1] == '\n') continue;
                                nchars[nlen] = 10;
                                ++nlen;
                                continue;
                            }
                            carry = is.read();
                            nchars[nlen] = 10;
                            ++nlen;
                            if (carry != 10) break;
                            carry = -1;
                            break;
                        }
                        nchars[nlen] = chars[i];
                        ++nlen;
                    }
                    out.characters((CharSequence)String.valueOf(nchars), 0, 0);
                    if (carry != -1) {
                        out.characters((CharSequence)String.valueOf((char)carry), 0, 0);
                    }
                    carry = -1;
                }
                is.close();
            }
            catch (Exception e) {
                System.out.println("Cannot read " + href);
            }
            return null;
        }
    }
}

