/**

    eMail is a command line SMTP client.

    Copyright (C) 2001 - 2004 email by Dean Jones
    Software supplied and written by http://www.cleancode.org

    This file is part of eMail.

    eMail is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    eMail is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with eMail; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <termios.h>

#define TTY "/dev/tty"
#define BACKSPACE 8             /* ascii char for BS */
#define DEL     127             /* ascii char for DEL */

/**
 * This is the Cgets function... Or known as "Controlled Gets".  
 * What this function does is ask for input from a user.  The Cgets 
 * function will fill 'buf' up to 'size' length. Input is taken in 
 * non-canonical mode, and non-echo mode.  However, characters that
 * are hit, are echoed back to the screen, unless characters are a  
 * backspace key.  In that case, we go back and erase the last char 
 * from 'buf' and erase the last char entered on the screen.  If the  
 * user types in more chars than 'size', the Cgets function will stop
 * echoing and storing data, and warn the use each time with an alarm bell.  
 * Good for no buffer overflows, and for letting the user know how much 
 * data will actually be accepted.
**/

int
cgets(char *buf, int size)
{
    int i = 0;
    int c;
    FILE *tty;
    struct termios init, newsettings;

    if (!(tty = fopen(TTY, "w+")))
        return (-1);

    /* get attributes on the input of /dev/tty and then let's set them to new settings */
    tcgetattr(fileno(stdin), &init);
    newsettings = init;
    newsettings.c_lflag &= ~(ICANON | ECHO);
    newsettings.c_cc[VMIN] = 1;
    newsettings.c_cc[VTIME] = 0;

    if (tcsetattr(fileno(stdin), TCSANOW, &newsettings) != 0)
        return (-1);

    for (;;)
    {
        c = getc(stdin);
        if ((c == '\n') || (c == '\r') || (c == EOF))
            break;

        if ((c == BACKSPACE) || (c == DEL))
        {
            if (i > 0)          /* Only erase if we have something */
            {
                buf[--i] = 0;
                fputs("\b \b", stdout);
            }
            else
                putc('\a', stdout);
            continue;
        }

        if (i >= size - 1)
        {
            putc('\a', stdout);
            continue;
        }

        fputc(c, stdout);
        buf[i] = c;
        i++;
    }

    /* set original attributes back to normal */
    tcsetattr(fileno(tty), TCSANOW, &init);
    fflush(tty);
    fclose(tty);

    buf[i] = '\0';
    printf("\n");

    return (0);
}


