
# Find the version

if [ -z "${VER}" ] ; then
  VER=`sed -n -e '/AC_PREREQ/s/[^(]*([[]*\([[:digit:]\.]*\)[]]*).*$/\1/p' < $infile`
fi

VER_MAJ=`echo $VER | awk -F. '{print $1}'`
VER_MIN=`echo $VER | awk -F. '{print $2}'`

# Set the PATH appropriately
if [ "x${VER_MIN}" != "x" ] ; then
  if (( ${VER_MIN} <= 13 )) ; then
    if [ ! -x ${AUTO_STABLE}/bin/@PROGRAM@ ] ; then
      echo "Can't find ${AUTO_STABLE}/bin/@PROGRAM@" 2>&1
      exit 1
    fi
    export PATH=${AUTO_STABLE}/bin:${PATH} 
    export M4PATH=${AUTO_STABLE}/share/aclocal:/usr/share/aclocal:${AUTO_STABLE}/share/automake:${AUTO_STABLE}/share/autoconf:${M4PATH}
  else
    if [ ! -x ${AUTO_DEVEL}/bin/@PROGRAM@ ] ; then
      echo "Can't find ${AUTO_DEVEL}/bin/@PROGRAM@" 2>&1
      exit 1
    fi
    export PATH=${AUTO_DEVEL}/bin:${PATH}
    export M4PATH=${AUTO_DEVEL}/share/aclocal:/usr/share/aclocal:${AUTO_DEVEL}/share/automake:${AUTO_DEVEL}/share/automake/am:${AUTO_DEVEL}/share/autoconf:${M4PATH}
  fi
else
  if [ ! -x ${AUTO_DEVEL}/bin/@PROGRAM@ ] ; then
    echo "Can't find ${AUTO_DEVEL}/bin/@PROGRAM@" 2>&1
    exit 1
  fi
  export PATH=${AUTO_DEVEL}/bin:${PATH}
  export M4PATH=${AUTO_DEVEL}/share/aclocal:/usr/share/aclocal:${AUTO_DEVEL}/share/automake:${AUTO_DEVEL}/share/automake/am:${AUTO_DEVEL}/share/autoconf:${M4PATH}
fi

