#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

export PKG=libtool-stable
export VER=1.4.2
export REL=2
export FULLPKG=${PKG}-${VER}-${REL}

export src_orig_pkg_name=libtool-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/libtool-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr/autotool/stable
docprefix=/usr
sysconfdir=${prefix}/etc
path_old=${PATH}

prep() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${topdir} && \
  tar xvzf ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} && \
  export PATH=${path_old} )
}
conf() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  ${srcdir}/configure --build=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=/nonexistent/include && \
  export PATH=${path_old} )
}
build() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make CFLAGS=-O2 && make info && \
  export PATH=${path_old} )
}
check() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 && \
  export PATH=${path_old} )
}
clean() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make clean && \
  export PATH=${path_old} )
}
install() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make install INSTALL=install \
  prefix=${instdir}${prefix} \
  exec_prefix=${instdir}${prefix} \
  bindir=${instdir}${prefix}/bin \
  libdir=${instdir}${prefix}/lib \
  sysconfdir=${instdir}${sysconfdir} \
  includedir=${instdir}${prefix}/include \
  tooldir=${instdir}${prefix} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${docprefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${docprefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${docprefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${docprefix}/doc/${PKG}-${VER} ; \
  fi && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${docprefix}/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${srcdir}/README \
    ${srcdir}/AUTHORS ${srcdir}/COPYING ${srcdir}/NEWS ${srcdir}/TODO \
	 ${srcdir}/THANKS ${instdir}${docprefix}/doc/${PKG}-${VER} && \
  export PATH=${path_old} )
}
mkpatch() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} && \
  mv libtool-${VER} ../libtool-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    libtool-${VER}-orig libtool-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf libtool-${VER}-orig && \
  export PATH=${path_old} )
}
strip() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${instdir} && \
  find . -name "*.dll" | xargs strip && \
  export PATH=${path_old} )
}
pkg() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${instdir} && \
  tar cvjf ${bin_pkg} * && \
  export PATH=${path_old} )
}
spkg() {
  (mkpatch && \
  export PATH=${prefix}/bin:${path_old} && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  export PATH=${path_old} )
}
finish() {
  (export PATH=${prefix}/bin:${path_old} && \
  rm -rf ${srcdir}
  export PATH=${path_old} )
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
export PATH=${path_old} 
exit ${STATUS}
