#ifndef _HTTP_AUTH_H_
#define _HTTP_AUTH_H_

#include "server.h"
#include "plugin.h"

#if defined(HAVE_LDAP_H) && defined(HAVE_LBER_H) && defined(HAVE_LIBLDAP) && defined(HAVE_LIBLBER)
# define USE_LDAP
# include <ldap.h>
#endif

typedef struct {
	PLUGIN_DATA;
	buffer *tmp_buf;
	
	/* auth */
	array  *conf_auth_require;
	
	buffer *conf_auth_plain_groupfile;
	buffer *conf_auth_plain_userfile;
	buffer *conf_auth_backend;
	
	buffer *conf_auth_ldap_hostname;
	buffer *conf_auth_ldap_basedn;
	buffer *conf_auth_ldap_filter;
	
	buffer *auth_user;
	
#ifdef USE_LDAP
	LDAP *ldap;
	
	buffer *ldap_filter_pre;
	buffer *ldap_filter_post;
	buffer *ldap_filter;
#endif
} mod_auth_plugin_data;

int http_auth_basic_check(server *srv, connection *con, mod_auth_plugin_data *p, array *req, buffer *url, const char *realm_str);
int http_auth_digest_check(server *srv, connection *con, mod_auth_plugin_data *p, array *req, buffer *url, const char *realm_str);
int http_auth_digest_generate_nonce(server *srv, mod_auth_plugin_data *p, buffer *fn, char hh[33]);

#endif
