#ifndef _NETWORK_BACKENDS_H_
#define _NETWORK_BACKENDS_H_

#include "config.h"

/* on linux 2.4.x you get either sendfile or LFS */
#if defined HAVE_SYS_SENDFILE_H && defined HAVE_SENDFILE && (!defined _LARGEFILE_SOURCE || defined HAVE_SENDFILE64) && defined HAVE_WRITEV && defined(__linux__) && !defined HAVE_SENDFILE_BROKEN
# define USE_LINUX_SENDFILE
# include <sys/sendfile.h>
# include <sys/uio.h>
#endif

#if defined HAVE_SYS_UIO_H && defined HAVE_SENDFILE && defined HAVE_WRITEV && defined(__FreeBSD__)
# define USE_FREEBSD_SENDFILE
# include <sys/uio.h>
#endif

#if defined HAVE_SYS_SENDFILE_H && defined HAVE_SENDFILEV && defined HAVE_WRITEV && defined(__sun)
# define USE_SOLARIS_SENDFILEV
# include <sys/sendfile.h>
# include <sys/uio.h>
#endif

#if defined HAVE_SYS_UIO_H && defined HAVE_WRITEV
# define USE_WRITEV
# include <sys/uio.h>
#endif

#if defined HAVE_SYS_MMAN_H && defined HAVE_MMAP
# define USE_MMAP
# include <sys/mman.h>
#endif

#if defined HAVE_SYS_UIO_H && defined HAVE_WRITEV && defined HAVE_SEND_FILE && defined(__aix)
# define USE_AIX_SENDFILE
#endif

int network_write_chunkqueue_write(server *srv, connection *con, chunkqueue *cq);
int network_write_chunkqueue_writev(server *srv, connection *con, chunkqueue *cq);
int network_write_chunkqueue_linuxsendfile(server *srv, connection *con, chunkqueue *cq);
int network_write_chunkqueue_freebsdsendfile(server *srv, connection *con, chunkqueue *cq);
int network_write_chunkqueue_solarissendfilev(server *srv, connection *con, chunkqueue *cq);
int network_write_chunkqueue_openssl(server *srv, connection *con, chunkqueue *cq);

#endif
