.\"

.\" GLE Tubing & Extrusions Library Documentation 

.\"

.TH gleLathe 3GLE "3.6" "GLE" "GLE"

.SH NAME

gleLathe - Sweep using a Z-axis shear to create an arbitrary contour along a helical path.

.SH SYNTAX

.nf

.LP

void gleLathe (int ncp,

                gleDouble contour[][2],

                gleDouble cont_normal[][2],

                gleDouble up[3],

                gleDouble startRadius,     /* spiral starts in x-y plane */

                gleDouble drdTheta,        /* change in radius per revolution */

                gleDouble startZ,          /* starting z value */

                gleDouble dzdTheta,        /* change in Z per revolution */

                gleDouble startXform[2][3], /* starting contour affine xform */

                gleDouble dXformdTheta[2][3], /* tangent change xform per revoln */

                gleDouble startTheta,      /* start angle in x-y plane */

                gleDouble sweepTheta);     /* degrees to spiral around */

.fi

.SH ARGUMENTS

.IP \fIncp\fP 1i

number of contour points

.IP \fIcontour\fP 1i

2D contour

.IP \fIcont_normal\fP 1i

2D contour normals

.IP \fIup\fP 1i

up vector for contour

.IP \fIstartRadius\fP 1i

spiral starts in x-y plane

.IP \fIdrdTheta\fP 1i

change in radius per revolution

.IP \fIstartZ\fP 1i

starting z value

.IP \fIdzdTheta\fP 1i

change in Z per revolution

.IP \fIstartXform\fP 1i

starting contour affine transformation

.IP \fIdXformdTheta\fP 1i

tangent change xform per revolution

.IP \fIstartTheta\fP 1i

start angle in x-y plane

.IP \fIsweepTheta\fP 1i

degrees to spiral around

.SH DESCRIPTION



Sweep an arbitrary contour along a helical path. The sweep will be

performed as a shear along the z-axis, so that the orientation of the

contour is displaced, rather than translated, as the contour is swept.



The axis of the helix lies along the modeling coordinate z-axis.



An affine transform can be applied as the contour is swept. For most

ordinary usage, the affines should be given as NULL.



.SH SEE ALSO

gleSpiral

.SH AUTHOR

Linas Vepstas (linas@fc.net)

