#! /bin/bash

# $Id: build.sh,v 1.2 2002/05/18 23:15:19 jt Exp $

# vim: tabstop=4

# parse arguments
version=$1
port=$2

# constants
pkg=procmail

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix
BinDir=$InstallPrefix/bin
LibDir=$InstallPrefix/lib
ManDir=$InstallPrefix/man
DocDir=$InstallPrefix/doc/$pkg-$version
CygDocDir=$TmpDir/usr/doc/Cygwin
PatchDir=CYGWIN-PATCHES
SrcDocDir=doc

# make
make EXE=.exe LOCKINGTEST=100

# make install
make BASENAME=$InstallPrefix EXE=.exe install

# strip executables
find $InstallPrefix -name '*.exe' | xargs strip

# create man cat dirs
mkdir $ManDir/cat1 $ManDir/cat5

# copy Cygwin procmail README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# copy procmail COPYING, README, etc. files
TopFiles=(Artistic COPYING FAQ FEATURES HISTORY INSTALL KNOWN_BUGS README)
mkdir -p $DocDir
cp ${TopFiles[*]} $DocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr

# remove temporary directory
rm -fr $TmpDir
