#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}
# if the orig src package is bzip2'ed, remember to
# change 'z' to 'j' in the 'tar xvzf' commands in the
# prep) and mkpatch) sections
export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check

## these bits are Very package dependent!!
export LIB_VER=15

export bin_files="usr/bin/aspell.exe \
  usr/bin/aspell-import \
  usr/bin/pspell-config \
  usr/bin/run-with-aspell \
  usr/bin/word-list-compress.exe \
  usr/doc/Cygwin/aspell-0.50.3.README \
  usr/doc/aspell-0.50.3/README \
  usr/doc/aspell-0.50.3/TODO"

export doc_files="usr/share/doc/aspell/devel.aux \
  usr/share/doc/aspell/devel.dvi \
  usr/share/doc/aspell/devel.tex \
  usr/share/doc/aspell/devel2.lyx \
  usr/share/doc/aspell/manual.aux \
  usr/share/doc/aspell/manual.dvi \
  usr/share/doc/aspell/manual.tex \
  usr/share/doc/aspell/manual2.lyx \
  usr/share/doc/aspell/dev-html/devel.css \
  usr/share/doc/aspell/dev-html/devel.html \
  usr/share/doc/aspell/dev-html/img1.png \
  usr/share/doc/aspell/dev-html/img2.png \
  usr/share/doc/aspell/dev-html/index.html \
  usr/share/doc/aspell/dev-html/nx_grp_g.png \
  usr/share/doc/aspell/dev-html/prev_g.png \
  usr/share/doc/aspell/dev-html/up_g.png \
  usr/share/doc/aspell/dev-text/devel.txt \
  usr/share/doc/aspell/dev-text/index.txt \
  usr/share/doc/aspell/man-html/1_Introduction.html \
  usr/share/doc/aspell/man-html/2_Getting.html \
  usr/share/doc/aspell/man-html/3_Basic.html \
  usr/share/doc/aspell/man-html/4_Customizing.html \
  usr/share/doc/aspell/man-html/5_Working.html \
  usr/share/doc/aspell/man-html/6_Writing.html \
  usr/share/doc/aspell/man-html/7_Adding.html \
  usr/share/doc/aspell/man-html/8_How.html \
  usr/share/doc/aspell/man-html/A_Changelog.html \
  usr/share/doc/aspell/man-html/About_this.html \
  usr/share/doc/aspell/man-html/B_Do.html \
  usr/share/doc/aspell/man-html/C_Credits.html \
  usr/share/doc/aspell/man-html/Contents.html \
  usr/share/doc/aspell/man-html/D_Glossary.html \
  usr/share/doc/aspell/man-html/E_Copyright.html \
  usr/share/doc/aspell/man-html/contents.png \
  usr/share/doc/aspell/man-html/crossref.png \
  usr/share/doc/aspell/man-html/index.html \
  usr/share/doc/aspell/man-html/manual.css \
  usr/share/doc/aspell/man-html/manual.html \
  usr/share/doc/aspell/man-html/next.png \
  usr/share/doc/aspell/man-html/next_g.png \
  usr/share/doc/aspell/man-html/prev.png \
  usr/share/doc/aspell/man-html/prev_g.png \
  usr/share/doc/aspell/man-html/up.png \
  usr/share/doc/aspell/man-html/up_g.png \
  usr/share/doc/aspell/man-text/1_Introduction.txt \
  usr/share/doc/aspell/man-text/2_Getting.txt \
  usr/share/doc/aspell/man-text/3_Basic.txt \
  usr/share/doc/aspell/man-text/4_Customizing.txt \
  usr/share/doc/aspell/man-text/5_Working.txt \
  usr/share/doc/aspell/man-text/6_Writing.txt \
  usr/share/doc/aspell/man-text/7_Adding.txt \
  usr/share/doc/aspell/man-text/8_How.txt \
  usr/share/doc/aspell/man-text/A_Changelog.txt \
  usr/share/doc/aspell/man-text/About_this.txt \
  usr/share/doc/aspell/man-text/B_Do.txt \
  usr/share/doc/aspell/man-text/C_Credits.txt \
  usr/share/doc/aspell/man-text/Contents.txt \
  usr/share/doc/aspell/man-text/D_Glossary.txt \
  usr/share/doc/aspell/man-text/E_Copyright.txt \
  usr/share/doc/aspell/man-text/index.txt \
  usr/share/doc/aspell/man-text/manual.txt"

export dev_files="usr/include/aspell.h \
  usr/lib/libaspell.dll.a \
  usr/lib/libaspell.la \
  usr/include/pspell/pspell.h"

export lib_files="usr/bin/cygaspell-15.dll \
  usr/share/aspell/ASCII.dat \
  usr/share/aspell/dvorak.kbd \
  usr/share/aspell/iso8859-1.dat \
  usr/share/aspell/iso8859-10.dat \
  usr/share/aspell/iso8859-13.dat \
  usr/share/aspell/iso8859-14.dat \
  usr/share/aspell/iso8859-15.dat \
  usr/share/aspell/iso8859-2.dat \
  usr/share/aspell/iso8859-3.dat \
  usr/share/aspell/iso8859-4.dat \
  usr/share/aspell/iso8859-5.dat \
  usr/share/aspell/iso8859-6.dat \
  usr/share/aspell/iso8859-7.dat \
  usr/share/aspell/iso8859-8.dat \
  usr/share/aspell/iso8859-9.dat \
  usr/share/aspell/ispell \
  usr/share/aspell/koi8-f.dat \
  usr/share/aspell/koi8-r.dat \
  usr/share/aspell/koi8-u.dat \
  usr/share/aspell/spell \
  usr/share/aspell/standard.kbd \
  usr/share/aspell/viscii.dat"

# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
MY_CFLAGS="-O2 -g"
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} 
  && mkdirs )
}
conf() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure --host=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --libexecdir='${sbindir}' --localstatedir=/var \
  --datadir='${prefix}/share'
)
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make )
}
check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} 
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
    mkdir -p ${instdir}${sysconfdir}/postinstall ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/ANNOUNCE ${srcdir}/CHANGES ${srcdir}/INSTALL \
           ${srcdir}/KNOWNBUG ${srcdir}/LICENSE ${srcdir}/README \
			  ${srcdir}/TODO ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
        ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
    fi ;\
  fi ;\
#  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
#    ${instdir}${sysconfdir}/postinstall/${PKG}.sh 
  )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir} 
}
split-bin-package() {
  (mkdir .binsplits && \
  cd .binsplits && \
  tar xjvf ${bin_pkg} && \
  mkdir ${PKG}-bin ${PKG}-doc ${PKG}-dev lib${PKG} && \
  for f in ${bin_files} ; do  \
    mkdir -p ${PKG}-bin/`dirname $f` && \
    cp $f ${PKG}-bin/$f \
  ; done && \
  for f in ${doc_files} ; do  \
    mkdir -p ${PKG}-doc/`dirname $f` && \
    cp $f ${PKG}-doc/$f \
  ; done && \
  for f in ${dev_files} ; do  \
    mkdir -p ${PKG}-dev/`dirname $f` && \
    cp $f ${PKG}-dev/$f \
  ; done && \
  for f in ${lib_files}  ; do  \
    mkdir -p lib${PKG}/`dirname $f` && \
    cp $f lib${PKG}/$f \
  ; done && \
  cd ${PKG}-bin && tar cjvf ../../${PKG}-bin-${VER}-${REL}.tar.bz2 * && cd .. && \
  cd ${PKG}-doc && tar cjvf ../../${PKG}-doc-${VER}-${REL}.tar.bz2 * && cd .. && \
  cd ${PKG}-dev && tar cjvf ../../${PKG}-dev-${VER}-${REL}.tar.bz2 * && cd .. && \
  cd lib${PKG} && tar cjvf ../../lib${PKG}${LIB_VER}-${VER}-${REL}.tar.bz2 * && cd .. && \
  cd .. && \
  rm -rf .binsplits)
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  split-bin-package) split-bin-package ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
