#if !defined(__parse_opt_cfg_hpp__)
#define __parse_opt_cfg_hpp__



namespace poc
{



	enum opt_enum {
		Void, Bool, Int, OInt, AInt, Dbl, ODbl, ADbl, Str, OStr, VStr, VCSVStr
	};

	//-----------------------------------------------------------------------------
	class opt_base
	{
	public:
		opt_enum OptType;
		char ShortName;
		string LongName;

		opt_base(opt_enum ot, char sn, string ln)
		{
			OptType = ot;
			ShortName = sn;
			LongName = ln;
		}

		static opt_base* get_opt(int idx)
		{
			return (idx < opt_base::opts_idx) ? opt_base::options[idx] : NULL;
		}

	protected:
		static opt_base** options;
		static int opts_idx;
		static int opts_sz;

		static void register_address(opt_base* obptr);
	};



	//-----------------------------------------------------------------------------
	class opt_bool : opt_base
	{
	public:
		bool Set;

		opt_bool(char sn, string ln, bool st = false) : opt_base(Bool, sn, ln)
		{
			Set = st;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_int : opt_base
	{
	public:
		int Value;
		int LineNbr;

		opt_int(char sn, string ln, int v = 0) : opt_base(Int, sn, ln)
		{
			Value = v;
			LineNbr = -1;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_o_int : opt_base
	{
	public:
		bool Set;
		int Value;
		int LineNbr;

		opt_o_int(char sn, string ln, int v = 0) : opt_base(OInt, sn, ln)
		{
			Set = false;
			Value = v;
			LineNbr = -1;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_dbl : opt_base
	{
	public:
		double Value;
		int LineNbr;

		opt_dbl(char sn, string ln, double v = 0) : opt_base(Dbl, sn, ln)
		{
			Value = v;
			LineNbr = -1;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_o_dbl : opt_base
	{
	public:
		bool Set;
		double Value;
		int LineNbr;

		opt_o_dbl(char sn, string ln, double v = 0) : opt_base(ODbl, sn, ln)
		{
			Set = false;
			Value = v;
			LineNbr = -1;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_str : opt_base
	{
	public:
		string Value;
		int LineNbr;

		opt_str(char sn, string ln, string v = "") : opt_base(Str, sn, ln)
		{
			Value = v;
			LineNbr = -1;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_o_str : opt_base
	{
	public:
		bool Set;
		string Value;
		int LineNbr;

		opt_o_str(char sn, string ln, string v = "") : opt_base(OStr, sn, ln)
		{
			Set = false;
			Value = v;
			LineNbr = -1;
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_v_str : opt_base
	{
	public:
		vector<string> Value;
		vector<int> LineNbr;

		opt_v_str(char sn, string ln) : opt_base(VStr, sn, ln)
		{
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};

	//-----------------------------------------------------------------------------
	class opt_v_csv_str : opt_base
	{
	public:
		vector< vector<string> > Value;
		vector<int> LineNbr;

		opt_v_csv_str(char sn, string ln) : opt_base(VCSVStr, sn, ln)
		{
			opt_base::register_address(reinterpret_cast<opt_base*> (this));
		}
	};



	//-----------------------------------------------------------------------------
	class parse_opt_cfg
	{

	public:
		void parse_configfile(string& file);
		void parse_configfile(char* file);

		void parse_cloptions(int argc, char** argv, vector<string>& non_opt_arg_array);

	protected:
		enum currently_reading_enum { ConfigFile, CLOptions };
		enum current_option_size_enum { Short, Long };

		void parse_long_option(string& src);
		void parse_short_option(string& src);

		void parse_configfile_read();

		void validate_on_opt_type(stringstream& err, opt_base& opt);

		int read_int_arg();
		double read_double_arg();
		string read_string_arg();
		void read_csv_strings_arg(vector<string>& vect);

		void trim_string(string& s);
		void clear_vectors();

		unsigned lineno;

		file_info cf;

		string opt;
		string arg;

		currently_reading_enum currently_reading;
		current_option_size_enum current_option_size;
	};



} /* namespace poc */



#endif /* !defined(__parse_opt_cfg_hpp__) */
