/*
  dc-lang.cc: implementation of backend callbacks and data structures

*/

// %%TODO(safe to include these?)
#include "root.h"
#include "mtype.h"
#include "id.h"
#include "module.h"
#include "d-backend.h"
#include "debcond.h"

#include <assert.h>
#include "d-gcc-includes.h"
#if D_GCC_VER >= 34
#include "options.h"
#endif
#include "d-lang.h"
#include "d-codegen.h"
#include "d-gcc-real.h"

#undef LANG_HOOKS_NAME
#define LANG_HOOKS_NAME "GNU D"
#undef LANG_HOOKS_INIT
#define LANG_HOOKS_INIT d_init
#undef LANG_HOOKS_INIT_OPTIONS
#define LANG_HOOKS_INIT_OPTIONS d_init_options
#if D_GCC_VER == 33
#undef LANG_HOOKS_DECODE_OPTION
#define LANG_HOOKS_DECODE_OPTION d_decode_option
#else
// gcc3.4
#undef LANG_HOOKS_HANDLE_OPTION
#define LANG_HOOKS_HANDLE_OPTION d_handle_option
#undef LANG_HOOKS_POST_OPTIONS
#define LANG_HOOKS_POST_OPTIONS d_post_options
#endif

#undef LANG_HOOKS_PARSE_FILE
#define LANG_HOOKS_PARSE_FILE d_parse_file

/* these are required (?); not sure if the above are requried */
#undef LANG_HOOKS_TRUTHVALUE_CONVERSION
#define LANG_HOOKS_TRUTHVALUE_CONVERSION d_truthvalue_conversion

#undef LANG_HOOKS_MARK_ADDRESSABLE
#define LANG_HOOKS_MARK_ADDRESSABLE d_mark_addressable

#undef LANG_HOOKS_TYPE_FOR_MODE
#define LANG_HOOKS_TYPE_FOR_MODE d_type_for_mode

#undef LANG_HOOKS_TYPE_FOR_SIZE
#define LANG_HOOKS_TYPE_FOR_SIZE d_type_for_size

#undef LANG_HOOKS_EXPAND_EXPR
#define LANG_HOOKS_EXPAND_EXPR d_expand_expr

#define LANG_HOOKS_UNSIGNED_TYPE d_unsigned_type
#define LANG_HOOKS_SIGNED_TYPE d_signed_type
#define LANG_HOOKS_SIGNED_OR_UNSIGNED_TYPE d_signed_or_unsigned_type
#define LANG_HOOKS_TYPE_FOR_SIZE d_type_for_size
#define LANG_HOOKS_TYPE_FOR_MODE d_type_for_mode

// for dynarray cmp
#undef LANG_HOOKS_EXPR_SIZE
#define LANG_HOOKS_EXPR_SIZE		d_expr_size

#undef LANG_HOOKS_WRITE_GLOBALS
#define LANG_HOOKS_WRITE_GLOBALS d_write_global_declarations

// Some phobos code (isnormal, etc.) breaks with strict aliasing...
// so I guess D doesn't have aliasing rules.  Would be nice to enable
// strict aliasing, but hooking or defaulting flag_strict_aliasing is
// not trivial
#undef LANG_HOOKS_GET_ALIAS_SET
#define LANG_HOOKS_GET_ALIAS_SET hook_get_alias_set_0

// Needed for try/finally -- statements cannont be re-evaluated
#undef LANG_HOOKS_UNSAFE_FOR_REEVAL
#define LANG_HOOKS_UNSAFE_FOR_REEVAL d_unsafe_for_reeval


static tree d_type_for_mode PARAMS ((enum machine_mode, int));
//static tree d_type_for_size PARAMS ((unsigned, int));
static tree d_signed_or_unsigned_type PARAMS ((int, tree));
tree d_unsigned_type PARAMS ((tree));
tree d_signed_type PARAMS ((tree));

static bool std_inc; // %%FIX: find a place for this

#if D_GCC_VER == 33

static Array * all_input_files = 0;

static void
d_init_options ()
#else
static unsigned int
d_init_options (unsigned int, const char **)
#endif
{
    // Set default values
#if D_GCC_VER == 33
    global.params.argv0 = "cc1d"; // %% fix

    all_input_files = new Array;    
#else
    global.params.argv0 = "cc1d"; // %% fix xstrdup(argv[0]); // %% want last path component
#endif
    global.params.link = 1;
    global.params.useAssert = 1;
    global.params.useInvariants = 1;
    global.params.useIn = 1;
    global.params.useOut = 1;
    global.params.useArrayBounds = 1;
    flag_bounds_check = global.params.useArrayBounds; // use the existing -fbounds-check flag
    global.params.useSwitchError = 1;
    global.params.useInline = 0;

    global.params.linkswitches = new Array();
    global.params.libfiles = new Array();
    global.params.objfiles = new Array();

    global.params.imppath = new Array();

    // GCC options
    flag_exceptions = 1;

    // extra D-specific options
    gen.emitTemplates = true;
    std_inc = true;

#if D_GCC_VER >= 34 
    return CL_D;
#endif
}

#if D_GCC_VER == 33
static const char *
d_init (const char * filename)
#else
static bool
d_init ()
#endif
{
    /*
#if D_GCC_VER == 33
    printf("d_init(%s)\n", filename);
#endif
    */

    Type::init();
    Id::initialize();
    Module::init();
    gcc_d_backend_init();
    real_t::init();

    // Predefine version identifiers
    // %% Should this be defined for GCC? -- It's still the DM front-end
    VersionCondition::addIdent("DigitalMars");

    VersionCondition::addIdent("GNU");
#ifdef D_CPU_VERSYM
    VersionCondition::addIdent(D_CPU_VERSYM);
#endif
#ifdef D_OS_VERSYM
    VersionCondition::addIdent(D_OS_VERSYM);
#endif
#ifdef D_OS_VERSYM2
    VersionCondition::addIdent(D_OS_VERSYM2);
#endif

#if BYTES_BIG_ENDIAN
    VersionCondition::addIdent("BigEndian");
#else    
    VersionCondition::addIdent("LittleEndian");
#endif
    // Need these for phobos/gcc/unwind.d
#if UNITS_PER_WORD == 4
    VersionCondition::addIdent("BitsPerWord32");
#elif UNITS_PER_WORD == 8
    VersionCondition::addIdent("BitsPerWord64");
#endif
#if POINTER_SIZE == 32
    VersionCondition::addIdent("BitsPerPointer32");
#elif POINTER_SIZE == 64
    VersionCondition::addIdent("BitsPerPointer64");
#endif
    if (d_using_sjlj_exceptions()) {
	VersionCondition::addIdent("GNU_SjLj_Exceptions");
    }
    
#if 0
    VersionCondition::addIdent("D_InlineAsm");
#endif

    // %%TODO: front or back?
    if (std_inc) {
	global.params.imppath->insert(0, xstrdup(D_PHOBOS_DIR));
    }

    if (global.params.imppath)
    {
	for (unsigned i = 0; i < global.params.imppath->dim; i++)
	{
	    char *path = (char *)global.params.imppath->data[i];
	    // We would do this for D_INCLUDE_PATH env var, but not for '-I'
	    // command line args.
	    //Array *a = FileName::splitPath(path);

	    if (path)
	    {
		if (!global.path)
		    global.path = new Array();
		//global.path->append(a);
		global.path->push(path);
	    }
	}
    }


    {
	char * path = FileName::searchPath(global.path, "phobos-ver-syms", 1);
	if (path) {
	    FILE * f = fopen(path, "r");
	    char buf[256];
	    char *p, *q;
	    if (f) {
		while ( ! feof(f) && fgets(buf, 256, f) ) {
		    p = buf;
		    while (*p && ISSPACE(*p))
			p++;
		    q = p;
		    while (*q && ! ISSPACE(*q))
			q++;
		    *q = 0;
		    if (p != q) {
			VersionCondition::addIdent(xstrdup(p));
		    }
		}
		fclose(f);
	    } else {
		//printf("failed\n");
	    }
	} else {
	    //printf("no p-v-s found\n");
	}
    }

#if D_GCC_VER == 33
    if (all_input_files && all_input_files->dim)
	return (char *) all_input_files->data[0];
    else
	return filename;
#else
    return 1;
#endif
}

#if D_GCC_VER == 33

typedef enum opt_code {
    Wrong,
    OPT_I,
    OPT_fdeprecated,
    OPT_fassert,
    OPT_frelease,
    OPT_funittest,
    OPT_fversion_,
    OPT_fdebug,
    OPT_fdebug_,
    OPT_femit_templates,
    OPT_nostdinc
};

#endif

// gcc 3.4, but also called by gcc3
static int
d_handle_option (size_t scode, const char *arg, int value)
{
  enum opt_code code = (enum opt_code) scode;

  switch (code)
      {
      case OPT_I:
	  global.params.imppath->push(xstrdup(arg)); // %% not sure if we can keep the arg or not
	  break;
      case OPT_fdeprecated:
	  global.params.useDeprecated = value;
	  break;
      case OPT_fassert:
	  global.params.useAssert = value;
	  break;
      case OPT_frelease:
	  global.params.useInvariants = ! value;
	  global.params.useIn = ! value;
	  global.params.useOut = ! value;
	  global.params.useAssert = ! value;
	  flag_bounds_check = global.params.useArrayBounds = ! value;
	  global.params.useSwitchError = ! value;
	  break;
      case OPT_funittest:
	  global.params.useUnitTests = value;
	  break;
      case OPT_fversion_:
	  if (ISDIGIT(arg[0]))
	      VersionCondition::setLevel(atoi(arg));
	  else if (ISALPHA(arg[0])) // %%TODO: check whole string
	      VersionCondition::addIdent(xstrdup(arg));
	  else
	      error("bad argument for -fversion");
	  break;
      case OPT_fdebug:
	  global.params.debuglevel = value ? 1 : 0;
	  break;
      case OPT_fdebug_:
	  if (ISDIGIT(arg[0]))
	      DebugCondition::setLevel(atoi(arg));
	  else if (ISALPHA(arg[0]))
	      DebugCondition::addIdent(xstrdup(arg));
	  else
	      error("bad argument for -fdebug");
	  break;
      case OPT_femit_templates:
	  gen.emitTemplates = value;
	  break;
      case OPT_nostdinc:
	  std_inc = false;
	  break;
      default:
	  break;
      }
  return 1;
}


#if D_GCC_VER == 33

static int
d_decode_option (int argc, char **argv)
{
    const char * p_arg = argv[0];
    
    //printf("d_decode_option %d, \"%s\"\n", argc, p_arg);
    
    if (strncmp(p_arg, "-I", 2) == 0) {
	if (p_arg[2] == '\0') {
	    d_handle_option(OPT_I, argv[1], 0);
	    return 2;
	} else {
	    d_handle_option(OPT_I, p_arg + 2, 0);
	    return 1;
	}
    } else if (strncmp(p_arg, "-f", 2) == 0) {
	int value = 1;
	p_arg += 2;
	if (strncmp(p_arg, "no-", 3) == 0) {
	    value = 0;
	    p_arg += 3;
	}
	if (strcmp(p_arg, "deprecated") == 0)
	    d_handle_option(OPT_fdeprecated, NULL, value);
	else if (strcmp(p_arg, "assert") == 0)
	    d_handle_option(OPT_fassert, NULL, value);
	else if (strcmp(p_arg, "release") == 0)
	    d_handle_option(OPT_frelease, NULL, value);
	else if (strcmp(p_arg, "unittest") == 0)
	    d_handle_option(OPT_funittest, NULL, value);
	else if (value && strncmp(p_arg, "version=", 8) == 0)
	    // %% better error handling
	    d_handle_option(OPT_fversion_, p_arg + 8, value);
	else if (value && strncmp(p_arg, "debug=", 6) == 0)
	    d_handle_option(OPT_fdebug_, p_arg + 6, value);
	else if (strcmp(p_arg, "debug") == 0)
	    d_handle_option(OPT_fdebug, p_arg + 5, value);
	else if (strcmp(p_arg, "emit-templates") == 0)
	    d_handle_option(OPT_femit_templates, NULL, value);
	else
	    return 0;
	return 1;
    } else if (strcmp(p_arg, "-nostdinc") == 0) {
	d_handle_option(OPT_nostdinc, NULL, 0);
	return 1;
    } else if (p_arg[0] != '-') {
	all_input_files->push((void *) p_arg);
	return 0;
    } else {
	return 0;
    }
}
#endif

#if D_GCC_VER >= 34

/* This isn't needed for snapshots after (about) 2004-02-04. */
   
bool d_post_options(const char ** fn)
{
    // The front end considers the first input file to be the main one.
    if (num_in_fnames)
	*fn = in_fnames[0];
    return false;
}

#endif

// %% In gcc 3.4 (not sure about 3.3), wrapup_global_declaration needs
// to be called or functions will not be emitted.
// would be best to use the binding stuff in d-lang.c, but non top-level
// functions may not end up in that list -- also means we have to override
// the LANG_HOOKS_WRITE_GLOBALS
Array globalFunctions; // Array of tree (for easy passing to wrapup_global_declarations)

void
d_add_global_function(tree decl)
{
    globalFunctions.push(decl);
}

// %% maint note -- need to keep this sync'd with the default versions
static void
d_write_global_declarations()
{
    wrapup_global_declarations( (tree *) globalFunctions.data, globalFunctions.dim );
    check_global_declarations( (tree *) globalFunctions.data, globalFunctions.dim );
}

// taken from c_common_unsafe_for_reeval
int
d_unsafe_for_reeval (tree exp)
{
  /* Statement expressions may not be reevaluated, likewise compound
     literals.  */
  if (TREE_CODE (exp) == (enum tree_code) D_STMT_EXPR)
      return 2;

  /* Walk all other expressions.  */
  return -1;
}



static Module * current_module = 0;
struct Module * getCurrentModule()
{
    return current_module;
}


static void
nametype(tree type, const char * name)
{
    tree ident = get_identifier(name);
    tree decl = build_decl(TYPE_DECL, ident, type);
    TYPE_NAME(type) = ident;
    TYPE_STUB_DECL(type) = decl;
    rest_of_type_compilation(type, 1);
}
static void nametype(Type * t)
{
    nametype(t->toCtype(), t->toChars());
}

static void
identify_builtin_modules()
{
    Array * packages = new Array;

    // gcc.builtins
    packages->push(Lexer::idPool("gcc"));
    
    Identifier *id = Lexer::idPool("builtins");

    // Duplicated from Import::semantic
    Package *pkg;
    DsymbolTable *dst = Package::resolve(packages, NULL, &pkg);
    Dsymbol *s;

    s = dst->lookup(id);
    if (s && s->isModule()) {
	gen.setBuiltinsModule( (Module*) s );
    }

    // find std.intrinsic
    packages->setDim(0);
    packages->push(Lexer::idPool("std"));
    id = Lexer::idPool("intrinsic");
    dst = Package::resolve(packages, NULL, &pkg);

    s = dst->lookup(id);
    if (s && s->isModule()) {
	gen.setIntrinsicModule( (Module*) s );
    }
    
}

void
d_parse_file (int /*set_yydebug*/)
{
    Identifier * id;
    //Module * m;
    char * p, * e;
    char * name;
    unsigned i;

    // %%TODO: move this to the post-options lang hook
    {
	global.params.useArrayBounds = flag_bounds_check;
    }
    

#if D_GCC_VER == 33
    (*debug_hooks->start_source_file) (lineno, input_filename);

    unsigned num_in_fnames = all_input_files->dim;
    char ** in_fnames = (char **) all_input_files->data;
    /*
    for (unsigned i = 0; i < all_input_files->dim; i++) {
	printf("%2d: '%s'\n", i, all_input_files->data[i]);
    }
    */
    
#else // elif >= 34
    // better to use input_location.xxx ?
    (*debug_hooks->start_source_file) (input_line, input_filename);
#endif
    /*
    printf("input_filename = '%s'\n", input_filename);
    printf("main_input_filename = '%s'\n", main_input_filename);
    */

    for (TY ty = (TY) 0; ty < TMAX; ty = (TY)(ty + 1)) {
	if (Type::basic[ty])
	    nametype(Type::basic[ty]);
    }

    /*
    p = FileName::name(input_filename);
    e = FileName::ext(p);
    if (e) {
	e--;
	assert( *e == '.' );
	name = (char *) xmalloc((e - p) + 1);
	memcpy(name, p, e - p);
	name[e - p] = 0;
    } else
	name = p;
    */

    Module * the_one = NULL;
    Array modules;
    modules.reserve(num_in_fnames + 1);
    
    // %% FIX
    if ( ! input_filename ) {
	::error("input file name required; cannot use stdin");
	goto had_errors;
    }

    //printf ("***** %d files  main=%s\n", num_in_fnames, input_filename);
    
    for (i = 0; i < num_in_fnames; i++) {

	// The main input filename is the last once and it should be
	// a duplicate.  But if it is not a dup, we cope. Once we find
	// the main file, we don't need to process any more files.
	if (the_one && ! strcmp(in_fnames[i], input_filename)) {
	    break;
	}
	
	char * the_fname = i < num_in_fnames ? (char*)in_fnames[i] : (char*)input_filename; // %% cheap cast
	
	p = FileName::name(the_fname);
	e = FileName::ext(p);
	if (e) {
	    e--;
	    assert( *e == '.' );
	    name = (char *) xmalloc((e - p) + 1);
	    memcpy(name, p, e - p);
	    name[e - p] = 0;
	} else
	    name = p;
	
	id = new Identifier(name, 0);
	Module * m = new Module(the_fname, id);

	if ( i == 0 ) {
	    the_one = m;
	} else {
	    modules.push(m);
	}
    }

    if (the_one)
	modules.push(the_one);

    // %% current_module shouldn't have any implications before genobjfile..

    
    Module * m;

    //global.params.verbose = 1;
    
    // Read files, parse them
    for (i = 0; i < modules.dim; i++)
    {
	m = (Module *)modules.data[i];
	if (global.params.verbose)
	    printf("parse     %s\n", m->toChars());
	//m->deleteObjFile(); // %% driver does this
	m->read();
	m->parse();
    }
    if (global.errors)
	goto had_errors;

    // Do semantic analysis
    for (i = 0; i < modules.dim; i++)
    {
	m = (Module *)modules.data[i];
	if (global.params.verbose)
	    printf("semantic  %s\n", m->toChars());
	m->semantic();
    }
    if (global.errors)
	goto had_errors;

    // Do pass 2 semantic analysis
    /*
    for (i = 0; i < modules.dim; i++)
    {
	m = (Module *)modules.data[i];
	if (global.params.verbose)
	    printf("semantic2 %s\n", m->toChars());
	m->semantic2();
    }
    if (global.errors)
	goto had_errors;
    */
    the_one->semantic2();
    if (global.errors)
	goto had_errors;

    /*
    // Do pass 3 semantic analysis
    for (i = 0; i < modules.dim; i++)
    {
	m = (Module *)modules.data[i];
	if (global.params.verbose)
	    printf("semantic3 %s\n", m->toChars());
	m->semantic3();
    }
    if (global.errors)
	goto had_errors;
    */
    the_one->semantic3();
    if (global.errors)
	goto had_errors;

    /*
    // Scan for functions to inline
    if (global.params.useInline)
    {
	for (i = 0; i < modules.dim; i++)
	{
	    m = (Module *)modules.data[i];
	    if (global.params.verbose)
		printf("inline scan %s\n", m->toChars());
	    m->inlineScan();
	}
    }
    if (global.errors)
	fatal();
    */

    /*
    // Generate output files
    for (i = 0; i < modules.dim; i++)
    {
	m = (Module *)modules.data[i];
	if (global.params.verbose)
	    printf("code      %s\n", m->toChars());
	m->genobjfile();
//	m->gensymfile();
    }
    */
    
    /* old
    
    id = new Identifier(name, 0);
    // %%TODO: fix crasher when file doesn't exist dsymbol.cc:80
    m = new Module((char*) input_filename, id);
    current_module = m;
    
    m->read();    
    m->parse();    
    if (global.errors)
	goto had_errors;
    
    if (global.params.verbose)
	printf("semantic  %s\n", m->toChars());
    m->semantic();
    if (global.errors)
	goto had_errors;

    if (global.params.verbose)
	printf("semantic2 %s\n", m->toChars());
    m->semantic2();
    if (global.errors)
	goto had_errors;

    if (global.params.verbose)
	printf("semantic3 %s\n", m->toChars());
    m->semantic3();
    if (global.errors)
	goto had_errors;
    */

    identify_builtin_modules();

    //printf("d_parse_file: parsed!\n");
    current_module = the_one;
    the_one->genobjfile(); // should probably set current_module to itself
#if D_GCC_VER == 33
    (*debug_hooks->end_source_file) (lineno);
#else
    // better to use input_location.xxx ?
    (*debug_hooks->end_source_file) (input_line);
#endif
 had_errors:
    // Add DMD error count to GCC error count to to exit with error status
    errorcount += global.errors;

    current_module = 0;
    
    gcc_d_backend_term();
}

bool
d_mark_addressable (tree t)
{
  tree x = t;
  while (1)
    switch (TREE_CODE (x))
      {
      case ADDR_EXPR:
      case COMPONENT_REF:
	  /* If D had bit fields, we would need to handle that here */
      case ARRAY_REF:
      case REALPART_EXPR:
      case IMAGPART_EXPR:
	x = TREE_OPERAND (x, 0);
	break;
	/* %% C++ prevents {& this} .... */
	/* %% TARGET_EXPR ... */
      case TRUTH_ANDIF_EXPR:
      case TRUTH_ORIF_EXPR:
      case COMPOUND_EXPR:
	x = TREE_OPERAND (x, 1);
	break;

      case COND_EXPR:
	return d_mark_addressable (TREE_OPERAND (x, 1))
	  && d_mark_addressable (TREE_OPERAND (x, 2));

      case CONSTRUCTOR:
	TREE_ADDRESSABLE (x) = 1;
	return true;

      case INDIRECT_REF:
	  /* %% this was in Java, not sure for D */
	/* We sometimes add a cast *(TYPE*)&FOO to handle type and mode
	   incompatibility problems.  Handle this case by marking FOO.  */
	if (TREE_CODE (TREE_OPERAND (x, 0)) == NOP_EXPR
	    && TREE_CODE (TREE_OPERAND (TREE_OPERAND (x, 0), 0)) == ADDR_EXPR)
	  {
	    x = TREE_OPERAND (TREE_OPERAND (x, 0), 0);
	    break;
	  }
	if (TREE_CODE (TREE_OPERAND (x, 0)) == ADDR_EXPR)
	  {
	    x = TREE_OPERAND (x, 0);
	    break;
	  }
	return true;

      case VAR_DECL:
      case CONST_DECL:
      case PARM_DECL:
      case RESULT_DECL:
	  if ( ! TREE_STATIC(x) ) // %% C doesn't do this check
	      put_var_into_stack(x
// Hack: Apple gcc-1495 differs from gcc-3.3 on this point.  This macro is
// used to distinguish from the true 3.3 release.
#ifndef APPLE_WEAK_ASSEMBLER_DIRECTIVE		  
		  , 1
#endif
				 );
	  // drop through
      case FUNCTION_DECL:
	TREE_ADDRESSABLE (x) = 1;
	/* drops through */
      default:
	return true;
    }
  
    return 1;
}



tree
d_type_for_mode (enum machine_mode mode, int unsignedp)
{
    // taken from c-common.c
  if (mode == TYPE_MODE (integer_type_node))
    return unsignedp ? unsigned_type_node : integer_type_node;

  if (mode == TYPE_MODE (signed_char_type_node))
    return unsignedp ? unsigned_char_type_node : signed_char_type_node;

  if (mode == TYPE_MODE (short_integer_type_node))
    return unsignedp ? short_unsigned_type_node : short_integer_type_node;

  if (mode == TYPE_MODE (long_integer_type_node))
    return unsignedp ? long_unsigned_type_node : long_integer_type_node;

  if (mode == TYPE_MODE (long_long_integer_type_node))
    return unsignedp ? long_long_unsigned_type_node : long_long_integer_type_node;

  /*%% ?
  if (mode == TYPE_MODE (widest_integer_literal_type_node))
    return unsignedp ? widest_unsigned_literal_type_node
                     : widest_integer_literal_type_node;
  */
  if (mode == QImode)
    return unsignedp ? unsigned_intQI_type_node : intQI_type_node;

  if (mode == HImode)
    return unsignedp ? unsigned_intHI_type_node : intHI_type_node;

  if (mode == SImode)
    return unsignedp ? unsigned_intSI_type_node : intSI_type_node;

  if (mode == DImode)
    return unsignedp ? unsigned_intDI_type_node : intDI_type_node;

#if HOST_BITS_PER_WIDE_INT >= 64
  if (mode == TYPE_MODE (intTI_type_node))
    return unsignedp ? unsigned_intTI_type_node : intTI_type_node;
#endif

  if (mode == TYPE_MODE (float_type_node))
    return float_type_node;

  if (mode == TYPE_MODE (double_type_node))
    return double_type_node;

  if (mode == TYPE_MODE (long_double_type_node))
    return long_double_type_node;

  if (mode == TYPE_MODE (build_pointer_type (char_type_node)))
    return build_pointer_type (char_type_node);

  if (mode == TYPE_MODE (build_pointer_type (integer_type_node)))
    return build_pointer_type (integer_type_node);

  switch (mode)
    {
    case V16QImode:
      return unsignedp ? unsigned_V16QI_type_node : V16QI_type_node;
    case V8HImode:
      return unsignedp ? unsigned_V8HI_type_node : V8HI_type_node;
    case V4SImode:
      return unsignedp ? unsigned_V4SI_type_node : V4SI_type_node;
    case V2DImode:
      return unsignedp ? unsigned_V2DI_type_node : V2DI_type_node;
    case V2SImode:
      return unsignedp ? unsigned_V2SI_type_node : V2SI_type_node;
    case V2HImode:
      return unsignedp ? unsigned_V2HI_type_node : V2HI_type_node;
    case V4HImode:
      return unsignedp ? unsigned_V4HI_type_node : V4HI_type_node;
    case V8QImode:
      return unsignedp ? unsigned_V8QI_type_node : V8QI_type_node;
    case V1DImode:
      return unsignedp ? unsigned_V1DI_type_node : V1DI_type_node;
    case V16SFmode:
      return V16SF_type_node;
    case V4SFmode:
      return V4SF_type_node;
    case V2SFmode:
      return V2SF_type_node;
    case V2DFmode:
      return V2DF_type_node;
    default:
      break;
    }

  return 0;
}

tree
d_type_for_size (unsigned bits, int unsignedp)
{
  if (bits == TYPE_PRECISION (integer_type_node))
    return unsignedp ? unsigned_type_node : integer_type_node;

  if (bits == TYPE_PRECISION (signed_char_type_node))
    return unsignedp ? unsigned_char_type_node : signed_char_type_node;

  if (bits == TYPE_PRECISION (short_integer_type_node))
    return unsignedp ? short_unsigned_type_node : short_integer_type_node;

  if (bits == TYPE_PRECISION (long_integer_type_node))
    return unsignedp ? long_unsigned_type_node : long_integer_type_node;

  if (bits == TYPE_PRECISION (long_long_integer_type_node))
    return (unsignedp ? long_long_unsigned_type_node
	    : long_long_integer_type_node);
  /* %%?
  if (bits == TYPE_PRECISION (widest_integer_literal_type_node))
    return (unsignedp ? widest_unsigned_literal_type_node
	    : widest_integer_literal_type_node);
  */
  if (bits <= TYPE_PRECISION (intQI_type_node))
    return unsignedp ? unsigned_intQI_type_node : intQI_type_node;

  if (bits <= TYPE_PRECISION (intHI_type_node))
    return unsignedp ? unsigned_intHI_type_node : intHI_type_node;

  if (bits <= TYPE_PRECISION (intSI_type_node))
    return unsignedp ? unsigned_intSI_type_node : intSI_type_node;

  if (bits <= TYPE_PRECISION (intDI_type_node))
    return unsignedp ? unsigned_intDI_type_node : intDI_type_node;

  return 0;
}

tree
d_unsigned_type (tree type)
{
  tree type1 = TYPE_MAIN_VARIANT (type);
  if (type1 == signed_char_type_node || type1 == char_type_node)
    return unsigned_char_type_node;
  if (type1 == integer_type_node)
    return unsigned_type_node;
  if (type1 == short_integer_type_node)
    return short_unsigned_type_node;
  if (type1 == long_integer_type_node)
    return long_unsigned_type_node;
  if (type1 == long_long_integer_type_node)
    return long_long_unsigned_type_node;
  /* %%?
  if (type1 == widest_integer_literal_type_node)
    return widest_unsigned_literal_type_node;
  */
#if HOST_BITS_PER_WIDE_INT >= 64
  if (type1 == intTI_type_node)
    return unsigned_intTI_type_node;
#endif
  if (type1 == intDI_type_node)
    return unsigned_intDI_type_node;
  if (type1 == intSI_type_node)
    return unsigned_intSI_type_node;
  if (type1 == intHI_type_node)
    return unsigned_intHI_type_node;
  if (type1 == intQI_type_node)
    return unsigned_intQI_type_node;

  return d_signed_or_unsigned_type (1, type);
}

tree
d_signed_type (tree type)
{
  tree type1 = TYPE_MAIN_VARIANT (type);
  if (type1 == unsigned_char_type_node || type1 == char_type_node)
    return signed_char_type_node;
  if (type1 == unsigned_type_node)
    return integer_type_node;
  if (type1 == short_unsigned_type_node)
    return short_integer_type_node;
  if (type1 == long_unsigned_type_node)
    return long_integer_type_node;
  if (type1 == long_long_unsigned_type_node)
    return long_long_integer_type_node;
  /*
  if (type1 == widest_unsigned_literal_type_node)
    return widest_integer_literal_type_node;
  */
#if HOST_BITS_PER_WIDE_INT >= 64
  if (type1 == unsigned_intTI_type_node)
    return intTI_type_node;
#endif
  if (type1 == unsigned_intDI_type_node)
    return intDI_type_node;
  if (type1 == unsigned_intSI_type_node)
    return intSI_type_node;
  if (type1 == unsigned_intHI_type_node)
    return intHI_type_node;
  if (type1 == unsigned_intQI_type_node)
    return intQI_type_node;

  return d_signed_or_unsigned_type (0, type);
}

tree
d_signed_or_unsigned_type (int unsignedp, tree type)
{
  if (! INTEGRAL_TYPE_P (type)
      || TREE_UNSIGNED (type) == (unsigned) unsignedp)
    return type;

  if (TYPE_PRECISION (type) == TYPE_PRECISION (signed_char_type_node))
    return unsignedp ? unsigned_char_type_node : signed_char_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (integer_type_node))
    return unsignedp ? unsigned_type_node : integer_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (short_integer_type_node))
    return unsignedp ? short_unsigned_type_node : short_integer_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (long_integer_type_node))
    return unsignedp ? long_unsigned_type_node : long_integer_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (long_long_integer_type_node))
    return (unsignedp ? long_long_unsigned_type_node
	    : long_long_integer_type_node);
  /* %%?
  if (TYPE_PRECISION (type) == TYPE_PRECISION (widest_integer_literal_type_node))
    return (unsignedp ? widest_unsigned_literal_type_node
	    : widest_integer_literal_type_node);
  */
#if HOST_BITS_PER_WIDE_INT >= 64
  if (TYPE_PRECISION (type) == TYPE_PRECISION (intTI_type_node))
    return unsignedp ? unsigned_intTI_type_node : intTI_type_node;
#endif
  if (TYPE_PRECISION (type) == TYPE_PRECISION (intDI_type_node))
    return unsignedp ? unsigned_intDI_type_node : intDI_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (intSI_type_node))
    return unsignedp ? unsigned_intSI_type_node : intSI_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (intHI_type_node))
    return unsignedp ? unsigned_intHI_type_node : intHI_type_node;
  if (TYPE_PRECISION (type) == TYPE_PRECISION (intQI_type_node))
    return unsignedp ? unsigned_intQI_type_node : intQI_type_node;

  return type;
}

extern "C" void pushlevel PARAMS ((int));
extern "C" tree poplevel PARAMS ((int, int, int));
extern "C" int global_bindings_p PARAMS ((void));
extern "C" void insert_block PARAMS ((tree));
extern "C" void set_block PARAMS ((tree));
extern "C" tree getdecls PARAMS ((void));


struct binding_level * current_binding_level;
struct binding_level * global_binding_level;


static binding_level *
alloc_binding_level()
{
    return (struct binding_level *) ggc_alloc_cleared (sizeof (struct binding_level));
}

/* The D front-end does not use the 'binding level' system for a symbol table,
   It is only needed to get debugging information for local variables and
   otherwise support the backend. */

void
pushlevel (int /*arg*/)
{
    binding_level * new_level = alloc_binding_level();
    new_level->level_chain = current_binding_level;
    current_binding_level = new_level;
}

tree
poplevel (int keep, int reverse, int routinebody)
{
    binding_level * level = current_binding_level;
    tree block, decls;

    current_binding_level = level->level_chain;
    decls = level->names;
    if (reverse)
	decls = nreverse(decls);

    //%% pascal does: "output any nested inline functions within this block if not done yet. */
    //...
    // other manips...
    
    if ( level->this_block )
	block = level->this_block;
    else if (keep || routinebody)
	block = make_node(BLOCK);
    else
	block = NULL_TREE;
    
    if (block) {
	BLOCK_VARS( block ) = routinebody ? NULL_TREE : decls;
	BLOCK_SUBBLOCKS( block ) = level->blocks;
	// %% need this for when insert_block is called by backend... or make
	// insert_block do it's work elsewere
	// BLOCK_SUBBLOCKS( block ) = level->blocks;
	// %% pascal does: in each subblock, record that this is the superiod..
    }
    /* In each subblock, record that this is its superior. */
    for (tree t = level->blocks; t; t = TREE_CHAIN (t))
	BLOCK_SUPERCONTEXT (t) = block;
    /* Dispose of the block that we just made inside some higher level. */
    if (routinebody)
	DECL_INITIAL (current_function_decl) = block;
    else if (block)
	{
	    if (!level->this_block)
		current_binding_level->blocks = chainon (current_binding_level->blocks, block);
	}
    /* If we did not make a block for the level just exited, any blocks made for inner
       levels (since they cannot be recorded as subblocks in that level) must be
       carried forward so they will later become subblocks of something else. */
    else if (level->blocks)
	current_binding_level->blocks = chainon (current_binding_level->blocks, level->blocks);
    if (block)
	TREE_USED (block) = 1;
    return block;
}

int
global_bindings_p (void)
{
    // This is called by the backend before parsing.  Need to make this do
    // something or lang_hooks.clear_binding_stack (lhd_clear_binding_stack)
    // loops forever. 
    return current_binding_level == global_binding_level || ! global_binding_level;
}

void
init_global_binding_level()
{
    current_binding_level = global_binding_level = alloc_binding_level();
}


void
insert_block (tree block)
{
    TREE_USED (block) = 1;
    current_binding_level->blocks = chainon (current_binding_level->blocks, block);
}

void
set_block (tree block)
{
    current_binding_level->this_block = block;
}

tree
pushdecl (tree decl)
{
    // %% Pascal: if not a local external routine decl doesn't consitite nesting

    // %% probably  should be cur_irs->getDeclContext()
    if ( DECL_CONTEXT( decl ) != NULL_TREE )
	DECL_CONTEXT( decl ) = current_function_decl; // could be NULL_TREE (top level) .. hmm. // hm.m.
    
    /* Put decls on list in reverse order. We will reverse them later if necessary. */
    TREE_CHAIN (decl) = current_binding_level->names;
    current_binding_level->names = decl;
    if (!TREE_CHAIN (decl))
	current_binding_level->names_end = decl;
    return decl;
}

void
set_decl_binding_chain(tree decl_chain)
{
    assert(current_binding_level);
    current_binding_level->names = decl_chain;
}


// %% this is called by dbxout_init from lang_dependend init when -gstabs is given
// don't need to give it anything?
tree
getdecls ()
{
    if (current_binding_level)
	return current_binding_level->names;
    else
	return NULL_TREE;
}


/* Tree code classes. */

#undef DEFTREECODE
#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) TYPE,

const char tree_code_type[] = {
#include "tree.def"
 'x',
#include "d/d-tree.def"
};
#undef DEFTREECODE

/* Table indexed by tree code giving number of expression
 operands beyond the fixed part of the node structure.
 Not used for types or decls. */

#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) LENGTH,

const unsigned char tree_code_length[] = {
#include "tree.def"
 0,
#include "d/d-tree.def"
};
#undef DEFTREECODE

/* Names of tree components.
 Used for printing out the tree and error messages. */
#define DEFTREECODE(SYM, NAME, TYPE, LEN) NAME,

const char *const tree_code_name[] = {
#include "tree.def"
 "@@dummy",
#include "d/d-tree.def"
};
#undef DEFTREECODE 

struct lang_type *
build_d_type_lang_specific(Type * t)
{
    struct lang_type * l = (struct lang_type *) ggc_alloc_cleared( sizeof(struct lang_type) );
    l->d_type = t;
    return l;
}

// hack.. for comparing dynamic arrays 
tree
d_expr_size (tree exp)
{
    struct lang_type * l = TYPE_LANG_SPECIFIC( TREE_TYPE( exp ));
    if (l && l->varblock_size)
	return l->varblock_size;
    else
	return lhd_expr_size(exp);
}

tree d_keep_list = NULL_TREE;
void dkeep(tree t)
{
    d_keep_list = tree_cons(NULL_TREE, t, d_keep_list);
}


const struct lang_hooks lang_hooks = LANG_HOOKS_INITIALIZER;

