#ifndef DMD_SYMBOL_H
#define DMD_SYMBOL_H

#include "root.h"

#include "d-gcc-tree.h"

#include "mtype.h"

enum mangle_t
{
    mTY_INVALID,
    mTYman_c,
    mTYman_cpp,
    mTYman_std,
    mTYman_pas,
    mTYman_d
};

enum TypeType
{
    // no clue about which can be used together..
    TYnptr =    0x001,
    TYnfunc =   0x010,
    TYjfunc =   0x020,
    TYstruct =  0x040,
    TYarray  =  0x080,
    TYbit    =  0x100,
    TYint    =  0x200,
    mTYconst    = 0x1000,
    mTYvolatile = 0x2000
};

typedef int tym_t;

enum TypeFlag
{
    TFsizeunknown = 0x01,
    TFforward = 0x02,
    TFprototype = 0x04,
    TFfixed = 0x08
};

/*
struct TYPE : Object
{
    tym_t        Tty;
    mangle_t     Tmangle;
    TYPE *       Tnext;
    int          Tcount;
    int          Tflags;
    void *       Ttag;
    void *       Tparamtypes;
    tree         Ttree;

    TYPE();
};

extern TYPE * tsvoid;

extern TYPE * type_alloc(tym_t ty); // ty: combination of TypeType values
extern TYPE * type_fake(tym_t ty);
extern void   type_setcv(TYPE ** pp_type, int ty);
extern void   type_setmangle(TYPE ** pp_type, mangle_t mangle);
extern int/ *?* / type_paramsize(TYPE * t);
*/

enum SymbolStorageClass // scope?
{
    SC_INVALID,
    SCextern,
    SCstatic,
    SCauto,
    SCglobal,
    SCstruct
};

enum SymbolFL
{
    FL_INVALID,
    FLextern,
    FLauto
};

enum SymbolFlag
{
    SFLimplem  = 0x01,
    SFLnodebug = 0x02,
    STRglobal  = 0x04
};

// not sure if this needs to inherit object..
union tree_node; typedef union tree_node dt_t;
struct Symbol : Object
{
    Symbol();
    // !!! need a dtor for Sident..

    char *Sident;
    TYPE *Stype; // maybe type/TYPE ?
    SymbolStorageClass Sclass;
    SymbolFL           Sfl;
    int                Sflags;

    int Ssymnum;

    dt_t * Sdt;

    // fake classsym....
    Symbol * Sstruct;
    int      Sstructalign;

    // Specific to GNU backend
    tree     Stree;
    tree     ScontextDecl; // The DECL_CONTEXT to use for child declarations
    union {
	AggregateDeclaration * aggDecl; // AggregateDeclaration.sinit set in AggregateDeclaration::toInitializer

	// Some information is generated in TypeClass::toCtype that is also
	// needed in ClassDeclaration::toObjFile
	struct { // ClassDeclaration.csym (also TypeClass::toSymbol)
	    Array * interfaceFields;    // FIELD_DECLs for each interface vtbl field
	    Array * interfacePtrs;      // ADDR_EXPRs of VAR_DECLs for each interface thunk vtbl (to avoid duplicating in derived classes)
	    Array * flattenedFields;    // to make creation of static init easier. has nulls for vtbl, monitor, etc..
	} classDecl;

	Array * thunks; // of struct Thunk; for FuncDeclarations
    } Sspecial;
};

struct Thunk
{
    int offset;
    tree staticDecl; // As long as only one object file is produced per run, 
    tree externDecl; // only one of these is needed
    Thunk();
};

typedef struct Symbol Classsym;

extern Symbol * symbol_calloc(const char * string);
extern Symbol * symbol_name(const char * id, int sclass, TYPE * t);
extern Symbol * struct_calloc();
extern Symbol * symbol_generate(SymbolStorageClass sc, TYPE * type);
extern void     symbol_func(Symbol * sym);
extern void     outdata(Symbol * sym);

#endif
