/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;

public class ProtectionDomain {
    private CodeSource code_source;
    private PermissionCollection perms;

    public ProtectionDomain(CodeSource code_source, PermissionCollection perms) {
        this.code_source = code_source;
        this.perms = perms;
        if (perms != null) {
            perms.setReadOnly();
        }
    }

    public final CodeSource getCodeSource() {
        return this.code_source;
    }

    public final PermissionCollection getPermissions() {
        return this.perms;
    }

    public boolean implies(Permission perm) {
        PermissionCollection pc = this.getPermissions();
        if (pc == null) {
            return false;
        }
        return pc.implies(perm);
    }

    public String toString() {
        String linesep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("");
        sb.append("ProtectionDomain (" + linesep);
        if (this.code_source == null) {
            sb.append("CodeSource:null" + linesep);
        } else {
            sb.append(this.code_source + linesep);
        }
        sb.append(this.perms);
        sb.append(linesep + ")" + linesep);
        return sb.toString();
    }
}

