/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Date
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 7523967970034938905L;
    private transient long time;
    private static final String[] weekNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public Date() {
        this.time = System.currentTimeMillis();
    }

    public Date(long time) {
        this.time = time;
    }

    public Date(int year, int month, int day) {
        this.time = new GregorianCalendar(year + 1900, month, day).getTimeInMillis();
    }

    public Date(int year, int month, int day, int hour, int min) {
        this.time = new GregorianCalendar(year + 1900, month, day, hour, min).getTimeInMillis();
    }

    public Date(int year, int month, int day, int hour, int min, int sec) {
        this.time = new GregorianCalendar(year + 1900, month, day, hour, min, sec).getTimeInMillis();
    }

    public Date(String s) {
        this.time = Date.parse(s);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        GregorianCalendar cal = new GregorianCalendar(year + 1900, month, date, hrs, min, sec);
        cal.set(15, 0);
        cal.set(16, 0);
        return cal.getTimeInMillis();
    }

    public long getTime() {
        return this.time;
    }

    public int getTimezoneOffset() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return (cal.get(15) + cal.get(16)) / 60000;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean after(Date when) {
        return this.time > when.time;
    }

    public boolean before(Date when) {
        return this.time < when.time;
    }

    public boolean equals(Object obj) {
        return obj instanceof Date && this.time == ((Date)obj).time;
    }

    public int compareTo(Date when) {
        if (this.time < when.time) {
            return -1;
        }
        if (this.time == when.time) {
            return 0;
        }
        return 1;
    }

    public int compareTo(Object obj) {
        return this.compareTo((Date)obj);
    }

    public int hashCode() {
        return (int)this.time ^ (int)(this.time >>> 32);
    }

    public String toString() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        String day = "0" + cal.get(5);
        String hour = "0" + cal.get(11);
        String min = "0" + cal.get(12);
        String sec = "0" + cal.get(13);
        String year = "000" + cal.get(1);
        return weekNames[cal.get(7) - 1] + " " + monthNames[cal.get(2)] + " " + day.substring(day.length() - 2) + " " + hour.substring(hour.length() - 2) + ":" + min.substring(min.length() - 2) + ":" + sec.substring(sec.length() - 2) + " " + cal.getTimeZone().getDisplayName(cal.getTimeZone().inDaylightTime(this), 0) + " " + year.substring(year.length() - 4);
    }

    public String toLocaleString() {
        return DateFormat.getInstance().format(this);
    }

    public String toGMTString() {
        DateFormat format = DateFormat.getInstance();
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(this);
    }

    private static int skipParens(String string, int offset) {
        int i;
        int len = string.length();
        int p = 0;
        for (i = offset; i < len; ++i) {
            if (string.charAt(i) == '(') {
                ++p;
                continue;
            }
            if (string.charAt(i) != ')') continue;
            if (--p == 0) {
                return i + 1;
            }
            if (p >= 0) continue;
            return i;
        }
        return i;
    }

    private static int parseTz(String tok, char sign) throws IllegalArgumentException {
        int num;
        try {
            num = Integer.parseInt(tok.substring(1));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(tok);
        }
        num = num < 24 ? (num *= 60) : num / 100 * 60 + num % 100;
        if (sign == '-') {
            return -num;
        }
        return num;
    }

    private static int parseMonth(String tok) {
        String[] months = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
        for (int i = 0; i < 12; ++i) {
            if (!months[i].startsWith(tok)) continue;
            return i;
        }
        return -1;
    }

    private static boolean parseDayOfWeek(String tok) {
        String[] daysOfWeek = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        for (int i = 0; i < 7; ++i) {
            if (!daysOfWeek[i].startsWith(tok)) continue;
            return true;
        }
        return false;
    }

    public static long parse(String string) {
        int openParenOffset;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int timezone = 0;
        boolean localTimezone = true;
        StringBuffer buf = new StringBuffer();
        int off = 0;
        while ((openParenOffset = string.indexOf(40, off)) >= 0) {
            buf.append(string.substring(off, openParenOffset));
            off = Date.skipParens(string, openParenOffset);
        }
        buf.append(string.substring(off));
        StringTokenizer strtok = new StringTokenizer(buf.toString().toUpperCase(), " \t\n\r,");
        while (strtok.hasMoreTokens()) {
            String tok = strtok.nextToken();
            char firstch = tok.charAt(0);
            if ((firstch == '+' || firstch == '-') && year >= 0) {
                timezone = Date.parseTz(tok, firstch);
                localTimezone = false;
                continue;
            }
            if (firstch >= '0' && firstch <= '9') {
                while (tok != null && tok.length() > 0) {
                    int num;
                    int colon = tok.indexOf(58);
                    int slash = tok.indexOf(47);
                    int hyphen = tok.indexOf(45);
                    int punctOffset = tok.length();
                    if (colon >= 0) {
                        punctOffset = Math.min(punctOffset, colon);
                    }
                    if (slash >= 0) {
                        punctOffset = Math.min(punctOffset, slash);
                    }
                    if (hyphen >= 0) {
                        punctOffset = Math.min(punctOffset, hyphen);
                    }
                    if (punctOffset == tok.length()) {
                        punctOffset = -1;
                    }
                    try {
                        num = Integer.parseInt(punctOffset < 0 ? tok : tok.substring(0, punctOffset));
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (num > 70 && (punctOffset < 0 || punctOffset == slash)) {
                        year = num > 1900 ? num - 1900 : num;
                    } else if (punctOffset > 0 && punctOffset == colon) {
                        if (hour < 0) {
                            hour = num;
                        } else {
                            minute = num;
                        }
                    } else if (punctOffset > 0 && punctOffset == slash) {
                        if (month < 0) {
                            month = num - 1;
                        } else {
                            day = num;
                        }
                    } else if (hour >= 0 && minute < 0) {
                        minute = num;
                    } else if (minute >= 0 && second < 0) {
                        second = num;
                    } else if (day < 0) {
                        day = num;
                    } else {
                        throw new IllegalArgumentException(tok);
                    }
                    if (punctOffset < 0 || punctOffset + 1 >= tok.length()) {
                        tok = null;
                        continue;
                    }
                    tok = tok.substring(punctOffset + 1);
                }
                continue;
            }
            if (firstch >= 'A' && firstch <= 'Z') {
                if (tok.equals("AM")) {
                    if (hour < 1 || hour > 12) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (hour != 12) continue;
                    hour = 0;
                    continue;
                }
                if (tok.equals("PM")) {
                    if (hour < 1 || hour > 12) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (hour >= 12) continue;
                    hour += 12;
                    continue;
                }
                if (Date.parseDayOfWeek(tok)) continue;
                if (tok.equals("UT") || tok.equals("UTC") || tok.equals("GMT")) {
                    localTimezone = false;
                    continue;
                }
                if (tok.startsWith("UT") || tok.startsWith("GMT")) {
                    char sign;
                    int signOffset = 3;
                    if (tok.charAt(1) == 'T' && tok.charAt(2) != 'C') {
                        signOffset = 2;
                    }
                    if ((sign = tok.charAt(signOffset)) != '+' && sign != '-') {
                        throw new IllegalArgumentException(tok);
                    }
                    timezone = Date.parseTz(tok.substring(signOffset), sign);
                    localTimezone = false;
                    continue;
                }
                int tmpMonth = Date.parseMonth(tok);
                if (tmpMonth >= 0) {
                    month = tmpMonth;
                    continue;
                }
                if (tok.length() == 3 && tok.charAt(2) == 'T') {
                    char ch = tok.charAt(0);
                    if (ch == 'E') {
                        timezone = -300;
                    } else if (ch == 'C') {
                        timezone = -360;
                    } else if (ch == 'M') {
                        timezone = -420;
                    } else if (ch == 'P') {
                        timezone = -480;
                    } else {
                        throw new IllegalArgumentException(tok);
                    }
                    if (tok.charAt(1) == 'D') {
                        timezone += 60;
                    } else if (tok.charAt(1) != 'S') {
                        throw new IllegalArgumentException(tok);
                    }
                    localTimezone = false;
                    continue;
                }
                throw new IllegalArgumentException(tok);
            }
            throw new IllegalArgumentException(tok);
        }
        if (minute < 0) {
            minute = 0;
        }
        if (second < 0) {
            second = 0;
        }
        if (year < 0 || month < 0 || day < 0 || hour < 0) {
            throw new IllegalArgumentException("Missing field");
        }
        return Date.UTC(year, month, day, hour, minute, second) + (long)(localTimezone ? new Date(year, month, day).getTimezoneOffset() * 60 * 1000 : -timezone * 60 * 1000);
    }

    public int getYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(1) - 1900;
    }

    public void setYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(1, 1900 + year);
        this.time = cal.getTimeInMillis();
    }

    public int getMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(2);
    }

    public void setMonth(int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(2, month);
        this.time = cal.getTimeInMillis();
    }

    public int getDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(5);
    }

    public void setDate(int date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(5, date);
        this.time = cal.getTimeInMillis();
    }

    public int getDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(7) - 1;
    }

    public int getHours() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(11);
    }

    public void setHours(int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(11, hours);
        this.time = cal.getTimeInMillis();
    }

    public int getMinutes() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(12);
    }

    public void setMinutes(int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(12, minutes);
        this.time = cal.getTimeInMillis();
    }

    public int getSeconds() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(13);
    }

    public void setSeconds(int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(13, seconds);
        this.time = cal.getTimeInMillis();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.time = input.readLong();
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeLong(this.time);
    }
}

