/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.Serializable;

public class Checkbox
extends Component
implements ItemSelectable,
Serializable {
    private static final long serialVersionUID = 7270714317450821763L;
    private CheckboxGroup group;
    private String label;
    private boolean state;
    private transient ItemListener item_listeners;

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String label) {
        this(label, false, null);
    }

    public Checkbox(String label, boolean state) {
        this(label, state, null);
    }

    public Checkbox(String label, CheckboxGroup group, boolean state) {
        this(label, state, group);
    }

    public Checkbox(String label, boolean state, CheckboxGroup group) {
        this.label = label;
        this.state = state;
        this.group = group;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setLabel(label);
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean state) {
        this.state = state;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setState(state);
        }
    }

    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] objs = new Object[]{this.label};
        return objs;
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public synchronized void setCheckboxGroup(CheckboxGroup group) {
        this.group = group;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setCheckboxGroup(group);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
        super.addNotify();
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners(this.item_listeners, Checkbox.class$("java.awt.event.ItemListener"));
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "label=" + this.label + ",state=" + this.state + ",group=" + this.group + "," + super.paramString();
    }
}

