/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.awt.EventModifier;
import java.awt.Component;
import java.awt.event.ComponentEvent;

public abstract class InputEvent
extends ComponentEvent {
    private static final long serialVersionUID = -2482525981698309786L;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    static final int CONVERT_MASK = 10176;
    private final long when;
    int modifiers;

    InputEvent(Component source, int id, long when, int modifiers) {
        super(source, id);
        this.when = when;
        this.modifiers = EventModifier.extend(modifiers);
    }

    public boolean isShiftDown() {
        return (this.modifiers >> 6 & 1) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers >> 7 & 1) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers >> 8 & 1) != 0;
    }

    public boolean isAltDown() {
        return (this.modifiers >> 9 & 1) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers >> 13 & 1) != 0;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return EventModifier.revert(this.modifiers);
    }

    public int getModifiersEx() {
        return this.modifiers;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public static String getModifiersExText(int modifiers) {
        if ((modifiers &= 0x3FC0) == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        if ((modifiers & 0x100) != 0) {
            s.append("Meta+");
        }
        if ((modifiers & 0x80) != 0) {
            s.append("Ctrl+");
        }
        if ((modifiers & 0x200) != 0) {
            s.append("Alt+");
        }
        if ((modifiers & 0x40) != 0) {
            s.append("Shift+");
        }
        if ((modifiers & 0x2000) != 0) {
            s.append("Alt Graph+");
        }
        if ((modifiers & 0x400) != 0) {
            s.append("Button1+");
        }
        if ((modifiers & 0x800) != 0) {
            s.append("Button2+");
        }
        if ((modifiers & 0x1000) != 0) {
            s.append("Button3+");
        }
        return s.substring(0, s.length() - 1);
    }
}

