/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;

final class ByteBufferImpl
extends ByteBuffer {
    private boolean readOnly;

    ByteBufferImpl(int capacity) {
        this(new byte[capacity], 0, capacity, capacity, 0, -1, false);
    }

    ByteBufferImpl(byte[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.order());
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ByteBuffer slice() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public ByteBuffer duplicate() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public ByteBuffer compact() {
        int pos = this.position();
        if (pos > 0) {
            int count = this.remaining();
            this.shiftDown(0, pos, count);
            this.position(count);
            this.limit(this.capacity());
        }
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final byte get() {
        byte result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final ByteBuffer put(byte value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final byte get(int index) {
        return this.backing_buffer[index];
    }

    public final ByteBuffer put(int index, byte value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public final ByteBuffer putChar(char value) {
        ByteBufferHelper.putChar(this, value, this.order());
        return this;
    }

    public final char getChar(int index) {
        return ByteBufferHelper.getChar(this, index, this.order());
    }

    public final ByteBuffer putChar(int index, char value) {
        ByteBufferHelper.putChar(this, index, value, this.order());
        return this;
    }

    public final short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public final ByteBuffer putShort(short value) {
        ByteBufferHelper.putShort(this, value, this.order());
        return this;
    }

    public final short getShort(int index) {
        return ByteBufferHelper.getShort(this, index, this.order());
    }

    public final ByteBuffer putShort(int index, short value) {
        ByteBufferHelper.putShort(this, index, value, this.order());
        return this;
    }

    public final int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public final ByteBuffer putInt(int value) {
        ByteBufferHelper.putInt(this, value, this.order());
        return this;
    }

    public final int getInt(int index) {
        return ByteBufferHelper.getInt(this, index, this.order());
    }

    public final ByteBuffer putInt(int index, int value) {
        ByteBufferHelper.putInt(this, index, value, this.order());
        return this;
    }

    public final long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public final ByteBuffer putLong(long value) {
        ByteBufferHelper.putLong(this, value, this.order());
        return this;
    }

    public final long getLong(int index) {
        return ByteBufferHelper.getLong(this, index, this.order());
    }

    public final ByteBuffer putLong(int index, long value) {
        ByteBufferHelper.putLong(this, index, value, this.order());
        return this;
    }

    public final float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public final ByteBuffer putFloat(float value) {
        ByteBufferHelper.putFloat(this, value, this.order());
        return this;
    }

    public final float getFloat(int index) {
        return ByteBufferHelper.getFloat(this, index, this.order());
    }

    public final ByteBuffer putFloat(int index, float value) {
        ByteBufferHelper.putFloat(this, index, value, this.order());
        return this;
    }

    public final double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public final ByteBuffer putDouble(double value) {
        ByteBufferHelper.putDouble(this, value, this.order());
        return this;
    }

    public final double getDouble(int index) {
        return ByteBufferHelper.getDouble(this, index, this.order());
    }

    public final ByteBuffer putDouble(int index, double value) {
        ByteBufferHelper.putDouble(this, index, value, this.order());
        return this;
    }
}

