#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export PKG2=libtiff4
export PKG3=libtiff-devel
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}
export FULLPKGLZW=${PKG}-LZW-${VER}-${REL}
export FULLPKGLZW2=${PKG2}-LZW-${VER}-${REL}
export FULLPKGLZW3=${PKG3}-LZW-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-v${VER}-beta2.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-v${VER}-beta2.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-v${VER}-beta2.tar.${src_orig_pkg_ext}
export src_orig_pkg_name2=v3.4pics.tar.gz
export src_orig_pkg_name3=tif_rpt_3.6.0.tar.gz
export src_orig_pkg_name4=libtiff-lzw-compression-kit-1.3.tar.gz
export src_orig_pkg_dir4=`echo ${src_orig_pkg_name4} | \
sed -e 's/\.tar\.[gb]z[2]*$//'`
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_lzw_pkg_name=${PKG}-LZW-${VER}-${REL}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2
export bin_lzw_pkg_name=${FULLPKGZLW}.tar.bz2
export bin_lzw_pkg_name2=${FULLPKGZLW2}.tar.bz2
export bin_lzw_pkg_name3=${FULLPKGZLW3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_orig_pkg2=${topdir}/${src_orig_pkg_name2}
export src_orig_pkg3=${topdir}/${src_orig_pkg_name3}
export src_orig_pkg4=${topdir}/${src_orig_pkg_name4}
export src_pkg=${topdir}/${src_pkg_name}
export src_lzw_pkg=${topdir}/${src_lzw_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export bin_lzw_pkg=${topdir}/${bin_lzw_pkg_name}
export bin_lzw_pkg2=${topdir}/${bin_lzw_pkg_name2}
export bin_lzw_pkg3=${topdir}/${bin_lzw_pkg_name3}
export srcdir=${topdir}/tiff-v3.6.0-beta2
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=${prefix}/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
CFLAGS="-O2"

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  cd ${srcdir} && \
  tar xvzf ${src_orig_pkg2} ; \
  tar xvzf ${src_orig_pkg3} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} \
  && mkdirs && \
  cd ${srcdir} && \
  chmod +x CYGWIN-PATCHES/shtool && \
  CYGWIN-PATCHES/shtool mkshadow -v pics ${objdir}/pics
)}

lzw_setup() {
  (the_dir=${srcdir}
  if [ "x$1" != "x" ]; then
    the_dir=$1 ; \
  fi && \
  cd ${the_dir} && \
  tar xvzf ${src_orig_pkg4} && \
  cd ${src_orig_pkg_dir4} && \
  cp tif_lzw.c ../libtiff/tif_lzw.c
)}

prep_lzw() {
  (prep && lzw_setup ${srcdir}
)}

conf() {
  (cd ${objdir} && \
  ${srcdir}/configure --noninteractive \
  --srcdir=${srcdir} --prefix=${prefix}
)}

build() {
  (cd ${objdir} && \
  make DESTDIR=${instdir} && \
  cp ${objdir}/libtiff/cygtiff*.dll ${objdir}/tools/
)}

check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install-private DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  for dirn in ${prefix}/share/doc/${PKG}-${VER} \
    ${prefix}/share/doc/${PKG3}-${VER} \
    ${prefix}/share/doc/Cygwin ; do \
    mkdir -p ${instdir}${dirn} ; \
  done && \
  templist=""; \
  for f in ${srcdir}/COPYRIGHT ${srcdir}/README ${srcdir}/RELEASE-DATE \
           ${srcdir}/TODO ${srcdir}/VERSION; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG3}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2>&1
  find . -name "*.dll" | xargs strip >/dev/null 2>&1
)}

mkpatch_setup() {
  (cd ${srcdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  mv tiff-v3.6.0-beta2 ../tiff-v3.6.0-beta2-orig && \
  cd ../tiff-v3.6.0-beta2-orig && \
  tar xvzf ${src_orig_pkg2} && \
  tar xvzf ${src_orig_pkg3}
)}

mkpatch() {
  (mkpatch_setup && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    tiff-v3.6.0-beta2-orig/ tiff-v3.6.0-beta2/ > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf tiff-v3.6.0-beta2-orig
)}

mkpatch_lzw() {
  (mkpatch_setup && \
  lzw_setup ${topdir}/tiff-v3.6.0-beta2-orig && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' -x "${src_orig_pkg_dir4}"\
    tiff-v3.6.0-beta2-orig/ tiff-v3.6.0-beta2/ > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf tiff-v3.6.0-beta2-orig
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} \
    ${pnoslash}/bin/*.exe \
    ${pnoslash}/share/man/man1/* \
    ${pnoslash}/share/doc/Cygwin/${PKG}-${VER}.README \
    ${pnoslash}/share/doc/tiff-${VER}/* 
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll
  tar cvjf ${bin_pkg3} \
    ${pnoslash}/lib/* \
    ${pnoslash}/include/* \
    ${pnoslash}/share/man/man3/* \
    ${pnoslash}/share/doc/Cygwin/${PKG3}-${VER}.README \
    ${pnoslash}/share/doc/${PKG3}-${VER}/* 
)}

pkg_lzw() {
  (cd ${instdir} && \
  tar cvjf ${bin_lzw_pkg} \
    ${pnoslash}/bin/*.exe \
    ${pnoslash}/man/man1/* \
    ${pnoslahs}/doc/Cygwin/${PKG}-${VER}.README \
    ${pnoslash}/doc/tiff-${VER}/* 
  tar cvjf ${bin_lzw_pkg2} ${pnoslash}/bin/*.dll
  tar cvjf ${bin_lzw_pkg3} \
    ${pnoslash}/lib/* \
    ${pnoslash}/include/* \
    ${pnoslash}/man/man3/* \
    ${pnoslahs}/doc/Cygwin/${PKG3}-${VER}.README \
    ${pnoslash}/doc/${PKG3}-${VER}/* 
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp ${src_orig_pkg2} ${srcinstdir}/${src_orig_pkg_name2} && \
  cp ${src_orig_pkg3} ${srcinstdir}/${src_orig_pkg_name3} && \
  cp ${src_orig_pkg4} ${srcinstdir}/${src_orig_pkg_name4} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

spkg_lzw() {
  (mkpatch_lzw && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp ${src_orig_pkg2} ${srcinstdir}/${src_orig_pkg_name2} && \
  cp ${src_orig_pkg3} ${srcinstdir}/${src_orig_pkg_name3} && \
  cp ${src_orig_pkg4} ${srcinstdir}/${src_orig_pkg_name4} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_lzw_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}

case $1 in
  mkdirs) mkdirs ; STATUS=$? ;;
  prep)	prep ; STATUS=$? ;;
  prep_lzw)	prep_lzw ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  mkpatch_lzw)	mkpatch_lzw ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  pkg_lzw)	pkg_lzw ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  spkg_lzw)	spkg_lzw ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  lzw) prep_lzw && conf && build && install && \
     strip && pkg_lzw && spkg_lzw && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
