(* $I1: Unison file synchronizer: src/case.ml $ *)
(* $I2: Last modified by bcpierce on Sun, 18 Aug 2002 08:50:53 -0400 $ *)
(* $I3: Copyright 1999-2002 (see COPYING for details) $ *)

(* The update detector, reconciler, and transporter behave differently       *)
(* depending on whether the local and/or remote file system is case          *)
(* insensitive.  This pref is set during the initial handshake if any one of *)
(* the hosts is case insensitive.                                            *)
let caseInsensitiveMode =
  Prefs.createBool "ignorecase" false
    "ignore upper/lowercase spelling of filenames"
    ("When set to {\\tt true}, this flag causes Unison to treat "
     ^ "filenames as case insensitive---i.e., files in the two "
     ^ "replicas whose names differ in (upper- and lower-case) `spelling' "
     ^ "are treated as the same file.  This flag is set automatically when "
     ^ "either host is running Windows or OSX.  In rare circumstances it is  "
     ^ "also useful to set it manually (e.g. when running Unison on a  "
     ^ "Unix system with a FAT [Windows] volume mounted).")

let insensitive () = Prefs.read caseInsensitiveMode

(* During startup the client determines the case sensitivity of each root.   *)
(* If any root is case insensitive, all roots must know it; we ensure this   *)
(* by storing the information in a pref so that it is propagated to the      *)
(* server with the rest of the prefs.                                        *)
let init someHostIsCaseInsensitive =
  Prefs.set caseInsensitiveMode
    (someHostIsCaseInsensitive || Prefs.read caseInsensitiveMode)

