/* l_w32pe.h -- created from l_w32pe.bin, 3966 (0xf7e) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2002 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2002 Laszlo Molnar
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define NRV_LOADER_ADLER32 0x80fbd47f
#define NRV_LOADER_CRC32   0x2a66725a

unsigned char nrv_loader[3966] = {
128,124, 36,  8,  1, 15,133,  0,  0,  0,  0, 96,190, 69, 83, 73,   /* 0x   0 */
 48,141,190, 69, 68, 73, 48,102,255,135, 73, 67, 79, 78,102,129,   /* 0x  10 */
135, 73, 67, 79, 78, 68, 82,199,135, 84, 76, 83, 65, 84, 76, 83,   /* 0x  20 */
 86, 87,131,205,255,235,  0,164,235,  0,138,  6, 70,136,  7, 71,   /* 0x  30 */
  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,   /* 0x  40 */
114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,   /* 0x  50 */
 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,   /* 0x  60 */
  0,  1,219,115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0,   /* 0x  70 */
 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,   /* 0x  80 */
116,  0,137,197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  90 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,  0,   /* 0x  a0 */
 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,   /* 0x  b0 */
117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,117,   /* 0x  c0 */
  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,129,   /* 0x  d0 */
253,  0,243,255,255,131,209,  1,137,242,141, 52, 47,243,164,137,   /* 0x  e0 */
214,233,  0,  0,  0,  0,141, 20, 47,131,253,252,118,  0,138,  2,   /* 0x  f0 */
 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,194,   /* 0x 100 */
  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,  0,   /* 0x 110 */
  0,  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,   /* 0x 120 */
  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,114,  0,184,   /* 0x 130 */
  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 140 */
192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,  1,219,   /* 0x 150 */
115, 11,117,  0,139, 30,131,238,252, 17,219,114,  0, 72,  1,219,   /* 0x 160 */
117,  7,139, 30,131,238,252, 17,219, 17,192,235,  0, 49,201,131,   /* 0x 170 */
232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,  0,209,   /* 0x 180 */
248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 190 */
 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,   /* 0x 1a0 */
  0, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,   /* 0x 1b0 */
219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,   /* 0x 1c0 */
117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,   /* 0x 1d0 */
129,253,  0,251,255,255,131,209,  1,137,242,141, 52, 47,243,164,   /* 0x 1e0 */
137,214,233,  0,  0,  0,  0,141, 20, 47,131,253,252,118,  0,138,   /* 0x 1f0 */
  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,   /* 0x 200 */
194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,   /* 0x 210 */
  0,  0,  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,   /* 0x 220 */
117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,114,  0,   /* 0x 230 */
184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 240 */
 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,  1,   /* 0x 250 */
219,115, 11,117,  0,139, 30,131,238,252, 17,219,114,  0, 72,  1,   /* 0x 260 */
219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,  0,  1,219,   /* 0x 270 */
117,  7,139, 30,131,238,252, 17,219, 17,201,235,  0, 49,201,131,   /* 0x 280 */
232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,  0,209,   /* 0x 290 */
248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 2a0 */
114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,114,190,   /* 0x 2b0 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,   /* 0x 2c0 */
  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,117,  9,   /* 0x 2d0 */
139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,129,253,   /* 0x 2e0 */
  0,251,255,255,131,209,  2,137,242,141, 52, 47,243,164,137,214,   /* 0x 2f0 */
233,  0,  0,  0,  0,141, 20, 47,131,253,252,118,  0,138,  2, 66,   /* 0x 300 */
136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,194,  4,   /* 0x 310 */
137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,  0,  0,   /* 0x 320 */
  0,173,  1,199, 15,130,  0,  0,  0,  0, 94,141,190, 84, 69, 88,   /* 0x 330 */
 86,137,247,185, 84, 69, 88, 76,138,  7, 71, 44,232, 60,  1,119,   /* 0x 340 */
247,128, 63, 63,117,  0,139,  7,138, 95,  4,102,193,232,  8,134,   /* 0x 350 */
196,193,192, 16,134,196, 41,248,128,235,232,  1,240,137,  7,131,   /* 0x 360 */
199,  5,137,216,226,  0,185, 84, 69, 88, 76,176,232,176,233,242,   /* 0x 370 */
174,117,  0,128, 63, 63,117,  0,139,  7,102,193,232,  8,134,196,   /* 0x 380 */
193,192, 16,134,196, 41,248,  1,240,171,235,  0,141,190, 66, 73,   /* 0x 390 */
 77, 80,139,  7,  9,192,116,  0,139, 95,  4,141,132, 48, 73, 77,   /* 0x 3a0 */
 80, 83,  1,243, 80,131,199,  8,255,150, 76, 79, 65, 68,149,138,   /* 0x 3b0 */
  7, 71,  8,192,116,220,137,249,121,  0,122, 14,139,  7,131,199,   /* 0x 3c0 */
  4,139,132, 48, 75, 51, 50, 79,235,  0, 15,183,  7, 71, 80, 71,   /* 0x 3d0 */
185, 87, 72,242,174, 85,255,150, 71, 69, 84, 80,  9,192,116,  7,   /* 0x 3e0 */
137,  3,131,195,  4,235,  0, 97, 49,192,194, 12,  0,255,150, 69,   /* 0x 3f0 */
 88, 73, 84,141,190, 66, 82, 69, 76,131,199,  4,141, 94,252, 49,   /* 0x 400 */
192,138,  7, 71,  9,192,116,  0, 60,239,119, 17,  1,195,139,  3,   /* 0x 410 */
134,196,193,192, 16,134,196,  1,240,137,  3,235,226, 36, 15,193,   /* 0x 420 */
224, 16,102,139,  7,131,199,  2,  9,192,117,  0,139,  7,131,199,   /* 0x 430 */
  4,235,  0,135,254,141,143, 68, 69, 76, 84,169,102,  1, 12,  7,   /* 0x 440 */
173,  9,192,117,247,193,233, 16,169,102,  1, 12,  7,173,  9,192,   /* 0x 450 */
117,247, 97, 49,192, 64,194, 12,  0,233, 74, 77, 80, 79, 85, 80,   /* 0x 460 */
 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x 470 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,  0,  0,   /* 0x 480 */
 80, 69, 73, 83, 68, 76, 76, 49,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x 490 */
 11,  0,  0,  0, 80, 69, 77, 65, 73, 78, 50, 48,  1,  0,  0,  0,   /* 0x 4a0 */
 80, 69, 77, 65, 73, 78, 48, 49, 11,  0,  0,  0, 80, 69, 73, 67,   /* 0x 4b0 */
 79, 78, 83, 49, 23,  0,  0,  0, 80, 69, 73, 67, 79, 78, 83, 50,   /* 0x 4c0 */
 30,  0,  0,  0, 80, 69, 73, 67, 79, 78, 83, 90, 39,  0,  0,  0,   /* 0x 4d0 */
 80, 69, 84, 76, 83, 72, 65, 75, 39,  0,  0,  0, 80, 69, 77, 65,   /* 0x 4e0 */
 73, 78, 48, 50, 49,  0,  0,  0, 78, 50, 66, 83, 77, 65, 49, 48,   /* 0x 4f0 */
 53,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0, 78, 50, 66, 68,   /* 0x 500 */
 69, 67, 49, 48,  4,  0,  0,  0, 78, 50, 66, 70, 65, 83, 49, 48,   /* 0x 510 */
 56,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0, 78, 50, 66, 68,   /* 0x 520 */
 69, 67, 49, 48,  4,  0,  0,  0, 78, 50, 66, 70, 65, 83, 49, 49,   /* 0x 530 */
 58,  0,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48, 64,  0,  0,  0,   /* 0x 540 */
 78, 50, 66, 83, 77, 65, 50, 48, 75,  0,  0,  0,  0,  0,  0,  0,   /* 0x 550 */
 77,  0,  0,  0, 78, 50, 66, 83, 77, 65, 49, 48,  2,  0,  0,  0,   /* 0x 560 */
 78, 50, 66, 70, 65, 83, 50, 48, 80,  0,  0,  0,  0,  0,  0,  0,   /* 0x 570 */
 82,  0,  0,  0, 78, 50, 66, 70, 65, 83, 49, 49,  0,  0,  0,  0,   /* 0x 580 */
 78, 50, 66, 68, 69, 67, 50, 48, 87,  0,  0,  0, 78, 50, 66, 83,   /* 0x 590 */
 77, 65, 51, 48,100,  0,  0,  0,  0,  0,  0,  0,113,  0,  0,  0,   /* 0x 5a0 */
 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0, 78, 50, 66, 70,   /* 0x 5b0 */
 65, 83, 51, 48,113,  0,  0,  0,  0,  0,  0,  0,117,  0,  0,  0,   /* 0x 5c0 */
 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x 5d0 */
128,  0,  0,  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,   /* 0x 5e0 */
 78, 50, 66, 68, 69, 67, 51, 48,128,  0,  0,  0,  0,  0,  0,  0,   /* 0x 5f0 */
146,  0,  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,  0,  0,  0,  0,   /* 0x 600 */
  0,  0,  0,  0,176,  0,  0,  0, 78, 50, 66, 68, 69, 67, 53, 48,   /* 0x 610 */
  0,  0,  0,  0, 78, 50, 66, 83, 77, 65, 52, 48,190,  0,  0,  0,   /* 0x 620 */
  0,  0,  0,  0,203,  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x 630 */
 49,  0,  0,  0, 78, 50, 66, 70, 65, 83, 52, 48,203,  0,  0,  0,   /* 0x 640 */
  0,  0,  0,  0,207,  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x 650 */
 49,  0,  0,  0,  0,  0,  0,  0,218,  0,  0,  0, 78, 50, 66, 68,   /* 0x 660 */
 69, 67, 51, 48, 49,  0,  0,  0, 78, 50, 66, 68, 85, 77, 77, 49,   /* 0x 670 */
218,  0,  0,  0, 78, 50, 66, 83, 77, 65, 53, 48,218,  0,  0,  0,   /* 0x 680 */
 78, 50, 66, 70, 65, 83, 53, 48,220,  0,  0,  0, 78, 50, 66, 68,   /* 0x 690 */
 69, 67, 53, 48,223,  0,  0,  0, 78, 50, 66, 83, 77, 65, 54, 48,   /* 0x 6a0 */
232,  0,  0,  0,  0,  0,  0,  0,246,  0,  0,  0, 78, 50, 66, 68,   /* 0x 6b0 */
 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 54, 48,   /* 0x 6c0 */
246,  0,  0,  0,  0,  0,  0,  0,254,  0,  0,  0, 78, 50, 66, 70,   /* 0x 6d0 */
 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0, 12,  1,  0,  0,   /* 0x 6e0 */
 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 66, 70,   /* 0x 6f0 */
 65, 83, 54, 49, 12,  1,  0,  0,  0,  0,  0,  0, 34,  1,  0,  0,   /* 0x 700 */
 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 66, 68,   /* 0x 710 */
 69, 67, 54, 48, 34,  1,  0,  0, 78, 82, 86, 50, 66, 69, 78, 68,   /* 0x 720 */
 34,  1,  0,  0, 78, 50, 68, 83, 77, 65, 49, 48, 34,  1,  0,  0,   /* 0x 730 */
  0,  0,  0,  0, 36,  1,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,   /* 0x 740 */
  4,  0,  0,  0, 78, 50, 68, 70, 65, 83, 49, 48, 37,  1,  0,  0,   /* 0x 750 */
  0,  0,  0,  0, 39,  1,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,   /* 0x 760 */
  4,  0,  0,  0, 78, 50, 68, 70, 65, 83, 49, 49, 39,  1,  0,  0,   /* 0x 770 */
 78, 50, 68, 68, 69, 67, 49, 48, 45,  1,  0,  0, 78, 50, 68, 83,   /* 0x 780 */
 77, 65, 50, 48, 56,  1,  0,  0,  0,  0,  0,  0, 58,  1,  0,  0,   /* 0x 790 */
 78, 50, 68, 83, 77, 65, 49, 48,  2,  0,  0,  0, 78, 50, 68, 70,   /* 0x 7a0 */
 65, 83, 50, 48, 61,  1,  0,  0,  0,  0,  0,  0, 63,  1,  0,  0,   /* 0x 7b0 */
 78, 50, 68, 70, 65, 83, 49, 49,  0,  0,  0,  0, 78, 50, 68, 68,   /* 0x 7c0 */
 69, 67, 50, 48, 68,  1,  0,  0, 78, 50, 68, 83, 77, 65, 51, 48,   /* 0x 7d0 */
 81,  1,  0,  0,  0,  0,  0,  0, 94,  1,  0,  0, 78, 50, 68, 68,   /* 0x 7e0 */
 69, 67, 51, 48, 16,  0,  0,  0, 78, 50, 68, 70, 65, 83, 51, 48,   /* 0x 7f0 */
 94,  1,  0,  0,  0,  0,  0,  0,100,  1,  0,  0, 78, 50, 68, 68,   /* 0x 800 */
 69, 67, 51, 48, 16,  0,  0,  0,  0,  0,  0,  0,109,  1,  0,  0,   /* 0x 810 */
 78, 50, 68, 68, 69, 67, 51, 48, 16,  0,  0,  0, 78, 50, 68, 68,   /* 0x 820 */
 69, 67, 51, 48,109,  1,  0,  0,  0,  0,  0,  0,125,  1,  0,  0,   /* 0x 830 */
 78, 50, 68, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x 840 */
143,  1,  0,  0, 78, 50, 68, 68, 69, 67, 54, 48,  0,  0,  0,  0,   /* 0x 850 */
  0,  0,  0,  0,177,  1,  0,  0, 78, 50, 68, 68, 69, 67, 53, 48,   /* 0x 860 */
  0,  0,  0,  0, 78, 50, 68, 83, 77, 65, 52, 48,191,  1,  0,  0,   /* 0x 870 */
  0,  0,  0,  0,204,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x 880 */
 69,  0,  0,  0, 78, 50, 68, 70, 65, 83, 52, 48,204,  1,  0,  0,   /* 0x 890 */
  0,  0,  0,  0,208,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x 8a0 */
 69,  0,  0,  0,  0,  0,  0,  0,219,  1,  0,  0, 78, 50, 68, 68,   /* 0x 8b0 */
 69, 67, 51, 48, 69,  0,  0,  0, 78, 50, 68, 68, 85, 77, 77, 49,   /* 0x 8c0 */
219,  1,  0,  0, 78, 50, 68, 83, 77, 65, 53, 48,219,  1,  0,  0,   /* 0x 8d0 */
 78, 50, 68, 70, 65, 83, 53, 48,221,  1,  0,  0, 78, 50, 68, 68,   /* 0x 8e0 */
 69, 67, 53, 48,224,  1,  0,  0, 78, 50, 68, 83, 77, 65, 54, 48,   /* 0x 8f0 */
233,  1,  0,  0,  0,  0,  0,  0,247,  1,  0,  0, 78, 50, 68, 68,   /* 0x 900 */
 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 68, 70, 65, 83, 54, 48,   /* 0x 910 */
247,  1,  0,  0,  0,  0,  0,  0,255,  1,  0,  0, 78, 50, 68, 70,   /* 0x 920 */
 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0, 13,  2,  0,  0,   /* 0x 930 */
 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 68, 70,   /* 0x 940 */
 65, 83, 54, 49, 13,  2,  0,  0,  0,  0,  0,  0, 35,  2,  0,  0,   /* 0x 950 */
 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 68, 68,   /* 0x 960 */
 69, 67, 54, 48, 35,  2,  0,  0, 78, 82, 86, 50, 68, 69, 78, 68,   /* 0x 970 */
 35,  2,  0,  0, 78, 50, 69, 83, 77, 65, 49, 48, 35,  2,  0,  0,   /* 0x 980 */
  0,  0,  0,  0, 37,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,   /* 0x 990 */
  4,  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 48, 38,  2,  0,  0,   /* 0x 9a0 */
  0,  0,  0,  0, 40,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,   /* 0x 9b0 */
  4,  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49, 40,  2,  0,  0,   /* 0x 9c0 */
 78, 50, 69, 68, 69, 67, 49, 48, 46,  2,  0,  0, 78, 50, 69, 83,   /* 0x 9d0 */
 77, 65, 50, 48, 57,  2,  0,  0,  0,  0,  0,  0, 59,  2,  0,  0,   /* 0x 9e0 */
 78, 50, 69, 83, 77, 65, 49, 48,  2,  0,  0,  0, 78, 50, 69, 70,   /* 0x 9f0 */
 65, 83, 50, 48, 62,  2,  0,  0,  0,  0,  0,  0, 64,  2,  0,  0,   /* 0x a00 */
 78, 50, 69, 70, 65, 83, 49, 49,  0,  0,  0,  0, 78, 50, 69, 68,   /* 0x a10 */
 69, 67, 50, 48, 69,  2,  0,  0, 78, 50, 69, 83, 77, 65, 51, 48,   /* 0x a20 */
 82,  2,  0,  0,  0,  0,  0,  0, 95,  2,  0,  0, 78, 50, 69, 68,   /* 0x a30 */
 69, 67, 51, 48, 31,  0,  0,  0, 78, 50, 69, 70, 65, 83, 51, 48,   /* 0x a40 */
 95,  2,  0,  0,  0,  0,  0,  0,101,  2,  0,  0, 78, 50, 69, 68,   /* 0x a50 */
 69, 67, 51, 48, 31,  0,  0,  0,  0,  0,  0,  0,110,  2,  0,  0,   /* 0x a60 */
 78, 50, 69, 68, 69, 67, 51, 48, 31,  0,  0,  0, 78, 50, 69, 68,   /* 0x a70 */
 69, 67, 51, 48,110,  2,  0,  0,  0,  0,  0,  0,126,  2,  0,  0,   /* 0x a80 */
 78, 50, 69, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x a90 */
141,  2,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,  0,  0,  0,   /* 0x aa0 */
  0,  0,  0,  0,159,  2,  0,  0, 78, 50, 69, 68, 69, 67, 54, 48,   /* 0x ab0 */
  0,  0,  0,  0, 78, 50, 69, 83, 77, 65, 52, 48,205,  2,  0,  0,   /* 0x ac0 */
  0,  0,  0,  0,218,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x ad0 */
 82,  0,  0,  0, 78, 50, 69, 70, 65, 83, 52, 48,218,  2,  0,  0,   /* 0x ae0 */
  0,  0,  0,  0,222,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x af0 */
 82,  0,  0,  0,  0,  0,  0,  0,233,  2,  0,  0, 78, 50, 69, 68,   /* 0x b00 */
 69, 67, 51, 48, 82,  0,  0,  0, 78, 50, 69, 68, 85, 77, 77, 49,   /* 0x b10 */
233,  2,  0,  0, 78, 50, 69, 83, 77, 65, 53, 48,233,  2,  0,  0,   /* 0x b20 */
 78, 50, 69, 70, 65, 83, 53, 48,235,  2,  0,  0, 78, 50, 69, 68,   /* 0x b30 */
 69, 67, 53, 48,238,  2,  0,  0, 78, 50, 69, 83, 77, 65, 54, 48,   /* 0x b40 */
247,  2,  0,  0,  0,  0,  0,  0,  5,  3,  0,  0, 78, 50, 69, 68,   /* 0x b50 */
 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 69, 70, 65, 83, 54, 48,   /* 0x b60 */
  5,  3,  0,  0,  0,  0,  0,  0, 13,  3,  0,  0, 78, 50, 69, 70,   /* 0x b70 */
 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0, 27,  3,  0,  0,   /* 0x b80 */
 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 69, 70,   /* 0x b90 */
 65, 83, 54, 49, 27,  3,  0,  0,  0,  0,  0,  0, 49,  3,  0,  0,   /* 0x ba0 */
 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0, 78, 50, 69, 68,   /* 0x bb0 */
 69, 67, 54, 48, 49,  3,  0,  0, 78, 82, 86, 50, 69, 69, 78, 68,   /* 0x bc0 */
 49,  3,  0,  0, 80, 69, 77, 85, 76, 84, 73, 80, 49,  3,  0,  0,   /* 0x bd0 */
  0,  0,  0,  0, 58,  3,  0,  0, 80, 69, 77, 65, 73, 78, 48, 50,   /* 0x be0 */
  1,  0,  0,  0, 80, 69, 77, 65, 73, 78, 49, 48, 58,  3,  0,  0,   /* 0x bf0 */
 80, 69, 67, 65, 76, 76, 84, 82, 59,  3,  0,  0, 80, 69, 67, 84,   /* 0x c00 */
 84, 80, 79, 83, 59,  3,  0,  0, 80, 69, 67, 84, 84, 78, 85, 76,   /* 0x c10 */
 65,  3,  0,  0, 80, 69, 68, 85, 77, 77, 89, 48, 67,  3,  0,  0,   /* 0x c20 */
 67, 65, 76, 76, 84, 82, 48, 48, 67,  3,  0,  0, 67, 84, 67, 76,   /* 0x c30 */
 69, 86, 69, 49, 81,  3,  0,  0,  0,  0,  0,  0, 86,  3,  0,  0,   /* 0x c40 */
 67, 65, 76, 76, 84, 82, 48, 48,  5,  0,  0,  0, 67, 65, 76, 76,   /* 0x c50 */
 84, 82, 48, 49, 86,  3,  0,  0, 67, 84, 68, 85, 77, 77, 89, 49,   /* 0x c60 */
 91,  3,  0,  0, 67, 84, 66, 83, 72, 82, 48, 49, 91,  3,  0,  0,   /* 0x c70 */
 67, 84, 66, 82, 79, 82, 48, 49, 95,  3,  0,  0, 67, 84, 66, 83,   /* 0x c80 */
 87, 65, 48, 49, 97,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 50,   /* 0x c90 */
102,  3,  0,  0,  0,  0,  0,  0,118,  3,  0,  0, 67, 65, 76, 76,   /* 0x ca0 */
 84, 82, 48, 48, 10,  0,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,   /* 0x cb0 */
118,  3,  0,  0, 67, 65, 76, 76, 84, 82, 69, 56,123,  3,  0,  0,   /* 0x cc0 */
 67, 65, 76, 76, 84, 82, 69, 57,125,  3,  0,  0, 67, 65, 76, 76,   /* 0x cd0 */
 84, 82, 49, 49,127,  3,  0,  0,  0,  0,  0,  0,131,  3,  0,  0,   /* 0x ce0 */
 67, 65, 76, 76, 84, 82, 49, 51,  7,  0,  0,  0, 67, 84, 67, 76,   /* 0x cf0 */
 69, 86, 69, 50,131,  3,  0,  0,  0,  0,  0,  0,136,  3,  0,  0,   /* 0x d00 */
 67, 65, 76, 76, 84, 82, 49, 49,  0,  0,  0,  0, 67, 65, 76, 76,   /* 0x d10 */
 84, 82, 49, 50,136,  3,  0,  0, 67, 84, 68, 85, 77, 77, 89, 50,   /* 0x d20 */
138,  3,  0,  0, 67, 84, 66, 83, 72, 82, 49, 49,138,  3,  0,  0,   /* 0x d30 */
 67, 84, 66, 82, 79, 82, 49, 49,142,  3,  0,  0, 67, 84, 66, 83,   /* 0x d40 */
 87, 65, 49, 49,144,  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,   /* 0x d50 */
149,  3,  0,  0,  0,  0,  0,  0,156,  3,  0,  0, 67, 65, 76, 76,   /* 0x d60 */
 84, 82, 49, 48,  5,  0,  0,  0, 67, 84, 84, 72, 69, 69, 78, 68,   /* 0x d70 */
156,  3,  0,  0, 80, 69, 68, 85, 77, 77, 89, 49,156,  3,  0,  0,   /* 0x d80 */
 80, 69, 73, 77, 80, 79, 82, 84,156,  3,  0,  0,  0,  0,  0,  0,   /* 0x d90 */
168,  3,  0,  0, 80, 69, 73, 77, 68, 79, 78, 69,  0,  0,  0,  0,   /* 0x da0 */
 80, 69, 73, 66, 89, 79, 82, 68,200,  3,  0,  0,  0,  0,  0,  0,   /* 0x db0 */
202,  3,  0,  0, 80, 69, 73, 77, 79, 82, 68, 49,  7,  0,  0,  0,   /* 0x dc0 */
 80, 69, 75, 51, 50, 79, 82, 68,202,  3,  0,  0,  0,  0,  0,  0,   /* 0x dd0 */
218,  3,  0,  0, 80, 69, 73, 77, 80, 79, 82, 50, 15,  0,  0,  0,   /* 0x de0 */
 80, 69, 73, 77, 79, 82, 68, 49,218,  3,  0,  0, 80, 69, 73, 77,   /* 0x df0 */
 80, 79, 82, 50,225,  3,  0,  0,  0,  0,  0,  0,247,  3,  0,  0,   /* 0x e00 */
 80, 69, 73, 77, 80, 79, 82, 84, 35,  0,  0,  0, 80, 69, 73, 69,   /* 0x e10 */
 82, 68, 76, 76,247,  3,  0,  0, 80, 69, 73, 69, 82, 69, 88, 69,   /* 0x e20 */
253,  3,  0,  0, 80, 69, 73, 77, 68, 79, 78, 69,  3,  4,  0,  0,   /* 0x e30 */
 80, 69, 73, 77, 80, 79, 82, 57,  3,  4,  0,  0, 80, 69, 82, 69,   /* 0x e40 */
 76, 79, 67, 49,  3,  4,  0,  0, 80, 69, 82, 69, 76, 79, 67, 50,   /* 0x e50 */
  9,  4,  0,  0, 80, 69, 82, 69, 76, 79, 67, 51, 12,  4,  0,  0,   /* 0x e60 */
 82, 69, 76, 79, 67, 51, 50, 48, 15,  4,  0,  0,  0,  0,  0,  0,   /* 0x e70 */
 24,  4,  0,  0, 82, 69, 76, 79, 67, 51, 50, 74,  2,  0,  0,  0,   /* 0x e80 */
 82, 69, 76, 51, 50, 66, 73, 71, 56,  4,  0,  0,  0,  0,  0,  0,   /* 0x e90 */
 60,  4,  0,  0, 82, 69, 76, 79, 67, 51, 50, 48, 13,  0,  0,  0,   /* 0x ea0 */
 82, 69, 76, 79, 67, 51, 50, 74, 65,  4,  0,  0,  0,  0,  0,  0,   /* 0x eb0 */
 67,  4,  0,  0, 82, 69, 76, 79, 67, 51, 50, 48, 13,  0,  0,  0,   /* 0x ec0 */
 82, 69, 76, 51, 50, 69, 78, 68, 67,  4,  0,  0, 80, 69, 82, 69,   /* 0x ed0 */
 76, 79, 67, 57, 67,  4,  0,  0, 80, 69, 82, 76, 79, 72, 73, 48,   /* 0x ee0 */
 67,  4,  0,  0, 80, 69, 82, 76, 79, 72, 73, 90, 75,  4,  0,  0,   /* 0x ef0 */
 80, 69, 82, 69, 76, 76, 79, 48, 75,  4,  0,  0, 80, 69, 82, 69,   /* 0x f00 */
 76, 76, 79, 90, 85,  4,  0,  0, 80, 69, 82, 69, 76, 72, 73, 48,   /* 0x f10 */
 85,  4,  0,  0, 80, 69, 82, 69, 76, 72, 73, 90, 98,  4,  0,  0,   /* 0x f20 */
 80, 69, 77, 65, 73, 78, 50, 48, 98,  4,  0,  0, 80, 69, 82, 69,   /* 0x f30 */
 84, 85, 82, 78, 99,  4,  0,  0, 80, 69, 68, 79, 74, 85, 77, 80,   /* 0x f40 */
105,  4,  0,  0, 80, 69, 68, 85, 77, 77, 89, 51,110,  4,  0,  0,   /* 0x f50 */
 85, 80, 88, 49, 72, 69, 65, 68,110,  4,  0,  0, 80, 69, 84, 72,   /* 0x f60 */
 69, 69, 78, 68,142,  4,  0,  0,255,255,255,255,142,  4            /* 0x f70 */
};
