/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import jsynoptic.builtin.RandomSource;
import jsynoptic.data.DataSourceAnimator;
import simtools.data.DataSource;
import simtools.util.NumberStringComparator;

public class UniformRandomSource
extends RandomSource {
    public static final String ID_PREFIX = "UniformRandomSource:";

    protected void setInfo() {
        this.info.comment = resources.getString("uniformSourceComment");
        this.info.id = ID_PREFIX + this.info.id;
    }

    public UniformRandomSource(String string, double d, double d2) {
        super(string, d, d2);
        this.setInfo();
    }

    public UniformRandomSource(String string, double d, double d2, long l) {
        super(string, d, d2, l);
        this.setInfo();
    }

    public UniformRandomSource(String string, long l, double d, double d2) {
        super(string, l, d, d2);
        this.setInfo();
    }

    public UniformRandomSource(String string, long l, double d, double d2, long l2) {
        super(string, l, d, d2, l2);
        this.setInfo();
    }

    protected double nextRandomValue() {
        double d = this.generator.nextDouble();
        if (d > 0.96875) {
            return this.nextRandomValue();
        }
        return d * (this.param2 - this.param1) / 0.96875 + this.param1;
    }

    public double getLowerBound() {
        return this.param1;
    }

    public double getHigherBound() {
        return this.param2;
    }

    public static class OptionPanel
    extends RandomSource.OptionPanel {
        protected String param1Name() {
            return RandomSource.resources.getString("lowerBound");
        }

        protected String param2Name() {
            return RandomSource.resources.getString("higherBound");
        }

        public DataSource createSource(String string) {
            DataSource dataSource;
            Number number = null;
            if (this.cbSeed.isSelected()) {
                number = NumberStringComparator.stringToNumber(this.tfSeed.getText());
            }
            if (this.rbDynamic.isSelected()) {
                Number number2 = NumberStringComparator.stringToNumber(this.tfPeriod.getText());
                if (number2 == null) {
                    number2 = new Long(1000L);
                }
                dataSource = number != null ? new DataSourceAnimator(new UniformRandomSource(string, number.longValue(), this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue()), (int)this.nfSize.getLongValue(), (long)number2.intValue()) : new DataSourceAnimator(new UniformRandomSource(string, this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue()), (int)this.nfSize.getLongValue(), (long)number2.intValue());
            } else {
                dataSource = number != null ? new UniformRandomSource(string, number.longValue(), this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue(), this.nfSize.getLongValue()) : new UniformRandomSource(string, this.nfParam1.getDoubleValue(), this.nfParam2.getDoubleValue(), this.nfSize.getLongValue());
            }
            return dataSource;
        }
    }
}

