/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin.ui;

import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simtools.ui.JPropertiesPanel;
import simtools.ui.MenuResourceBundle;
import simtools.ui.NumberField;

public class AxePropertiesPanel
extends JPropertiesPanel {
    protected NumberField tfmin;
    protected NumberField tfmax;
    protected NumberField tfstep;
    protected JTextField tflabel;
    protected JCheckBox cbgrid;
    protected JCheckBox cbauto;
    protected String id;
    protected JLabel lmin;
    protected JLabel lmax;
    protected JLabel lstep;
    protected JLabel llabel;
    protected MenuResourceBundle resources;

    public AxePropertiesPanel(MenuResourceBundle menuResourceBundle, String string) {
        this.id = string;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), menuResourceBundle.getStringValue(string + "Section")));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.cbgrid = menuResourceBundle.getCheckBox("grid", null);
        jPanel.add(this.cbgrid);
        this.cbauto = menuResourceBundle.getCheckBox("autoscale", null);
        jPanel.add(this.cbauto);
        this.llabel = new JLabel(menuResourceBundle.getStringValue("labelLabel"));
        jPanel.add(this.llabel);
        this.tflabel = new JTextField(15);
        jPanel.add(this.tflabel);
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0));
        this.lmin = new JLabel(menuResourceBundle.getStringValue("minLabel"));
        jPanel.add(this.lmin);
        this.addMinMaxComponent(true, jPanel);
        this.lmax = new JLabel(menuResourceBundle.getStringValue("maxLabel"));
        jPanel.add(this.lmax);
        this.tfmax = new NumberField(0L, 10);
        this.addMinMaxComponent(false, jPanel);
        this.lstep = new JLabel(menuResourceBundle.getStringValue("stepLabel"));
        jPanel.add(this.lstep);
        this.tfstep = new NumberField(0L, 10);
        jPanel.add(this.tfstep);
        this.add(jPanel);
    }

    protected void addMinMaxComponent(boolean bl, JPanel jPanel) {
        if (bl) {
            this.tfmin = new NumberField(0L, 10);
            jPanel.add(this.tfmin);
        } else {
            this.tfmax = new NumberField(0L, 10);
            jPanel.add(this.tfmax);
        }
    }

    public static String getPrefix(String string) {
        return "PLOT_AXE_" + string;
    }

    public static String[] getPropertyNames(String string) {
        String[] stringArray = new String[]{AxePropertiesPanel.getPrefix(string) + "_OK", AxePropertiesPanel.getPrefix(string) + "_GRID", AxePropertiesPanel.getPrefix(string) + "_AUTO", AxePropertiesPanel.getPrefix(string) + "_MIN", AxePropertiesPanel.getPrefix(string) + "_MAX", AxePropertiesPanel.getPrefix(string) + "_STEP", AxePropertiesPanel.getPrefix(string) + "_LABEL"};
        return stringArray;
    }

    public String[] getPropertyNames() {
        return AxePropertiesPanel.getPropertyNames(this.id);
    }

    protected void setEnabledMinMaxComponent(boolean bl, boolean bl2) {
        if (bl) {
            this.tfmin.setEnabled(bl2);
        } else {
            this.tfmax.setEnabled(bl2);
        }
    }

    protected void setMinMaxComponentValue(boolean bl, double d) {
        if (bl) {
            this.tfmin.setValue(d);
        } else {
            this.tfmax.setValue(d);
        }
    }

    protected double getMinMaxComponentValue(boolean bl) {
        if (bl) {
            return this.tfmin.getDoubleValue();
        }
        return this.tfmax.getDoubleValue();
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_OK") && object instanceof Boolean) {
            boolean bl = (Boolean)object;
            this.tfstep.setEnabled(bl);
            this.setEnabledMinMaxComponent(true, bl);
            this.setEnabledMinMaxComponent(false, bl);
            this.tflabel.setEnabled(bl);
            this.lmin.setEnabled(bl);
            this.lmax.setEnabled(bl);
            this.lstep.setEnabled(bl);
            this.llabel.setEnabled(bl);
            this.cbgrid.setEnabled(bl);
            this.cbauto.setEnabled(bl);
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_GRID") && object instanceof Boolean) {
            this.cbgrid.setSelected((Boolean)object);
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_AUTO") && object instanceof Boolean) {
            this.cbauto.setSelected((Boolean)object);
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_MIN") && object instanceof Double) {
            this.setMinMaxComponentValue(true, (Double)object);
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_MAX") && object instanceof Double) {
            this.setMinMaxComponentValue(false, (Double)object);
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_STEP") && object instanceof Double) {
            this.tfstep.setValue((Double)object);
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_LABEL")) {
            if (object instanceof String) {
                this.tflabel.setText((String)object);
            } else {
                this.tflabel.setText("");
            }
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_OK")) {
            object = new Boolean(this.tfstep.isEnabled());
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_GRID")) {
            object = new Boolean(this.cbgrid.isSelected());
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_AUTO")) {
            object = new Boolean(this.cbauto.isSelected());
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_MIN")) {
            object = new Double(this.getMinMaxComponentValue(true));
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_MAX")) {
            object = new Double(this.getMinMaxComponentValue(false));
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_STEP")) {
            object = new Double(this.tfstep.getDoubleValue());
        } else if (string.equalsIgnoreCase(AxePropertiesPanel.getPrefix(this.id) + "_LABEL")) {
            object = this.tflabel.getText().length() > 0 ? this.tflabel.getText() : null;
        }
        return object;
    }
}

