/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import jsynoptic.ui.ShapesContainer;
import simtools.diagram.DiagramSelection;
import simtools.shapes.AbstractShape;
import simtools.ui.JPropertiesPanel;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;
import simtools.util.NamedProperties;

public class DiagramSelectionPropertiesPanel
extends JPropertiesPanel {
    protected final String name;
    protected final String title;
    protected final Icon firstIcon;
    protected JButton button;
    protected final SelectionAction action;
    protected final String toolTip;
    protected String propertyName;
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$ui$DiagramSelectionPropertiesPanel == null ? (class$jsynoptic$ui$DiagramSelectionPropertiesPanel = DiagramSelectionPropertiesPanel.class$("jsynoptic.ui.DiagramSelectionPropertiesPanel")) : class$jsynoptic$ui$DiagramSelectionPropertiesPanel);
    static /* synthetic */ Class class$jsynoptic$ui$DiagramSelectionPropertiesPanel;

    public DiagramSelectionPropertiesPanel(String string, Icon icon, String string2, String string3, String string4) {
        this.name = string;
        this.title = string2;
        this.firstIcon = icon;
        this.propertyName = string4;
        this.toolTip = string3;
        this.action = new SelectionAction(this.getClass().toString(), icon);
    }

    public JButton createButton() {
        this.button = new JButton(this.action);
        this.button.setText(this.name);
        this.button.setToolTipText(this.toolTip);
        return this.button;
    }

    public SelectionAction getAction() {
        return this.action;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    protected void doAction(ActionEvent actionEvent) {
        final ShapesContainer.ShapesComponent shapesComponent = (ShapesContainer.ShapesComponent)JSynoptic.gui.getActiveDiagram();
        if (shapesComponent == null) {
            return;
        }
        DiagramSelection diagramSelection = shapesComponent.getDiagramSelection();
        final Vector vector = diagramSelection.getSelection();
        final NamedProperties namedProperties = this.containsValidProperties(vector);
        if (namedProperties == null) {
            return;
        }
        new LongAction(16L, diagramSelection, actionEvent.getSource()){

            protected void doAction() {
                DiagramSelection diagramSelection = (DiagramSelection)this.param;
                DiagramSelectionPropertiesPanel.this.setProperties(namedProperties);
                int n = JOptionPane.showConfirmDialog(null, DiagramSelectionPropertiesPanel.this, DiagramSelectionPropertiesPanel.this.title, 2, -1);
                if (n == 0) {
                    DiagramSelectionPropertiesPanel.this.update();
                    CompoundEdit compoundEdit = new CompoundEdit();
                    boolean bl = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        AbstractShape abstractShape;
                        Object e = vector.get(i);
                        if (!(e instanceof AbstractShape) || !(abstractShape = (AbstractShape)e).setProperties(DiagramSelectionPropertiesPanel.this, compoundEdit)) continue;
                        bl = true;
                    }
                    if (bl) {
                        compoundEdit.end();
                        shapesComponent.fireUndoableEditUpdate(new UndoableEditEvent(shapesComponent, compoundEdit));
                        shapesComponent.repaint();
                    }
                }
            }
        }.start();
    }

    public String[] getPropertyNames() {
        return new String[]{this.propertyName};
    }

    protected boolean containsValidProperties(NamedProperties namedProperties) {
        String[] stringArray = namedProperties.getPropertyNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(this.propertyName)) continue;
            return true;
        }
        return false;
    }

    protected NamedProperties containsValidProperties(Vector vector) {
        NamedProperties namedProperties = null;
        for (int i = 0; i < vector.size(); ++i) {
            NamedProperties namedProperties2;
            Object e = vector.get(i);
            if (!(e instanceof NamedProperties) || !this.containsValidProperties(namedProperties2 = (NamedProperties)e)) continue;
            this.setProperties(namedProperties2);
            namedProperties = namedProperties2;
            break;
        }
        return namedProperties;
    }

    protected void update() {
        if (this.propertyName.indexOf("COLOR") >= 0) {
            this.action.firePropertyChange("background", null, this.getPropertyValue(this.propertyName));
            if (this.button != null) {
                this.button.setBackground((Color)this.getPropertyValue(this.propertyName));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FontColorEditorPanel
    extends ColorEditorPanel {
        public FontColorEditorPanel() {
            super(resources.getIcon("fontColorIcon"), resources.getStringValue("fontColorTitle"), resources.getStringValue("fontColorTip"), "TEXT_COLOR");
        }
    }

    public static class BackgroundColorEditorPanel
    extends ColorEditorPanel {
        public BackgroundColorEditorPanel() {
            super(resources.getIcon("backgroundColorIcon"), resources.getStringValue("backgroundColorTitle"), resources.getStringValue("backgroundColorTip"), "FILL_COLOR");
        }
    }

    public static class LineColorEditorPanel
    extends ColorEditorPanel {
        public LineColorEditorPanel() {
            super(resources.getIcon("lineColorIcon"), resources.getStringValue("lineColorTitle"), resources.getStringValue("lineColorTip"), "STROKE_COLOR");
        }
    }

    public static class ColorEditorPanel
    extends DiagramSelectionPropertiesPanel {
        JColorChooser colorChooser;

        public ColorEditorPanel(Icon icon, String string, String string2, String string3) {
            super("", icon, string, string2, string3);
            this.setLayout(new BorderLayout());
            this.colorChooser = new JColorChooser();
            this.add((Component)this.colorChooser, "Center");
        }

        public Object getPropertyValue(String string) {
            Color color = null;
            if (string.equalsIgnoreCase(this.propertyName)) {
                color = this.colorChooser.getColor();
            }
            return color;
        }

        public void setPropertyValue(String string, Object object) {
            if (string.equalsIgnoreCase(this.propertyName) && object instanceof Color) {
                this.colorChooser.setColor((Color)object);
            }
        }
    }

    protected class SelectionAction
    extends AbstractAction {
        public SelectionAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DiagramSelectionPropertiesPanel.this.doAction(actionEvent);
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        public boolean update(Vector vector) {
            NamedProperties namedProperties = DiagramSelectionPropertiesPanel.this.containsValidProperties(vector);
            if (namedProperties != null) {
                DiagramSelectionPropertiesPanel.this.setProperties(namedProperties);
                DiagramSelectionPropertiesPanel.this.update();
                return true;
            }
            return false;
        }
    }
}

