/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jsynoptic.base.Plugin;
import jsynoptic.data.ExpressionDataSource;
import jsynoptic.data.VariableAssociation;
import jsynoptic.parser.ExpressionNode;
import jsynoptic.parser.ExpressionParser;
import jsynoptic.parser.ParseException;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.Run;
import jsynoptic.ui.SourceTree;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.ui.ResourceFinder;

public class ExpressionPanel
extends JPanel {
    protected JTextField tfNewSourceName;
    protected JTextField tfExpression;
    protected JButton addExp;
    protected JComboBox cbxPredefined;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$ui$ExpressionPanel == null ? (class$jsynoptic$ui$ExpressionPanel = ExpressionPanel.class$("jsynoptic.ui.ExpressionPanel")) : class$jsynoptic$ui$ExpressionPanel);
    protected SourceTree sourceTree;
    protected JTabbedPane tabbedPane;
    static /* synthetic */ Class class$jsynoptic$ui$ExpressionPanel;

    public ExpressionPanel(SourceTree sourceTree) {
        this.sourceTree = sourceTree;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(resources.getString("computedSources")));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(resources.getString("nameOfComputedSource")));
        box.add(Box.createHorizontalGlue());
        this.tfNewSourceName = new JTextField();
        box.add(this.tfNewSourceName);
        this.add((Component)box, "North");
        this.tabbedPane = new JTabbedPane(1, 1);
        this.cbxPredefined = new JComboBox();
        this.tabbedPane.add(this.cbxPredefined, resources.getString("predefinedSources"));
        this.tfExpression = new JTextField();
        this.tabbedPane.add((Component)this.tfExpression, resources.getString("mathExpression"));
        this.add((Component)this.tabbedPane, "Center");
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.addExp = new JButton(resources.getString("addTemplate"));
        box.add(this.addExp);
        this.add((Component)box, "South");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                switch (ExpressionPanel.this.tabbedPane.getSelectedIndex()) {
                    case 0: {
                        ExpressionPanel.this.addExp.setText(resources.getString("addTemplate"));
                        break;
                    }
                    case 1: {
                        ExpressionPanel.this.addExp.setText(resources.getString("addExp"));
                        break;
                    }
                }
                ExpressionPanel.this.updateAddExpState();
            }
        });
        Iterator iterator = Run.plugins.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            Plugin plugin = (Plugin)iterator.next();
            if (plugin == null || (stringArray = plugin.getSources()) == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                for (n = 0; n < this.cbxPredefined.getItemCount() && this.cbxPredefined.getItemAt(n).toString().compareTo(stringArray[i]) <= 0; ++n) {
                }
                this.cbxPredefined.insertItemAt(new SourceTemplate(stringArray[i], plugin), n);
            }
        }
        if (this.cbxPredefined.getItemCount() > 0) {
            this.cbxPredefined.setSelectedIndex(0);
        }
        this.tfExpression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExpressionPanel.this.addExp.isEnabled()) {
                    ExpressionPanel.this.addExp.doClick();
                }
            }
        });
        this.addExp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string = ExpressionPanel.this.tfNewSourceName.getText();
                if (ExpressionPanel.this.tabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                if (ExpressionPanel.this.tabbedPane.getSelectedIndex() == 0) {
                    Object object5 = ExpressionPanel.this.cbxPredefined.getSelectedItem();
                    if (object5 == null) {
                        return;
                    }
                    if (!(object5 instanceof SourceTemplate)) {
                        return;
                    }
                    SourceTemplate sourceTemplate = (SourceTemplate)object5;
                    DataSource dataSource = sourceTemplate.plugin.createSource(sourceTemplate.template, string);
                    if (dataSource == null) {
                        return;
                    }
                    DataSourcePool.global.addDataSource(dataSource);
                    ExpressionPanel.this.sourceTree.setSelectedValue(dataSource);
                    return;
                }
                String string2 = ExpressionPanel.this.tfExpression.getText();
                if (string == null || string.equals("")) {
                    JOptionPane.showMessageDialog(JSynoptic.gui, resources.getString("PleaseEnterNewSourceName"), resources.getString("Error"), 0);
                    return;
                }
                if (string2 == null || string2.equals("")) {
                    JOptionPane.showMessageDialog(JSynoptic.gui, resources.getString("PleaseEnterAMathematicalExpression"), resources.getString("Error"), 0);
                    return;
                }
                ExpressionNode expressionNode = null;
                try {
                    ExpressionParser expressionParser = new ExpressionParser(string2);
                    object4 = DataSourcePool.global.dataSourceCollections();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (Collection)object3.next();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            this.addVariable(expressionParser, object.next());
                        }
                    }
                    object3 = DataSourcePool.global.dataSources();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        this.addVariable(expressionParser, object2.next());
                    }
                    object2 = Run.plugins.iterator();
                    while (object2.hasNext()) {
                        expressionParser.addClass(object2.next().getClass());
                    }
                    expressionNode = expressionParser.parse();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(JSynoptic.gui, parseException.getLocalizedMessage(), resources.getString("InvalidExpression"), 0);
                    return;
                }
                catch (Error error) {
                    JOptionPane.showMessageDialog(JSynoptic.gui, error.getLocalizedMessage(), resources.getString("InvalidExpression"), 0);
                    return;
                }
                boolean bl = true;
                object4 = DataSourcePool.global.dataSources().iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    if (!(object3 instanceof ExpressionDataSource) || !string.equals(DataInfo.getLabel(object2 = (ExpressionDataSource)object3)) && !string.equals(DataInfo.getAlias(object2))) continue;
                    ((ExpressionDataSource)object2).changeExpression(string2, expressionNode);
                    bl = false;
                    ExpressionPanel.this.sourceTree.setSelectedValue(object2);
                    object = (TreeNode)ExpressionPanel.this.sourceTree.getSelectionPath().getLastPathComponent();
                    ((DefaultTreeModel)ExpressionPanel.this.sourceTree.getModel()).nodeChanged((TreeNode)object);
                    break;
                }
                if (bl) {
                    object4 = new ExpressionDataSource(new DataInfo(string, string, string2), expressionNode);
                    DataSourcePool.global.addDataSource((DataSource)object4);
                    ExpressionPanel.this.sourceTree.setSelectedValue(object4);
                }
            }

            private void addVariable(ExpressionParser expressionParser, Object object) {
                if (object == null) {
                    return;
                }
                if (!(object instanceof DataSource)) {
                    return;
                }
                String string = DataInfo.getAlias(object);
                if (string != null) {
                    expressionParser.addVariable(new VariableAssociation((DataSource)object, string));
                } else {
                    expressionParser.addVariable(new VariableAssociation((DataSource)object, DataInfo.getLabel(object)));
                }
            }
        });
        sourceTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = ExpressionPanel.this.sourceTree.getSelectedSourceOrCollection();
                if (object != null && object instanceof ExpressionDataSource) {
                    ExpressionPanel.this.tfNewSourceName.setText(DataInfo.getLabel(object));
                    ExpressionPanel.this.tfExpression.setText(DataInfo.getComment(object));
                    ExpressionPanel.this.tabbedPane.setSelectedIndex(1);
                } else {
                    ExpressionPanel.this.tfNewSourceName.setText("");
                    ExpressionPanel.this.tfExpression.setText("");
                }
            }
        });
        this.tfNewSourceName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ExpressionPanel.this.updateAddExpState();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ExpressionPanel.this.updateAddExpState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ExpressionPanel.this.updateAddExpState();
            }
        });
        this.tfExpression.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ExpressionPanel.this.updateAddExpState();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ExpressionPanel.this.updateAddExpState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ExpressionPanel.this.updateAddExpState();
            }
        });
        this.updateAddExpState();
    }

    protected void updateAddExpState() {
        String string = this.tfNewSourceName.getText();
        String string2 = this.tfExpression.getText();
        if (string == null || string.equals("")) {
            this.addExp.setEnabled(false);
            return;
        }
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.addExp.setEnabled(true);
            return;
        }
        if (string2 == null || string2.equals("")) {
            this.addExp.setEnabled(false);
            return;
        }
        this.addExp.setEnabled(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class SourceTemplate {
        public String template;
        public Plugin plugin;

        public String toString() {
            return this.template;
        }

        public SourceTemplate(String string, Plugin plugin) {
            this.template = string;
            this.plugin = plugin;
        }
    }
}

