/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.undo.CompoundEdit;
import simtools.diagram.undo.PropertyChangeEdit;
import simtools.shapes.ShapeListener;
import simtools.util.ListenerManager;
import simtools.util.NamedProperties;

public abstract class AbstractShape
implements Serializable,
Cloneable,
Shape,
NamedProperties {
    static final long serialVersionUID = -7697012777559414541L;
    protected int _x;
    protected int _y;
    protected int _w;
    protected int _h;
    protected int _ox;
    protected int _oy;
    protected transient ListenerManager listeners = new ListenerManager();
    protected transient Timer timer;
    protected transient Rectangle changedArea;
    public static int REFRESH_PERIOD = 100;
    public static boolean ANTI_ALIASING = true;

    public AbstractShape() {
        this(0, 0);
        this.timer = null;
    }

    public AbstractShape(int n, int n2) {
        this._ox = n;
        this._oy = n2;
        this._x = 0;
        this._y = 0;
        this._w = 0;
        this._h = 0;
        this.timer = null;
    }

    protected AbstractShape cloneShape() {
        try {
            AbstractShape abstractShape = (AbstractShape)super.clone();
            abstractShape.listeners = new ListenerManager();
            abstractShape.timer = null;
            abstractShape.changedArea = null;
            return abstractShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void getMin(Point point) {
        int n = this._ox + this._x;
        int n2 = this._oy + this._y - this._h;
        if (n < point.x) {
            point.x = n;
        }
        if (n2 < point.y) {
            point.y = n2;
        }
    }

    public Point getAnchor() {
        return new Point(this._ox, this._oy);
    }

    public void setAnchor(Point point) {
        this.setAnchor(point.x, point.y);
    }

    public void setAnchor(int n, int n2) {
        this._ox = n;
        this._oy = n2;
    }

    public void getMax(Point point) {
        int n = this._ox + this._x + this._w;
        int n2 = this._oy + this._y;
        if (n > point.x) {
            point.x = n;
        }
        if (n2 > point.y) {
            point.y = n2;
        }
    }

    public void getMaxTranslated(Point point, int n, int n2) {
        int n3 = this._ox + this._x + this._w + n;
        int n4 = this._oy - this._y;
        if (n3 > point.x) {
            point.x = n3;
        }
        if (n4 > point.y) {
            point.y = n4;
        }
    }

    public void translate(int n, int n2) {
        this._ox += n;
        this._oy += n2;
    }

    public abstract void draw(Graphics2D var1);

    public boolean contains(double d, double d2) {
        int n = this._ox + this._x;
        int n2 = this._oy + this._y;
        return d >= (double)n && d <= (double)(n + this._w) && d2 >= (double)(n2 - this._h) && d2 <= (double)n2;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        int n = this._ox + this._x;
        int n2 = this._oy + this._y;
        return d >= (double)n && d + d3 <= (double)(n + this._w) && d2 >= (double)(n2 - this._h) && d2 + d4 <= (double)n2;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getBounds2D().intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.getBounds2D().intersects(rectangle2D);
    }

    public Rectangle getBounds() {
        return new Rectangle(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return null;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return null;
    }

    public void addListener(ShapeListener shapeListener) {
        this.listeners.add(shapeListener);
    }

    public void removeListener(ShapeListener shapeListener) {
        this.listeners.remove(shapeListener);
    }

    protected synchronized void notifyChange() {
        this.notifyChange(null);
    }

    protected synchronized void notifyChange(Rectangle rectangle) {
        if (this.listeners.size() == 0) {
            return;
        }
        if (rectangle == null) {
            rectangle = this.getBounds();
        }
        if (this.changedArea == null) {
            this.changedArea = (Rectangle)rectangle.clone();
        } else {
            this.changedArea.add(rectangle);
        }
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Rectangle rectangle;
                Object object = AbstractShape.this;
                synchronized (object) {
                    if (AbstractShape.this.changedArea == null) {
                        AbstractShape.this.timer.cancel();
                        AbstractShape.this.timer = null;
                        return;
                    }
                    rectangle = AbstractShape.this.changedArea;
                    AbstractShape.this.changedArea = null;
                }
                object = AbstractShape.this.listeners;
                synchronized (object) {
                    int n = AbstractShape.this.listeners.size();
                    for (int i = 0; i < n; ++i) {
                        ShapeListener shapeListener = (ShapeListener)AbstractShape.this.listeners.get(i);
                        if (shapeListener == null) continue;
                        shapeListener.shapeChanged(AbstractShape.this, rectangle);
                    }
                }
            }
        }, 0L, (long)REFRESH_PERIOD);
    }

    protected void finalize() throws Throwable {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.finalize();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new ListenerManager();
    }

    public void setPropertyValue(String string, Object object) {
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public Collection getInnerProperties() {
        return null;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public boolean setProperties(NamedProperties namedProperties, CompoundEdit compoundEdit) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        Collection collection = namedProperties.getInnerProperties();
        Collection collection2 = this.getInnerProperties();
        if (collection != null && collection2 != null) {
            object3 = collection.iterator();
            Iterator iterator = collection2.iterator();
            while (object3.hasNext() && iterator.hasNext()) {
                object2 = (AbstractShape)iterator.next();
                if (!((AbstractShape)object2).setProperties((NamedProperties)(object = (NamedProperties)object3.next()), compoundEdit)) continue;
                bl = true;
            }
        }
        if ((object3 = namedProperties.getPropertyNames()) != null) {
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object2 = object3[i];
                object = namedProperties.getPropertyValue((String)object2);
                compoundEdit.addEdit(new PropertyChangeEdit(this, (String)object2, this.getPropertyValue((String)object2), object));
                this.setPropertyValue((String)object2, object);
                bl = true;
            }
        }
        return bl;
    }
}

