/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;

public class BasicShape
extends AbstractShape
implements Serializable,
Cloneable,
Resizable {
    static final long serialVersionUID = -1727924798190005009L;
    public static final int RECTANGLE = 1;
    public static final int ELLIPSE = 2;
    public static final int ARC = 3;
    public static final int ROUND_RECTANGLE = 4;
    protected RectangularShape _shape;
    protected Color _bColor;
    protected Color _fColor;

    public BasicShape(int n, int n2, int n3, int n4, int n5, double d, double d2) {
        super(n2, n3);
        this._w = n4;
        this._h = n5;
        this._x = -this._w / 2;
        this._y = this._h / 2;
        switch (n) {
            case 1: {
                this._shape = new Rectangle2D.Double(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
                break;
            }
            case 2: {
                this._shape = new Ellipse2D.Double(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
                break;
            }
            case 3: {
                Arc2D.Double double_ = new Arc2D.Double();
                ((Arc2D)double_).setAngleStart(d);
                ((Arc2D)double_).setAngleExtent(d2);
                double_.setFrame(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
                this._shape = double_;
                break;
            }
            case 4: {
                this._shape = new RoundRectangle2D.Double(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h, d, d2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this._bColor = null;
        this._fColor = null;
    }

    protected AbstractShape cloneShape() {
        BasicShape basicShape = null;
        try {
            basicShape = (BasicShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        basicShape._shape = (RectangularShape)basicShape._shape.clone();
        return basicShape;
    }

    public void setBorderColor(Color color) {
        this._bColor = color;
    }

    public Color setBorderColor() {
        return this._bColor;
    }

    public void setFillerColor(Color color) {
        this._fColor = color;
    }

    public Color setFillerColor() {
        return this._fColor;
    }

    public void resize(int n, int n2) {
        this._w += n;
        this._h += n2;
        if (this._w < 3) {
            this._w = 3;
        }
        if (this._h < 3) {
            this._h = 3;
        }
        this._shape.setFrame(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
    }

    public void setAnchor(Point point) {
        int n = point.x - this._ox;
        int n2 = point.y - this._oy;
        this.translate(n, n2);
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this._shape.setFrame(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
    }

    public void draw(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        if (this._fColor != null) {
            graphics2D.setColor(this._fColor);
            graphics2D.fill(this._shape);
        }
        if (this._bColor != null) {
            graphics2D.setColor(this._bColor);
            graphics2D.draw(this._shape);
        }
        graphics2D.setColor(color);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this._shape.getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this._shape.getPathIterator(affineTransform, d);
    }
}

